/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.lang;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.name.ClassId;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.name.SpecialNames;

public class BuiltInsSerializationUtil {
    private BuiltInsSerializationUtil() {
    }

    @Nullable
    private static String relativeClassNameToFilePath(@NotNull FqNameUnsafe className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/jet/lang/types/lang/BuiltInsSerializationUtil", "relativeClassNameToFilePath"));
        }
        List<Name> segments = className.pathSegments();
        ArrayList<String> correctedSegments = new ArrayList<String>(segments.size());
        for (Name segment : segments) {
            if (SpecialNames.isClassObjectName(segment)) {
                correctedSegments.add("object");
                continue;
            }
            if (!segment.isSpecial()) {
                correctedSegments.add(segment.getIdentifier());
                continue;
            }
            return null;
        }
        return FqName.fromSegments(correctedSegments).asString();
    }

    @Nullable
    public static String getClassMetadataPath(@NotNull ClassId classId) {
        if (classId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classId", "org/jetbrains/jet/lang/types/lang/BuiltInsSerializationUtil", "getClassMetadataPath"));
        }
        String filePath = BuiltInsSerializationUtil.relativeClassNameToFilePath(classId.getRelativeClassName());
        if (filePath == null) {
            return null;
        }
        return BuiltInsSerializationUtil.packageFqNameToPath(classId.getPackageFqName()) + "/" + filePath + "." + "kotlin_class";
    }

    @NotNull
    public static String getPackageFilePath(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/types/lang/BuiltInsSerializationUtil", "getPackageFilePath"));
        }
        String string = BuiltInsSerializationUtil.packageFqNameToPath(fqName2) + "/" + ".kotlin_package";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltInsSerializationUtil", "getPackageFilePath"));
        }
        return string;
    }

    @NotNull
    public static String getNameTableFilePath(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/types/lang/BuiltInsSerializationUtil", "getNameTableFilePath"));
        }
        String string = BuiltInsSerializationUtil.packageFqNameToPath(fqName2) + "/" + ".kotlin_name_table";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltInsSerializationUtil", "getNameTableFilePath"));
        }
        return string;
    }

    @NotNull
    public static String getClassNamesFilePath(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/types/lang/BuiltInsSerializationUtil", "getClassNamesFilePath"));
        }
        String string = BuiltInsSerializationUtil.packageFqNameToPath(fqName2) + "/" + ".kotlin_class_names";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltInsSerializationUtil", "getClassNamesFilePath"));
        }
        return string;
    }

    private static String packageFqNameToPath(FqName fqName2) {
        return fqName2.asString().replace('.', '/');
    }
}

