/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.utils;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryUtils {
    private static final Logger LOG = Logger.getInstance(LibraryUtils.class);
    public static final String TITLE_KOTLIN_JVM_RUNTIME_AND_STDLIB;
    public static final String TITLE_KOTLIN_JAVASCRIPT_STDLIB;

    private LibraryUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Manifest getManifestFromJar(@NotNull File library) {
        Manifest manifest;
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/jet/utils/LibraryUtils", "getManifestFromJar"));
        }
        if (!library.canRead()) {
            return null;
        }
        JarFile jarFile = new JarFile(library);
        try {
            manifest = jarFile.getManifest();
        }
        catch (Throwable throwable) {
            try {
                jarFile.close();
                throw throwable;
            }
            catch (IOException ignored) {
                return null;
            }
        }
        jarFile.close();
        return manifest;
    }

    @Nullable
    public static Attributes getManifestMainAttributesFromJar(@NotNull File library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/jet/utils/LibraryUtils", "getManifestMainAttributesFromJar"));
        }
        Manifest manifest = LibraryUtils.getManifestFromJar(library);
        return manifest != null ? manifest.getMainAttributes() : null;
    }

    private static boolean checkImplTitle(@NotNull File library, String expected) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/jet/utils/LibraryUtils", "checkImplTitle"));
        }
        Attributes attributes = LibraryUtils.getManifestMainAttributesFromJar(library);
        if (attributes == null) {
            return false;
        }
        String title = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
        return title != null && title.equals(expected);
    }

    public static boolean isJsRuntimeLibrary(@NotNull File library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/jet/utils/LibraryUtils", "isJsRuntimeLibrary"));
        }
        return LibraryUtils.checkImplTitle(library, TITLE_KOTLIN_JAVASCRIPT_STDLIB);
    }

    public static boolean isJvmRuntimeLibrary(@NotNull File library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/jet/utils/LibraryUtils", "isJvmRuntimeLibrary"));
        }
        return LibraryUtils.checkImplTitle(library, TITLE_KOTLIN_JVM_RUNTIME_AND_STDLIB);
    }

    static {
        String jsStdLib = "";
        String jvmStdLib = "";
        InputStream manifestProperties = LibraryUtils.class.getResourceAsStream("/manifest.properties");
        if (manifestProperties != null) {
            try {
                Properties properties2 = new Properties();
                properties2.load(manifestProperties);
                jvmStdLib = properties2.getProperty("manifest.impl.title.kotlin.jvm.runtime");
                jsStdLib = properties2.getProperty("manifest.impl.title.kotlin.javascript.stdlib");
            }
            catch (IOException e) {
                LOG.error(e);
            }
        } else {
            LOG.error("Resource 'manifest.properties' not found.");
        }
        TITLE_KOTLIN_JVM_RUNTIME_AND_STDLIB = jvmStdLib;
        TITLE_KOTLIN_JAVASCRIPT_STDLIB = jsStdLib;
    }
}

