/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.initializer;

import com.google.dart.compiler.backend.js.ast.JsStatement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.general.TranslatorVisitor;
import org.jetbrains.k2js.translate.initializer.InitializerUtils;
import org.jetbrains.k2js.translate.utils.BindingUtils;

public final class InitializerVisitor
extends TranslatorVisitor<Void> {
    private final List<JsStatement> result;

    public InitializerVisitor(List<JsStatement> result2) {
        this.result = result2;
    }

    @Override
    public final Void visitProperty(@NotNull JetProperty property2, @NotNull TranslationContext context2) {
        JsStatement delegate2;
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/k2js/translate/initializer/InitializerVisitor", "visitProperty"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/initializer/InitializerVisitor", "visitProperty"));
        }
        JetExpression initializer = property2.getInitializer();
        if (initializer != null) {
            this.result.add(InitializerUtils.generateInitializerForProperty(context2, BindingUtils.getPropertyDescriptor(context2.bindingContext(), property2), Translation.translateAsExpression(initializer, context2)));
        }
        if ((delegate2 = InitializerUtils.generateInitializerForDelegate(context2, property2)) != null) {
            this.result.add(delegate2);
        }
        return null;
    }

    @Override
    public Void visitAnonymousInitializer(@NotNull JetClassInitializer initializer, @NotNull TranslationContext context2) {
        if (initializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "org/jetbrains/k2js/translate/initializer/InitializerVisitor", "visitAnonymousInitializer"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/initializer/InitializerVisitor", "visitAnonymousInitializer"));
        }
        this.result.add(Translation.translateAsStatementAndMergeInBlockIfNeeded(initializer.getBody(), context2));
        return null;
    }

    @Override
    public Void visitDeclaration(@NotNull JetDeclaration expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/initializer/InitializerVisitor", "visitDeclaration"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/initializer/InitializerVisitor", "visitDeclaration"));
        }
        return null;
    }

    @Override
    public Void visitObjectDeclaration(@NotNull JetObjectDeclaration declaration, @NotNull TranslationContext context2) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/k2js/translate/initializer/InitializerVisitor", "visitObjectDeclaration"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/initializer/InitializerVisitor", "visitObjectDeclaration"));
        }
        InitializerUtils.generateObjectInitializer(declaration, this.result, context2);
        return null;
    }
}

