/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.intellij.util.SmartList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.VarargValueArgument;
import org.jetbrains.k2js.translate.context.TemporaryConstVariable;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.utils.AnnotationsUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public class CallArgumentTranslator
extends AbstractTranslator {
    @NotNull
    private final ResolvedCall<?> resolvedCall;
    @Nullable
    private final JsExpression receiver;
    private final boolean isNativeFunctionCall;

    @NotNull
    public static ArgumentsInfo translate(@NotNull ResolvedCall<?> resolvedCall, @Nullable JsExpression receiver, @NotNull TranslationContext context2) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "translate"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "translate"));
        }
        ArgumentsInfo argumentsInfo = CallArgumentTranslator.translate(resolvedCall, receiver, context2, context2.dynamicContext().jsBlock());
        if (argumentsInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "translate"));
        }
        return argumentsInfo;
    }

    @NotNull
    public static ArgumentsInfo translate(@NotNull ResolvedCall<?> resolvedCall, @Nullable JsExpression receiver, @NotNull TranslationContext context2, @NotNull JsBlock block) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "translate"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "translate"));
        }
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "translate"));
        }
        TranslationContext innerContext = context2.innerBlock(block);
        CallArgumentTranslator argumentTranslator = new CallArgumentTranslator(resolvedCall, receiver, innerContext);
        ArgumentsInfo result2 = argumentTranslator.translate();
        context2.moveVarsFrom(innerContext);
        ArgumentsInfo argumentsInfo = result2;
        if (argumentsInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "translate"));
        }
        return argumentsInfo;
    }

    @NotNull
    public static ArgumentsKind translateSingleArgument(@NotNull ResolvedValueArgument actualArgument, @NotNull List<JsExpression> result2, @NotNull TranslationContext context2, boolean shouldWrapVarargInArray) {
        if (actualArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actualArgument", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "translateSingleArgument"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "translateSingleArgument"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "translateSingleArgument"));
        }
        List<ValueArgument> valueArguments2 = actualArgument.getArguments();
        if (actualArgument instanceof VarargValueArgument) {
            ArgumentsKind argumentsKind = CallArgumentTranslator.translateVarargArgument(valueArguments2, result2, context2, shouldWrapVarargInArray);
            if (argumentsKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "translateSingleArgument"));
            }
            return argumentsKind;
        }
        if (actualArgument instanceof DefaultValueArgument) {
            result2.add(context2.namer().getUndefinedExpression());
            ArgumentsKind argumentsKind = ArgumentsKind.HAS_NOT_EMPTY_EXPRESSION_ARGUMENT;
            if (argumentsKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "translateSingleArgument"));
            }
            return argumentsKind;
        }
        assert (actualArgument instanceof ExpressionValueArgument);
        assert (valueArguments2.size() == 1);
        JetExpression argumentExpression = valueArguments2.get(0).getArgumentExpression();
        assert (argumentExpression != null);
        JsExpression jsExpression = Translation.translateAsExpression(argumentExpression, context2);
        result2.add(jsExpression);
        if (JsAstUtils.isEmptyExpression(jsExpression)) {
            ArgumentsKind argumentsKind = ArgumentsKind.HAS_EMPTY_EXPRESSION_ARGUMENT;
            if (argumentsKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "translateSingleArgument"));
            }
            return argumentsKind;
        }
        ArgumentsKind argumentsKind = ArgumentsKind.HAS_NOT_EMPTY_EXPRESSION_ARGUMENT;
        if (argumentsKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "translateSingleArgument"));
        }
        return argumentsKind;
    }

    @NotNull
    private static ArgumentsKind translateVarargArgument(@NotNull List<ValueArgument> arguments, @NotNull List<JsExpression> result2, @NotNull TranslationContext context2, boolean shouldWrapVarargInArray) {
        List<JsExpression> list;
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "translateVarargArgument"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "translateVarargArgument"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "translateVarargArgument"));
        }
        ArgumentsKind resultKind = ArgumentsKind.HAS_NOT_EMPTY_EXPRESSION_ARGUMENT;
        if (arguments.isEmpty()) {
            if (shouldWrapVarargInArray) {
                result2.add(new JsArrayLiteral(Collections.<JsExpression>emptyList()));
            }
            ArgumentsKind argumentsKind = ArgumentsKind.HAS_NOT_EMPTY_EXPRESSION_ARGUMENT;
            if (argumentsKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "translateVarargArgument"));
            }
            return argumentsKind;
        }
        if (shouldWrapVarargInArray) {
            list = arguments.size() == 1 ? new SmartList() : new ArrayList(arguments.size());
            result2.add(new JsArrayLiteral(list));
        } else {
            list = result2;
        }
        SmartList<TranslationContext> argContexts = new SmartList<TranslationContext>();
        boolean argumentsShouldBeExtractedToTmpVars = false;
        for (ValueArgument argument : arguments) {
            JetExpression argumentExpression = argument.getArgumentExpression();
            assert (argumentExpression != null);
            TranslationContext argContext = context2.innerBlock();
            JsExpression argExpression = Translation.translateAsExpression(argumentExpression, argContext);
            list.add(argExpression);
            context2.moveVarsFrom(argContext);
            argContexts.add(argContext);
            boolean bl = argumentsShouldBeExtractedToTmpVars = argumentsShouldBeExtractedToTmpVars || !argContext.currentBlockIsEmpty();
            if (!JsAstUtils.isEmptyExpression(argExpression)) continue;
            resultKind = ArgumentsKind.HAS_EMPTY_EXPRESSION_ARGUMENT;
            break;
        }
        if (argumentsShouldBeExtractedToTmpVars) {
            CallArgumentTranslator.extractArguments(list, argContexts, context2, resultKind == ArgumentsKind.HAS_NOT_EMPTY_EXPRESSION_ARGUMENT);
        }
        ArgumentsKind argumentsKind = resultKind;
        if (argumentsKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "translateVarargArgument"));
        }
        return argumentsKind;
    }

    private static void extractArguments(@NotNull List<JsExpression> argExpressions, @NotNull List<TranslationContext> argContexts, @NotNull TranslationContext context2, boolean toTmpVars) {
        if (argExpressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argExpressions", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "extractArguments"));
        }
        if (argContexts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argContexts", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "extractArguments"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "extractArguments"));
        }
        for (int i = 0; i < argExpressions.size(); ++i) {
            TranslationContext argContext = argContexts.get(i);
            JsExpression jsArgExpression = argExpressions.get(i);
            if (argContext.currentBlockIsEmpty() && TranslationUtils.isCacheNeeded(jsArgExpression)) {
                if (toTmpVars) {
                    TemporaryVariable temporaryVariable = context2.declareTemporary(jsArgExpression);
                    context2.addStatementToCurrentBlock(temporaryVariable.assignmentExpression().makeStmt());
                    argExpressions.set(i, temporaryVariable.reference());
                    continue;
                }
                context2.addStatementToCurrentBlock(jsArgExpression.makeStmt());
                continue;
            }
            context2.addStatementsToCurrentBlockFrom(argContext);
        }
    }

    private CallArgumentTranslator(@NotNull ResolvedCall<?> resolvedCall, @Nullable JsExpression receiver, @NotNull TranslationContext context2) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "<init>"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "<init>"));
        }
        super(context2);
        this.resolvedCall = resolvedCall;
        this.receiver = receiver;
        this.isNativeFunctionCall = AnnotationsUtils.isNativeObject(resolvedCall.getCandidateDescriptor());
    }

    private void removeLastUndefinedArguments(@NotNull List<JsExpression> result2) {
        int i;
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator", "removeLastUndefinedArguments"));
        }
        for (i = result2.size() - 1; i >= 0 && result2.get(i) == this.context().namer().getUndefinedExpression(); --i) {
        }
        result2.subList(i + 1, result2.size()).clear();
    }

    private ArgumentsInfo translate() {
        List<ValueParameterDescriptor> valueParameters = this.resolvedCall.getResultingDescriptor().getValueParameters();
        if (valueParameters.isEmpty()) {
            return new ArgumentsInfo(Collections.<JsExpression>emptyList(), false, null);
        }
        boolean hasSpreadOperator = false;
        TemporaryConstVariable cachedReceiver = null;
        AbstractList result2 = new ArrayList<JsExpression>(valueParameters.size());
        List<ResolvedValueArgument> valueArgumentsByIndex = this.resolvedCall.getValueArgumentsByIndex();
        if (valueArgumentsByIndex == null) {
            throw new IllegalStateException("Failed to arrange value arguments by index: " + this.resolvedCall.getResultingDescriptor());
        }
        AbstractList argsBeforeVararg = null;
        boolean argumentsShouldBeExtractedToTmpVars = false;
        SmartList<TranslationContext> argContexts = new SmartList<TranslationContext>();
        ArgumentsKind kind = ArgumentsKind.HAS_NOT_EMPTY_EXPRESSION_ARGUMENT;
        for (ValueParameterDescriptor parameterDescriptor : valueParameters) {
            ResolvedValueArgument actualArgument = valueArgumentsByIndex.get(parameterDescriptor.getIndex());
            if (actualArgument instanceof VarargValueArgument) {
                assert (!hasSpreadOperator);
                List<ValueArgument> arguments = actualArgument.getArguments();
                boolean bl = hasSpreadOperator = arguments.size() == 1 && arguments.get(0).getSpreadElement() != null;
                if (this.isNativeFunctionCall && hasSpreadOperator) {
                    argsBeforeVararg = result2;
                    result2 = new SmartList();
                }
            }
            TranslationContext argContext = this.context().innerBlock();
            kind = CallArgumentTranslator.translateSingleArgument(actualArgument, result2, argContext, !this.isNativeFunctionCall && !hasSpreadOperator);
            this.context().moveVarsFrom(argContext);
            argContexts.add(argContext);
            boolean bl = argumentsShouldBeExtractedToTmpVars = argumentsShouldBeExtractedToTmpVars || !argContext.currentBlockIsEmpty();
            if (kind != ArgumentsKind.HAS_EMPTY_EXPRESSION_ARGUMENT) continue;
            break;
        }
        if (argumentsShouldBeExtractedToTmpVars) {
            CallArgumentTranslator.extractArguments(result2, argContexts, this.context(), kind == ArgumentsKind.HAS_NOT_EMPTY_EXPRESSION_ARGUMENT);
        }
        if (this.isNativeFunctionCall && hasSpreadOperator) {
            if (!argsBeforeVararg.isEmpty()) {
                JsInvocation concatArguments = new JsInvocation((JsExpression)new JsNameRef("concat", (JsExpression)new JsArrayLiteral(argsBeforeVararg)), result2);
                result2 = new SmartList<JsInvocation>(concatArguments);
            }
            if (this.receiver != null) {
                cachedReceiver = this.context().getOrDeclareTemporaryConstVariable(this.receiver);
                result2.add(0, cachedReceiver.reference());
            } else {
                result2.add(0, JsLiteral.NULL);
            }
        }
        this.removeLastUndefinedArguments(result2);
        return new ArgumentsInfo(result2, hasSpreadOperator, cachedReceiver);
    }

    private static enum ArgumentsKind {
        HAS_EMPTY_EXPRESSION_ARGUMENT,
        HAS_NOT_EMPTY_EXPRESSION_ARGUMENT;

    }

    public static class ArgumentsInfo {
        private final List<JsExpression> translateArguments;
        private final boolean hasSpreadOperator;
        private final TemporaryConstVariable cachedReceiver;

        public ArgumentsInfo(List<JsExpression> arguments, boolean operator, TemporaryConstVariable receiver) {
            this.translateArguments = arguments;
            this.hasSpreadOperator = operator;
            this.cachedReceiver = receiver;
        }

        @NotNull
        public List<JsExpression> getTranslateArguments() {
            List<JsExpression> list = this.translateArguments;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallArgumentTranslator$ArgumentsInfo", "getTranslateArguments"));
            }
            return list;
        }

        public boolean isHasSpreadOperator() {
            return this.hasSpreadOperator;
        }

        @Nullable
        public TemporaryConstVariable getCachedReceiver() {
            return this.cachedReceiver;
        }
    }
}

