/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiParserFacadeImpl
implements PsiParserFacade {
    protected final PsiManagerEx myManager;

    public PsiParserFacadeImpl(PsiManagerEx manager) {
        this.myManager = manager;
    }

    @Override
    @NotNull
    public PsiElement createWhiteSpaceFromText(@NotNull @NonNls String text) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiParserFacadeImpl", "createWhiteSpaceFromText"));
        }
        FileElement holderElement = DummyHolderFactory.createHolder(this.myManager, null).getTreeElement();
        LeafElement newElement = ASTFactory.leaf(TokenType.WHITE_SPACE, holderElement.getCharTable().intern(text));
        holderElement.rawAddChildren(newElement);
        GeneratedMarkerVisitor.markGenerated(newElement.getPsi());
        PsiElement psiElement = newElement.getPsi();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiParserFacadeImpl", "createWhiteSpaceFromText"));
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiComment createLineCommentFromText(@NotNull LanguageFileType fileType, @NotNull String text) throws IncorrectOperationException {
        PsiElement[] children;
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/psi/impl/PsiParserFacadeImpl", "createLineCommentFromText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiParserFacadeImpl", "createLineCommentFromText"));
        }
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(fileType.getLanguage());
        assert (commenter != null);
        String prefix = commenter.getLineCommentPrefix();
        if (prefix == null) {
            throw new IncorrectOperationException("No line comment prefix defined for language " + fileType.getLanguage().getID());
        }
        PsiFile aFile = this.createDummyFile(prefix + text, fileType);
        for (PsiElement aChildren : children = aFile.getChildren()) {
            if (!(aChildren instanceof PsiComment)) continue;
            PsiComment comment = (PsiComment)aChildren;
            DummyHolderFactory.createHolder((PsiManager)this.myManager, (TreeElement)SourceTreeToPsiMap.psiElementToTree(comment), null);
            PsiComment psiComment = comment;
            if (psiComment == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiParserFacadeImpl", "createLineCommentFromText"));
            }
            return psiComment;
        }
        throw new IncorrectOperationException("Incorrect comment \"" + text + "\".");
    }

    @Override
    @NotNull
    public PsiComment createLineOrBlockCommentFromText(@NotNull Language lang, @NotNull String text) throws IncorrectOperationException {
        PsiElement[] children;
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/intellij/psi/impl/PsiParserFacadeImpl", "createLineOrBlockCommentFromText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiParserFacadeImpl", "createLineOrBlockCommentFromText"));
        }
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(lang);
        assert (commenter != null) : lang;
        String prefix = commenter.getLineCommentPrefix();
        String blockCommentPrefix = commenter.getBlockCommentPrefix();
        String blockCommentSuffix = commenter.getBlockCommentSuffix();
        assert (prefix != null || blockCommentPrefix != null && blockCommentSuffix != null);
        PsiFile aFile = PsiFileFactory.getInstance(this.myManager.getProject()).createFileFromText("_Dummy_", lang, (CharSequence)(prefix != null ? prefix + text : blockCommentPrefix + text + blockCommentSuffix));
        for (PsiElement aChildren : children = aFile.getChildren()) {
            if (!(aChildren instanceof PsiComment)) continue;
            PsiComment comment = (PsiComment)aChildren;
            DummyHolderFactory.createHolder((PsiManager)this.myManager, (TreeElement)SourceTreeToPsiMap.psiElementToTree(comment), null);
            PsiComment psiComment = comment;
            if (psiComment == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiParserFacadeImpl", "createLineOrBlockCommentFromText"));
            }
            return psiComment;
        }
        throw new IncorrectOperationException("Incorrect comment \"" + text + "\".");
    }

    protected PsiFile createDummyFile(String text, LanguageFileType fileType) {
        String ext = fileType.getDefaultExtension();
        String fileName = "_Dummy_." + ext;
        return PsiFileFactory.getInstance(this.myManager.getProject()).createFileFromText(fileType, fileName, (CharSequence)text, 0, text.length());
    }
}

