/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.util.text.CharSequenceSubSequence;
import org.jetbrains.annotations.NotNull;

public abstract class ImmutableCharSequence
implements CharSequence {
    public static CharSequence asImmutable(@NotNull CharSequence cs) {
        if (cs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cs", "com/intellij/util/text/ImmutableCharSequence", "asImmutable"));
        }
        return ImmutableCharSequence.isImmutable(cs) ? cs : ((Object)cs).toString();
    }

    public static boolean isImmutable(@NotNull CharSequence cs) {
        if (cs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cs", "com/intellij/util/text/ImmutableCharSequence", "isImmutable"));
        }
        if (cs instanceof ImmutableCharSequence) {
            return true;
        }
        if (cs instanceof CharSequenceSubSequence) {
            return ImmutableCharSequence.isImmutable(((CharSequenceSubSequence)cs).getBaseSequence());
        }
        return false;
    }
}

