/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.asJava;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.light.LightTypeParameterListBuilder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kotlin.Function1;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.asJava.JavaElementFinder;
import org.jetbrains.jet.asJava.KotlinLightMethod;
import org.jetbrains.jet.asJava.KotlinLightTypeParameter;
import org.jetbrains.jet.asJava.LightClassGenerationSupport;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassBody;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwner;
import org.jetbrains.jet.lang.resolve.java.JvmAbi;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.utils.KotlinVfsUtil;
import org.jetbrains.jet.utils.UtilsPackage;

public class LightClassUtil {
    private static final Logger LOG = Logger.getInstance(LightClassUtil.class);
    public static final File BUILT_INS_SRC_DIR = new File("core/builtins/native", KotlinBuiltIns.BUILT_INS_PACKAGE_NAME.asString());

    public static boolean belongsToKotlinBuiltIns(@NotNull JetFile file) {
        VirtualFile parent;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/asJava/LightClassUtil", "belongsToKotlinBuiltIns"));
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null && (parent = virtualFile.getParent()) != null) {
            try {
                String jetVfsPathUrl = KotlinVfsUtil.convertFromUrl(LightClassUtil.getBuiltInsDirUrl());
                String fileDirVfsUrl = parent.getUrl();
                if (jetVfsPathUrl.equals(fileDirVfsUrl)) {
                    return true;
                }
            }
            catch (MalformedURLException e) {
                LOG.error(e);
            }
        }
        return false;
    }

    @NotNull
    public static URL getBuiltInsDirUrl() {
        URL uRL = BuiltinsDirUrlHolder.BUILT_INS_DIR_URL;
        if (uRL == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/LightClassUtil", "getBuiltInsDirUrl"));
        }
        return uRL;
    }

    @NotNull
    private static URL computeBuiltInsDir() {
        URL uRL;
        block7: {
            String builtInFilePath = "/" + KotlinBuiltIns.BUILT_INS_PACKAGE_NAME + "/Library.kt";
            URL url = KotlinBuiltIns.class.getResource(builtInFilePath);
            if (url == null) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    URL uRL2;
                    block6: {
                        try {
                            uRL2 = new URL("file", "", FileUtil.toSystemIndependentName(BUILT_INS_SRC_DIR.getAbsolutePath()));
                            if (uRL2 != null) break block6;
                        }
                        catch (MalformedURLException e) {
                            throw UtilsPackage.rethrow(e);
                        }
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/LightClassUtil", "computeBuiltInsDir"));
                    }
                    return uRL2;
                }
                throw new IllegalStateException("Built-ins file wasn't found at url: " + builtInFilePath);
            }
            try {
                uRL = new URL(url.getProtocol(), url.getHost(), PathUtil.getParentPath(url.getFile()));
                if (uRL != null) break block7;
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/LightClassUtil", "computeBuiltInsDir"));
        }
        return uRL;
    }

    @Nullable
    static PsiClass findClass(@NotNull FqName fqn, @NotNull StubElement<?> stub) {
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "org/jetbrains/jet/asJava/LightClassUtil", "findClass"));
        }
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/asJava/LightClassUtil", "findClass"));
        }
        if (stub instanceof PsiClassStub && Comparing.equal(fqn.asString(), ((PsiClassStub)stub).getQualifiedName())) {
            return (PsiClass)stub.getPsi();
        }
        if (stub instanceof PsiClassStub || stub instanceof PsiFileStub) {
            for (StubElement child : stub.getChildrenStubs()) {
                PsiClass answer = LightClassUtil.findClass(fqn, child);
                if (answer == null) continue;
                return answer;
            }
        }
        return null;
    }

    @Nullable
    public static PsiClass getPsiClass(@Nullable JetClassOrObject classOrObject) {
        if (classOrObject == null) {
            return null;
        }
        return LightClassGenerationSupport.getInstance(classOrObject.getProject()).getPsiClass(classOrObject);
    }

    @Nullable
    public static PsiMethod getLightClassAccessorMethod(@NotNull JetPropertyAccessor accessor) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "org/jetbrains/jet/asJava/LightClassUtil", "getLightClassAccessorMethod"));
        }
        return LightClassUtil.getPsiMethodWrapper(accessor);
    }

    @NotNull
    public static PropertyAccessorsPsiMethods getLightClassPropertyMethods(@NotNull JetProperty property2) {
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/asJava/LightClassUtil", "getLightClassPropertyMethods"));
        }
        JetPropertyAccessor getter = property2.getGetter();
        JetPropertyAccessor setter = property2.getSetter();
        PsiMethod getterWrapper = getter != null ? LightClassUtil.getLightClassAccessorMethod(getter) : null;
        PsiMethod setterWrapper = setter != null ? LightClassUtil.getLightClassAccessorMethod(setter) : null;
        PropertyAccessorsPsiMethods propertyAccessorsPsiMethods = LightClassUtil.extractPropertyAccessors(property2, getterWrapper, setterWrapper);
        if (propertyAccessorsPsiMethods == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/LightClassUtil", "getLightClassPropertyMethods"));
        }
        return propertyAccessorsPsiMethods;
    }

    @NotNull
    public static PropertyAccessorsPsiMethods getLightClassPropertyMethods(@NotNull JetParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/jet/asJava/LightClassUtil", "getLightClassPropertyMethods"));
        }
        PropertyAccessorsPsiMethods propertyAccessorsPsiMethods = LightClassUtil.extractPropertyAccessors(parameter, null, null);
        if (propertyAccessorsPsiMethods == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/LightClassUtil", "getLightClassPropertyMethods"));
        }
        return propertyAccessorsPsiMethods;
    }

    @Nullable
    public static PsiMethod getLightClassMethod(@NotNull JetNamedFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/asJava/LightClassUtil", "getLightClassMethod"));
        }
        return LightClassUtil.getPsiMethodWrapper(function);
    }

    @Nullable
    private static PsiMethod getPsiMethodWrapper(@NotNull JetDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/asJava/LightClassUtil", "getPsiMethodWrapper"));
        }
        List<PsiMethod> wrappers = LightClassUtil.getPsiMethodWrappers(declaration, false);
        return !wrappers.isEmpty() ? wrappers.get(0) : null;
    }

    @NotNull
    private static List<PsiMethod> getPsiMethodWrappers(@NotNull JetDeclaration declaration, boolean collectAll) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/asJava/LightClassUtil", "getPsiMethodWrappers"));
        }
        PsiClass psiClass = LightClassUtil.getWrappingClass(declaration);
        if (psiClass == null) {
            List<PsiMethod> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/LightClassUtil", "getPsiMethodWrappers"));
            }
            return list;
        }
        SmartList<PsiMethod> methods = new SmartList<PsiMethod>();
        for (PsiMethod method : psiClass.getMethods()) {
            SmartList<PsiMethod> smartList;
            try {
                if (!(method instanceof KotlinLightMethod) || ((KotlinLightMethod)method).getOrigin() != declaration) continue;
                methods.add(method);
                if (collectAll) continue;
                smartList = methods;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new IllegalStateException("Error while wrapping declaration " + declaration.getName() + "Context\n:" + String.format("=== In file ===\n%s\n=== On element ===\n%s\n=== WrappedElement ===\n%s\n", declaration.getContainingFile().getText(), declaration.getText(), method.toString()), e);
            }
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/LightClassUtil", "getPsiMethodWrappers"));
            }
            return smartList;
        }
        SmartList<PsiMethod> smartList = methods;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/LightClassUtil", "getPsiMethodWrappers"));
        }
        return smartList;
    }

    @Nullable
    private static PsiClass getWrappingClass(@NotNull JetDeclaration declaration) {
        JetClass constructorClass;
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/asJava/LightClassUtil", "getWrappingClass"));
        }
        if (declaration instanceof JetParameter && (constructorClass = JetPsiUtil.getClassIfParameterIsProperty((JetParameter)declaration)) != null) {
            return LightClassUtil.getPsiClass(constructorClass);
        }
        if (declaration instanceof JetPropertyAccessor) {
            PsiElement propertyParent = declaration.getParent();
            assert (propertyParent instanceof JetProperty) : "JetProperty is expected to be parent of accessor";
            declaration = (JetProperty)propertyParent;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)declaration, JetFunction.class, JetProperty.class) != null) {
            return null;
        }
        PsiElement parent = declaration.getParent();
        if (parent instanceof JetFile) {
            FqName fqName2 = PackageClassUtils.getPackageClassFqName(((JetFile)parent).getPackageFqName());
            Project project = declaration.getProject();
            return JavaElementFinder.getInstance(project).findClass(fqName2.asString(), GlobalSearchScope.allScope(project));
        }
        if (parent instanceof JetClassBody) {
            assert (parent.getParent() instanceof JetClassOrObject);
            return LightClassUtil.getPsiClass((JetClassOrObject)parent.getParent());
        }
        return null;
    }

    @NotNull
    private static PropertyAccessorsPsiMethods extractPropertyAccessors(@NotNull JetDeclaration jetDeclaration, @Nullable PsiMethod specialGetter, @Nullable PsiMethod specialSetter) {
        if (jetDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetDeclaration", "org/jetbrains/jet/asJava/LightClassUtil", "extractPropertyAccessors"));
        }
        PsiMethod getterWrapper = specialGetter;
        PsiMethod setterWrapper = specialSetter;
        if (getterWrapper == null || setterWrapper == null) {
            List<PsiMethod> wrappers = KotlinPackage.filter(LightClassUtil.getPsiMethodWrappers(jetDeclaration, true), new Function1<PsiMethod, Boolean>(){

                @Override
                public Boolean invoke(PsiMethod method) {
                    return JvmAbi.isAccessorName(method.getName());
                }
            });
            assert (wrappers.size() <= 2) : "Maximum two wrappers are expected to be generated for declaration: " + jetDeclaration.getText();
            for (PsiMethod wrapper : wrappers) {
                if (wrapper.getName().startsWith("set")) {
                    assert (setterWrapper == null) : String.format("Setter accessor isn't expected to be reassigned (old: %s, new: %s)", setterWrapper, wrapper);
                    setterWrapper = wrapper;
                    continue;
                }
                assert (getterWrapper == null) : String.format("Getter accessor isn't expected to be reassigned (old: %s, new: %s)", getterWrapper, wrapper);
                getterWrapper = wrapper;
            }
        }
        PropertyAccessorsPsiMethods propertyAccessorsPsiMethods = new PropertyAccessorsPsiMethods(getterWrapper, setterWrapper);
        if (propertyAccessorsPsiMethods == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/LightClassUtil", "extractPropertyAccessors"));
        }
        return propertyAccessorsPsiMethods;
    }

    @NotNull
    public static PsiTypeParameterList buildLightTypeParameterList(PsiTypeParameterListOwner owner, JetDeclaration declaration) {
        LightTypeParameterListBuilder builder = new LightTypeParameterListBuilder(owner.getManager(), owner.getLanguage());
        if (declaration instanceof JetTypeParameterListOwner) {
            JetTypeParameterListOwner typeParameterListOwner = (JetTypeParameterListOwner)declaration;
            List<JetTypeParameter> parameters2 = typeParameterListOwner.getTypeParameters();
            for (int i = 0; i < parameters2.size(); ++i) {
                JetTypeParameter jetTypeParameter = parameters2.get(i);
                String name = jetTypeParameter.getName();
                String safeName = name == null ? "__no_name__" : name;
                builder.addParameter(new KotlinLightTypeParameter(owner, i, safeName));
            }
        }
        LightTypeParameterListBuilder lightTypeParameterListBuilder = builder;
        if (lightTypeParameterListBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/LightClassUtil", "buildLightTypeParameterList"));
        }
        return lightTypeParameterListBuilder;
    }

    private LightClassUtil() {
    }

    static /* synthetic */ URL access$000() {
        return LightClassUtil.computeBuiltInsDir();
    }

    public static class PropertyAccessorsPsiMethods
    implements Iterable<PsiMethod> {
        private final PsiMethod getter;
        private final PsiMethod setter;
        private final Collection<PsiMethod> accessors = new ArrayList<PsiMethod>(2);

        PropertyAccessorsPsiMethods(@Nullable PsiMethod getter, @Nullable PsiMethod setter) {
            this.getter = getter;
            if (getter != null) {
                this.accessors.add(getter);
            }
            this.setter = setter;
            if (setter != null) {
                this.accessors.add(setter);
            }
        }

        @Nullable
        public PsiMethod getGetter() {
            return this.getter;
        }

        @Nullable
        public PsiMethod getSetter() {
            return this.setter;
        }

        @Override
        @NotNull
        public Iterator<PsiMethod> iterator() {
            Iterator<PsiMethod> iterator2 = this.accessors.iterator();
            if (iterator2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/LightClassUtil$PropertyAccessorsPsiMethods", "iterator"));
            }
            return iterator2;
        }
    }

    private static final class BuiltinsDirUrlHolder {
        private static final URL BUILT_INS_DIR_URL = LightClassUtil.access$000();

        private BuiltinsDirUrlHolder() {
        }
    }
}

