/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization.descriptors;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.SerializationPackage;
import org.jetbrains.jet.descriptors.serialization.TypeDeserializer;
import org.jetbrains.jet.descriptors.serialization.context.DeserializationContext;
import org.jetbrains.jet.lang.descriptors.SourceElement;
import org.jetbrains.jet.lang.descriptors.impl.AbstractLazyTypeParameterDescriptor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class DeserializedTypeParameterDescriptor
extends AbstractLazyTypeParameterDescriptor {
    private final ProtoBuf.TypeParameter proto;
    private final TypeDeserializer typeDeserializer;

    public DeserializedTypeParameterDescriptor(@NotNull DeserializationContext c, @NotNull ProtoBuf.TypeParameter proto, int index2) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedTypeParameterDescriptor", "<init>"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedTypeParameterDescriptor", "<init>"));
        }
        super(c.getStorageManager(), c.getContainingDeclaration(), c.getNameResolver().getName(proto.getName()), SerializationPackage.variance(proto.getVariance()), proto.getReified(), index2, SourceElement.NO_SOURCE);
        this.proto = proto;
        this.typeDeserializer = c.getTypeDeserializer();
    }

    @Override
    @NotNull
    protected Set<JetType> resolveUpperBounds() {
        if (this.proto.getUpperBoundCount() == 0) {
            Set<JetType> set = Collections.singleton(KotlinBuiltIns.getInstance().getDefaultBound());
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedTypeParameterDescriptor", "resolveUpperBounds"));
            }
            return set;
        }
        LinkedHashSet<JetType> result2 = new LinkedHashSet<JetType>(this.proto.getUpperBoundCount());
        for (ProtoBuf.Type upperBound : this.proto.getUpperBoundList()) {
            result2.add(this.typeDeserializer.type(upperBound));
        }
        LinkedHashSet<JetType> linkedHashSet = result2;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedTypeParameterDescriptor", "resolveUpperBounds"));
        }
        return linkedHashSet;
    }
}

