/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.di;

import com.intellij.openapi.project.Project;
import javax.annotation.PreDestroy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.context.GlobalContext;
import org.jetbrains.jet.context.LazinessToken;
import org.jetbrains.jet.lang.PlatformToKotlinClassMap;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.psi.JetImportsFactory;
import org.jetbrains.jet.lang.reflect.ReflectionTypes;
import org.jetbrains.jet.lang.resolve.AdditionalCheckerProvider;
import org.jetbrains.jet.lang.resolve.AnnotationResolver;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BodyResolver;
import org.jetbrains.jet.lang.resolve.ControlFlowAnalyzer;
import org.jetbrains.jet.lang.resolve.DeclarationResolver;
import org.jetbrains.jet.lang.resolve.DeclarationsChecker;
import org.jetbrains.jet.lang.resolve.DelegatedPropertyResolver;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.FunctionAnalyzerExtension;
import org.jetbrains.jet.lang.resolve.ImportsResolver;
import org.jetbrains.jet.lang.resolve.LazyTopDownAnalyzer;
import org.jetbrains.jet.lang.resolve.ModifiersChecker;
import org.jetbrains.jet.lang.resolve.OverloadResolver;
import org.jetbrains.jet.lang.resolve.OverrideResolver;
import org.jetbrains.jet.lang.resolve.PartialBodyResolveProvider;
import org.jetbrains.jet.lang.resolve.QualifiedExpressionResolver;
import org.jetbrains.jet.lang.resolve.ScriptBodyResolver;
import org.jetbrains.jet.lang.resolve.TypeResolver;
import org.jetbrains.jet.lang.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.jet.lang.resolve.calls.CallCompleter;
import org.jetbrains.jet.lang.resolve.calls.CallExpressionResolver;
import org.jetbrains.jet.lang.resolve.calls.CallResolver;
import org.jetbrains.jet.lang.resolve.calls.CallResolverExtensionProvider;
import org.jetbrains.jet.lang.resolve.calls.CandidateResolver;
import org.jetbrains.jet.lang.resolve.calls.tasks.TaskPrioritizer;
import org.jetbrains.jet.lang.resolve.lazy.KotlinCodeAnalyzer;
import org.jetbrains.jet.lang.types.expressions.ControlStructureTypingUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingComponents;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingUtils;
import org.jetbrains.jet.lang.types.expressions.ForLoopConventionsChecker;
import org.jetbrains.jet.storage.StorageManager;

public class InjectorForLazyBodyResolve {
    private final Project project;
    private final GlobalContext globalContext;
    private final StorageManager storageManager;
    private final BindingTrace bindingTrace;
    private final AdditionalCheckerProvider additionalCheckerProvider;
    private final ModuleDescriptor moduleDescriptor;
    private final PlatformToKotlinClassMap platformToKotlinClassMap;
    private final LazyTopDownAnalyzer lazyTopDownAnalyzer;
    private final BodyResolver bodyResolver;
    private final AnnotationResolver annotationResolver;
    private final CallResolver callResolver;
    private final ArgumentTypeResolver argumentTypeResolver;
    private final ExpressionTypingServices expressionTypingServices;
    private final ExpressionTypingComponents expressionTypingComponents;
    private final ControlStructureTypingUtils controlStructureTypingUtils;
    private final ExpressionTypingUtils expressionTypingUtils;
    private final ForLoopConventionsChecker forLoopConventionsChecker;
    private final ReflectionTypes reflectionTypes;
    private final CallExpressionResolver callExpressionResolver;
    private final DescriptorResolver descriptorResolver;
    private final DelegatedPropertyResolver delegatedPropertyResolver;
    private final TypeResolver typeResolver;
    private final QualifiedExpressionResolver qualifiedExpressionResolver;
    private final TypeResolver.FlexibleTypeCapabilitiesProvider flexibleTypeCapabilitiesProvider;
    private final LazinessToken lazinessToken;
    private final CallResolverExtensionProvider callResolverExtensionProvider;
    private final PartialBodyResolveProvider partialBodyResolveProvider;
    private final CallCompleter callCompleter;
    private final CandidateResolver candidateResolver;
    private final TaskPrioritizer taskPrioritizer;
    private final ControlFlowAnalyzer controlFlowAnalyzer;
    private final DeclarationsChecker declarationsChecker;
    private final ModifiersChecker modifiersChecker;
    private final FunctionAnalyzerExtension functionAnalyzerExtension;
    private final ScriptBodyResolver scriptBodyResolver;
    private final DeclarationResolver declarationResolver;
    private final ImportsResolver importsResolver;
    private final JetImportsFactory jetImportsFactory;
    private final OverloadResolver overloadResolver;
    private final OverrideResolver overrideResolver;

    public InjectorForLazyBodyResolve(@NotNull Project project, @NotNull GlobalContext globalContext, @NotNull KotlinCodeAnalyzer analyzer, @NotNull BindingTrace bindingTrace, @NotNull AdditionalCheckerProvider additionalCheckerProvider) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/di/InjectorForLazyBodyResolve", "<init>"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "org/jetbrains/jet/di/InjectorForLazyBodyResolve", "<init>"));
        }
        if (analyzer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "analyzer", "org/jetbrains/jet/di/InjectorForLazyBodyResolve", "<init>"));
        }
        if (bindingTrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingTrace", "org/jetbrains/jet/di/InjectorForLazyBodyResolve", "<init>"));
        }
        if (additionalCheckerProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalCheckerProvider", "org/jetbrains/jet/di/InjectorForLazyBodyResolve", "<init>"));
        }
        this.project = project;
        this.globalContext = globalContext;
        this.storageManager = globalContext.getStorageManager();
        this.bindingTrace = bindingTrace;
        this.additionalCheckerProvider = additionalCheckerProvider;
        this.moduleDescriptor = analyzer.getModuleDescriptor();
        this.platformToKotlinClassMap = this.moduleDescriptor.getPlatformToKotlinClassMap();
        this.lazyTopDownAnalyzer = new LazyTopDownAnalyzer();
        this.bodyResolver = new BodyResolver();
        this.annotationResolver = new AnnotationResolver();
        this.callResolver = new CallResolver();
        this.argumentTypeResolver = new ArgumentTypeResolver();
        this.expressionTypingComponents = new ExpressionTypingComponents();
        this.expressionTypingServices = new ExpressionTypingServices(this.expressionTypingComponents);
        this.controlStructureTypingUtils = new ControlStructureTypingUtils(this.expressionTypingServices);
        this.expressionTypingUtils = new ExpressionTypingUtils(this.expressionTypingServices, this.callResolver);
        this.forLoopConventionsChecker = new ForLoopConventionsChecker();
        this.reflectionTypes = new ReflectionTypes(this.moduleDescriptor);
        this.callExpressionResolver = new CallExpressionResolver();
        this.descriptorResolver = new DescriptorResolver();
        this.delegatedPropertyResolver = new DelegatedPropertyResolver();
        this.qualifiedExpressionResolver = new QualifiedExpressionResolver();
        this.flexibleTypeCapabilitiesProvider = new TypeResolver.FlexibleTypeCapabilitiesProvider();
        this.lazinessToken = new LazinessToken();
        this.typeResolver = new TypeResolver(this.annotationResolver, this.qualifiedExpressionResolver, this.moduleDescriptor, this.flexibleTypeCapabilitiesProvider, this.storageManager, this.lazinessToken);
        this.callResolverExtensionProvider = new CallResolverExtensionProvider();
        this.partialBodyResolveProvider = new PartialBodyResolveProvider();
        this.candidateResolver = new CandidateResolver();
        this.callCompleter = new CallCompleter(this.argumentTypeResolver, this.candidateResolver);
        this.taskPrioritizer = new TaskPrioritizer(this.storageManager);
        this.controlFlowAnalyzer = new ControlFlowAnalyzer();
        this.declarationsChecker = new DeclarationsChecker();
        this.modifiersChecker = new ModifiersChecker(bindingTrace, additionalCheckerProvider);
        this.functionAnalyzerExtension = new FunctionAnalyzerExtension();
        this.scriptBodyResolver = new ScriptBodyResolver();
        this.declarationResolver = new DeclarationResolver();
        this.importsResolver = new ImportsResolver();
        this.jetImportsFactory = new JetImportsFactory();
        this.overloadResolver = new OverloadResolver();
        this.overrideResolver = new OverrideResolver();
        this.lazyTopDownAnalyzer.setBodyResolver(this.bodyResolver);
        this.lazyTopDownAnalyzer.setDeclarationResolver(this.declarationResolver);
        this.lazyTopDownAnalyzer.setModuleDescriptor(this.moduleDescriptor);
        this.lazyTopDownAnalyzer.setOverloadResolver(this.overloadResolver);
        this.lazyTopDownAnalyzer.setOverrideResolver(this.overrideResolver);
        this.lazyTopDownAnalyzer.setTrace(bindingTrace);
        this.bodyResolver.setAnnotationResolver(this.annotationResolver);
        this.bodyResolver.setCallResolver(this.callResolver);
        this.bodyResolver.setControlFlowAnalyzer(this.controlFlowAnalyzer);
        this.bodyResolver.setDeclarationsChecker(this.declarationsChecker);
        this.bodyResolver.setDelegatedPropertyResolver(this.delegatedPropertyResolver);
        this.bodyResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.bodyResolver.setFunctionAnalyzerExtension(this.functionAnalyzerExtension);
        this.bodyResolver.setScriptBodyResolverResolver(this.scriptBodyResolver);
        this.bodyResolver.setTrace(bindingTrace);
        this.annotationResolver.setCallResolver(this.callResolver);
        this.annotationResolver.setStorageManager(this.storageManager);
        this.annotationResolver.setTypeResolver(this.typeResolver);
        this.callResolver.setArgumentTypeResolver(this.argumentTypeResolver);
        this.callResolver.setCallCompleter(this.callCompleter);
        this.callResolver.setCandidateResolver(this.candidateResolver);
        this.callResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.callResolver.setTaskPrioritizer(this.taskPrioritizer);
        this.callResolver.setTypeResolver(this.typeResolver);
        this.argumentTypeResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.argumentTypeResolver.setTypeResolver(this.typeResolver);
        this.expressionTypingServices.setAnnotationResolver(this.annotationResolver);
        this.expressionTypingServices.setCallExpressionResolver(this.callExpressionResolver);
        this.expressionTypingServices.setCallResolver(this.callResolver);
        this.expressionTypingServices.setDescriptorResolver(this.descriptorResolver);
        this.expressionTypingServices.setExtensionProvider(this.callResolverExtensionProvider);
        this.expressionTypingServices.setPartialBodyResolveProvider(this.partialBodyResolveProvider);
        this.expressionTypingServices.setProject(project);
        this.expressionTypingServices.setTypeResolver(this.typeResolver);
        this.expressionTypingComponents.setAdditionalCheckerProvider(additionalCheckerProvider);
        this.expressionTypingComponents.setCallResolver(this.callResolver);
        this.expressionTypingComponents.setControlStructureTypingUtils(this.controlStructureTypingUtils);
        this.expressionTypingComponents.setExpressionTypingServices(this.expressionTypingServices);
        this.expressionTypingComponents.setExpressionTypingUtils(this.expressionTypingUtils);
        this.expressionTypingComponents.setForLoopConventionsChecker(this.forLoopConventionsChecker);
        this.expressionTypingComponents.setGlobalContext(globalContext);
        this.expressionTypingComponents.setPlatformToKotlinClassMap(this.platformToKotlinClassMap);
        this.expressionTypingComponents.setReflectionTypes(this.reflectionTypes);
        this.forLoopConventionsChecker.setExpressionTypingServices(this.expressionTypingServices);
        this.forLoopConventionsChecker.setExpressionTypingUtils(this.expressionTypingUtils);
        this.forLoopConventionsChecker.setProject(project);
        this.callExpressionResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.descriptorResolver.setAnnotationResolver(this.annotationResolver);
        this.descriptorResolver.setDelegatedPropertyResolver(this.delegatedPropertyResolver);
        this.descriptorResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.descriptorResolver.setStorageManager(this.storageManager);
        this.descriptorResolver.setTypeResolver(this.typeResolver);
        this.delegatedPropertyResolver.setCallResolver(this.callResolver);
        this.delegatedPropertyResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.candidateResolver.setArgumentTypeResolver(this.argumentTypeResolver);
        this.controlFlowAnalyzer.setTrace(bindingTrace);
        this.declarationsChecker.setDescriptorResolver(this.descriptorResolver);
        this.declarationsChecker.setModifiersChecker(this.modifiersChecker);
        this.declarationsChecker.setTrace(bindingTrace);
        this.functionAnalyzerExtension.setTrace(bindingTrace);
        this.scriptBodyResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.declarationResolver.setAnnotationResolver(this.annotationResolver);
        this.declarationResolver.setDescriptorResolver(this.descriptorResolver);
        this.declarationResolver.setImportsResolver(this.importsResolver);
        this.declarationResolver.setTrace(bindingTrace);
        this.importsResolver.setImportsFactory(this.jetImportsFactory);
        this.importsResolver.setModuleDescriptor(this.moduleDescriptor);
        this.importsResolver.setQualifiedExpressionResolver(this.qualifiedExpressionResolver);
        this.importsResolver.setTrace(bindingTrace);
        this.jetImportsFactory.setProject(project);
        this.overloadResolver.setTrace(bindingTrace);
        this.overrideResolver.setTrace(bindingTrace);
    }

    @PreDestroy
    public void destroy() {
    }

    public LazyTopDownAnalyzer getLazyTopDownAnalyzer() {
        return this.lazyTopDownAnalyzer;
    }
}

