/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartFMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Function0;
import kotlin.Function1;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.cfg.GenerationTrigger;
import org.jetbrains.jet.lang.cfg.JetControlFlowBuilder;
import org.jetbrains.jet.lang.cfg.Label;
import org.jetbrains.jet.lang.cfg.LoopInfo;
import org.jetbrains.jet.lang.cfg.pseudocode.AllTypes;
import org.jetbrains.jet.lang.cfg.pseudocode.JetControlFlowInstructionsGenerator;
import org.jetbrains.jet.lang.cfg.pseudocode.PseudoValue;
import org.jetbrains.jet.lang.cfg.pseudocode.Pseudocode;
import org.jetbrains.jet.lang.cfg.pseudocode.PseudocodeImpl;
import org.jetbrains.jet.lang.cfg.pseudocode.PseudocodePackage;
import org.jetbrains.jet.lang.cfg.pseudocode.SingleType;
import org.jetbrains.jet.lang.cfg.pseudocode.TypePredicate;
import org.jetbrains.jet.lang.cfg.pseudocode.instructions.eval.AccessTarget;
import org.jetbrains.jet.lang.cfg.pseudocode.instructions.eval.CallInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.instructions.eval.InstructionWithValue;
import org.jetbrains.jet.lang.cfg.pseudocode.instructions.eval.MagicKind;
import org.jetbrains.jet.lang.cfg.pseudocode.instructions.eval.ReadValueInstruction;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetAnnotatedExpression;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetBreakExpression;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetCallableReferenceExpression;
import org.jetbrains.jet.lang.psi.JetCatchClause;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetContinueExpression;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifierList;
import org.jetbrains.jet.lang.psi.JetDelegatorByExpressionSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegatorToSuperCall;
import org.jetbrains.jet.lang.psi.JetDelegatorToSuperClass;
import org.jetbrains.jet.lang.psi.JetDoWhileExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetExpressionWithLabel;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetFinallySection;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetIfExpression;
import org.jetbrains.jet.lang.psi.JetIsExpression;
import org.jetbrains.jet.lang.psi.JetLabeledExpression;
import org.jetbrains.jet.lang.psi.JetLoopExpression;
import org.jetbrains.jet.lang.psi.JetMultiDeclaration;
import org.jetbrains.jet.lang.psi.JetMultiDeclarationEntry;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetObjectLiteralExpression;
import org.jetbrains.jet.lang.psi.JetOperationExpression;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetPostfixExpression;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetReturnExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetStatementExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntryWithExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateExpression;
import org.jetbrains.jet.lang.psi.JetThisExpression;
import org.jetbrains.jet.lang.psi.JetThrowExpression;
import org.jetbrains.jet.lang.psi.JetTryExpression;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.psi.JetWhenCondition;
import org.jetbrains.jet.lang.psi.JetWhenConditionInRange;
import org.jetbrains.jet.lang.psi.JetWhenConditionIsPattern;
import org.jetbrains.jet.lang.psi.JetWhenConditionWithExpression;
import org.jetbrains.jet.lang.psi.JetWhenEntry;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.jet.lang.psi.JetWhileExpression;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.psi.psiUtil.PsiUtilPackage;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.CompileTimeConstantUtils;
import org.jetbrains.jet.lang.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.jet.lang.resolve.calls.model.ArgumentMapping;
import org.jetbrains.jet.lang.resolve.calls.model.ArgumentMatch;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ThisReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.jet.lexer.JetTokens;

public class JetControlFlowProcessor {
    private final JetControlFlowBuilder builder = new JetControlFlowInstructionsGenerator();
    private final BindingTrace trace;

    public JetControlFlowProcessor(BindingTrace trace) {
        this.trace = trace;
    }

    @NotNull
    public Pseudocode generatePseudocode(@NotNull JetElement subroutine) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor", "generatePseudocode"));
        }
        Pseudocode pseudocode = this.generate(subroutine);
        ((PseudocodeImpl)pseudocode).postProcess();
        Pseudocode pseudocode2 = pseudocode;
        if (pseudocode2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor", "generatePseudocode"));
        }
        return pseudocode2;
    }

    @NotNull
    private Pseudocode generate(@NotNull JetElement subroutine) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor", "generate"));
        }
        this.builder.enterSubroutine(subroutine);
        CFPVisitor cfpVisitor = new CFPVisitor(this.builder);
        if (subroutine instanceof JetDeclarationWithBody) {
            JetDeclarationWithBody declarationWithBody = (JetDeclarationWithBody)subroutine;
            List<JetParameter> valueParameters = declarationWithBody.getValueParameters();
            for (JetParameter valueParameter : valueParameters) {
                cfpVisitor.generateInstructions(valueParameter);
            }
            JetExpression bodyExpression = declarationWithBody.getBodyExpression();
            if (bodyExpression != null) {
                cfpVisitor.generateInstructions(bodyExpression);
                if (!declarationWithBody.hasBlockBody()) {
                    this.generateImplicitReturnValue(bodyExpression, subroutine);
                }
            }
        } else {
            cfpVisitor.generateInstructions(subroutine);
        }
        Pseudocode pseudocode = this.builder.exitSubroutine(subroutine);
        if (pseudocode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor", "generate"));
        }
        return pseudocode;
    }

    private void generateImplicitReturnValue(@NotNull JetExpression bodyExpression, @NotNull JetElement subroutine) {
        if (bodyExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bodyExpression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor", "generateImplicitReturnValue"));
        }
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor", "generateImplicitReturnValue"));
        }
        CallableDescriptor subroutineDescriptor = (CallableDescriptor)this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, subroutine);
        if (subroutineDescriptor == null) {
            return;
        }
        JetType returnType = subroutineDescriptor.getReturnType();
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        if (returnType != null && builtIns.isUnit(returnType) && subroutineDescriptor instanceof AnonymousFunctionDescriptor) {
            return;
        }
        PseudoValue returnValue = this.builder.getBoundValue(bodyExpression);
        if (returnValue == null) {
            return;
        }
        this.builder.returnValue(bodyExpression, returnValue, subroutine);
    }

    private void processLocalDeclaration(@NotNull JetDeclaration subroutine) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor", "processLocalDeclaration"));
        }
        JetElement parent = PsiTreeUtil.getParentOfType((PsiElement)subroutine, JetElement.class);
        assert (parent != null);
        Label afterDeclaration = this.builder.createUnboundLabel("after local declaration");
        this.builder.nondeterministicJump(afterDeclaration, parent, null);
        this.generate(subroutine);
        this.builder.bindLabel(afterDeclaration);
    }

    private class CFPVisitor
    extends JetVisitorVoid {
        private final JetControlFlowBuilder builder;
        private final JetVisitorVoid conditionVisitor;

        private CFPVisitor(@NotNull JetControlFlowBuilder builder) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "<init>"));
            }
            this.conditionVisitor = new JetVisitorVoid(){

                private JetExpression getSubjectExpression(JetWhenCondition condition) {
                    JetWhenExpression whenExpression = PsiTreeUtil.getParentOfType((PsiElement)condition, JetWhenExpression.class);
                    return whenExpression != null ? whenExpression.getSubjectExpression() : null;
                }

                @Override
                public void visitWhenConditionInRange(@NotNull JetWhenConditionInRange condition) {
                    if (condition == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor$1", "visitWhenConditionInRange"));
                    }
                    if (!CFPVisitor.this.generateCall(condition.getOperationReference())) {
                        JetExpression rangeExpression = condition.getRangeExpression();
                        CFPVisitor.this.generateInstructions(rangeExpression);
                        CFPVisitor.this.createNonSyntheticValue(condition, MagicKind.UNRESOLVED_CALL, new JetElement[]{rangeExpression});
                    }
                }

                @Override
                public void visitWhenConditionIsPattern(@NotNull JetWhenConditionIsPattern condition) {
                    if (condition == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor$1", "visitWhenConditionIsPattern"));
                    }
                    CFPVisitor.this.mark(condition);
                    CFPVisitor.this.createNonSyntheticValue(condition, MagicKind.IS, new JetElement[]{this.getSubjectExpression(condition)});
                }

                @Override
                public void visitWhenConditionWithExpression(@NotNull JetWhenConditionWithExpression condition) {
                    if (condition == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor$1", "visitWhenConditionWithExpression"));
                    }
                    CFPVisitor.this.mark(condition);
                    JetExpression expression = condition.getExpression();
                    CFPVisitor.this.generateInstructions(expression);
                    JetExpression subjectExpression = this.getSubjectExpression(condition);
                    if (subjectExpression != null) {
                        CFPVisitor.this.createNonSyntheticValue(condition, MagicKind.EQUALS_IN_WHEN_CONDITION, new JetElement[]{subjectExpression, expression});
                    } else {
                        CFPVisitor.this.copyValue(expression, condition);
                    }
                }

                @Override
                public void visitJetElement(@NotNull JetElement element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor$1", "visitJetElement"));
                    }
                    throw new UnsupportedOperationException("[JetControlFlowProcessor] " + element.toString());
                }
            };
            this.builder = builder;
        }

        private void mark(JetElement element) {
            this.builder.mark(element);
        }

        public void generateInstructions(@Nullable JetElement element) {
            if (element == null) {
                return;
            }
            element.accept(this);
            this.checkNothingType(element);
        }

        private void checkNothingType(JetElement element) {
            if (!(element instanceof JetExpression)) {
                return;
            }
            JetExpression expression = JetPsiUtil.deparenthesize((JetExpression)element);
            if (expression == null) {
                return;
            }
            if (expression instanceof JetStatementExpression || expression instanceof JetTryExpression || expression instanceof JetIfExpression || expression instanceof JetWhenExpression) {
                return;
            }
            JetType type2 = JetControlFlowProcessor.this.trace.getBindingContext().get(BindingContext.EXPRESSION_TYPE, expression);
            if (type2 != null && KotlinBuiltIns.getInstance().isNothing(type2)) {
                this.builder.jumpToError(expression);
            }
        }

        @NotNull
        private PseudoValue createSyntheticValue(@NotNull JetElement instructionElement, @NotNull MagicKind kind, JetElement ... from) {
            if (instructionElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instructionElement", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "createSyntheticValue"));
            }
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "createSyntheticValue"));
            }
            List<PseudoValue> values = this.elementsToValues(from.length > 0 ? Arrays.asList(from) : Collections.emptyList());
            PseudoValue pseudoValue = this.builder.magic(instructionElement, null, values, this.defaultTypeMap(values), kind).getOutputValue();
            if (pseudoValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "createSyntheticValue"));
            }
            return pseudoValue;
        }

        @NotNull
        private PseudoValue createNonSyntheticValue(@NotNull JetElement to, @NotNull List<? extends JetElement> from, @NotNull MagicKind kind) {
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "createNonSyntheticValue"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "createNonSyntheticValue"));
            }
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "createNonSyntheticValue"));
            }
            List<PseudoValue> values = this.elementsToValues(from);
            PseudoValue pseudoValue = this.builder.magic(to, to, values, this.defaultTypeMap(values), kind).getOutputValue();
            if (pseudoValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "createNonSyntheticValue"));
            }
            return pseudoValue;
        }

        @NotNull
        private PseudoValue createNonSyntheticValue(@NotNull JetElement to, @NotNull MagicKind kind, JetElement ... from) {
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "createNonSyntheticValue"));
            }
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "createNonSyntheticValue"));
            }
            PseudoValue pseudoValue = this.createNonSyntheticValue(to, Arrays.asList(from), kind);
            if (pseudoValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "createNonSyntheticValue"));
            }
            return pseudoValue;
        }

        @NotNull
        private Map<PseudoValue, TypePredicate> defaultTypeMap(List<PseudoValue> values) {
            Map<PseudoValue, TypePredicate> map = PseudocodePackage.expectedTypeFor(AllTypes.INSTANCE$, values);
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "defaultTypeMap"));
            }
            return map;
        }

        private void mergeValues(@NotNull List<JetExpression> from, @NotNull JetExpression to) {
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "mergeValues"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "mergeValues"));
            }
            this.builder.merge(to, this.elementsToValues(from));
        }

        private void copyValue(@Nullable JetElement from, @NotNull JetElement to) {
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "copyValue"));
            }
            PseudoValue value = this.getBoundOrUnreachableValue(from);
            if (value != null) {
                this.builder.bindValue(value, to);
            }
        }

        @Nullable
        private PseudoValue getBoundOrUnreachableValue(@Nullable JetElement element) {
            if (element == null) {
                return null;
            }
            PseudoValue value = this.builder.getBoundValue(element);
            return value != null || element instanceof JetDeclaration ? value : this.builder.newValue(element);
        }

        private List<PseudoValue> elementsToValues(List<? extends JetElement> from) {
            if (from.isEmpty()) {
                return Collections.emptyList();
            }
            return KotlinPackage.filterNotNull(KotlinPackage.map(from, new Function1<JetElement, PseudoValue>(){

                @Override
                public PseudoValue invoke(JetElement element) {
                    return CFPVisitor.this.getBoundOrUnreachableValue(element);
                }
            }));
        }

        private void generateInitializer(@NotNull JetDeclaration declaration, @NotNull PseudoValue initValue) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "generateInitializer"));
            }
            if (initValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initValue", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "generateInitializer"));
            }
            this.builder.write(declaration, declaration, initValue, this.getDeclarationAccessTarget(declaration), Collections.<PseudoValue, ReceiverValue>emptyMap());
        }

        @NotNull
        private AccessTarget getResolvedCallAccessTarget(JetElement element) {
            ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(element, JetControlFlowProcessor.this.trace.getBindingContext());
            AccessTarget accessTarget = resolvedCall != null ? new AccessTarget.Call(resolvedCall) : AccessTarget.BlackBox.INSTANCE$;
            if (accessTarget == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "getResolvedCallAccessTarget"));
            }
            return accessTarget;
        }

        @NotNull
        private AccessTarget getDeclarationAccessTarget(JetElement element) {
            DeclarationDescriptor descriptor = JetControlFlowProcessor.this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, element);
            AccessTarget accessTarget = descriptor instanceof VariableDescriptor ? new AccessTarget.Declaration((VariableDescriptor)descriptor) : AccessTarget.BlackBox.INSTANCE$;
            if (accessTarget == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "getDeclarationAccessTarget"));
            }
            return accessTarget;
        }

        @Override
        public void visitParenthesizedExpression(@NotNull JetParenthesizedExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitParenthesizedExpression"));
            }
            this.mark(expression);
            JetExpression innerExpression = expression.getExpression();
            if (innerExpression != null) {
                this.generateInstructions(innerExpression);
                this.copyValue(innerExpression, expression);
            }
        }

        @Override
        public void visitAnnotatedExpression(@NotNull JetAnnotatedExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitAnnotatedExpression"));
            }
            JetExpression baseExpression = expression.getBaseExpression();
            if (baseExpression != null) {
                this.generateInstructions(baseExpression);
                this.copyValue(baseExpression, expression);
            }
        }

        @Override
        public void visitThisExpression(@NotNull JetThisExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitThisExpression"));
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(expression, JetControlFlowProcessor.this.trace.getBindingContext());
            if (resolvedCall == null) {
                this.createNonSyntheticValue((JetElement)expression, MagicKind.UNRESOLVED_CALL, new JetElement[0]);
                return;
            }
            CallableDescriptor resultingDescriptor = resolvedCall.getResultingDescriptor();
            if (resultingDescriptor instanceof ReceiverParameterDescriptor) {
                this.builder.readVariable(expression, resolvedCall, this.getReceiverValues(resolvedCall));
            }
            this.copyValue(expression, expression.getInstanceReference());
        }

        @Override
        public void visitConstantExpression(@NotNull JetConstantExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitConstantExpression"));
            }
            CompileTimeConstant<?> constant = JetControlFlowProcessor.this.trace.get(BindingContext.COMPILE_TIME_VALUE, expression);
            this.builder.loadConstant(expression, constant);
        }

        @Override
        public void visitSimpleNameExpression(@NotNull JetSimpleNameExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitSimpleNameExpression"));
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(expression, JetControlFlowProcessor.this.trace.getBindingContext());
            if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
                VariableAsFunctionResolvedCall variableAsFunctionResolvedCall = (VariableAsFunctionResolvedCall)((Object)resolvedCall);
                this.generateCall(variableAsFunctionResolvedCall.getVariableCall());
            } else if (!this.generateCall(expression) && !(expression.getParent() instanceof JetCallExpression)) {
                this.createNonSyntheticValue((JetElement)expression, MagicKind.UNRESOLVED_CALL, this.generateAndGetReceiverIfAny(expression));
            }
        }

        @Override
        public void visitLabeledExpression(@NotNull JetLabeledExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitLabeledExpression"));
            }
            this.mark(expression);
            JetExpression baseExpression = expression.getBaseExpression();
            if (baseExpression != null) {
                this.generateInstructions(baseExpression);
                this.copyValue(baseExpression, expression);
            }
        }

        @Override
        public void visitBinaryExpression(@NotNull JetBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitBinaryExpression"));
            }
            JetSimpleNameExpression operationReference = expression.getOperationReference();
            IElementType operationType = operationReference.getReferencedNameElementType();
            JetExpression left = expression.getLeft();
            JetExpression right = expression.getRight();
            if (operationType == JetTokens.ANDAND || operationType == JetTokens.OROR) {
                this.generateBooleanOperation(expression);
            } else if (operationType == JetTokens.EQ) {
                this.visitAssignment(left, this.getDeferredValue(right), expression);
            } else if (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(operationType)) {
                ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(expression, JetControlFlowProcessor.this.trace.getBindingContext());
                if (resolvedCall != null) {
                    PseudoValue rhsValue = this.generateCall(resolvedCall).getOutputValue();
                    Name assignMethodName = OperatorConventions.getNameForOperationSymbol((JetToken)expression.getOperationToken());
                    if (!resolvedCall.getResultingDescriptor().getName().equals(assignMethodName)) {
                        this.visitAssignment(left, this.getValueAsFunction(rhsValue), expression);
                    }
                } else {
                    this.generateBothArgumentsAndMark(expression);
                }
            } else if (operationType == JetTokens.ELVIS) {
                this.generateInstructions(left);
                this.mark(expression);
                Label afterElvis = this.builder.createUnboundLabel("after elvis operator");
                this.builder.jumpOnTrue(afterElvis, expression, this.builder.getBoundValue(left));
                if (right != null) {
                    this.generateInstructions(right);
                }
                this.builder.bindLabel(afterElvis);
                this.mergeValues(Arrays.asList(left, right), expression);
            } else if (!this.generateCall(expression)) {
                this.generateBothArgumentsAndMark(expression);
            }
        }

        private void generateBooleanOperation(JetBinaryExpression expression) {
            IElementType operationType = expression.getOperationReference().getReferencedNameElementType();
            JetExpression left = expression.getLeft();
            JetExpression right = expression.getRight();
            Label resultLabel = this.builder.createUnboundLabel("result of boolean operation");
            this.generateInstructions(left);
            if (operationType == JetTokens.ANDAND) {
                this.builder.jumpOnFalse(resultLabel, expression, this.builder.getBoundValue(left));
            } else {
                this.builder.jumpOnTrue(resultLabel, expression, this.builder.getBoundValue(left));
            }
            if (right != null) {
                this.generateInstructions(right);
            }
            this.builder.bindLabel(resultLabel);
            JetControlFlowBuilder.PredefinedOperation operation = operationType == JetTokens.ANDAND ? JetControlFlowBuilder.PredefinedOperation.AND : JetControlFlowBuilder.PredefinedOperation.OR;
            this.builder.predefinedOperation(expression, operation, this.elementsToValues(Arrays.asList(left, right)));
        }

        private Function0<PseudoValue> getValueAsFunction(final PseudoValue value) {
            return new Function0<PseudoValue>(){

                @Override
                public PseudoValue invoke() {
                    return value;
                }
            };
        }

        private Function0<PseudoValue> getDeferredValue(final JetExpression expression) {
            return new Function0<PseudoValue>(){

                @Override
                public PseudoValue invoke() {
                    CFPVisitor.this.generateInstructions(expression);
                    return CFPVisitor.this.getBoundOrUnreachableValue(expression);
                }
            };
        }

        private void generateBothArgumentsAndMark(JetBinaryExpression expression) {
            JetExpression right;
            JetExpression left = JetPsiUtil.deparenthesize(expression.getLeft());
            if (left != null) {
                this.generateInstructions(left);
            }
            if ((right = expression.getRight()) != null) {
                this.generateInstructions(right);
            }
            this.createNonSyntheticValue((JetElement)expression, MagicKind.UNRESOLVED_CALL, left, right);
            this.mark(expression);
        }

        private void visitAssignment(JetExpression lhs, @NotNull Function0<PseudoValue> rhsDeferredValue, JetExpression parentExpression) {
            if (rhsDeferredValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rhsDeferredValue", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitAssignment"));
            }
            JetExpression left = JetPsiUtil.deparenthesize(lhs);
            if (left == null) {
                List<PseudoValue> arguments2 = Collections.singletonList(rhsDeferredValue.invoke());
                this.builder.magic(parentExpression, parentExpression, arguments2, this.defaultTypeMap(arguments2), MagicKind.UNSUPPORTED_ELEMENT);
                return;
            }
            if (left instanceof JetArrayAccessExpression) {
                this.generateArrayAssignment((JetArrayAccessExpression)left, rhsDeferredValue, parentExpression);
                return;
            }
            Map<PseudoValue, ReceiverValue> receiverValues = SmartFMap.emptyMap();
            AccessTarget accessTarget = AccessTarget.BlackBox.INSTANCE$;
            if (left instanceof JetSimpleNameExpression || left instanceof JetQualifiedExpression) {
                accessTarget = this.getResolvedCallAccessTarget(PsiUtilPackage.getQualifiedElementSelector(left));
                if (accessTarget instanceof AccessTarget.Call) {
                    receiverValues = this.getReceiverValues(((AccessTarget.Call)accessTarget).getResolvedCall());
                }
            } else if (left instanceof JetProperty) {
                accessTarget = this.getDeclarationAccessTarget(left);
            }
            this.recordWrite(left, accessTarget, rhsDeferredValue.invoke(), receiverValues, parentExpression);
        }

        private void generateArrayAssignment(JetArrayAccessExpression lhs, @NotNull Function0<PseudoValue> rhsDeferredValue, @NotNull JetExpression parentExpression) {
            if (rhsDeferredValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rhsDeferredValue", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "generateArrayAssignment"));
            }
            if (parentExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentExpression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "generateArrayAssignment"));
            }
            ResolvedCall<FunctionDescriptor> setResolvedCall = JetControlFlowProcessor.this.trace.get(BindingContext.INDEXED_LVALUE_SET, lhs);
            if (setResolvedCall == null) {
                this.generateArrayAccess(lhs, null);
                List<PseudoValue> arguments2 = Arrays.asList(this.getBoundOrUnreachableValue(lhs), rhsDeferredValue.invoke());
                this.builder.magic(parentExpression, parentExpression, arguments2, this.defaultTypeMap(arguments2), MagicKind.UNRESOLVED_CALL);
                return;
            }
            if (((JetOperationExpression)parentExpression).getOperationReference().getReferencedNameElementType() == JetTokens.EQ) {
                this.mark(lhs);
            }
            this.generateInstructions(lhs.getArrayExpression());
            Map<PseudoValue, ReceiverValue> receiverValues = this.getReceiverValues(setResolvedCall);
            SmartFMap<PseudoValue, ValueParameterDescriptor> argumentValues = this.getArraySetterArguments(rhsDeferredValue, setResolvedCall);
            this.builder.call(parentExpression, setResolvedCall, receiverValues, argumentValues);
        }

        private SmartFMap<PseudoValue, ValueParameterDescriptor> getArraySetterArguments(Function0<PseudoValue> rhsDeferredValue, final ResolvedCall<FunctionDescriptor> setResolvedCall) {
            List valueArguments2 = KotlinPackage.flatMapTo(setResolvedCall.getResultingDescriptor().getValueParameters(), new ArrayList(), new Function1<ValueParameterDescriptor, Iterable<? extends ValueArgument>>(){

                @Override
                public Iterable<? extends ValueArgument> invoke(ValueParameterDescriptor descriptor) {
                    ResolvedValueArgument resolvedValueArgument = setResolvedCall.getValueArguments().get(descriptor);
                    return resolvedValueArgument != null ? resolvedValueArgument.getArguments() : Collections.emptyList();
                }
            });
            ValueArgument rhsArgument = (ValueArgument)KotlinPackage.lastOrNull(valueArguments2);
            SmartFMap<PseudoValue, ValueParameterDescriptor> argumentValues = SmartFMap.emptyMap();
            for (ValueArgument valueArgument : valueArguments2) {
                ArgumentMapping argumentMapping = setResolvedCall.getArgumentMapping(valueArgument);
                if (argumentMapping.isError() || !(argumentMapping instanceof ArgumentMatch)) continue;
                ValueParameterDescriptor parameterDescriptor = ((ArgumentMatch)argumentMapping).getValueParameter();
                if (valueArgument != rhsArgument) {
                    argumentValues = this.generateValueArgument(valueArgument, parameterDescriptor, argumentValues);
                    continue;
                }
                PseudoValue rhsValue = rhsDeferredValue.invoke();
                if (rhsValue == null) continue;
                argumentValues = argumentValues.plus(rhsValue, parameterDescriptor);
            }
            return argumentValues;
        }

        private void recordWrite(@NotNull JetExpression left, @NotNull AccessTarget target, @Nullable PseudoValue rightValue, @NotNull Map<PseudoValue, ReceiverValue> receiverValues, @NotNull JetExpression parentExpression) {
            if (left == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "recordWrite"));
            }
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "recordWrite"));
            }
            if (receiverValues == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverValues", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "recordWrite"));
            }
            if (parentExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentExpression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "recordWrite"));
            }
            if (target == AccessTarget.BlackBox.INSTANCE$) {
                List<PseudoValue> values = ContainerUtil.createMaybeSingletonList(rightValue);
                this.builder.magic(parentExpression, parentExpression, values, this.defaultTypeMap(values), MagicKind.UNSUPPORTED_ELEMENT);
            } else {
                PseudoValue rValue = rightValue != null ? rightValue : this.createSyntheticValue(parentExpression, MagicKind.UNRECOGNIZED_WRITE_RHS, new JetElement[0]);
                this.builder.write(parentExpression, left, rValue, target, receiverValues);
            }
        }

        private void generateArrayAccess(JetArrayAccessExpression arrayAccessExpression, @Nullable ResolvedCall<?> resolvedCall) {
            if (this.builder.getBoundValue(arrayAccessExpression) != null) {
                return;
            }
            this.mark(arrayAccessExpression);
            if (!this.checkAndGenerateCall(resolvedCall)) {
                this.generateArrayAccessWithoutCall(arrayAccessExpression);
            }
        }

        private void generateArrayAccessWithoutCall(JetArrayAccessExpression arrayAccessExpression) {
            this.createNonSyntheticValue((JetElement)arrayAccessExpression, this.generateArrayAccessArguments(arrayAccessExpression), MagicKind.UNRESOLVED_CALL);
        }

        private List<JetExpression> generateArrayAccessArguments(JetArrayAccessExpression arrayAccessExpression) {
            ArrayList<JetExpression> inputExpressions = new ArrayList<JetExpression>();
            JetExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            inputExpressions.add(arrayExpression);
            this.generateInstructions(arrayExpression);
            for (JetExpression index2 : arrayAccessExpression.getIndexExpressions()) {
                this.generateInstructions(index2);
                inputExpressions.add(index2);
            }
            return inputExpressions;
        }

        @Override
        public void visitUnaryExpression(@NotNull JetUnaryExpression expression) {
            PseudoValue rhsValue;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitUnaryExpression"));
            }
            JetSimpleNameExpression operationSign = expression.getOperationReference();
            IElementType operationType = operationSign.getReferencedNameElementType();
            JetExpression baseExpression = expression.getBaseExpression();
            if (baseExpression == null) {
                return;
            }
            if (JetTokens.EXCLEXCL == operationType) {
                this.generateInstructions(baseExpression);
                this.builder.predefinedOperation(expression, JetControlFlowBuilder.PredefinedOperation.NOT_NULL_ASSERTION, this.elementsToValues(Collections.singletonList(baseExpression)));
                return;
            }
            boolean incrementOrDecrement = this.isIncrementOrDecrement(operationType);
            ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(expression, JetControlFlowProcessor.this.trace.getBindingContext());
            if (resolvedCall != null) {
                rhsValue = this.generateCall(resolvedCall).getOutputValue();
            } else {
                this.generateInstructions(baseExpression);
                rhsValue = this.createNonSyntheticValue((JetElement)expression, MagicKind.UNRESOLVED_CALL, baseExpression);
            }
            if (incrementOrDecrement) {
                this.visitAssignment(baseExpression, this.getValueAsFunction(rhsValue), expression);
                if (expression instanceof JetPostfixExpression) {
                    this.copyValue(baseExpression, expression);
                }
            }
        }

        private boolean isIncrementOrDecrement(IElementType operationType) {
            return operationType == JetTokens.PLUSPLUS || operationType == JetTokens.MINUSMINUS;
        }

        @Override
        public void visitIfExpression(@NotNull JetIfExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitIfExpression"));
            }
            this.mark(expression);
            ArrayList<JetExpression> branches = new ArrayList<JetExpression>(2);
            JetExpression condition = expression.getCondition();
            if (condition != null) {
                this.generateInstructions(condition);
            }
            Label elseLabel = this.builder.createUnboundLabel("else branch");
            this.builder.jumpOnFalse(elseLabel, expression, this.builder.getBoundValue(condition));
            JetExpression thenBranch = expression.getThen();
            if (thenBranch != null) {
                branches.add(thenBranch);
                this.generateInstructions(thenBranch);
            } else {
                this.builder.loadUnit(expression);
            }
            Label resultLabel = this.builder.createUnboundLabel("'if' expression result");
            this.builder.jump(resultLabel, expression);
            this.builder.bindLabel(elseLabel);
            JetExpression elseBranch = expression.getElse();
            if (elseBranch != null) {
                branches.add(elseBranch);
                this.generateInstructions(elseBranch);
            } else {
                this.builder.loadUnit(expression);
            }
            this.builder.bindLabel(resultLabel);
            this.mergeValues(branches, expression);
        }

        @Override
        public void visitTryExpression(@NotNull JetTryExpression expression) {
            boolean hasFinally;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitTryExpression"));
            }
            this.mark(expression);
            JetFinallySection finallyBlock = expression.getFinallyBlock();
            final FinallyBlockGenerator finallyBlockGenerator = new FinallyBlockGenerator(finallyBlock);
            boolean bl = hasFinally = finallyBlock != null;
            if (hasFinally) {
                this.builder.enterTryFinally(new GenerationTrigger(){
                    private boolean working = false;

                    @Override
                    public void generate() {
                        if (this.working) {
                            return;
                        }
                        this.working = true;
                        finallyBlockGenerator.generate();
                        this.working = false;
                    }
                });
            }
            Label onExceptionToFinallyBlock = this.generateTryAndCatches(expression);
            if (hasFinally) {
                assert (onExceptionToFinallyBlock != null) : "No finally lable generated: " + expression.getText();
                this.builder.exitTryFinally();
                Label skipFinallyToErrorBlock = this.builder.createUnboundLabel("skipFinallyToErrorBlock");
                this.builder.jump(skipFinallyToErrorBlock, expression);
                this.builder.bindLabel(onExceptionToFinallyBlock);
                finallyBlockGenerator.generate();
                this.builder.jumpToError(expression);
                this.builder.bindLabel(skipFinallyToErrorBlock);
                finallyBlockGenerator.generate();
            }
            ArrayList<JetExpression> branches = new ArrayList<JetExpression>();
            branches.add(expression.getTryBlock());
            for (JetCatchClause catchClause : expression.getCatchClauses()) {
                branches.add(catchClause.getCatchBody());
            }
            this.mergeValues(branches, expression);
        }

        @Nullable
        private Label generateTryAndCatches(@NotNull JetTryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "generateTryAndCatches"));
            }
            List<JetCatchClause> catchClauses = expression.getCatchClauses();
            boolean hasCatches = !catchClauses.isEmpty();
            Label onException = null;
            if (hasCatches) {
                onException = this.builder.createUnboundLabel("onException");
                this.builder.nondeterministicJump(onException, expression, null);
            }
            Label onExceptionToFinallyBlock = null;
            if (expression.getFinallyBlock() != null) {
                onExceptionToFinallyBlock = this.builder.createUnboundLabel("onExceptionToFinallyBlock");
                this.builder.nondeterministicJump(onExceptionToFinallyBlock, expression, null);
            }
            JetBlockExpression tryBlock = expression.getTryBlock();
            this.generateInstructions(tryBlock);
            if (hasCatches) {
                Label afterCatches = this.builder.createUnboundLabel("afterCatches");
                this.builder.jump(afterCatches, expression);
                this.builder.bindLabel(onException);
                LinkedList<Label> catchLabels = Lists.newLinkedList();
                int catchClausesSize = catchClauses.size();
                for (int i = 0; i < catchClausesSize - 1; ++i) {
                    catchLabels.add(this.builder.createUnboundLabel("catch " + i));
                }
                if (!catchLabels.isEmpty()) {
                    this.builder.nondeterministicJump(catchLabels, expression);
                }
                boolean isFirst = true;
                for (JetCatchClause catchClause : catchClauses) {
                    JetExpression catchBody;
                    this.builder.enterLexicalScope(catchClause);
                    if (!isFirst) {
                        this.builder.bindLabel(catchLabels.remove());
                    } else {
                        isFirst = false;
                    }
                    JetParameter catchParameter = catchClause.getCatchParameter();
                    if (catchParameter != null) {
                        this.builder.declareParameter(catchParameter);
                        this.generateInitializer(catchParameter, this.createSyntheticValue(catchParameter, MagicKind.FAKE_INITIALIZER, new JetElement[0]));
                    }
                    if ((catchBody = catchClause.getCatchBody()) != null) {
                        this.generateInstructions(catchBody);
                    }
                    this.builder.jump(afterCatches, expression);
                    this.builder.exitLexicalScope(catchClause);
                }
                this.builder.bindLabel(afterCatches);
            }
            return onExceptionToFinallyBlock;
        }

        @Override
        public void visitWhileExpression(@NotNull JetWhileExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitWhileExpression"));
            }
            LoopInfo loopInfo = this.builder.enterLoop(expression);
            this.builder.bindLabel(loopInfo.getConditionEntryPoint());
            JetExpression condition = expression.getCondition();
            if (condition != null) {
                this.generateInstructions(condition);
            }
            this.mark(expression);
            boolean conditionIsTrueConstant = CompileTimeConstantUtils.canBeReducedToBooleanConstant(condition, JetControlFlowProcessor.this.trace, true);
            if (!conditionIsTrueConstant) {
                this.builder.jumpOnFalse(loopInfo.getExitPoint(), expression, this.builder.getBoundValue(condition));
            } else {
                assert (condition != null) : "Invalid while condition: " + expression.getText();
                List<PseudoValue> values = ContainerUtil.createMaybeSingletonList(this.builder.getBoundValue(condition));
                Map<PseudoValue, TypePredicate> typePredicates = PseudocodePackage.expectedTypeFor(new SingleType(KotlinBuiltIns.getInstance().getBooleanType()), values);
                this.builder.magic(condition, null, values, typePredicates, MagicKind.VALUE_CONSUMER);
            }
            this.builder.enterLoopBody(expression);
            JetExpression body = expression.getBody();
            if (body != null) {
                this.generateInstructions(body);
            }
            this.builder.jump(loopInfo.getEntryPoint(), expression);
            this.builder.exitLoopBody(expression);
            this.builder.bindLabel(loopInfo.getExitPoint());
            this.builder.loadUnit(expression);
        }

        @Override
        public void visitDoWhileExpression(@NotNull JetDoWhileExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitDoWhileExpression"));
            }
            this.builder.enterLexicalScope(expression);
            this.mark(expression);
            LoopInfo loopInfo = this.builder.enterLoop(expression);
            this.builder.enterLoopBody(expression);
            JetExpression body = expression.getBody();
            if (body != null) {
                this.generateInstructions(body);
            }
            this.builder.exitLoopBody(expression);
            this.builder.bindLabel(loopInfo.getConditionEntryPoint());
            JetExpression condition = expression.getCondition();
            if (condition != null) {
                this.generateInstructions(condition);
            }
            this.builder.jumpOnTrue(loopInfo.getEntryPoint(), expression, this.builder.getBoundValue(condition));
            this.builder.bindLabel(loopInfo.getExitPoint());
            this.builder.loadUnit(expression);
            this.builder.exitLexicalScope(expression);
        }

        @Override
        public void visitForExpression(@NotNull JetForExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitForExpression"));
            }
            this.builder.enterLexicalScope(expression);
            JetExpression loopRange = expression.getLoopRange();
            if (loopRange != null) {
                this.generateInstructions(loopRange);
            }
            this.declareLoopParameter(expression);
            LoopInfo loopInfo = this.builder.enterLoop(expression);
            this.builder.bindLabel(loopInfo.getConditionEntryPoint());
            this.builder.nondeterministicJump(loopInfo.getExitPoint(), expression, null);
            this.writeLoopParameterAssignment(expression);
            this.mark(expression);
            this.builder.enterLoopBody(expression);
            JetExpression body = expression.getBody();
            if (body != null) {
                this.generateInstructions(body);
            }
            this.builder.jump(loopInfo.getEntryPoint(), expression);
            this.builder.exitLoopBody(expression);
            this.builder.bindLabel(loopInfo.getExitPoint());
            this.builder.loadUnit(expression);
            this.builder.exitLexicalScope(expression);
        }

        private void declareLoopParameter(JetForExpression expression) {
            JetParameter loopParameter = expression.getLoopParameter();
            JetMultiDeclaration multiDeclaration = expression.getMultiParameter();
            if (loopParameter != null) {
                this.builder.declareParameter(loopParameter);
            } else if (multiDeclaration != null) {
                this.visitMultiDeclaration(multiDeclaration, false);
            }
        }

        private void writeLoopParameterAssignment(JetForExpression expression) {
            JetParameter loopParameter = expression.getLoopParameter();
            JetMultiDeclaration multiDeclaration = expression.getMultiParameter();
            JetExpression loopRange = expression.getLoopRange();
            TypePredicate loopRangeTypePredicate = this.getTypePredicateByReceiverValue(JetControlFlowProcessor.this.trace.get(BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL, loopRange));
            PseudoValue loopRangeValue = this.builder.getBoundValue(loopRange);
            PseudoValue value = this.builder.magic(loopRange != null ? loopRange : expression, null, ContainerUtil.createMaybeSingletonList(loopRangeValue), loopRangeValue != null ? Collections.singletonMap(loopRangeValue, loopRangeTypePredicate) : Collections.emptyMap(), MagicKind.LOOP_RANGE_ITERATION).getOutputValue();
            if (loopParameter != null) {
                this.generateInitializer(loopParameter, value);
            } else if (multiDeclaration != null) {
                for (JetMultiDeclarationEntry entry : multiDeclaration.getEntries()) {
                    this.generateInitializer(entry, value);
                }
            }
        }

        private ReceiverValue getExplicitReceiverValue(ResolvedCall<?> resolvedCall) {
            switch (resolvedCall.getExplicitReceiverKind()) {
                case DISPATCH_RECEIVER: {
                    return resolvedCall.getDispatchReceiver();
                }
                case EXTENSION_RECEIVER: {
                    return resolvedCall.getExtensionReceiver();
                }
            }
            return ReceiverValue.NO_RECEIVER;
        }

        @Override
        public void visitBreakExpression(@NotNull JetBreakExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitBreakExpression"));
            }
            JetElement loop = this.getCorrespondingLoop(expression);
            if (loop != null) {
                this.checkJumpDoesNotCrossFunctionBoundary(expression, loop);
                this.builder.jump(this.builder.getExitPoint(loop), expression);
            }
        }

        @Override
        public void visitContinueExpression(@NotNull JetContinueExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitContinueExpression"));
            }
            JetElement loop = this.getCorrespondingLoop(expression);
            if (loop != null) {
                this.checkJumpDoesNotCrossFunctionBoundary(expression, loop);
                this.builder.jump(this.builder.getConditionEntryPoint(loop), expression);
            }
        }

        @Nullable
        private JetElement getCorrespondingLoop(JetExpressionWithLabel expression) {
            JetLoopExpression loop;
            String labelName = expression.getLabelName();
            if (labelName != null) {
                JetSimpleNameExpression targetLabel = expression.getTargetLabel();
                assert (targetLabel != null);
                PsiElement labeledElement = JetControlFlowProcessor.this.trace.get(BindingContext.LABEL_TARGET, targetLabel);
                if (labeledElement instanceof JetLoopExpression) {
                    loop = (JetLoopExpression)labeledElement;
                } else {
                    JetControlFlowProcessor.this.trace.report(Errors.NOT_A_LOOP_LABEL.on(expression, targetLabel.getText()));
                    loop = null;
                }
            } else {
                loop = this.builder.getCurrentLoop();
                if (loop == null) {
                    JetControlFlowProcessor.this.trace.report(Errors.BREAK_OR_CONTINUE_OUTSIDE_A_LOOP.on(expression));
                }
            }
            if (loop != null && loop.getBody() != null && !loop.getBody().getTextRange().contains(expression.getTextRange())) {
                JetControlFlowProcessor.this.trace.report(Errors.BREAK_OR_CONTINUE_OUTSIDE_A_LOOP.on(expression));
                return null;
            }
            return loop;
        }

        private void checkJumpDoesNotCrossFunctionBoundary(@NotNull JetExpressionWithLabel jumpExpression, @NotNull JetElement jumpTarget) {
            FunctionDescriptor labelTargetEnclosingFunc;
            if (jumpExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jumpExpression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "checkJumpDoesNotCrossFunctionBoundary"));
            }
            if (jumpTarget == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jumpTarget", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "checkJumpDoesNotCrossFunctionBoundary"));
            }
            BindingContext bindingContext = JetControlFlowProcessor.this.trace.getBindingContext();
            FunctionDescriptor labelExprEnclosingFunc = BindingContextUtils.getEnclosingFunctionDescriptor(bindingContext, jumpExpression);
            if (labelExprEnclosingFunc != (labelTargetEnclosingFunc = BindingContextUtils.getEnclosingFunctionDescriptor(bindingContext, jumpTarget))) {
                JetControlFlowProcessor.this.trace.report(Errors.BREAK_OR_CONTINUE_JUMPS_ACROSS_FUNCTION_BOUNDARY.on(jumpExpression));
            }
        }

        @Override
        public void visitReturnExpression(@NotNull JetReturnExpression expression) {
            JetElement subroutine;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitReturnExpression"));
            }
            JetExpression returnedExpression = expression.getReturnedExpression();
            if (returnedExpression != null) {
                this.generateInstructions(returnedExpression);
            }
            JetSimpleNameExpression labelElement = expression.getTargetLabel();
            String labelName = expression.getLabelName();
            if (labelElement != null && labelName != null) {
                PsiElement labeledElement = JetControlFlowProcessor.this.trace.get(BindingContext.LABEL_TARGET, labelElement);
                if (labeledElement != null) {
                    assert (labeledElement instanceof JetElement);
                    subroutine = (JetElement)labeledElement;
                } else {
                    subroutine = null;
                }
            } else {
                subroutine = this.builder.getReturnSubroutine();
            }
            if (subroutine instanceof JetFunction || subroutine instanceof JetPropertyAccessor) {
                PseudoValue returnValue;
                PseudoValue pseudoValue = returnValue = returnedExpression != null ? this.builder.getBoundValue(returnedExpression) : null;
                if (returnValue == null) {
                    this.builder.returnNoValue(expression, subroutine);
                } else {
                    this.builder.returnValue(expression, returnValue, subroutine);
                }
            } else {
                this.createNonSyntheticValue((JetElement)expression, MagicKind.UNSUPPORTED_ELEMENT, returnedExpression);
            }
        }

        @Override
        public void visitParameter(@NotNull JetParameter parameter) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitParameter"));
            }
            this.builder.declareParameter(parameter);
            JetExpression defaultValue = parameter.getDefaultValue();
            if (defaultValue != null) {
                Label skipDefaultValue = this.builder.createUnboundLabel("after default value for parameter " + parameter.getName());
                this.builder.nondeterministicJump(skipDefaultValue, defaultValue, null);
                this.generateInstructions(defaultValue);
                this.builder.bindLabel(skipDefaultValue);
            }
            this.generateInitializer(parameter, this.computePseudoValueForParameter(parameter));
        }

        @NotNull
        private PseudoValue computePseudoValueForParameter(@NotNull JetParameter parameter) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "computePseudoValueForParameter"));
            }
            PseudoValue syntheticValue = this.createSyntheticValue(parameter, MagicKind.FAKE_INITIALIZER, new JetElement[0]);
            PseudoValue defaultValue = this.builder.getBoundValue(parameter.getDefaultValue());
            if (defaultValue == null) {
                PseudoValue pseudoValue = syntheticValue;
                if (pseudoValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "computePseudoValueForParameter"));
                }
                return pseudoValue;
            }
            PseudoValue pseudoValue = this.builder.merge(parameter, Lists.newArrayList(defaultValue, syntheticValue)).getOutputValue();
            if (pseudoValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "computePseudoValueForParameter"));
            }
            return pseudoValue;
        }

        @Override
        public void visitBlockExpression(@NotNull JetBlockExpression expression) {
            boolean declareLexicalScope;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitBlockExpression"));
            }
            boolean bl = declareLexicalScope = !this.isBlockInDoWhile(expression);
            if (declareLexicalScope) {
                this.builder.enterLexicalScope(expression);
            }
            this.mark(expression);
            List<JetElement> statements = expression.getStatements();
            for (JetElement statement : statements) {
                this.generateInstructions(statement);
            }
            if (statements.isEmpty()) {
                this.builder.loadUnit(expression);
            } else {
                this.copyValue(KotlinPackage.lastOrNull(statements), expression);
            }
            if (declareLexicalScope) {
                this.builder.exitLexicalScope(expression);
            }
        }

        private boolean isBlockInDoWhile(@NotNull JetBlockExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "isBlockInDoWhile"));
            }
            PsiElement parent = expression.getParent();
            if (parent == null) {
                return false;
            }
            return parent.getParent() instanceof JetDoWhileExpression;
        }

        @Override
        public void visitNamedFunction(@NotNull JetNamedFunction function) {
            if (function == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitNamedFunction"));
            }
            JetControlFlowProcessor.this.processLocalDeclaration(function);
        }

        @Override
        public void visitFunctionLiteralExpression(@NotNull JetFunctionLiteralExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitFunctionLiteralExpression"));
            }
            this.mark(expression);
            JetFunctionLiteral functionLiteral = expression.getFunctionLiteral();
            JetControlFlowProcessor.this.processLocalDeclaration(functionLiteral);
            this.builder.createFunctionLiteral(expression);
        }

        @Override
        public void visitQualifiedExpression(@NotNull JetQualifiedExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitQualifiedExpression"));
            }
            this.mark(expression);
            JetExpression selectorExpression = expression.getSelectorExpression();
            JetExpression receiverExpression = expression.getReceiverExpression();
            if (selectorExpression instanceof JetCallExpression || selectorExpression instanceof JetSimpleNameExpression) {
                this.generateInstructions(selectorExpression);
                this.copyValue(selectorExpression, expression);
            } else {
                this.generateInstructions(receiverExpression);
                this.createNonSyntheticValue((JetElement)expression, MagicKind.UNSUPPORTED_ELEMENT, receiverExpression);
            }
        }

        @Override
        public void visitCallExpression(@NotNull JetCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitCallExpression"));
            }
            if (!this.generateCall(expression)) {
                ArrayList<JetExpression> inputExpressions = new ArrayList<JetExpression>();
                for (ValueArgument valueArgument : expression.getValueArguments()) {
                    JetExpression argumentExpression = valueArgument.getArgumentExpression();
                    if (argumentExpression == null) continue;
                    this.generateInstructions(argumentExpression);
                    inputExpressions.add(argumentExpression);
                }
                JetExpression calleeExpression = expression.getCalleeExpression();
                this.generateInstructions(calleeExpression);
                inputExpressions.add(calleeExpression);
                inputExpressions.add(this.generateAndGetReceiverIfAny(expression));
                this.mark(expression);
                this.createNonSyntheticValue((JetElement)expression, inputExpressions, MagicKind.UNRESOLVED_CALL);
            }
        }

        @Nullable
        private JetExpression generateAndGetReceiverIfAny(JetExpression expression) {
            PsiElement parent = expression.getParent();
            if (!(parent instanceof JetQualifiedExpression)) {
                return null;
            }
            JetQualifiedExpression qualifiedExpression = (JetQualifiedExpression)parent;
            if (qualifiedExpression.getSelectorExpression() != expression) {
                return null;
            }
            JetExpression receiverExpression = qualifiedExpression.getReceiverExpression();
            this.generateInstructions(receiverExpression);
            return receiverExpression;
        }

        @Override
        public void visitProperty(@NotNull JetProperty property2) {
            JetExpression delegate2;
            if (property2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitProperty"));
            }
            this.builder.declareVariable(property2);
            JetExpression initializer = property2.getInitializer();
            if (initializer != null) {
                this.visitAssignment(property2, this.getDeferredValue(initializer), property2);
            }
            if ((delegate2 = property2.getDelegateExpression()) != null) {
                this.generateInstructions(delegate2);
                this.generateDelegateConsumer(property2, delegate2);
            }
            if (JetPsiUtil.isLocal(property2)) {
                for (JetPropertyAccessor accessor : property2.getAccessors()) {
                    this.generateInstructions(accessor);
                }
            }
        }

        private void generateDelegateConsumer(@NotNull JetProperty property2, @NotNull JetExpression delegate2) {
            if (property2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "generateDelegateConsumer"));
            }
            if (delegate2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "generateDelegateConsumer"));
            }
            DeclarationDescriptor descriptor = JetControlFlowProcessor.this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, property2);
            if (!(descriptor instanceof PropertyDescriptor)) {
                return;
            }
            PseudoValue delegateValue = this.builder.getBoundValue(delegate2);
            if (delegateValue == null) {
                return;
            }
            List<TypePredicate> typePredicates = KotlinPackage.map(((PropertyDescriptor)descriptor).getAccessors(), new Function1<PropertyAccessorDescriptor, TypePredicate>(){

                @Override
                public TypePredicate invoke(PropertyAccessorDescriptor descriptor) {
                    return CFPVisitor.this.getTypePredicateByReceiverValue(JetControlFlowProcessor.this.trace.get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, descriptor));
                }
            });
            SmartFMap<PseudoValue, TypePredicate> valuesToTypePredicates = SmartFMap.emptyMap().plus(delegateValue, PseudocodePackage.and(KotlinPackage.filterNotNull(typePredicates)));
            this.builder.magic(property2, null, Collections.singletonList(delegateValue), valuesToTypePredicates, MagicKind.VALUE_CONSUMER);
        }

        private TypePredicate getTypePredicateByReceiverValue(@Nullable ResolvedCall<?> resolvedCall) {
            if (resolvedCall == null) {
                return AllTypes.INSTANCE$;
            }
            ReceiverValue receiverValue = this.getExplicitReceiverValue(resolvedCall);
            if (receiverValue.exists()) {
                return PseudocodePackage.getReceiverTypePredicate(resolvedCall, receiverValue);
            }
            return AllTypes.INSTANCE$;
        }

        @Override
        public void visitMultiDeclaration(@NotNull JetMultiDeclaration declaration) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitMultiDeclaration"));
            }
            this.visitMultiDeclaration(declaration, true);
        }

        @Override
        private void visitMultiDeclaration(@NotNull JetMultiDeclaration declaration, boolean generateWriteForEntries) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitMultiDeclaration"));
            }
            JetExpression initializer = declaration.getInitializer();
            this.generateInstructions(initializer);
            for (JetMultiDeclarationEntry entry : declaration.getEntries()) {
                this.builder.declareVariable(entry);
                ResolvedCall<FunctionDescriptor> resolvedCall = JetControlFlowProcessor.this.trace.get(BindingContext.COMPONENT_RESOLVED_CALL, entry);
                PseudoValue writtenValue = resolvedCall != null ? this.builder.call(entry, resolvedCall, this.getReceiverValues(resolvedCall), Collections.<PseudoValue, ValueParameterDescriptor>emptyMap()).getOutputValue() : this.createSyntheticValue(entry, MagicKind.UNRESOLVED_CALL, initializer);
                if (!generateWriteForEntries) continue;
                this.generateInitializer(entry, writtenValue != null ? writtenValue : this.createSyntheticValue(entry, MagicKind.FAKE_INITIALIZER, new JetElement[0]));
            }
        }

        @Override
        public void visitPropertyAccessor(@NotNull JetPropertyAccessor accessor) {
            if (accessor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitPropertyAccessor"));
            }
            JetControlFlowProcessor.this.processLocalDeclaration(accessor);
        }

        @Override
        public void visitBinaryWithTypeRHSExpression(@NotNull JetBinaryExpressionWithTypeRHS expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitBinaryWithTypeRHSExpression"));
            }
            this.mark(expression);
            IElementType operationType = expression.getOperationReference().getReferencedNameElementType();
            JetExpression left = expression.getLeft();
            if (operationType == JetTokens.COLON || operationType == JetTokens.AS_KEYWORD || operationType == JetTokens.AS_SAFE) {
                this.generateInstructions(left);
                if (this.getBoundOrUnreachableValue(left) != null) {
                    this.createNonSyntheticValue((JetElement)expression, MagicKind.CAST, left);
                }
            } else {
                this.visitJetElement(expression);
                this.createNonSyntheticValue((JetElement)expression, MagicKind.UNSUPPORTED_ELEMENT, left);
            }
        }

        @Override
        public void visitThrowExpression(@NotNull JetThrowExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitThrowExpression"));
            }
            this.mark(expression);
            JetExpression thrownExpression = expression.getThrownExpression();
            if (thrownExpression == null) {
                return;
            }
            this.generateInstructions(thrownExpression);
            PseudoValue thrownValue = this.builder.getBoundValue(thrownExpression);
            if (thrownValue == null) {
                return;
            }
            this.builder.throwException(expression, thrownValue);
        }

        @Override
        public void visitArrayAccessExpression(@NotNull JetArrayAccessExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitArrayAccessExpression"));
            }
            this.generateArrayAccess(expression, JetControlFlowProcessor.this.trace.get(BindingContext.INDEXED_LVALUE_GET, expression));
        }

        @Override
        public void visitIsExpression(@NotNull JetIsExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitIsExpression"));
            }
            this.mark(expression);
            JetExpression left = expression.getLeftHandSide();
            this.generateInstructions(left);
            this.createNonSyntheticValue((JetElement)expression, MagicKind.IS, left);
        }

        @Override
        public void visitWhenExpression(@NotNull JetWhenExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitWhenExpression"));
            }
            this.mark(expression);
            JetExpression subjectExpression = expression.getSubjectExpression();
            if (subjectExpression != null) {
                this.generateInstructions(subjectExpression);
            }
            ArrayList<JetExpression> branches = new ArrayList<JetExpression>();
            Label doneLabel = this.builder.createUnboundLabel("after 'when' expression");
            Label nextLabel = null;
            Iterator<JetWhenEntry> iterator2 = expression.getEntries().iterator();
            while (iterator2.hasNext()) {
                JetWhenEntry whenEntry = iterator2.next();
                this.mark(whenEntry);
                boolean isElse = whenEntry.isElse();
                if (isElse && iterator2.hasNext()) {
                    JetControlFlowProcessor.this.trace.report(Errors.ELSE_MISPLACED_IN_WHEN.on(whenEntry));
                }
                Label bodyLabel = this.builder.createUnboundLabel("'when' entry body");
                JetWhenCondition[] conditions = whenEntry.getConditions();
                for (int i = 0; i < conditions.length; ++i) {
                    JetWhenCondition condition = conditions[i];
                    condition.accept(this.conditionVisitor);
                    if (i + 1 >= conditions.length) continue;
                    this.builder.nondeterministicJump(bodyLabel, expression, this.builder.getBoundValue(condition));
                }
                if (!isElse) {
                    nextLabel = this.builder.createUnboundLabel("next 'when' entry");
                    JetWhenCondition lastCondition = KotlinPackage.lastOrNull(conditions);
                    this.builder.nondeterministicJump(nextLabel, expression, this.builder.getBoundValue(lastCondition));
                }
                this.builder.bindLabel(bodyLabel);
                JetExpression whenEntryExpression = whenEntry.getExpression();
                if (whenEntryExpression != null) {
                    this.generateInstructions(whenEntryExpression);
                    branches.add(whenEntryExpression);
                }
                this.builder.jump(doneLabel, expression);
                if (isElse) continue;
                this.builder.bindLabel(nextLabel);
            }
            this.builder.bindLabel(doneLabel);
            this.mergeValues(branches, expression);
        }

        @Override
        public void visitObjectLiteralExpression(@NotNull JetObjectLiteralExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitObjectLiteralExpression"));
            }
            this.mark(expression);
            JetObjectDeclaration declaration = expression.getObjectDeclaration();
            this.generateInstructions(declaration);
            this.builder.createAnonymousObject(expression);
        }

        @Override
        public void visitObjectDeclaration(@NotNull JetObjectDeclaration objectDeclaration) {
            if (objectDeclaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectDeclaration", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitObjectDeclaration"));
            }
            this.visitClassOrObject(objectDeclaration);
        }

        @Override
        public void visitStringTemplateExpression(@NotNull JetStringTemplateExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitStringTemplateExpression"));
            }
            this.mark(expression);
            ArrayList<JetExpression> inputExpressions = new ArrayList<JetExpression>();
            for (JetStringTemplateEntry entry : expression.getEntries()) {
                if (!(entry instanceof JetStringTemplateEntryWithExpression)) continue;
                JetExpression entryExpression = entry.getExpression();
                this.generateInstructions(entryExpression);
                inputExpressions.add(entryExpression);
            }
            this.builder.loadStringTemplate(expression, this.elementsToValues(inputExpressions));
        }

        @Override
        public void visitTypeProjection(@NotNull JetTypeProjection typeProjection) {
            if (typeProjection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeProjection", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitTypeProjection"));
            }
        }

        @Override
        public void visitAnonymousInitializer(@NotNull JetClassInitializer classInitializer) {
            if (classInitializer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classInitializer", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitAnonymousInitializer"));
            }
            this.generateInstructions(classInitializer.getBody());
        }

        private void visitClassOrObject(JetClassOrObject classOrObject) {
            for (JetDelegationSpecifier specifier : classOrObject.getDelegationSpecifiers()) {
                this.generateInstructions(specifier);
            }
            List<JetDeclaration> declarations = classOrObject.getDeclarations();
            if (classOrObject.isLocal()) {
                for (JetDeclaration declaration : declarations) {
                    this.generateInstructions(declaration);
                }
                return;
            }
            for (JetDeclaration declaration : declarations) {
                if (!(declaration instanceof JetProperty) && !(declaration instanceof JetClassInitializer)) continue;
                this.generateInstructions(declaration);
            }
        }

        @Override
        public void visitClass(@NotNull JetClass klass) {
            if (klass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitClass"));
            }
            List<JetParameter> parameters2 = klass.getPrimaryConstructorParameters();
            for (JetParameter parameter : parameters2) {
                this.generateInstructions(parameter);
            }
            this.visitClassOrObject(klass);
        }

        @Override
        public void visitDelegationToSuperCallSpecifier(@NotNull JetDelegatorToSuperCall call) {
            if (call == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitDelegationToSuperCallSpecifier"));
            }
            if (!this.generateCall(call)) {
                List<JetExpression> arguments2 = KotlinPackage.map(call.getValueArguments(), new Function1<ValueArgument, JetExpression>(){

                    @Override
                    public JetExpression invoke(ValueArgument valueArgument) {
                        return valueArgument.getArgumentExpression();
                    }
                });
                for (JetExpression argument : arguments2) {
                    this.generateInstructions(argument);
                }
                this.createNonSyntheticValue((JetElement)call, arguments2, MagicKind.UNRESOLVED_CALL);
            }
        }

        @Override
        public void visitDelegationByExpressionSpecifier(@NotNull JetDelegatorByExpressionSpecifier specifier) {
            if (specifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitDelegationByExpressionSpecifier"));
            }
            this.generateInstructions(specifier.getDelegateExpression());
            List<PseudoValue> arguments2 = ContainerUtil.createMaybeSingletonList(this.builder.getBoundValue(specifier.getDelegateExpression()));
            JetType jetType = JetControlFlowProcessor.this.trace.get(BindingContext.TYPE, specifier.getTypeReference());
            TypePredicate expectedTypePredicate = jetType != null ? PseudocodePackage.getSubtypesPredicate(jetType) : AllTypes.INSTANCE$;
            this.builder.magic(specifier, null, arguments2, PseudocodePackage.expectedTypeFor(expectedTypePredicate, arguments2), MagicKind.VALUE_CONSUMER);
        }

        @Override
        public void visitDelegationToSuperClassSpecifier(@NotNull JetDelegatorToSuperClass specifier) {
            if (specifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitDelegationToSuperClassSpecifier"));
            }
        }

        @Override
        public void visitDelegationSpecifierList(@NotNull JetDelegationSpecifierList list) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitDelegationSpecifierList"));
            }
            list.acceptChildren(this);
        }

        @Override
        public void visitJetFile(@NotNull JetFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitJetFile"));
            }
            for (JetDeclaration declaration : file.getDeclarations()) {
                if (!(declaration instanceof JetProperty)) continue;
                this.generateInstructions(declaration);
            }
        }

        @Override
        public void visitCallableReferenceExpression(@NotNull JetCallableReferenceExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitCallableReferenceExpression"));
            }
            this.mark(expression);
            this.createNonSyntheticValue((JetElement)expression, MagicKind.CALLABLE_REFERENCE, new JetElement[0]);
        }

        @Override
        public void visitJetElement(@NotNull JetElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitJetElement"));
            }
            this.createNonSyntheticValue(element, MagicKind.UNSUPPORTED_ELEMENT, new JetElement[0]);
        }

        private boolean generateCall(@Nullable JetElement callElement) {
            if (callElement == null) {
                return false;
            }
            return this.checkAndGenerateCall(CallUtilPackage.getResolvedCall(callElement, JetControlFlowProcessor.this.trace.getBindingContext()));
        }

        private boolean checkAndGenerateCall(@Nullable ResolvedCall<?> resolvedCall) {
            if (resolvedCall == null) {
                return false;
            }
            this.generateCall(resolvedCall);
            return true;
        }

        @NotNull
        private InstructionWithValue generateCall(@NotNull ResolvedCall<?> resolvedCall) {
            if (resolvedCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "generateCall"));
            }
            JetElement callElement = resolvedCall.getCall().getCallElement();
            if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
                VariableAsFunctionResolvedCall variableAsFunctionResolvedCall = (VariableAsFunctionResolvedCall)((Object)resolvedCall);
                InstructionWithValue instructionWithValue = this.generateCall(variableAsFunctionResolvedCall.getFunctionCall());
                if (instructionWithValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "generateCall"));
                }
                return instructionWithValue;
            }
            Object resultingDescriptor = resolvedCall.getResultingDescriptor();
            Map<PseudoValue, ReceiverValue> receivers = this.getReceiverValues(resolvedCall);
            SmartFMap<PseudoValue, ValueParameterDescriptor> parameterValues = SmartFMap.emptyMap();
            for (ValueArgument valueArgument : resolvedCall.getCall().getValueArguments()) {
                ArgumentMapping argumentMapping = resolvedCall.getArgumentMapping(valueArgument);
                JetExpression argumentExpression = valueArgument.getArgumentExpression();
                if (argumentMapping instanceof ArgumentMatch) {
                    parameterValues = this.generateValueArgument(valueArgument, ((ArgumentMatch)argumentMapping).getValueParameter(), parameterValues);
                    continue;
                }
                if (argumentExpression == null) continue;
                this.generateInstructions(argumentExpression);
                this.createSyntheticValue(argumentExpression, MagicKind.VALUE_CONSUMER, argumentExpression);
            }
            if (resultingDescriptor instanceof VariableDescriptor) {
                JetExpression callExpression;
                JetExpression jetExpression = callExpression = callElement instanceof JetExpression ? (JetExpression)callElement : null;
                assert (callExpression != null) : "Variable-based call without callee expression: " + callElement.getText();
                assert (parameterValues.isEmpty()) : "Variable-based call with non-empty argument list: " + callElement.getText();
                ReadValueInstruction readValueInstruction = this.builder.readVariable(callExpression, resolvedCall, receivers);
                if (readValueInstruction == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "generateCall"));
                }
                return readValueInstruction;
            }
            this.mark(resolvedCall.getCall().getCallElement());
            CallInstruction callInstruction = this.builder.call(callElement, resolvedCall, receivers, parameterValues);
            if (callInstruction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "generateCall"));
            }
            return callInstruction;
        }

        @NotNull
        private Map<PseudoValue, ReceiverValue> getReceiverValues(ResolvedCall<?> resolvedCall) {
            SmartFMap<PseudoValue, ReceiverValue> receiverValues = SmartFMap.emptyMap();
            JetElement callElement = resolvedCall.getCall().getCallElement();
            receiverValues = this.getReceiverValues(callElement, resolvedCall.getDispatchReceiver(), receiverValues);
            SmartFMap<PseudoValue, ReceiverValue> smartFMap = receiverValues = this.getReceiverValues(callElement, resolvedCall.getExtensionReceiver(), receiverValues);
            if (smartFMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "getReceiverValues"));
            }
            return smartFMap;
        }

        @NotNull
        private SmartFMap<PseudoValue, ReceiverValue> getReceiverValues(JetElement callElement, ReceiverValue receiver, SmartFMap<PseudoValue, ReceiverValue> receiverValues) {
            if (!receiver.exists()) {
                SmartFMap<PseudoValue, ReceiverValue> smartFMap = receiverValues;
                if (smartFMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "getReceiverValues"));
                }
                return smartFMap;
            }
            if (receiver instanceof ThisReceiver) {
                receiverValues = receiverValues.plus(this.createSyntheticValue(callElement, MagicKind.IMPLICIT_RECEIVER, new JetElement[0]), receiver);
            } else if (receiver instanceof ExpressionReceiver) {
                PseudoValue receiverPseudoValue;
                JetExpression expression = ((ExpressionReceiver)receiver).getExpression();
                if (this.builder.getBoundValue(expression) == null) {
                    this.generateInstructions(expression);
                }
                if ((receiverPseudoValue = this.getBoundOrUnreachableValue(expression)) != null) {
                    receiverValues = receiverValues.plus(receiverPseudoValue, receiver);
                }
            } else if (!(receiver instanceof TransientReceiver)) {
                throw new IllegalArgumentException("Unknown receiver kind: " + receiver);
            }
            SmartFMap<PseudoValue, ReceiverValue> smartFMap = receiverValues;
            if (smartFMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "getReceiverValues"));
            }
            return smartFMap;
        }

        @NotNull
        private SmartFMap<PseudoValue, ValueParameterDescriptor> generateValueArgument(ValueArgument valueArgument, ValueParameterDescriptor parameterDescriptor, SmartFMap<PseudoValue, ValueParameterDescriptor> parameterValues) {
            JetExpression expression = valueArgument.getArgumentExpression();
            if (expression != null) {
                PseudoValue argValue;
                if (!valueArgument.isExternal()) {
                    this.generateInstructions(expression);
                }
                if ((argValue = this.getBoundOrUnreachableValue(expression)) != null) {
                    parameterValues = parameterValues.plus(argValue, parameterDescriptor);
                }
            }
            SmartFMap<PseudoValue, ValueParameterDescriptor> smartFMap = parameterValues;
            if (smartFMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "generateValueArgument"));
            }
            return smartFMap;
        }

        private class FinallyBlockGenerator {
            private final JetFinallySection finallyBlock;
            private Label startFinally = null;
            private Label finishFinally = null;

            private FinallyBlockGenerator(JetFinallySection block) {
                this.finallyBlock = block;
            }

            public void generate() {
                JetBlockExpression finalExpression = this.finallyBlock.getFinalExpression();
                if (finalExpression == null) {
                    return;
                }
                if (this.startFinally != null) {
                    assert (this.finishFinally != null);
                    CFPVisitor.this.builder.repeatPseudocode(this.startFinally, this.finishFinally);
                    return;
                }
                this.startFinally = CFPVisitor.this.builder.createUnboundLabel("start finally");
                CFPVisitor.this.builder.bindLabel(this.startFinally);
                CFPVisitor.this.generateInstructions(finalExpression);
                this.finishFinally = CFPVisitor.this.builder.createUnboundLabel("finish finally");
                CFPVisitor.this.builder.bindLabel(this.finishFinally);
            }
        }
    }
}

