/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.diagnostics;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.diagnostics.ParametrizedDiagnostic;

public class PositioningStrategy<E extends PsiElement> {
    @NotNull
    public List<TextRange> markDiagnostic(@NotNull ParametrizedDiagnostic<? extends E> diagnostic) {
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/jet/lang/diagnostics/PositioningStrategy", "markDiagnostic"));
        }
        List<TextRange> list = this.mark(diagnostic.getPsiElement());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategy", "markDiagnostic"));
        }
        return list;
    }

    @NotNull
    protected List<TextRange> mark(@NotNull E element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/PositioningStrategy", "mark"));
        }
        List<TextRange> list = PositioningStrategy.markElement(element);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategy", "mark"));
        }
        return list;
    }

    public boolean isValid(@NotNull E element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/PositioningStrategy", "isValid"));
        }
        return !PositioningStrategy.hasSyntaxErrors(element);
    }

    @NotNull
    protected static List<TextRange> markElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/PositioningStrategy", "markElement"));
        }
        List<TextRange> list = Collections.singletonList(new TextRange(PositioningStrategy.getStartOffset(element), PositioningStrategy.getEndOffset(element)));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategy", "markElement"));
        }
        return list;
    }

    @NotNull
    protected static List<TextRange> markNode(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/diagnostics/PositioningStrategy", "markNode"));
        }
        List<TextRange> list = PositioningStrategy.markElement(node.getPsi());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategy", "markNode"));
        }
        return list;
    }

    @NotNull
    protected static List<TextRange> markRange(@NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/jet/lang/diagnostics/PositioningStrategy", "markRange"));
        }
        List<TextRange> list = Collections.singletonList(range);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategy", "markRange"));
        }
        return list;
    }

    @NotNull
    protected static List<TextRange> markRange(@NotNull PsiElement from, @NotNull PsiElement to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/jet/lang/diagnostics/PositioningStrategy", "markRange"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/jet/lang/diagnostics/PositioningStrategy", "markRange"));
        }
        List<TextRange> list = PositioningStrategy.markRange(new TextRange(PositioningStrategy.getStartOffset(from), PositioningStrategy.getEndOffset(to)));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategy", "markRange"));
        }
        return list;
    }

    private static int getStartOffset(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/PositioningStrategy", "getStartOffset"));
        }
        PsiElement child = element.getFirstChild();
        if (child != null) {
            while (child instanceof PsiComment || child instanceof PsiWhiteSpace) {
                child = child.getNextSibling();
            }
            if (child != null) {
                return PositioningStrategy.getStartOffset(child);
            }
        }
        return element.getTextRange().getStartOffset();
    }

    private static int getEndOffset(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/PositioningStrategy", "getEndOffset"));
        }
        PsiElement child = element.getLastChild();
        if (child != null) {
            while (child instanceof PsiComment || child instanceof PsiWhiteSpace) {
                child = child.getPrevSibling();
            }
            if (child != null) {
                return PositioningStrategy.getEndOffset(child);
            }
        }
        return element.getTextRange().getEndOffset();
    }

    protected static boolean hasSyntaxErrors(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/jet/lang/diagnostics/PositioningStrategy", "hasSyntaxErrors"));
        }
        if (psiElement instanceof PsiErrorElement) {
            return true;
        }
        PsiElement[] children = psiElement.getChildren();
        return children.length > 0 && PositioningStrategy.hasSyntaxErrors(children[children.length - 1]);
    }
}

