/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetDeclarationStub;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetStatementExpression;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;

public class JetClassInitializer
extends JetDeclarationStub<KotlinPlaceHolderStub<JetClassInitializer>>
implements JetStatementExpression {
    public JetClassInitializer(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetClassInitializer", "<init>"));
        }
        super(node);
    }

    public JetClassInitializer(@NotNull KotlinPlaceHolderStub<JetClassInitializer> stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/lang/psi/JetClassInitializer", "<init>"));
        }
        super(stub, JetStubElementTypes.ANONYMOUS_INITIALIZER);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetClassInitializer", "accept"));
        }
        return visitor.visitAnonymousInitializer(this, data2);
    }

    @NotNull
    public JetExpression getBody() {
        JetExpression body = this.findChildByClass(JetExpression.class);
        assert (body != null);
        JetExpression jetExpression = body;
        if (jetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetClassInitializer", "getBody"));
        }
        return jetExpression;
    }

    @Nullable
    public PsiElement getOpenBraceNode() {
        JetExpression body = this.getBody();
        return body instanceof JetBlockExpression ? ((JetBlockExpression)body).getLBrace() : null;
    }
}

