/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.MemberDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetAnnotationEntry;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetModifierListOwner;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.resolve.AdditionalCheckerProvider;
import org.jetbrains.jet.lang.resolve.AnnotationChecker;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.StringValue;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lexer.JetModifierKeywordToken;
import org.jetbrains.jet.lexer.JetTokens;

public class ModifiersChecker {
    private static final Collection<JetModifierKeywordToken> MODALITY_MODIFIERS = Lists.newArrayList(JetTokens.ABSTRACT_KEYWORD, JetTokens.OPEN_KEYWORD, JetTokens.FINAL_KEYWORD, JetTokens.OVERRIDE_KEYWORD);
    private static final Collection<JetModifierKeywordToken> VISIBILITY_MODIFIERS = Lists.newArrayList(JetTokens.PRIVATE_KEYWORD, JetTokens.PROTECTED_KEYWORD, JetTokens.PUBLIC_KEYWORD, JetTokens.INTERNAL_KEYWORD);
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final AdditionalCheckerProvider additionalCheckerProvider;

    public static void reportIllegalModifiers(@Nullable JetModifierList modifierList, @NotNull Collection<JetModifierKeywordToken> illegalModifiers, @NotNull BindingTrace trace) {
        if (illegalModifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "illegalModifiers", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "reportIllegalModifiers"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "reportIllegalModifiers"));
        }
        if (modifierList == null) {
            return;
        }
        for (JetModifierKeywordToken modifierToken : illegalModifiers) {
            if (!modifierList.hasModifier(modifierToken)) continue;
            PsiElement modifierPsi = modifierList.getModifier(modifierToken);
            assert (modifierPsi != null);
            trace.report(Errors.ILLEGAL_MODIFIER.on(modifierPsi, modifierToken));
        }
    }

    public ModifiersChecker(@NotNull BindingTrace trace, @NotNull AdditionalCheckerProvider additionalCheckerProvider) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "<init>"));
        }
        if (additionalCheckerProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalCheckerProvider", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "<init>"));
        }
        this.trace = trace;
        this.additionalCheckerProvider = additionalCheckerProvider;
    }

    public static ModifiersChecker create(@NotNull BindingTrace trace, @NotNull AdditionalCheckerProvider provider) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "create"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "create"));
        }
        return new ModifiersChecker(trace, provider);
    }

    public void checkModifiersForDeclaration(@NotNull JetDeclaration modifierListOwner, @NotNull MemberDescriptor descriptor) {
        if (modifierListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "checkModifiersForDeclaration"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "checkModifiersForDeclaration"));
        }
        if (modifierListOwner instanceof JetEnumEntry) {
            this.checkIllegalInThisContextModifiers(modifierListOwner, Arrays.asList(JetTokens.MODIFIER_KEYWORDS_ARRAY));
        } else {
            this.checkInnerModifier(modifierListOwner, descriptor);
            this.checkModalityModifiers(modifierListOwner);
            this.checkVisibilityModifiers(modifierListOwner, descriptor);
        }
        this.checkPlatformNameApplicability(descriptor);
        this.runAnnotationCheckers(modifierListOwner, descriptor);
    }

    public void checkModifiersForLocalDeclaration(@NotNull JetDeclaration modifierListOwner, @NotNull DeclarationDescriptor descriptor) {
        if (modifierListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "checkModifiersForLocalDeclaration"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "checkModifiersForLocalDeclaration"));
        }
        this.checkIllegalModalityModifiers(modifierListOwner);
        this.checkIllegalVisibilityModifiers(modifierListOwner);
        this.checkPlatformNameApplicability(descriptor);
        this.runAnnotationCheckers(modifierListOwner, descriptor);
    }

    public void checkIllegalModalityModifiers(@NotNull JetModifierListOwner modifierListOwner) {
        if (modifierListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "checkIllegalModalityModifiers"));
        }
        this.checkIllegalInThisContextModifiers(modifierListOwner, MODALITY_MODIFIERS);
    }

    public void checkIllegalVisibilityModifiers(@NotNull JetModifierListOwner modifierListOwner) {
        if (modifierListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "checkIllegalVisibilityModifiers"));
        }
        this.checkIllegalInThisContextModifiers(modifierListOwner, VISIBILITY_MODIFIERS);
    }

    private void checkModalityModifiers(@NotNull JetModifierListOwner modifierListOwner) {
        if (modifierListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "checkModalityModifiers"));
        }
        JetModifierList modifierList = modifierListOwner.getModifierList();
        if (modifierList == null) {
            return;
        }
        this.checkRedundantModifier(modifierList, Pair.create(JetTokens.OPEN_KEYWORD, JetTokens.ABSTRACT_KEYWORD), Pair.create(JetTokens.OPEN_KEYWORD, JetTokens.OVERRIDE_KEYWORD));
        this.checkCompatibility(modifierList, Arrays.asList(JetTokens.ABSTRACT_KEYWORD, JetTokens.OPEN_KEYWORD, JetTokens.FINAL_KEYWORD), Arrays.asList(JetTokens.ABSTRACT_KEYWORD, JetTokens.OPEN_KEYWORD));
        if (modifierListOwner.getParent() instanceof JetClassObject || modifierListOwner instanceof JetObjectDeclaration) {
            this.checkIllegalModalityModifiers(modifierListOwner);
        } else if (modifierListOwner instanceof JetClassOrObject) {
            this.checkIllegalInThisContextModifiers(modifierListOwner, Collections.singletonList(JetTokens.OVERRIDE_KEYWORD));
        }
    }

    private void checkVisibilityModifiers(@NotNull JetModifierListOwner modifierListOwner, @NotNull DeclarationDescriptor descriptor) {
        if (modifierListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "checkVisibilityModifiers"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "checkVisibilityModifiers"));
        }
        JetModifierList modifierList = modifierListOwner.getModifierList();
        if (modifierList == null) {
            return;
        }
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        if (containingDeclaration instanceof PackageFragmentDescriptor && modifierList.hasModifier(JetTokens.PROTECTED_KEYWORD)) {
            this.trace.report(Errors.PACKAGE_MEMBER_CANNOT_BE_PROTECTED.on(modifierListOwner));
        }
        this.checkCompatibility(modifierList, VISIBILITY_MODIFIERS, new Collection[0]);
    }

    private void checkInnerModifier(@NotNull JetModifierListOwner modifierListOwner, @NotNull DeclarationDescriptor descriptor) {
        if (modifierListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "checkInnerModifier"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "checkInnerModifier"));
        }
        if (modifierListOwner.hasModifier(JetTokens.INNER_KEYWORD)) {
            if (ModifiersChecker.isIllegalInner(descriptor)) {
                this.checkIllegalInThisContextModifiers(modifierListOwner, Collections.singletonList(JetTokens.INNER_KEYWORD));
            }
            return;
        }
        if (modifierListOwner instanceof JetClass && !(modifierListOwner instanceof JetEnumEntry)) {
            boolean localEnumError;
            JetClass aClass = (JetClass)modifierListOwner;
            boolean bl = localEnumError = aClass.isLocal() && aClass.isEnum();
            if (!localEnumError && ModifiersChecker.isIllegalNestedClass(descriptor)) {
                this.trace.report(Errors.NESTED_CLASS_NOT_ALLOWED.on(aClass));
            }
        }
    }

    private static boolean isIllegalInner(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "isIllegalInner"));
        }
        if (!(descriptor instanceof ClassDescriptor)) {
            return true;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)descriptor;
        if (classDescriptor.getKind() != ClassKind.CLASS) {
            return true;
        }
        DeclarationDescriptor containingDeclaration = classDescriptor.getContainingDeclaration();
        if (!(containingDeclaration instanceof ClassDescriptor)) {
            return true;
        }
        return ((ClassDescriptor)containingDeclaration).getKind() == ClassKind.TRAIT;
    }

    private static boolean isIllegalNestedClass(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "isIllegalNestedClass"));
        }
        if (!(descriptor instanceof ClassDescriptor)) {
            return false;
        }
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        if (!(containingDeclaration instanceof ClassDescriptor)) {
            return false;
        }
        ClassDescriptor containingClass = (ClassDescriptor)containingDeclaration;
        return containingClass.isInner() || containingClass.getContainingDeclaration() instanceof FunctionDescriptor;
    }

    private void checkPlatformNameApplicability(@NotNull DeclarationDescriptor descriptor) {
        String value;
        CompileTimeConstant<?> name;
        Collection<CompileTimeConstant<?>> values;
        AnnotationDescriptor annotation2;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "checkPlatformNameApplicability"));
        }
        if (descriptor instanceof PropertyDescriptor) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor;
            if (propertyDescriptor.getGetter() != null) {
                this.checkPlatformNameApplicability(propertyDescriptor.getGetter());
            }
            if (propertyDescriptor.getSetter() != null) {
                this.checkPlatformNameApplicability(propertyDescriptor.getSetter());
            }
        }
        if ((annotation2 = descriptor.getAnnotations().findAnnotation(new FqName("kotlin.platform.platformName"))) == null) {
            return;
        }
        JetAnnotationEntry annotationEntry = this.trace.get(BindingContext.ANNOTATION_DESCRIPTOR_TO_PSI_ELEMENT, annotation2);
        if (annotationEntry == null) {
            return;
        }
        if (!DescriptorUtils.isTopLevelDeclaration(descriptor) || !(descriptor instanceof FunctionDescriptor)) {
            this.trace.report(Errors.INAPPLICABLE_ANNOTATION.on(annotationEntry));
        }
        if (!((values = annotation2.getAllValueArguments().values()).isEmpty() || !((name = values.iterator().next()) instanceof StringValue) || (value = (String)((StringValue)name).getValue()) != null && Name.isValidIdentifier(value))) {
            this.trace.report(Errors.ILLEGAL_PLATFORM_NAME.on(annotationEntry, String.valueOf(value)));
        }
    }

    private void checkCompatibility(@Nullable JetModifierList modifierList, Collection<JetModifierKeywordToken> availableModifiers, Collection<JetModifierKeywordToken> ... availableCombinations) {
        if (modifierList == null) {
            return;
        }
        LinkedHashSet<JetModifierKeywordToken> presentModifiers = Sets.newLinkedHashSet();
        for (JetModifierKeywordToken modifier : availableModifiers) {
            if (!modifierList.hasModifier(modifier)) continue;
            presentModifiers.add(modifier);
        }
        if (presentModifiers.size() == 1) {
            return;
        }
        for (Collection<JetModifierKeywordToken> combination : availableCombinations) {
            if (!presentModifiers.containsAll(combination) || !combination.containsAll(presentModifiers)) continue;
            return;
        }
        for (JetModifierKeywordToken token : presentModifiers) {
            this.trace.report(Errors.INCOMPATIBLE_MODIFIERS.on(modifierList.getModifierNode(token).getPsi(), presentModifiers));
        }
    }

    private void checkRedundantModifier(@NotNull JetModifierList modifierList, Pair<JetModifierKeywordToken, JetModifierKeywordToken> ... redundantBundles) {
        if (modifierList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierList", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "checkRedundantModifier"));
        }
        for (Pair<JetModifierKeywordToken, JetModifierKeywordToken> tokenPair : redundantBundles) {
            JetModifierKeywordToken redundantModifier = tokenPair.getFirst();
            JetModifierKeywordToken sufficientModifier = tokenPair.getSecond();
            if (!modifierList.hasModifier(redundantModifier) || !modifierList.hasModifier(sufficientModifier)) continue;
            this.trace.report(Errors.REDUNDANT_MODIFIER.on(modifierList.getModifierNode(redundantModifier).getPsi(), redundantModifier, sufficientModifier));
        }
    }

    public void checkIllegalInThisContextModifiers(@NotNull JetModifierListOwner modifierListOwner, @NotNull Collection<JetModifierKeywordToken> illegalModifiers) {
        if (modifierListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "checkIllegalInThisContextModifiers"));
        }
        if (illegalModifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "illegalModifiers", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "checkIllegalInThisContextModifiers"));
        }
        ModifiersChecker.reportIllegalModifiers(modifierListOwner.getModifierList(), illegalModifiers, this.trace);
    }

    @NotNull
    public static Map<JetModifierKeywordToken, ASTNode> getNodesCorrespondingToModifiers(@NotNull JetModifierList modifierList, @NotNull Collection<JetModifierKeywordToken> possibleModifiers) {
        if (modifierList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierList", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "getNodesCorrespondingToModifiers"));
        }
        if (possibleModifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "possibleModifiers", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "getNodesCorrespondingToModifiers"));
        }
        HashMap<JetModifierKeywordToken, ASTNode> nodes = Maps.newHashMap();
        for (JetModifierKeywordToken modifier : possibleModifiers) {
            if (!modifierList.hasModifier(modifier)) continue;
            nodes.put(modifier, modifierList.getModifierNode(modifier));
        }
        HashMap<JetModifierKeywordToken, ASTNode> hashMap = nodes;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "getNodesCorrespondingToModifiers"));
        }
        return hashMap;
    }

    @NotNull
    public static Modality resolveModalityFromModifiers(@NotNull JetModifierListOwner modifierListOwner, @NotNull Modality defaultModality) {
        if (modifierListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "resolveModalityFromModifiers"));
        }
        if (defaultModality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultModality", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "resolveModalityFromModifiers"));
        }
        Modality modality = ModifiersChecker.resolveModalityFromModifiers(modifierListOwner.getModifierList(), defaultModality);
        if (modality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "resolveModalityFromModifiers"));
        }
        return modality;
    }

    public static Modality resolveModalityFromModifiers(@Nullable JetModifierList modifierList, @NotNull Modality defaultModality) {
        if (defaultModality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultModality", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "resolveModalityFromModifiers"));
        }
        if (modifierList == null) {
            return defaultModality;
        }
        boolean hasAbstractModifier = modifierList.hasModifier(JetTokens.ABSTRACT_KEYWORD);
        boolean hasOverrideModifier = modifierList.hasModifier(JetTokens.OVERRIDE_KEYWORD);
        if (modifierList.hasModifier(JetTokens.OPEN_KEYWORD)) {
            if (hasAbstractModifier || defaultModality == Modality.ABSTRACT) {
                return Modality.ABSTRACT;
            }
            return Modality.OPEN;
        }
        if (hasAbstractModifier) {
            return Modality.ABSTRACT;
        }
        boolean hasFinalModifier = modifierList.hasModifier(JetTokens.FINAL_KEYWORD);
        if (hasOverrideModifier && !hasFinalModifier && defaultModality != Modality.ABSTRACT) {
            return Modality.OPEN;
        }
        if (hasFinalModifier) {
            return Modality.FINAL;
        }
        return defaultModality;
    }

    @NotNull
    public static Visibility resolveVisibilityFromModifiers(@NotNull JetModifierListOwner modifierListOwner, @NotNull Visibility defaultVisibility) {
        if (modifierListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "resolveVisibilityFromModifiers"));
        }
        if (defaultVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultVisibility", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "resolveVisibilityFromModifiers"));
        }
        Visibility visibility = ModifiersChecker.resolveVisibilityFromModifiers(modifierListOwner.getModifierList(), defaultVisibility);
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "resolveVisibilityFromModifiers"));
        }
        return visibility;
    }

    public static Visibility resolveVisibilityFromModifiers(@Nullable JetModifierList modifierList, @NotNull Visibility defaultVisibility) {
        if (defaultVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultVisibility", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "resolveVisibilityFromModifiers"));
        }
        if (modifierList == null) {
            return defaultVisibility;
        }
        if (modifierList.hasModifier(JetTokens.PRIVATE_KEYWORD)) {
            return Visibilities.PRIVATE;
        }
        if (modifierList.hasModifier(JetTokens.PUBLIC_KEYWORD)) {
            return Visibilities.PUBLIC;
        }
        if (modifierList.hasModifier(JetTokens.PROTECTED_KEYWORD)) {
            return Visibilities.PROTECTED;
        }
        if (modifierList.hasModifier(JetTokens.INTERNAL_KEYWORD)) {
            return Visibilities.INTERNAL;
        }
        return defaultVisibility;
    }

    public static boolean isInnerClass(@Nullable JetModifierList modifierList) {
        return modifierList != null && modifierList.hasModifier(JetTokens.INNER_KEYWORD);
    }

    @NotNull
    public static Visibility getDefaultClassVisibility(@NotNull ClassDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "getDefaultClassVisibility"));
        }
        ClassKind kind = descriptor.getKind();
        if (kind == ClassKind.ENUM_ENTRY) {
            Visibility visibility = Visibilities.PUBLIC;
            if (visibility == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "getDefaultClassVisibility"));
            }
            return visibility;
        }
        if (kind == ClassKind.CLASS_OBJECT) {
            Visibility visibility = ((ClassDescriptor)descriptor.getContainingDeclaration()).getVisibility();
            if (visibility == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "getDefaultClassVisibility"));
            }
            return visibility;
        }
        Visibility visibility = Visibilities.INTERNAL;
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "getDefaultClassVisibility"));
        }
        return visibility;
    }

    private void runAnnotationCheckers(@NotNull JetDeclaration declaration, @NotNull DeclarationDescriptor descriptor) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "runAnnotationCheckers"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/ModifiersChecker", "runAnnotationCheckers"));
        }
        for (AnnotationChecker checker : this.additionalCheckerProvider.getAnnotationCheckers()) {
            checker.check(declaration, descriptor, this.trace);
        }
    }
}

