/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.analyzer.AnalysisResult;
import org.jetbrains.jet.context.ContextPackage;
import org.jetbrains.jet.context.GlobalContext;
import org.jetbrains.jet.di.InjectorForTopDownAnalyzerForJvm;
import org.jetbrains.jet.lang.descriptors.PackageFragmentProvider;
import org.jetbrains.jet.lang.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisParameters;
import org.jetbrains.jet.lang.resolve.java.mapping.JavaToKotlinClassMap;
import org.jetbrains.jet.lang.resolve.kotlin.incremental.IncrementalPackageFragmentProvider;
import org.jetbrains.jet.lang.resolve.kotlin.incremental.cache.IncrementalCache;
import org.jetbrains.jet.lang.resolve.kotlin.incremental.cache.IncrementalCacheProvider;
import org.jetbrains.jet.lang.resolve.name.Name;

public enum TopDownAnalyzerFacadeForJVM {
    INSTANCE;

    public static final List<ImportPath> DEFAULT_IMPORTS;

    @NotNull
    public static AnalysisResult analyzeFilesWithJavaIntegration(@NotNull Project project, @NotNull Collection<JetFile> files, @NotNull BindingTrace trace, @NotNull TopDownAnalysisParameters topDownAnalysisParameters, @NotNull ModuleDescriptorImpl module) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/lang/resolve/java/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegration"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/jet/lang/resolve/java/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegration"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/java/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegration"));
        }
        if (topDownAnalysisParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topDownAnalysisParameters", "org/jetbrains/jet/lang/resolve/java/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegration"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jet/lang/resolve/java/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegration"));
        }
        AnalysisResult analysisResult = TopDownAnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration(project, files, trace, topDownAnalysisParameters, module, null, null);
        if (analysisResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegration"));
        }
        return analysisResult;
    }

    @NotNull
    public static AnalysisResult analyzeFilesWithJavaIntegration(@NotNull Project project, @NotNull Collection<JetFile> files, @NotNull BindingTrace trace, @NotNull Predicate<PsiFile> filesToAnalyzeCompletely, @NotNull ModuleDescriptorImpl module, @Nullable List<String> moduleIds, @Nullable IncrementalCacheProvider incrementalCacheProvider) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/lang/resolve/java/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegration"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/jet/lang/resolve/java/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegration"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/java/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegration"));
        }
        if (filesToAnalyzeCompletely == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToAnalyzeCompletely", "org/jetbrains/jet/lang/resolve/java/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegration"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jet/lang/resolve/java/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegration"));
        }
        AnalysisResult analysisResult = TopDownAnalyzerFacadeForJVM.analyzeFilesWithJavaIntegrationWithCustomContext(project, ContextPackage.GlobalContext(), files, trace, filesToAnalyzeCompletely, module, moduleIds, incrementalCacheProvider);
        if (analysisResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegration"));
        }
        return analysisResult;
    }

    @NotNull
    public static AnalysisResult analyzeFilesWithJavaIntegrationWithCustomContext(@NotNull Project project, @NotNull GlobalContext globalContext, @NotNull Collection<JetFile> files, @NotNull BindingTrace trace, @NotNull Predicate<PsiFile> filesToAnalyzeCompletely, @NotNull ModuleDescriptorImpl module, @Nullable List<String> moduleIds, @Nullable IncrementalCacheProvider incrementalCacheProvider) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/lang/resolve/java/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationWithCustomContext"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "org/jetbrains/jet/lang/resolve/java/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationWithCustomContext"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/jet/lang/resolve/java/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationWithCustomContext"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/java/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationWithCustomContext"));
        }
        if (filesToAnalyzeCompletely == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToAnalyzeCompletely", "org/jetbrains/jet/lang/resolve/java/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationWithCustomContext"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jet/lang/resolve/java/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationWithCustomContext"));
        }
        TopDownAnalysisParameters topDownAnalysisParameters = TopDownAnalysisParameters.create(globalContext.getStorageManager(), globalContext.getExceptionTracker(), filesToAnalyzeCompletely, false, false);
        AnalysisResult analysisResult = TopDownAnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration(project, files, trace, topDownAnalysisParameters, module, moduleIds, incrementalCacheProvider);
        if (analysisResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationWithCustomContext"));
        }
        return analysisResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static AnalysisResult analyzeFilesWithJavaIntegration(Project project, Collection<JetFile> files, BindingTrace trace, TopDownAnalysisParameters topDownAnalysisParameters, ModuleDescriptorImpl module, @Nullable List<String> moduleIds, @Nullable IncrementalCacheProvider incrementalCacheProvider) {
        InjectorForTopDownAnalyzerForJvm injector = new InjectorForTopDownAnalyzerForJvm(project, topDownAnalysisParameters, trace, module);
        ArrayList<PackageFragmentProvider> additionalProviders = new ArrayList<PackageFragmentProvider>();
        if (moduleIds != null && incrementalCacheProvider != null) {
            for (String moduleId : moduleIds) {
                IncrementalCache incrementalCache = incrementalCacheProvider.getIncrementalCache(moduleId);
                additionalProviders.add(new IncrementalPackageFragmentProvider(files, module, topDownAnalysisParameters.getStorageManager(), injector.getDeserializationComponentsForJava().getComponents(), incrementalCache, moduleId, injector.getJavaDescriptorResolver()));
            }
        }
        additionalProviders.add(injector.getJavaDescriptorResolver().getPackageFragmentProvider());
        injector.getTopDownAnalyzer().analyzeFiles(topDownAnalysisParameters, files, additionalProviders);
        AnalysisResult analysisResult = AnalysisResult.success(trace.getBindingContext(), module);
        AnalysisResult analysisResult2 = analysisResult;
        if (analysisResult2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegration"));
        }
        return analysisResult2;
        finally {
            injector.destroy();
        }
    }

    @NotNull
    public static ModuleDescriptorImpl createJavaModule(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/java/TopDownAnalyzerFacadeForJVM", "createJavaModule"));
        }
        ModuleDescriptorImpl moduleDescriptorImpl = new ModuleDescriptorImpl(Name.special(name), DEFAULT_IMPORTS, JavaToKotlinClassMap.getInstance());
        if (moduleDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/TopDownAnalyzerFacadeForJVM", "createJavaModule"));
        }
        return moduleDescriptorImpl;
    }

    static {
        DEFAULT_IMPORTS = ImmutableList.of(new ImportPath("java.lang.*"), new ImportPath("kotlin.*"), new ImportPath("kotlin.jvm.*"), new ImportPath("kotlin.io.*"));
    }
}

