/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.kotlin;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.descriptors.AnnotatedCallableKind;
import org.jetbrains.jet.descriptors.serialization.descriptors.ConstantLoader;
import org.jetbrains.jet.lang.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.java.resolver.ErrorReporter;
import org.jetbrains.jet.lang.resolve.kotlin.BaseDescriptorLoader;
import org.jetbrains.jet.lang.resolve.kotlin.DescriptorLoadersStorage;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinClassFinder;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinJvmBinaryClass;

public class ConstantDescriptorLoader
extends BaseDescriptorLoader
implements ConstantLoader {
    public ConstantDescriptorLoader(@NotNull DescriptorLoadersStorage storage2, @NotNull KotlinClassFinder kotlinClassFinder, @NotNull ErrorReporter errorReporter) {
        if (storage2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "org/jetbrains/jet/lang/resolve/kotlin/ConstantDescriptorLoader", "<init>"));
        }
        if (kotlinClassFinder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClassFinder", "org/jetbrains/jet/lang/resolve/kotlin/ConstantDescriptorLoader", "<init>"));
        }
        if (errorReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorReporter", "org/jetbrains/jet/lang/resolve/kotlin/ConstantDescriptorLoader", "<init>"));
        }
        super(kotlinClassFinder, errorReporter, storage2);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> loadPropertyConstant(@NotNull ClassOrPackageFragmentDescriptor container, @NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver, @NotNull AnnotatedCallableKind kind) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/jetbrains/jet/lang/resolve/kotlin/ConstantDescriptorLoader", "loadPropertyConstant"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/lang/resolve/kotlin/ConstantDescriptorLoader", "loadPropertyConstant"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/lang/resolve/kotlin/ConstantDescriptorLoader", "loadPropertyConstant"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/resolve/kotlin/ConstantDescriptorLoader", "loadPropertyConstant"));
        }
        DescriptorLoadersStorage.MemberSignature signature = ConstantDescriptorLoader.getCallableSignature(proto, nameResolver, kind);
        if (signature == null) {
            return null;
        }
        KotlinJvmBinaryClass kotlinClass = this.findClassWithAnnotationsAndInitializers(container, proto, nameResolver, kind);
        if (kotlinClass == null) {
            this.errorReporter.reportLoadingError("Kotlin class for loading property constant is not found: " + container, null);
            return null;
        }
        return this.storage.getStorageForClass(kotlinClass).getPropertyConstants().get(signature);
    }
}

