/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.kotlin;

import com.intellij.psi.PsiElement;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.jvm.internal.InternalPackage;
import kotlin.reflect.jvm.internal.KClassImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.diagnostics.DiagnosticSink;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.resolve.AnnotationChecker;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.annotations.AnnotationsPackage$AnnotationUtil$e04122e8;
import org.jetbrains.jet.lang.resolve.java.diagnostics.ErrorsJvm;
import org.jetbrains.jet.lexer.JetTokens;

@KotlinClass(abiVersion=19, data={"H\u0006)y\u0002\u000b\\1uM>\u0014Xn\u0015;bi&\u001c\u0017I\u001c8pi\u0006$\u0018n\u001c8DQ\u0016\u001c7.\u001a:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*\u0019!.\u001a;\u000b\t1\fgn\u001a\u0006\be\u0016\u001cx\u000e\u001c<f\u0015\u0019Yw\u000e\u001e7j]*\t\u0012I\u001c8pi\u0006$\u0018n\u001c8DQ\u0016\u001c7.\u001a:\u000b\rqJg.\u001b;?\u0015\u0015\u0019\u0007.Z2l\u0015-!Wm\u00197be\u0006$\u0018n\u001c8\u000b\u001d)+G\u000fR3dY\u0006\u0014\u0018\r^5p]*\u0019\u0001o]5\u000b\u0015\u0011,7o\u0019:jaR|'OC\u000bEK\u000ed\u0017M]1uS>tG)Z:de&\u0004Ho\u001c:\u000b\u0017\u0011,7o\u0019:jaR|'o\u001d\u0006\u0011I&\fwM\\8ti&\u001c\u0007j\u001c7eKJTa\u0002R5bO:|7\u000f^5d'&t7NC\u0006eS\u0006<gn\\:uS\u000e\u001c(\u0002B+oSRT\u0001c\u00195fG.$Um\u00197be\u0006$\u0018n\u001c8\u000b%I,\u0007o\u001c:u\t&\fwM\\8ti&\u001cwJ\u001c\u0006\u0010G>tG/Y5oKJ\\\u0015N\u001c3Jg*!1.\u001b8e\u0015%\u0019E.Y:t\u0017&tGMC\u0004C_>dW-\u00198\u0011\u0004)\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011QA\u0001C\u0002\u0011\u000b)!\u0001\u0002\u0002\t\u0007\u0015\u0019AQ\u0001\u0005\u0001\u0019\u0001)1\u0001\u0002\u0002\t\b1\u0001QA\u0001C\u0002\u0011\u0019)1\u0001\u0002\u0003\t\f1\u0001QA\u0001C\u0002\u0011\u001f)1\u0001B\u0003\t\u000f1\u0001QA\u0001C\u0002\u0011%)1\u0001\u0002\u0004\t\u00121\u0001Q!\u0001\u0005\u0004\u000b\r!q\u0001c\u0005\r\u0001\u0015\u0011A\u0001\u0002E\u0006\u000b\t!Q\u0001C\u0004\u0006\u0005\u00111\u0001\u0012C\u0003\u0004\t\u0015AA\u0002\u0004\u0001\u0006\u0007\u00119\u0001\u0012\u0004\u0007\u0001\u000b\t!Q\u0001\u0003\u0007\u0005\u00071\u0019\u0011DA\u0003\u0002\u0011\u000fic\u0005B\u0006\u0019\nu5A\u0001\u0001\u0005\u0006\u001b\t)\u0011\u0001#\u0003Q\u0007\u0001ij\u0001\u0002\u0001\t\u000e5\u0011Q!\u0001E\u0006!\u000e\u0005QT\u0002\u0003\u0001\u0011!i!!B\u0001\t\u000eA\u001b\u0011!\t\u0002\u0006\u0003!=\u0011kA\u0005\u0005\n%\tA\u0001A\u0007\u0002\u0011!i\u0011\u0001#\u0005\u000e\u0003!IQv\f\u0003\u00021)ij\u0001\u0002\u0001\t\u000b5\u0011Q!\u0001E\u0005!\u000e\u0001QT\u0002\u0003\u0001\u0011\u001bi!!B\u0001\t\fA\u001b\t!(\u0004\u0005\u0001!AQBA\u0003\u0002\u0011\u001b\u00016!AO\u0007\t\u0001A)\"\u0004\u0002\u0006\u0003!%\u0001ka\u0001\"\u0005\u0015\t\u0001rB)\u0004\u0017\u0011Q\u0011\"\u0001\u0003\u0001\u001b\u0005A\u0001\"D\u0001\t\u00125\t\u0001\"C\u0007\u0002\u0011!iK\u0004B\u0001\u0019\u0017u5A\u0001\u0001E\u0007\u001b\t)\u0011\u0001c\u0003Q\u0007\u0001ij\u0001\u0002\u0001\t\u00185\u0011Q!\u0001E\n!\u000e\u0005\u0011EA\u0003\u0002\u0011)\t6a\u0002\u0003\f\u0013\u0005!\t!D\u0001\t\u00125\t\u0001RC\u001b\f\u000b)!1\u001d\u0001\r\u0005C\t)\u0011\u0001C\u0002R\u0007\r!A!C\u0001\u0005\u0001\u0001"})
public final class PlatformStaticAnnotationChecker
implements KObject,
AnnotationChecker {
    public static final /* synthetic */ KClassImpl $kotlinClass;

    static {
        $kotlinClass = InternalPackage.kClassFromKotlin(PlatformStaticAnnotationChecker.class);
    }

    @Override
    public void check(@JetValueParameter(name="declaration") @NotNull JetDeclaration declaration, @JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor, @JetValueParameter(name="diagnosticHolder") @NotNull DiagnosticSink diagnosticHolder) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/resolve/kotlin/PlatformStaticAnnotationChecker", "check"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/kotlin/PlatformStaticAnnotationChecker", "check"));
        }
        if (diagnosticHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnosticHolder", "org/jetbrains/jet/lang/resolve/kotlin/PlatformStaticAnnotationChecker", "check"));
        }
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        if (AnnotationsPackage$AnnotationUtil$e04122e8.hasPlatformStaticAnnotation(descriptor)) {
            if (!(declaration instanceof JetNamedFunction) ? declaration instanceof JetProperty : true) {
                this.checkDeclaration(declaration, descriptor, diagnosticHolder, declaration);
            } else {
                diagnosticHolder.report(ErrorsJvm.PLATFORM_STATIC_ILLEGAL_USAGE.on((JetDeclaration)((PsiElement)declaration), descriptor));
            }
        }
        if (declaration instanceof JetProperty) {
            JetPropertyAccessor setter;
            JetPropertyAccessor getter = ((JetProperty)declaration).getGetter();
            if (getter != null) {
                PropertyGetterDescriptor propertyGetterDescriptor;
                DeclarationDescriptor declarationDescriptor = descriptor;
                if (declarationDescriptor == null) {
                    throw new TypeCastException("org.jetbrains.jet.lang.descriptors.DeclarationDescriptor cannot be cast to org.jetbrains.jet.lang.descriptors.PropertyDescriptor");
                }
                PropertyGetterDescriptor propertyGetterDescriptor2 = ((PropertyDescriptor)declarationDescriptor).getGetter();
                if (propertyGetterDescriptor2 == null) {
                    Intrinsics.throwNpe();
                }
                if (AnnotationsPackage$AnnotationUtil$e04122e8.hasPlatformStaticAnnotation(propertyGetterDescriptor = propertyGetterDescriptor2)) {
                    this.checkDeclaration(declaration, descriptor, diagnosticHolder, getter);
                }
            }
            if ((setter = ((JetProperty)declaration).getSetter()) != null) {
                PropertySetterDescriptor propertySetterDescriptor;
                DeclarationDescriptor declarationDescriptor = descriptor;
                if (declarationDescriptor == null) {
                    throw new TypeCastException("org.jetbrains.jet.lang.descriptors.DeclarationDescriptor cannot be cast to org.jetbrains.jet.lang.descriptors.PropertyDescriptor");
                }
                PropertySetterDescriptor propertySetterDescriptor2 = ((PropertyDescriptor)declarationDescriptor).getSetter();
                if (propertySetterDescriptor2 == null) {
                    Intrinsics.throwNpe();
                }
                if (AnnotationsPackage$AnnotationUtil$e04122e8.hasPlatformStaticAnnotation(propertySetterDescriptor = propertySetterDescriptor2)) {
                    this.checkDeclaration(declaration, descriptor, diagnosticHolder, setter);
                }
            }
        }
    }

    private final void checkDeclaration(@JetValueParameter(name="declaration") JetDeclaration declaration, @JetValueParameter(name="descriptor") DeclarationDescriptor descriptor, @JetValueParameter(name="diagnosticHolder") DiagnosticSink diagnosticHolder, @JetValueParameter(name="reportDiagnosticOn") JetDeclaration reportDiagnosticOn) {
        boolean bl;
        boolean insideObject = this.containerKindIs(descriptor, ClassKind.OBJECT);
        boolean insideClassObject = this.containerKindIs(descriptor, ClassKind.CLASS_OBJECT);
        if (!insideObject) {
            boolean bl2;
            if (insideClassObject) {
                DeclarationDescriptor declarationDescriptor = descriptor.getContainingDeclaration();
                if (declarationDescriptor == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "descriptor.getContainingDeclaration()!!");
                bl2 = this.containerKindIs(declarationDescriptor, ClassKind.CLASS);
            } else {
                bl2 = false;
            }
            bl = !bl2;
        } else {
            bl = false;
        }
        if (bl) {
            diagnosticHolder.report(ErrorsJvm.PLATFORM_STATIC_NOT_IN_OBJECT.on((JetDeclaration)((PsiElement)reportDiagnosticOn)));
        }
        if (insideObject ? declaration.hasModifier(JetTokens.OVERRIDE_KEYWORD) : false) {
            diagnosticHolder.report(ErrorsJvm.OVERRIDE_CANNOT_BE_STATIC.on((JetDeclaration)((PsiElement)reportDiagnosticOn)));
        }
    }

    private final boolean containerKindIs(@JetValueParameter(name="descriptor") DeclarationDescriptor descriptor, @JetValueParameter(name="kind") ClassKind kind) {
        DeclarationDescriptor parentDeclaration = descriptor.getContainingDeclaration();
        return parentDeclaration != null ? DescriptorUtils.isKindOf(parentDeclaration, kind) : false;
    }
}

