/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy;

import com.intellij.openapi.diagnostic.Logger;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.resolve.lazy.LazyEntity;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypesPackage;

public class ForceResolveUtil {
    private static final Logger LOG = Logger.getInstance(ForceResolveUtil.class);

    private ForceResolveUtil() {
    }

    public static <T extends DeclarationDescriptor> T forceResolveAllContents(@NotNull T descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/lazy/ForceResolveUtil", "forceResolveAllContents"));
        }
        ForceResolveUtil.doForceResolveAllContents(descriptor);
        return descriptor;
    }

    public static void forceResolveAllContents(@NotNull JetScope scope2) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/lazy/ForceResolveUtil", "forceResolveAllContents"));
        }
        ForceResolveUtil.forceResolveAllContents(scope2.getAllDescriptors());
    }

    public static void forceResolveAllContents(@NotNull Iterable<? extends DeclarationDescriptor> descriptors) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jet/lang/resolve/lazy/ForceResolveUtil", "forceResolveAllContents"));
        }
        for (DeclarationDescriptor declarationDescriptor : descriptors) {
            ForceResolveUtil.forceResolveAllContents(declarationDescriptor);
        }
    }

    public static void forceResolveAllContents(@NotNull Collection<JetType> types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/jet/lang/resolve/lazy/ForceResolveUtil", "forceResolveAllContents"));
        }
        for (JetType type2 : types) {
            ForceResolveUtil.forceResolveAllContents(type2);
        }
    }

    public static void forceResolveAllContents(@NotNull TypeConstructor typeConstructor2) {
        if (typeConstructor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeConstructor", "org/jetbrains/jet/lang/resolve/lazy/ForceResolveUtil", "forceResolveAllContents"));
        }
        ForceResolveUtil.doForceResolveAllContents(typeConstructor2);
    }

    public static void forceResolveAllContents(@NotNull Annotations annotations2) {
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/jet/lang/resolve/lazy/ForceResolveUtil", "forceResolveAllContents"));
        }
        ForceResolveUtil.doForceResolveAllContents(annotations2);
        for (AnnotationDescriptor annotation2 : annotations2) {
            ForceResolveUtil.doForceResolveAllContents(annotation2);
        }
    }

    private static void doForceResolveAllContents(Object object2) {
        if (object2 instanceof LazyEntity) {
            LazyEntity lazyEntity = (LazyEntity)object2;
            lazyEntity.forceResolveAllContents();
        } else if (object2 instanceof CallableDescriptor) {
            CallableDescriptor callableDescriptor = (CallableDescriptor)object2;
            ReceiverParameterDescriptor parameter = callableDescriptor.getExtensionReceiverParameter();
            if (parameter != null) {
                ForceResolveUtil.forceResolveAllContents(parameter.getType());
            }
            for (ValueParameterDescriptor parameterDescriptor : callableDescriptor.getValueParameters()) {
                ForceResolveUtil.forceResolveAllContents(parameterDescriptor);
            }
            for (TypeParameterDescriptor typeParameterDescriptor : callableDescriptor.getTypeParameters()) {
                ForceResolveUtil.forceResolveAllContents(typeParameterDescriptor.getUpperBounds());
            }
            ForceResolveUtil.forceResolveAllContents(callableDescriptor.getReturnType());
        }
    }

    @Nullable
    public static JetType forceResolveAllContents(@Nullable JetType type2) {
        if (type2 == null) {
            return null;
        }
        if (TypesPackage.isFlexible(type2)) {
            ForceResolveUtil.forceResolveAllContents(TypesPackage.flexibility(type2).getLowerBound());
            ForceResolveUtil.forceResolveAllContents(TypesPackage.flexibility(type2).getUpperBound());
        } else {
            ForceResolveUtil.forceResolveAllContents(type2.getConstructor());
            for (TypeProjection projection : type2.getArguments()) {
                ForceResolveUtil.forceResolveAllContents(projection.getType());
            }
        }
        return type2;
    }
}

