/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.AbstractJetType;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;

public final class JetTypeImpl
extends AbstractJetType {
    private final TypeConstructor constructor;
    private final List<? extends TypeProjection> arguments;
    private final boolean nullable;
    private final JetScope memberScope;
    private final Annotations annotations;

    public JetTypeImpl(@NotNull Annotations annotations2, @NotNull TypeConstructor constructor2, boolean nullable2, @NotNull List<? extends TypeProjection> arguments2, @NotNull JetScope memberScope2) {
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/jet/lang/types/JetTypeImpl", "<init>"));
        }
        if (constructor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/jet/lang/types/JetTypeImpl", "<init>"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/jet/lang/types/JetTypeImpl", "<init>"));
        }
        if (memberScope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberScope", "org/jetbrains/jet/lang/types/JetTypeImpl", "<init>"));
        }
        this.annotations = annotations2;
        if (memberScope2 instanceof ErrorUtils.ErrorScope) {
            throw new IllegalStateException("JetTypeImpl should not be created for error type: " + memberScope2 + "\n" + constructor2);
        }
        this.constructor = constructor2;
        this.nullable = nullable2;
        this.arguments = arguments2;
        this.memberScope = memberScope2;
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        Annotations annotations2 = this.annotations;
        if (annotations2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/JetTypeImpl", "getAnnotations"));
        }
        return annotations2;
    }

    @Override
    @NotNull
    public TypeConstructor getConstructor() {
        TypeConstructor typeConstructor2 = this.constructor;
        if (typeConstructor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/JetTypeImpl", "getConstructor"));
        }
        return typeConstructor2;
    }

    @Override
    @NotNull
    public List<TypeProjection> getArguments() {
        List<TypeProjection> list = this.arguments;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/JetTypeImpl", "getArguments"));
        }
        return list;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    @NotNull
    public JetScope getMemberScope() {
        JetScope jetScope = this.memberScope;
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/JetTypeImpl", "getMemberScope"));
        }
        return jetScope;
    }

    @Override
    public boolean isError() {
        return false;
    }
}

