/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.scopes.SubstitutingScope;
import org.jetbrains.jet.lang.types.CompositeTypeSubstitution;
import org.jetbrains.jet.lang.types.CustomTypeVariable;
import org.jetbrains.jet.lang.types.DelegatingFlexibleType;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.Flexibility;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeProjectionImpl;
import org.jetbrains.jet.lang.types.TypeSubstitution;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.TypesPackage;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lang.types.typeUtil.TypeUtilPackage;

public class TypeSubstitutor {
    public static final TypeSubstitutor EMPTY = TypeSubstitutor.create(TypeSubstitution.EMPTY);
    @NotNull
    private final TypeSubstitution substitution;

    public static TypeSubstitutor create(@NotNull TypeSubstitution substitution) {
        if (substitution == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitution", "org/jetbrains/jet/lang/types/TypeSubstitutor", "create"));
        }
        return new TypeSubstitutor(substitution);
    }

    public static TypeSubstitutor create(TypeSubstitution ... substitutions) {
        if (substitutions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutions", "org/jetbrains/jet/lang/types/TypeSubstitutor", "create"));
        }
        return TypeSubstitutor.create((TypeSubstitution)new CompositeTypeSubstitution(substitutions));
    }

    public static TypeSubstitutor create(@NotNull Map<TypeConstructor, TypeProjection> substitutionContext) {
        if (substitutionContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutionContext", "org/jetbrains/jet/lang/types/TypeSubstitutor", "create"));
        }
        return TypeSubstitutor.create((TypeSubstitution)new MapToTypeSubstitutionAdapter(substitutionContext));
    }

    public static TypeSubstitutor create(@NotNull JetType context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/TypeSubstitutor", "create"));
        }
        return TypeSubstitutor.create(TypeSubstitutor.buildSubstitutionContext(context2.getConstructor().getParameters(), context2.getArguments()));
    }

    @NotNull
    public static Map<TypeConstructor, TypeProjection> buildSubstitutionContext(@NotNull List<TypeParameterDescriptor> parameters2, @NotNull List<? extends TypeProjection> contextArguments) {
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/jet/lang/types/TypeSubstitutor", "buildSubstitutionContext"));
        }
        if (contextArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextArguments", "org/jetbrains/jet/lang/types/TypeSubstitutor", "buildSubstitutionContext"));
        }
        HashMap<TypeConstructor, TypeProjection> parameterValues = new HashMap<TypeConstructor, TypeProjection>();
        if (parameters2.size() != contextArguments.size()) {
            throw new IllegalArgumentException("type parameter count != context arguments: \nparameters=" + parameters2 + "\n" + "contextArgs=" + contextArguments);
        }
        int size = parameters2.size();
        for (int i = 0; i < size; ++i) {
            parameterValues.put(parameters2.get(i).getTypeConstructor(), contextArguments.get(i));
        }
        HashMap<TypeConstructor, TypeProjection> hashMap = parameterValues;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeSubstitutor", "buildSubstitutionContext"));
        }
        return hashMap;
    }

    protected TypeSubstitutor(@NotNull TypeSubstitution substitution) {
        if (substitution == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitution", "org/jetbrains/jet/lang/types/TypeSubstitutor", "<init>"));
        }
        this.substitution = substitution;
    }

    public boolean inRange(@NotNull TypeConstructor typeConstructor2) {
        if (typeConstructor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeConstructor", "org/jetbrains/jet/lang/types/TypeSubstitutor", "inRange"));
        }
        return this.substitution.get(typeConstructor2) != null;
    }

    public boolean isEmpty() {
        return this.substitution.isEmpty();
    }

    @NotNull
    public TypeSubstitution getSubstitution() {
        TypeSubstitution typeSubstitution = this.substitution;
        if (typeSubstitution == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeSubstitutor", "getSubstitution"));
        }
        return typeSubstitution;
    }

    @NotNull
    public JetType safeSubstitute(@NotNull JetType type2, @NotNull Variance howThisTypeIsUsed) {
        JetType jetType;
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/TypeSubstitutor", "safeSubstitute"));
        }
        if (howThisTypeIsUsed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "howThisTypeIsUsed", "org/jetbrains/jet/lang/types/TypeSubstitutor", "safeSubstitute"));
        }
        if (this.isEmpty()) {
            JetType jetType2 = type2;
            if (jetType2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeSubstitutor", "safeSubstitute"));
            }
            return jetType2;
        }
        try {
            jetType = this.unsafeSubstitute(new TypeProjectionImpl(howThisTypeIsUsed, type2), 0).getType();
        }
        catch (SubstitutionException e) {
            JetType jetType3 = ErrorUtils.createErrorType(e.getMessage());
            if (jetType3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeSubstitutor", "safeSubstitute"));
            }
            return jetType3;
        }
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeSubstitutor", "safeSubstitute"));
        }
        return jetType;
    }

    @Nullable
    public JetType substitute(@NotNull JetType type2, @NotNull Variance howThisTypeIsUsed) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/TypeSubstitutor", "substitute"));
        }
        if (howThisTypeIsUsed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "howThisTypeIsUsed", "org/jetbrains/jet/lang/types/TypeSubstitutor", "substitute"));
        }
        TypeProjection projection = this.substitute(new TypeProjectionImpl(howThisTypeIsUsed, type2));
        return projection == null ? null : projection.getType();
    }

    @Nullable
    public TypeProjection substitute(@NotNull TypeProjection typeProjection) {
        if (typeProjection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeProjection", "org/jetbrains/jet/lang/types/TypeSubstitutor", "substitute"));
        }
        if (this.isEmpty()) {
            return typeProjection;
        }
        try {
            return this.unsafeSubstitute(typeProjection, 0);
        }
        catch (SubstitutionException e) {
            return null;
        }
    }

    @NotNull
    private TypeProjection unsafeSubstitute(@NotNull TypeProjection originalProjection, int recursionDepth) throws SubstitutionException {
        if (originalProjection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalProjection", "org/jetbrains/jet/lang/types/TypeSubstitutor", "unsafeSubstitute"));
        }
        TypeSubstitutor.assertRecursionDepth(recursionDepth, originalProjection, this.substitution);
        JetType type2 = originalProjection.getType();
        Variance originalProjectionKind = originalProjection.getProjectionKind();
        if (TypesPackage.isFlexible(type2) && !TypesPackage.isCustomTypeVariable(type2)) {
            Flexibility flexibility = TypesPackage.flexibility(type2);
            TypeProjection substitutedLower = this.unsafeSubstitute(new TypeProjectionImpl(originalProjectionKind, flexibility.getLowerBound()), recursionDepth + 1);
            TypeProjection substitutedUpper = this.unsafeSubstitute(new TypeProjectionImpl(originalProjectionKind, flexibility.getUpperBound()), recursionDepth + 1);
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(originalProjectionKind, DelegatingFlexibleType.create(substitutedLower.getType(), substitutedUpper.getType(), flexibility.getExtraCapabilities()));
            if (typeProjectionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeSubstitutor", "unsafeSubstitute"));
            }
            return typeProjectionImpl;
        }
        if (KotlinBuiltIns.getInstance().isNothing(type2) || type2.isError()) {
            TypeProjection typeProjection = originalProjection;
            if (typeProjection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeSubstitutor", "unsafeSubstitute"));
            }
            return typeProjection;
        }
        TypeProjection replacement = this.substitution.get(type2.getConstructor());
        if (replacement != null) {
            TypeParameterDescriptor typeParameter = (TypeParameterDescriptor)type2.getConstructor().getDeclarationDescriptor();
            switch (TypeSubstitutor.conflictType(originalProjectionKind, replacement.getProjectionKind())) {
                case OUT_IN_IN_POSITION: {
                    throw new SubstitutionException("Out-projection in in-position");
                }
                case IN_IN_OUT_POSITION: {
                    TypeProjection typeProjection = TypeUtils.makeStarProjection(typeParameter);
                    if (typeProjection == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeSubstitutor", "unsafeSubstitute"));
                    }
                    return typeProjection;
                }
                case NO_CONFLICT: {
                    CustomTypeVariable typeVariable = TypesPackage.getCustomTypeVariable(type2);
                    JetType substitutedType = typeVariable != null ? typeVariable.substitutionResult(replacement.getType()) : (type2.isNullable() ? TypeUtils.makeNullable(replacement.getType()) : replacement.getType());
                    Variance resultingProjectionKind = TypeSubstitutor.combine(originalProjectionKind, replacement.getProjectionKind());
                    TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(resultingProjectionKind, substitutedType);
                    if (typeProjectionImpl == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeSubstitutor", "unsafeSubstitute"));
                    }
                    return typeProjectionImpl;
                }
            }
            throw new IllegalStateException();
        }
        TypeProjection typeProjection = this.substituteCompoundType(type2, originalProjectionKind, recursionDepth);
        if (typeProjection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeSubstitutor", "unsafeSubstitute"));
        }
        return typeProjection;
    }

    private TypeProjection substituteCompoundType(final JetType type2, Variance projectionKind, int recursionDepth) throws SubstitutionException {
        List<TypeProjection> substitutedArguments = this.substituteTypeArguments(type2.getConstructor().getParameters(), type2.getArguments(), recursionDepth);
        TypeSubstitution substitutionFilteringTypeParameters = new TypeSubstitution(){
            private final Collection<TypeConstructor> containedOrCapturedTypeParameters;
            {
                this.containedOrCapturedTypeParameters = TypeUtilPackage.getContainedAndCapturedTypeParameterConstructors(type2);
            }

            @Override
            @Nullable
            public TypeProjection get(TypeConstructor key) {
                return this.containedOrCapturedTypeParameters.contains(key) ? TypeSubstitutor.this.substitution.get(key) : null;
            }

            @Override
            public boolean isEmpty() {
                return TypeSubstitutor.this.substitution.isEmpty();
            }
        };
        JetTypeImpl substitutedType = new JetTypeImpl(type2.getAnnotations(), type2.getConstructor(), type2.isNullable(), substitutedArguments, new SubstitutingScope(type2.getMemberScope(), TypeSubstitutor.create(substitutionFilteringTypeParameters)));
        return new TypeProjectionImpl(projectionKind, substitutedType);
    }

    private List<TypeProjection> substituteTypeArguments(List<TypeParameterDescriptor> typeParameters, List<TypeProjection> typeArguments, int recursionDepth) throws SubstitutionException {
        ArrayList<TypeProjection> substitutedArguments = new ArrayList<TypeProjection>(typeParameters.size());
        for (int i = 0; i < typeParameters.size(); ++i) {
            TypeParameterDescriptor typeParameter = typeParameters.get(i);
            TypeProjection typeArgument = typeArguments.get(i);
            TypeProjection substitutedTypeArgument = this.unsafeSubstitute(typeArgument, recursionDepth + 1);
            switch (TypeSubstitutor.conflictType(typeParameter.getVariance(), substitutedTypeArgument.getProjectionKind())) {
                case NO_CONFLICT: {
                    if (typeParameter.getVariance() == Variance.INVARIANT) break;
                    substitutedTypeArgument = new TypeProjectionImpl(Variance.INVARIANT, substitutedTypeArgument.getType());
                    break;
                }
                case OUT_IN_IN_POSITION: 
                case IN_IN_OUT_POSITION: {
                    substitutedTypeArgument = TypeUtils.makeStarProjection(typeParameter);
                }
            }
            substitutedArguments.add(substitutedTypeArgument);
        }
        return substitutedArguments;
    }

    private static Variance combine(Variance typeParameterVariance, Variance projectionKind) {
        if (typeParameterVariance == Variance.INVARIANT) {
            return projectionKind;
        }
        if (projectionKind == Variance.INVARIANT) {
            return typeParameterVariance;
        }
        if (typeParameterVariance == projectionKind) {
            return projectionKind;
        }
        return Variance.IN_VARIANCE;
    }

    private static VarianceConflictType conflictType(Variance position, Variance argument) {
        if (position == Variance.IN_VARIANCE && argument == Variance.OUT_VARIANCE) {
            return VarianceConflictType.OUT_IN_IN_POSITION;
        }
        if (position == Variance.OUT_VARIANCE && argument == Variance.IN_VARIANCE) {
            return VarianceConflictType.IN_IN_OUT_POSITION;
        }
        return VarianceConflictType.NO_CONFLICT;
    }

    private static void assertRecursionDepth(int recursionDepth, TypeProjection projection, TypeSubstitution substitution) {
        if (recursionDepth > 100) {
            throw new IllegalStateException("Recursion too deep. Most likely infinite loop while substituting " + TypeSubstitutor.safeToString(projection) + "; substitution: " + TypeSubstitutor.safeToString(substitution));
        }
    }

    private static String safeToString(Object o) {
        try {
            return o.toString();
        }
        catch (Throwable e) {
            if (e.getClass().getName().equals("com.intellij.openapi.progress.ProcessCanceledException")) {
                throw (RuntimeException)e;
            }
            return "[Exception while computing toString(): " + e + "]";
        }
    }

    private static enum VarianceConflictType {
        NO_CONFLICT,
        IN_IN_OUT_POSITION,
        OUT_IN_IN_POSITION;

    }

    private static final class SubstitutionException
    extends Exception {
        public SubstitutionException(String message) {
            super(message);
        }
    }

    public static class MapToTypeSubstitutionAdapter
    implements TypeSubstitution {
        @NotNull
        private final Map<TypeConstructor, TypeProjection> substitutionContext;

        public MapToTypeSubstitutionAdapter(@NotNull Map<TypeConstructor, TypeProjection> substitutionContext) {
            if (substitutionContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutionContext", "org/jetbrains/jet/lang/types/TypeSubstitutor$MapToTypeSubstitutionAdapter", "<init>"));
            }
            this.substitutionContext = substitutionContext;
        }

        @Override
        public TypeProjection get(TypeConstructor key) {
            return this.substitutionContext.get(key);
        }

        @Override
        public boolean isEmpty() {
            return this.substitutionContext.isEmpty();
        }

        public String toString() {
            return this.substitutionContext.toString();
        }
    }
}

