/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import com.google.common.collect.Sets;
import com.intellij.psi.tree.IElementType;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetAnnotatedExpression;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDoWhileExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.jet.lang.psi.JetIfExpression;
import org.jetbrains.jet.lang.psi.JetLabeledExpression;
import org.jetbrains.jet.lang.psi.JetMultiDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetTypedef;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.jet.lang.psi.JetWhileExpression;
import org.jetbrains.jet.lang.resolve.AnnotationResolver;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.FunctionDescriptorUtil;
import org.jetbrains.jet.lang.resolve.ModifiersChecker;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.calls.context.ContextDependency;
import org.jetbrains.jet.lang.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResultsUtil;
import org.jetbrains.jet.lang.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeInfo;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.BasicExpressionTypingVisitor;
import org.jetbrains.jet.lang.types.expressions.ControlStructureTypingVisitor;
import org.jetbrains.jet.lang.types.expressions.DataFlowUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingInternals;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.jet.lang.types.expressions.LocalClassifierAnalyzer;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lang.types.expressions.PatternMatchingTypingVisitor;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetTokens;

public class ExpressionTypingVisitorForStatements
extends ExpressionTypingVisitor {
    private final WritableScope scope;
    private final BasicExpressionTypingVisitor basic;
    private final ControlStructureTypingVisitor controlStructures;
    private final PatternMatchingTypingVisitor patterns;

    public ExpressionTypingVisitorForStatements(@NotNull ExpressionTypingInternals facade, @NotNull WritableScope scope2, BasicExpressionTypingVisitor basic, @NotNull ControlStructureTypingVisitor controlStructures, @NotNull PatternMatchingTypingVisitor patterns) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorForStatements", "<init>"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorForStatements", "<init>"));
        }
        if (controlStructures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controlStructures", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorForStatements", "<init>"));
        }
        if (patterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorForStatements", "<init>"));
        }
        super(facade);
        this.scope = scope2;
        this.basic = basic;
        this.controlStructures = controlStructures;
        this.patterns = patterns;
    }

    @Nullable
    private static JetType checkAssignmentType(@Nullable JetType assignmentType, @NotNull JetBinaryExpression expression, @NotNull ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorForStatements", "checkAssignmentType"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorForStatements", "checkAssignmentType"));
        }
        if (assignmentType != null && !KotlinBuiltIns.getInstance().isUnit(assignmentType) && !TypeUtils.noExpectedType(context2.expectedType) && TypeUtils.equalTypes(context2.expectedType, assignmentType)) {
            context2.trace.report(Errors.ASSIGNMENT_TYPE_MISMATCH.on(expression, context2.expectedType));
            return null;
        }
        return DataFlowUtils.checkStatementType(expression, context2);
    }

    @Override
    public JetTypeInfo visitObjectDeclaration(@NotNull JetObjectDeclaration declaration, ExpressionTypingContext context2) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorForStatements", "visitObjectDeclaration"));
        }
        LocalClassifierAnalyzer.processClassOrObject(this.components.globalContext, this.scope, (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceScope(this.scope)).replaceContextDependency(ContextDependency.INDEPENDENT), this.scope.getContainingDeclaration(), declaration, this.components.additionalCheckerProvider);
        return DataFlowUtils.checkStatementType(declaration, context2, context2.dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitProperty(@NotNull JetProperty property2, ExpressionTypingContext typingContext) {
        JetExpression delegateExpression;
        JetPropertyAccessor setter;
        JetPropertyAccessor getter;
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorForStatements", "visitProperty"));
        }
        ExpressionTypingContext context2 = (ExpressionTypingContext)((ExpressionTypingContext)typingContext.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceScope(this.scope);
        JetTypeReference receiverTypeRef = property2.getReceiverTypeReference();
        if (receiverTypeRef != null) {
            context2.trace.report(Errors.LOCAL_EXTENSION_PROPERTY.on(receiverTypeRef));
        }
        if ((getter = property2.getGetter()) != null) {
            context2.trace.report(Errors.LOCAL_VARIABLE_WITH_GETTER.on(getter));
        }
        if ((setter = property2.getSetter()) != null) {
            context2.trace.report(Errors.LOCAL_VARIABLE_WITH_SETTER.on(setter));
        }
        if ((delegateExpression = property2.getDelegateExpression()) != null) {
            this.components.expressionTypingServices.getTypeInfo(delegateExpression, context2);
            context2.trace.report(Errors.LOCAL_VARIABLE_WITH_DELEGATE.on(property2.getDelegate()));
        }
        for (JetTypeParameter typeParameter : property2.getTypeParameters()) {
            AnnotationResolver.reportUnsupportedAnnotationForTypeParameter(typeParameter, context2.trace);
        }
        VariableDescriptor propertyDescriptor = this.components.expressionTypingServices.getDescriptorResolver().resolveLocalVariableDescriptor(this.scope, property2, context2.dataFlowInfo, context2.trace);
        JetExpression initializer = property2.getInitializer();
        DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
        if (initializer != null) {
            JetType outType = propertyDescriptor.getType();
            JetTypeInfo typeInfo = this.facade.getTypeInfo(initializer, (ExpressionTypingContext)context2.replaceExpectedType(outType));
            dataFlowInfo = typeInfo.getDataFlowInfo();
        }
        VariableDescriptor olderVariable = this.scope.getLocalVariable(propertyDescriptor.getName());
        ExpressionTypingUtils.checkVariableShadowing(context2, propertyDescriptor, olderVariable);
        this.scope.addVariableDescriptor(propertyDescriptor);
        ModifiersChecker.create(context2.trace, this.components.additionalCheckerProvider).checkModifiersForLocalDeclaration(property2, propertyDescriptor);
        return DataFlowUtils.checkStatementType(property2, context2, dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitMultiDeclaration(@NotNull JetMultiDeclaration multiDeclaration, ExpressionTypingContext context2) {
        if (multiDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multiDeclaration", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorForStatements", "visitMultiDeclaration"));
        }
        this.components.expressionTypingServices.getAnnotationResolver().resolveAnnotationsWithArguments((JetScope)this.scope, multiDeclaration.getModifierList(), context2.trace);
        JetExpression initializer = multiDeclaration.getInitializer();
        if (initializer == null) {
            context2.trace.report(Errors.INITIALIZER_REQUIRED_FOR_MULTIDECLARATION.on(multiDeclaration));
            return JetTypeInfo.create(null, context2.dataFlowInfo);
        }
        ExpressionReceiver expressionReceiver = ExpressionTypingUtils.getExpressionReceiver(this.facade, initializer, (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT));
        DataFlowInfo dataFlowInfo = this.facade.getTypeInfo(initializer, context2).getDataFlowInfo();
        if (expressionReceiver == null) {
            return JetTypeInfo.create(null, dataFlowInfo);
        }
        this.components.expressionTypingUtils.defineLocalVariablesFromMultiDeclaration(this.scope, multiDeclaration, expressionReceiver, initializer, context2);
        return DataFlowUtils.checkStatementType(multiDeclaration, context2, dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitNamedFunction(@NotNull JetNamedFunction function, ExpressionTypingContext context2) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorForStatements", "visitNamedFunction"));
        }
        SimpleFunctionDescriptor functionDescriptor = this.components.expressionTypingServices.getDescriptorResolver().resolveFunctionDescriptorWithAnnotationArguments(this.scope.getContainingDeclaration(), this.scope, function, context2.trace, context2.dataFlowInfo);
        this.scope.addFunctionDescriptor(functionDescriptor);
        JetScope functionInnerScope = FunctionDescriptorUtil.getFunctionInnerScope(context2.scope, functionDescriptor, context2.trace);
        this.components.expressionTypingServices.checkFunctionReturnType(functionInnerScope, function, functionDescriptor, context2.dataFlowInfo, null, context2.trace);
        this.components.expressionTypingServices.resolveValueParameters(function.getValueParameters(), functionDescriptor.getValueParameters(), this.scope, context2.dataFlowInfo, context2.trace, true);
        ModifiersChecker.create(context2.trace, this.components.additionalCheckerProvider).checkModifiersForLocalDeclaration(function, functionDescriptor);
        if (!function.hasBody()) {
            context2.trace.report(Errors.NON_MEMBER_FUNCTION_NO_BODY.on(function, functionDescriptor));
        }
        return DataFlowUtils.checkStatementType(function, context2, context2.dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitClass(@NotNull JetClass klass, ExpressionTypingContext context2) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorForStatements", "visitClass"));
        }
        LocalClassifierAnalyzer.processClassOrObject(this.components.globalContext, this.scope, (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceScope(this.scope)).replaceContextDependency(ContextDependency.INDEPENDENT), this.scope.getContainingDeclaration(), klass, this.components.additionalCheckerProvider);
        return DataFlowUtils.checkStatementType(klass, context2, context2.dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitTypedef(@NotNull JetTypedef typedef, ExpressionTypingContext context2) {
        if (typedef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typedef", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorForStatements", "visitTypedef"));
        }
        context2.trace.report(Errors.UNSUPPORTED.on(typedef, "Typedefs are not supported"));
        return (JetTypeInfo)super.visitTypedef(typedef, context2);
    }

    @Override
    public JetTypeInfo visitDeclaration(@NotNull JetDeclaration dcl, ExpressionTypingContext context2) {
        if (dcl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dcl", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorForStatements", "visitDeclaration"));
        }
        return DataFlowUtils.checkStatementType(dcl, context2, context2.dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitBinaryExpression(@NotNull JetBinaryExpression expression, ExpressionTypingContext context2) {
        JetTypeInfo result2;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorForStatements", "visitBinaryExpression"));
        }
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType == JetTokens.EQ) {
            result2 = this.visitAssignment(expression, context2);
        } else if (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(operationType)) {
            result2 = this.visitAssignmentOperation(expression, context2);
        } else {
            return this.facade.getTypeInfo(expression, context2);
        }
        return DataFlowUtils.checkType(result2.getType(), expression, context2, result2.getDataFlowInfo());
    }

    @NotNull
    protected JetTypeInfo visitAssignmentOperation(JetBinaryExpression expression, ExpressionTypingContext contextWithExpectedType) {
        JetType type2;
        JetExpression left;
        TemporaryTraceAndCache temporary = TemporaryTraceAndCache.create(contextWithExpectedType, "trace to resolve array set method for binary expression", expression);
        ExpressionTypingContext context2 = (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceTraceAndCache(temporary)).replaceContextDependency(ContextDependency.INDEPENDENT);
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        IElementType operationType = operationSign.getReferencedNameElementType();
        JetExpression leftOperand = expression.getLeft();
        JetTypeInfo leftInfo = ExpressionTypingUtils.getTypeInfoOrNullType(leftOperand, context2, this.facade);
        JetType leftType = leftInfo.getType();
        DataFlowInfo dataFlowInfo = leftInfo.getDataFlowInfo();
        JetExpression right = expression.getRight();
        JetExpression jetExpression = left = leftOperand == null ? null : JetPsiUtil.deparenthesize(leftOperand);
        if (right == null || left == null) {
            temporary.commit();
            JetTypeInfo jetTypeInfo = JetTypeInfo.create(null, dataFlowInfo);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorForStatements", "visitAssignmentOperation"));
            }
            return jetTypeInfo;
        }
        if (leftType == null) {
            dataFlowInfo = this.facade.getTypeInfo(right, (ExpressionTypingContext)context2.replaceDataFlowInfo(dataFlowInfo)).getDataFlowInfo();
            context2.trace.report(Errors.UNRESOLVED_REFERENCE.on(operationSign, operationSign));
            temporary.commit();
            JetTypeInfo jetTypeInfo = JetTypeInfo.create(null, dataFlowInfo);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorForStatements", "visitAssignmentOperation"));
            }
            return jetTypeInfo;
        }
        ExpressionReceiver receiver = new ExpressionReceiver(left, leftType);
        Name name = (Name)OperatorConventions.ASSIGNMENT_OPERATIONS.get(operationType);
        TemporaryTraceAndCache temporaryForAssignmentOperation = TemporaryTraceAndCache.create(context2, "trace to check assignment operation like '+=' for", expression);
        OverloadResolutionResults<FunctionDescriptor> assignmentOperationDescriptors = this.components.callResolver.resolveBinaryCall((ExpressionTypingContext)((ExpressionTypingContext)context2.replaceTraceAndCache(temporaryForAssignmentOperation)).replaceScope(this.scope), receiver, expression, name);
        JetType assignmentOperationType = OverloadResolutionResultsUtil.getResultingType(assignmentOperationDescriptors, context2.contextDependency);
        Name counterpartName = (Name)OperatorConventions.BINARY_OPERATION_NAMES.get(OperatorConventions.ASSIGNMENT_OPERATION_COUNTERPARTS.get(operationType));
        TemporaryTraceAndCache temporaryForBinaryOperation = TemporaryTraceAndCache.create(context2, "trace to check binary operation like '+' for", expression);
        OverloadResolutionResults<FunctionDescriptor> binaryOperationDescriptors = this.components.callResolver.resolveBinaryCall((ExpressionTypingContext)((ExpressionTypingContext)context2.replaceTraceAndCache(temporaryForBinaryOperation)).replaceScope(this.scope), receiver, expression, counterpartName);
        JetType binaryOperationType = OverloadResolutionResultsUtil.getResultingType(binaryOperationDescriptors, context2.contextDependency);
        JetType jetType = type2 = assignmentOperationType != null ? assignmentOperationType : binaryOperationType;
        if (assignmentOperationDescriptors.isSuccess() && binaryOperationDescriptors.isSuccess()) {
            OverloadResolutionResults<FunctionDescriptor> ambiguityResolutionResults = OverloadResolutionResultsUtil.ambiguity(assignmentOperationDescriptors, binaryOperationDescriptors);
            context2.trace.report(Errors.ASSIGN_OPERATOR_AMBIGUITY.on(operationSign, ambiguityResolutionResults.getResultingCalls()));
            HashSet<FunctionDescriptor> descriptors = Sets.newHashSet();
            for (ResolvedCall<FunctionDescriptor> resolvedCall : ambiguityResolutionResults.getResultingCalls()) {
                descriptors.add(resolvedCall.getResultingDescriptor());
            }
            dataFlowInfo = this.facade.getTypeInfo(right, (ExpressionTypingContext)context2.replaceDataFlowInfo(dataFlowInfo)).getDataFlowInfo();
            context2.trace.record(BindingContext.AMBIGUOUS_REFERENCE_TARGET, operationSign, descriptors);
        } else if (assignmentOperationType != null && (assignmentOperationDescriptors.isSuccess() || !binaryOperationDescriptors.isSuccess())) {
            temporaryForAssignmentOperation.commit();
            if (!KotlinBuiltIns.getInstance().isUnit(assignmentOperationType)) {
                context2.trace.report(Errors.ASSIGNMENT_OPERATOR_SHOULD_RETURN_UNIT.on(operationSign, assignmentOperationDescriptors.getResultingDescriptor(), operationSign));
            }
        } else {
            temporaryForBinaryOperation.commit();
            context2.trace.record(BindingContext.VARIABLE_REASSIGNMENT, expression);
            if (left instanceof JetArrayAccessExpression) {
                ExpressionTypingContext contextForResolve = (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceScope(this.scope)).replaceBindingTrace(TemporaryBindingTrace.create(context2.trace, "trace to resolve array set method for assignment", expression));
                this.basic.resolveArrayAccessSetMethod((JetArrayAccessExpression)left, right, contextForResolve, context2.trace);
            }
            dataFlowInfo = this.facade.getTypeInfo(right, (ExpressionTypingContext)context2.replaceDataFlowInfo(dataFlowInfo)).getDataFlowInfo();
            DataFlowUtils.checkType(binaryOperationType, expression, leftType, dataFlowInfo, context2.trace);
            BasicExpressionTypingVisitor.checkLValue(context2.trace, leftOperand);
        }
        temporary.commit();
        JetTypeInfo jetTypeInfo = JetTypeInfo.create(ExpressionTypingVisitorForStatements.checkAssignmentType(type2, expression, contextWithExpectedType), dataFlowInfo);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorForStatements", "visitAssignmentOperation"));
        }
        return jetTypeInfo;
    }

    @NotNull
    protected JetTypeInfo visitAssignment(JetBinaryExpression expression, ExpressionTypingContext contextWithExpectedType) {
        ExpressionTypingContext context2 = (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceScope(this.scope)).replaceContextDependency(ContextDependency.INDEPENDENT);
        JetExpression leftOperand = expression.getLeft();
        JetExpression left = this.components.expressionTypingServices.deparenthesizeWithTypeResolution(leftOperand, context2);
        JetExpression right = expression.getRight();
        if (left instanceof JetArrayAccessExpression) {
            JetArrayAccessExpression arrayAccessExpression = (JetArrayAccessExpression)left;
            if (right == null) {
                JetTypeInfo jetTypeInfo = JetTypeInfo.create(null, context2.dataFlowInfo);
                if (jetTypeInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorForStatements", "visitAssignment"));
                }
                return jetTypeInfo;
            }
            JetTypeInfo typeInfo = this.basic.resolveArrayAccessSetMethod(arrayAccessExpression, right, context2, context2.trace);
            BasicExpressionTypingVisitor.checkLValue(context2.trace, arrayAccessExpression);
            JetTypeInfo jetTypeInfo = JetTypeInfo.create(ExpressionTypingVisitorForStatements.checkAssignmentType(typeInfo.getType(), expression, contextWithExpectedType), typeInfo.getDataFlowInfo());
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorForStatements", "visitAssignment"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo leftInfo = ExpressionTypingUtils.getTypeInfoOrNullType(left, context2, this.facade);
        JetType leftType = leftInfo.getType();
        DataFlowInfo dataFlowInfo = leftInfo.getDataFlowInfo();
        if (right != null) {
            JetTypeInfo rightInfo = this.facade.getTypeInfo(right, (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceDataFlowInfo(dataFlowInfo)).replaceExpectedType(leftType));
            dataFlowInfo = rightInfo.getDataFlowInfo();
        }
        if (leftType != null && leftOperand != null) {
            BasicExpressionTypingVisitor.checkLValue(context2.trace, leftOperand);
        }
        JetTypeInfo jetTypeInfo = DataFlowUtils.checkStatementType(expression, contextWithExpectedType, dataFlowInfo);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorForStatements", "visitAssignment"));
        }
        return jetTypeInfo;
    }

    @Override
    public JetTypeInfo visitExpression(@NotNull JetExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorForStatements", "visitExpression"));
        }
        return this.facade.getTypeInfo(expression, context2);
    }

    @Override
    public JetTypeInfo visitJetElement(@NotNull JetElement element, ExpressionTypingContext context2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorForStatements", "visitJetElement"));
        }
        context2.trace.report(Errors.UNSUPPORTED.on(element, "in a block"));
        return JetTypeInfo.create(null, context2.dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitWhileExpression(@NotNull JetWhileExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorForStatements", "visitWhileExpression"));
        }
        return this.controlStructures.visitWhileExpression(expression, context2, true);
    }

    @Override
    public JetTypeInfo visitDoWhileExpression(@NotNull JetDoWhileExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorForStatements", "visitDoWhileExpression"));
        }
        return this.controlStructures.visitDoWhileExpression(expression, context2, true);
    }

    @Override
    public JetTypeInfo visitForExpression(@NotNull JetForExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorForStatements", "visitForExpression"));
        }
        return this.controlStructures.visitForExpression(expression, context2, true);
    }

    @Override
    public JetTypeInfo visitAnnotatedExpression(@NotNull JetAnnotatedExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorForStatements", "visitAnnotatedExpression"));
        }
        return this.basic.visitAnnotatedExpression(expression, data2, true);
    }

    @Override
    public JetTypeInfo visitIfExpression(@NotNull JetIfExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorForStatements", "visitIfExpression"));
        }
        return this.controlStructures.visitIfExpression(expression, context2, true);
    }

    @Override
    public JetTypeInfo visitWhenExpression(@NotNull JetWhenExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorForStatements", "visitWhenExpression"));
        }
        return this.patterns.visitWhenExpression(expression, context2, true);
    }

    @Override
    public JetTypeInfo visitBlockExpression(@NotNull JetBlockExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorForStatements", "visitBlockExpression"));
        }
        return this.components.expressionTypingServices.getBlockReturnedType(expression, context2, true);
    }

    @Override
    public JetTypeInfo visitParenthesizedExpression(@NotNull JetParenthesizedExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorForStatements", "visitParenthesizedExpression"));
        }
        return this.basic.visitParenthesizedExpression(expression, context2, true);
    }

    @Override
    public JetTypeInfo visitLabeledExpression(@NotNull JetLabeledExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorForStatements", "visitLabeledExpression"));
        }
        return this.basic.visitLabeledExpression(expression, context2, true);
    }
}

