/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.reference.CachedAccessTranslator;
import org.jetbrains.k2js.translate.reference.ReferenceTranslator;
import org.jetbrains.k2js.translate.utils.AnnotationsUtils;
import org.jetbrains.k2js.translate.utils.BindingUtils;

public class ClassObjectAccessTranslator
extends AbstractTranslator
implements CachedAccessTranslator {
    @NotNull
    private final JsExpression referenceToClassObject;

    @NotNull
    static ClassObjectAccessTranslator newInstance(@NotNull JetSimpleNameExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/reference/ClassObjectAccessTranslator", "newInstance"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/ClassObjectAccessTranslator", "newInstance"));
        }
        DeclarationDescriptor referenceDescriptor = BindingUtils.getDescriptorForReferenceExpression(context2.bindingContext(), expression);
        assert (referenceDescriptor != null) : "JetSimpleName expression must reference a descriptor " + expression.getText();
        ClassObjectAccessTranslator classObjectAccessTranslator = new ClassObjectAccessTranslator(referenceDescriptor, context2);
        if (classObjectAccessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/ClassObjectAccessTranslator", "newInstance"));
        }
        return classObjectAccessTranslator;
    }

    static boolean isClassObjectReference(@NotNull JetReferenceExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/reference/ClassObjectAccessTranslator", "isClassObjectReference"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/ClassObjectAccessTranslator", "isClassObjectReference"));
        }
        DeclarationDescriptor descriptor = BindingUtils.getDescriptorForReferenceExpression(context2.bindingContext(), expression);
        return descriptor instanceof ClassDescriptor && !AnnotationsUtils.isNativeObject(descriptor);
    }

    private ClassObjectAccessTranslator(@NotNull DeclarationDescriptor descriptor, @NotNull TranslationContext context2) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/reference/ClassObjectAccessTranslator", "<init>"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/ClassObjectAccessTranslator", "<init>"));
        }
        super(context2);
        JsExpression fqReference = ReferenceTranslator.translateAsFQReference(descriptor, this.context());
        this.referenceToClassObject = DescriptorUtils.isObject(descriptor) || DescriptorUtils.isEnumEntry(descriptor) ? fqReference : Namer.getClassObjectAccessor(fqReference);
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        JsExpression jsExpression = this.referenceToClassObject;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/ClassObjectAccessTranslator", "translateAsGet"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression toSetTo) {
        if (toSetTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toSetTo", "org/jetbrains/k2js/translate/reference/ClassObjectAccessTranslator", "translateAsSet"));
        }
        throw new IllegalStateException("Class object can't set");
    }

    @Override
    @NotNull
    public CachedAccessTranslator getCached() {
        ClassObjectAccessTranslator classObjectAccessTranslator = this;
        if (classObjectAccessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/ClassObjectAccessTranslator", "getCached"));
        }
        return classObjectAccessTranslator;
    }

    @Override
    @NotNull
    public List<TemporaryVariable> declaredTemporaries() {
        List<TemporaryVariable> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/ClassObjectAccessTranslator", "declaredTemporaries"));
        }
        return list;
    }
}

