/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils;

import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.k2js.PredefinedAnnotation;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;

public final class AnnotationsUtils {
    private AnnotationsUtils() {
    }

    private static boolean hasAnnotation(@NotNull DeclarationDescriptor descriptor, @NotNull PredefinedAnnotation annotation2) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "hasAnnotation"));
        }
        if (annotation2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "hasAnnotation"));
        }
        return AnnotationsUtils.getAnnotationByName(descriptor, annotation2) != null;
    }

    @Nullable
    private static String getAnnotationStringParameter(@NotNull DeclarationDescriptor declarationDescriptor, @NotNull PredefinedAnnotation annotation2) {
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "getAnnotationStringParameter"));
        }
        if (annotation2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "getAnnotationStringParameter"));
        }
        AnnotationDescriptor annotationDescriptor = AnnotationsUtils.getAnnotationByName(declarationDescriptor, annotation2);
        assert (annotationDescriptor != null);
        if (annotationDescriptor.getAllValueArguments().isEmpty()) {
            return null;
        }
        CompileTimeConstant<?> constant = annotationDescriptor.getAllValueArguments().values().iterator().next();
        if (constant == null) {
            return null;
        }
        Object value = constant.getValue();
        assert (value instanceof String) : "Native function annotation should have one String parameter";
        return (String)value;
    }

    @Nullable
    public static String getNameForAnnotatedObject(@NotNull DeclarationDescriptor declarationDescriptor, @NotNull PredefinedAnnotation annotation2) {
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "getNameForAnnotatedObject"));
        }
        if (annotation2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "getNameForAnnotatedObject"));
        }
        if (!AnnotationsUtils.hasAnnotation(declarationDescriptor, annotation2)) {
            return null;
        }
        return AnnotationsUtils.getAnnotationStringParameter(declarationDescriptor, annotation2);
    }

    @Nullable
    public static String getNameForAnnotatedObjectWithOverrides(@NotNull DeclarationDescriptor declarationDescriptor) {
        List<DeclarationDescriptor> descriptors;
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "getNameForAnnotatedObjectWithOverrides"));
        }
        if (declarationDescriptor instanceof CallableMemberDescriptor && JsDescriptorUtils.isOverride((CallableMemberDescriptor)declarationDescriptor)) {
            Set<CallableMemberDescriptor> overriddenDeclarations = DescriptorUtils.getAllOverriddenDeclarations((CallableMemberDescriptor)declarationDescriptor);
            descriptors = ContainerUtil.mapNotNull(overriddenDeclarations, new Function<CallableMemberDescriptor, DeclarationDescriptor>(){

                @Override
                public DeclarationDescriptor fun(CallableMemberDescriptor descriptor) {
                    return JsDescriptorUtils.isOverride(descriptor) ? null : descriptor;
                }
            });
        } else {
            descriptors = ContainerUtil.newArrayList(new DeclarationDescriptor[]{declarationDescriptor});
        }
        for (DeclarationDescriptor descriptor : descriptors) {
            for (PredefinedAnnotation annotation2 : PredefinedAnnotation.values()) {
                if (!AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor, annotation2)) continue;
                String name = AnnotationsUtils.getNameForAnnotatedObject(descriptor, annotation2);
                return name != null ? name : descriptor.getName().asString();
            }
        }
        return null;
    }

    @Nullable
    private static AnnotationDescriptor getAnnotationByName(@NotNull DeclarationDescriptor descriptor, @NotNull PredefinedAnnotation annotation2) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "getAnnotationByName"));
        }
        if (annotation2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "getAnnotationByName"));
        }
        return AnnotationsUtils.getAnnotationByName(descriptor, annotation2.getFqName());
    }

    @Nullable
    private static AnnotationDescriptor getAnnotationByName(@NotNull DeclarationDescriptor descriptor, @NotNull String fqn) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "getAnnotationByName"));
        }
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "getAnnotationByName"));
        }
        return descriptor.getAnnotations().findAnnotation(new FqName(fqn));
    }

    public static boolean isNativeObject(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "isNativeObject"));
        }
        return AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor, PredefinedAnnotation.NATIVE);
    }

    public static boolean isLibraryObject(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "isLibraryObject"));
        }
        return AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor, PredefinedAnnotation.LIBRARY);
    }

    public static boolean isPredefinedObject(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "isPredefinedObject"));
        }
        for (PredefinedAnnotation annotation2 : PredefinedAnnotation.values()) {
            if (!AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor, annotation2)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAnnotationOrInsideAnnotatedClass(@NotNull DeclarationDescriptor descriptor, @NotNull PredefinedAnnotation annotation2) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "hasAnnotationOrInsideAnnotatedClass"));
        }
        if (annotation2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "hasAnnotationOrInsideAnnotatedClass"));
        }
        return AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor, annotation2.getFqName());
    }

    private static boolean hasAnnotationOrInsideAnnotatedClass(@NotNull DeclarationDescriptor descriptor, @NotNull String fqn) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "hasAnnotationOrInsideAnnotatedClass"));
        }
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "org/jetbrains/k2js/translate/utils/AnnotationsUtils", "hasAnnotationOrInsideAnnotatedClass"));
        }
        if (AnnotationsUtils.getAnnotationByName(descriptor, fqn) != null) {
            return true;
        }
        ClassDescriptor containingClass = JsDescriptorUtils.getContainingClass(descriptor);
        return containingClass != null && AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass((DeclarationDescriptor)containingClass, fqn);
    }
}

