/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.utils.addToStdlib;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.ArraysKt;
import kotlin.CollectionsKt;
import kotlin.IntProgression;
import kotlin.MapsKt;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.RangesKt;
import kotlin.Sequence;
import kotlin.SequencesKt;
import kotlin.StringsKt;
import kotlin.TypeCastException;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.utils.addToStdlib.AddToStdlibKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AddToStdlibKt {
    private static final ConcurrentHashMap<Function0<?>, Object> constantMap = new ConcurrentHashMap();

    @NotNull
    public static final <T> List<T> singletonOrEmptyList(T $receiver) {
        return $receiver != null ? Collections.singletonList($receiver) : Collections.emptyList();
    }

    @NotNull
    public static final <T> List<T> singletonList(T $receiver) {
        List<T> list = Collections.singletonList($receiver);
        Intrinsics.checkExpressionValueIsNotNull(list, "Collections.singletonList(this)");
        return list;
    }

    @NotNull
    public static final <T> Set<T> singletonOrEmptySet(T $receiver) {
        return $receiver != null ? Collections.singleton($receiver) : Collections.emptySet();
    }

    @Nullable
    public static final <T> T firstIsInstanceOrNull(Sequence<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Iterator<?> iterator2 = $receiver.iterator();
        while (iterator2.hasNext()) {
            Object element = iterator2.next();
            Intrinsics.reifyInstanceof("T");
            if (!(element instanceof Object)) continue;
            return (T)element;
        }
        return null;
    }

    @Nullable
    public static final <T> T firstIsInstanceOrNull(Iterable<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        for (Object element : $receiver) {
            Intrinsics.reifyInstanceof("T");
            if (!(element instanceof Object)) continue;
            return (T)element;
        }
        return null;
    }

    @Nullable
    public static final <T> T firstIsInstanceOrNull(Object[] $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        for (int i = 0; i < $receiver.length; ++i) {
            Object element = $receiver[i];
            Intrinsics.reifyInstanceof("T");
            if (!(element instanceof Object)) continue;
            return (T)element;
        }
        return null;
    }

    public static final <T> T firstIsInstance(Sequence<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Iterator<?> iterator2 = $receiver.iterator();
        while (iterator2.hasNext()) {
            Object element = iterator2.next();
            Intrinsics.reifyInstanceof("T");
            if (!(element instanceof Object)) continue;
            return (T)element;
        }
        throw (Throwable)new NoSuchElementException("No element of given type found");
    }

    public static final <T> T firstIsInstance(Iterable<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        for (Object element : $receiver) {
            Intrinsics.reifyInstanceof("T");
            if (!(element instanceof Object)) continue;
            return (T)element;
        }
        throw (Throwable)new NoSuchElementException("No element of given type found");
    }

    public static final <T> T firstIsInstance(Object[] $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        for (int i = 0; i < $receiver.length; ++i) {
            Object element = $receiver[i];
            Intrinsics.reifyInstanceof("T");
            if (!(element instanceof Object)) continue;
            return (T)element;
        }
        throw (Throwable)new NoSuchElementException("No element of given type found");
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final <T> T lastIsInstanceOrNull(Iterable<?> $receiver) {
        T t;
        block5: {
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            Iterable<?> iterable = $receiver;
            if (iterable instanceof List) {
                IntProgression intProgression = RangesKt.reversed(CollectionsKt.getIndices((Collection)$receiver));
                int n = ((Number)intProgression.getStart()).intValue();
                int n2 = ((Number)intProgression.getEnd()).intValue();
                int n3 = ((Number)intProgression.getIncrement()).intValue();
                int n4 = ProgressionUtilKt.getProgressionFinalElement(n, n2, n3);
                int n5 = n;
                int n6 = n2;
                if (n3 > 0 ? n5 <= n6 : n5 >= n6) {
                    while (true) {
                        void i;
                        Object element = ((List)$receiver).get((int)i);
                        Intrinsics.reifyInstanceof("T");
                        if (element instanceof Object) {
                            return (T)element;
                        }
                        if (i == n4) break;
                        i += n3;
                    }
                }
                return null;
            }
            Iterable $receiver2 = CollectionsKt.reversed($receiver);
            for (Object element : $receiver2) {
                Intrinsics.reifyInstanceof("T");
                if (!(element instanceof Object)) continue;
                t = element;
                break block5;
            }
            t = null;
        }
        return t;
    }

    @NotNull
    public static final <T> Sequence<T> sequenceOfLazyValues(Function0<T> ... elements) {
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        return SequencesKt.map(ArraysKt.asSequence((Object[])elements), sequenceOfLazyValues.1.INSTANCE);
    }

    @NotNull
    public static final <T1, T2> Pair<T2, T1> swap(Pair<? extends T1, ? extends T2> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new Pair<T2, T1>($receiver.getSecond(), $receiver.getFirst());
    }

    @Nullable
    public static final <T> T check(T $receiver, @NotNull Function1<? super T, ? extends Boolean> predicate) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(predicate, "predicate");
        return (T)(predicate.invoke($receiver) != false ? $receiver : null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> T constant(@NotNull Function0<? extends T> calculator) {
        void destination;
        void $receiver;
        Intrinsics.checkParameterIsNotNull(calculator, "calculator");
        Object cached = constantMap.get(calculator);
        if (cached != null) {
            Object object = cached;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            return (T)object;
        }
        Object[] $receiver2 = calculator.getClass().getDeclaredFields();
        Object[] objectArray = $receiver2;
        Collection collection = new ArrayList();
        for (int i = 0; i < ((void)$receiver).length; ++i) {
            void element = $receiver[i];
            Field it2 = (Field)element;
            if (!((it2.getModifiers() & 8) == 0)) continue;
            destination.add(element);
        }
        List fields2 = (List)destination;
        boolean value2 = fields2.isEmpty();
        if (PreconditionsKt.getASSERTIONS_ENABLED() && !value2) {
            String message = "No fields in the passed lambda expected but " + CollectionsKt.joinToString$default(fields2, null, null, null, 0, null, null, 63) + " found";
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        T value22 = calculator.invoke();
        MapsKt.set(constantMap, calculator, value22);
        return value22;
    }

    @Nullable
    public static final Integer indexOfOrNull(String $receiver, char c, int startIndex, boolean ignoreCase) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        int index2 = StringsKt.indexOf($receiver, c, startIndex, ignoreCase);
        return index2 >= 0 ? Integer.valueOf(index2) : (Integer)null;
    }

    @Nullable
    public static /* synthetic */ Integer indexOfOrNull$default(String string, char c, int n, boolean bl, int n2) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return AddToStdlibKt.indexOfOrNull(string, c, n, bl);
    }

    @Nullable
    public static final Integer lastIndexOfOrNull(String $receiver, char c, int startIndex, boolean ignoreCase) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        int index2 = StringsKt.lastIndexOf($receiver, c, startIndex, ignoreCase);
        return index2 >= 0 ? Integer.valueOf(index2) : (Integer)null;
    }

    @Nullable
    public static /* synthetic */ Integer lastIndexOfOrNull$default(String string, char c, int n, boolean bl, int n2) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return AddToStdlibKt.lastIndexOfOrNull(string, c, n, bl);
    }

    @Nullable
    public static final <T, R> R firstNotNullResult(Iterable<? extends T> $receiver, @NotNull Function1<? super T, ? extends R> transform) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(transform, "transform");
        for (T element : $receiver) {
            R result2 = transform.invoke(element);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }
}

