/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import gnu.trove.TIntIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.IntRange;
import kotlin.PreconditionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.FileMapping;
import org.jetbrains.kotlin.codegen.inline.RangeMapping;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"?\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\u000f\u0015\tA1A\u0003\u0002\u0011\u0011)\u0001!B\u0001\r\u0003\u0015\tAAA\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u00012B\u0003\u0002\t\u0007)\u0011\u0001C\u0001\u0006\u0003\u0011)Q!\u0001\u0007\u0002\u0019\u0001I\u0012\u0001'\u0001\"\u0016%\u0019\u0001\"A\u0007\u00021\u0007I1\u0001\u0003\u0002\u000e\u0003a\r\u0011kA\u0001\t\u0006\u0015bA!\u0001\u0005\t\u001b\u0005A\n\"G\u0002\t\u00135\t\u0001tA\r\u0004\u0011'i\u0011\u0001g\u0002&\u0017!QQ\"\u0001M\u000b3\rA1\"D\u0001\u0019\be\u0019\u0001rC\u0007\u00021\u000f)s\u0002\u0003\u0007\u000e\u0003a\u001d\u0011d\u0001E\r\u001b\u0005A:!G\u0002\t\u001b5\t\u0001tA\r\u0004\u00117i\u0011\u0001'\u0005&\u001f!qQ\"\u0001M\u000b3\rAI\"D\u0001\u0019\be\u0019\u0001RD\u0007\u00021\u000fI2\u0001C\b\u000e\u0003a\u001dQe\u0001E\u0010\u001b\u0005A\u0002#K\u0004\u0005\u0003rA1!D\u0001\u0019\bE\u001b\u0011!\u0002\u0001*\u000f\u0011\t\u0005\u0002\u0003\u0003\u000e\u0003a%\u0011kA\u0001\u0006\u0001%RAa\u0011\u0005\t\u00035\t\u00014A)\u0004\t\u0015\u0001QB\u0001\u0003\u0006\u0011\u0017I#\u0002B\"\t\u0011\ti\u0011\u0001g\u0001R\u0007\u0011)\u0001!\u0004\u0002\u0005\r!-\u0011F\u0003\u0003B\u0011!5Q\u0002B\u0005\u0003\u0013\u0005Az\u0001G\u0004R\u0007\u0005)\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/codegen/inline/RawFileMapping;", "", "name", "", "path", "(Ljava/lang/String;Ljava/lang/String;)V", "lastMappedWithNewIndex", "", "lineMappings", "Lgnu/trove/TIntIntHashMap;", "getName", "()Ljava/lang/String;", "getPath", "rangeMappings", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/codegen/inline/RangeMapping;", "couldFoldInRange", "", "first", "second", "initRange", "", "start", "end", "mapLine", "source", "currentIndex", "isLastMapped", "mapNewInterval", "dest", "range", "toFileMapping", "Lorg/jetbrains/kotlin/codegen/inline/FileMapping;"}, moduleName="kotlin-compiler")
public final class RawFileMapping {
    private final TIntIntHashMap lineMappings;
    private final ArrayList<RangeMapping> rangeMappings;
    private int lastMappedWithNewIndex;
    @NotNull
    private final String name;
    @NotNull
    private final String path;

    @NotNull
    public final FileMapping toFileMapping() {
        FileMapping fileMapping = new FileMapping(this.name, this.path);
        for (RangeMapping range : this.rangeMappings) {
            fileMapping.addRangeMapping(range);
        }
        return fileMapping;
    }

    /*
     * WARNING - void declaration
     */
    public final void initRange(int start, int end) {
        int value2 = this.lineMappings.isEmpty();
        if (PreconditionsKt.getASSERTIONS_ENABLED() && value2 == 0) {
            String message = "initRange should only be called for empty mapping";
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        value2 = start;
        int n = end;
        if (value2 <= n) {
            while (true) {
                void index2;
                this.lineMappings.put((int)index2, (int)index2);
                if (index2 == n) break;
                ++index2;
            }
        }
        this.rangeMappings.add(new RangeMapping(start, start, end - start + 1));
        this.lastMappedWithNewIndex = end;
    }

    public final int mapLine(int source, int currentIndex, boolean isLastMapped) {
        int dest = this.lineMappings.get(source);
        if (dest == 0) {
            if (CollectionsKt.isNotEmpty((Collection)this.rangeMappings) && isLastMapped && this.couldFoldInRange(this.lastMappedWithNewIndex, source)) {
                RangeMapping rangeMapping;
                RangeMapping rangeMapping2 = rangeMapping = (RangeMapping)CollectionsKt.last((List)this.rangeMappings);
                rangeMapping2.setRange(rangeMapping2.getRange() + (source - this.lastMappedWithNewIndex));
                dest = this.lineMappings.get(this.lastMappedWithNewIndex) + source - this.lastMappedWithNewIndex;
            } else {
                dest = currentIndex + 1;
                RangeMapping rangeMapping = new RangeMapping(source, dest, 0, 4, null);
                this.rangeMappings.add(rangeMapping);
            }
            this.lineMappings.put(source, dest);
            this.lastMappedWithNewIndex = source;
        }
        return dest;
    }

    /*
     * WARNING - void declaration
     */
    public final void mapNewInterval(int source, int dest, int range) {
        void $receiver;
        RangeMapping rangeMapping = new RangeMapping(source, dest, range);
        this.rangeMappings.add(rangeMapping);
        Iterable iterable = new IntRange(source, source + range - 1);
        for (Object element : $receiver) {
            int it2 = ((Number)element).intValue();
            this.lineMappings.put(source, dest);
        }
    }

    private final boolean couldFoldInRange(int first, int second) {
        int delta = second - first;
        return delta > 0 && delta <= 10;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public RawFileMapping(@NotNull String name, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(path, "path");
        this.name = name;
        this.path = path;
        this.lineMappings = new TIntIntHashMap();
        this.rangeMappings = CollectionsKt.arrayListOf(new RangeMapping[0]);
        this.lastMappedWithNewIndex = -1000;
    }
}

