/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.state;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.BuiltinsPackageFragment;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.functions.FunctionClassDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForCallableDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForConstructorDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForPropertyDescriptor;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.SamCodegenUtil;
import org.jetbrains.kotlin.codegen.SamType;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.binding.MutableClosure;
import org.jetbrains.kotlin.codegen.binding.PsiCodegenPredictor;
import org.jetbrains.kotlin.codegen.signature.BothSignatureWriter;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fileClasses.FileClasses;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.fileClasses.JvmFileClassesProvider;
import org.jetbrains.kotlin.load.java.BuiltinMethodsWithSpecialGenericSignature;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.load.java.SpecialBuiltinMembers;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaPackageScope;
import org.jetbrains.kotlin.load.kotlin.incremental.IncrementalPackageFragmentProvider;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCache;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMap;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtFunctionLiteralExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.FunctionImportedFromObject;
import org.jetbrains.kotlin.resolve.ImportedFromObjectCallableDescriptor;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.resolve.scopes.AbstractScopeAdapter;
import org.jetbrains.kotlin.resolve.scopes.KtScope;
import org.jetbrains.kotlin.serialization.deserialization.DeserializedType;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class JetTypeMapper {
    private final BindingContext bindingContext;
    private final ClassBuilderMode classBuilderMode;
    private final JvmFileClassesProvider fileClassesProvider;
    private final IncrementalCache incrementalCache;
    private final String moduleName;
    private static final ClassId FAKE_CLASS_ID_FOR_BUILTINS = ClassId.topLevel(new FqName("kotlin.KotlinPackage"));

    public JetTypeMapper(@NotNull BindingContext bindingContext2, @NotNull ClassBuilderMode classBuilderMode, @NotNull JvmFileClassesProvider fileClassesProvider, @Nullable IncrementalCache incrementalCache, @NotNull String moduleName) {
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "<init>"));
        }
        if (classBuilderMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classBuilderMode", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "<init>"));
        }
        if (fileClassesProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileClassesProvider", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "<init>"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "<init>"));
        }
        this.bindingContext = bindingContext2;
        this.classBuilderMode = classBuilderMode;
        this.fileClassesProvider = fileClassesProvider;
        this.incrementalCache = incrementalCache;
        this.moduleName = moduleName;
    }

    @NotNull
    public BindingContext getBindingContext() {
        BindingContext bindingContext2 = this.bindingContext;
        if (bindingContext2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "getBindingContext"));
        }
        return bindingContext2;
    }

    @NotNull
    public Type mapOwner(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapOwner"));
        }
        Type type2 = this.mapOwner(descriptor2, true);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapOwner"));
        }
        return type2;
    }

    public Type mapImplementationOwner(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapImplementationOwner"));
        }
        return this.mapOwner(descriptor2, false);
    }

    @NotNull
    public Type mapOwner(@NotNull DeclarationDescriptor descriptor2, boolean publicFacade) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapOwner"));
        }
        if (DescriptorUtils.isLocalFunction(descriptor2)) {
            Type type2 = CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, (FunctionDescriptor)descriptor2);
            if (type2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapOwner"));
            }
            return type2;
        }
        DeclarationDescriptor container = descriptor2.getContainingDeclaration();
        if (container instanceof PackageFragmentDescriptor) {
            String packageMemberOwner = this.internalNameForPackageMemberOwner((CallableMemberDescriptor)descriptor2, publicFacade);
            Type type3 = Type.getObjectType(packageMemberOwner);
            if (type3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapOwner"));
            }
            return type3;
        }
        if (container instanceof ClassDescriptor) {
            Type type4 = this.mapClass((ClassDescriptor)container);
            if (type4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapOwner"));
            }
            return type4;
        }
        if (container instanceof ScriptDescriptor) {
            Type type5 = CodegenBinding.asmTypeForScriptDescriptor(this.bindingContext, (ScriptDescriptor)container);
            if (type5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapOwner"));
            }
            return type5;
        }
        throw new UnsupportedOperationException("Don't know how to map owner for " + descriptor2);
    }

    @NotNull
    private String internalNameForPackageMemberOwner(@NotNull CallableMemberDescriptor descriptor2, boolean publicFacade) {
        String facadeFqName;
        KtFile file;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "internalNameForPackageMemberOwner"));
        }
        boolean isAccessor = descriptor2 instanceof AccessorForCallableDescriptor;
        if (isAccessor) {
            descriptor2 = ((AccessorForCallableDescriptor)((Object)descriptor2)).getCalleeDescriptor();
        }
        if ((file = DescriptorToSourceUtils.getContainingFile(descriptor2)) != null) {
            Visibility visibility = descriptor2.getVisibility();
            if (!publicFacade || descriptor2 instanceof PropertyDescriptor || Visibilities.isPrivate(visibility) || isAccessor) {
                String string = FileClasses.getFileClassInternalName(this.fileClassesProvider, file);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "internalNameForPackageMemberOwner"));
                }
                return string;
            }
            String string = FileClasses.getFacadeClassInternalName(this.fileClassesProvider, file);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "internalNameForPackageMemberOwner"));
            }
            return string;
        }
        CallableMemberDescriptor directMember = JvmCodegenUtil.getDirectMember(descriptor2);
        if (directMember instanceof DeserializedCallableMemberDescriptor && (facadeFqName = this.getPackageMemberOwnerInternalName((DeserializedCallableMemberDescriptor)directMember, publicFacade)) != null) {
            String string = facadeFqName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "internalNameForPackageMemberOwner"));
            }
            return string;
        }
        throw new RuntimeException("Could not find package member for " + descriptor2 + " in package fragment " + descriptor2.getContainingDeclaration());
    }

    public ContainingClassesInfo getContainingClassesForDeserializedCallable(DeserializedCallableMemberDescriptor deserializedDescriptor) {
        ContainingClassesInfo containingClassesInfo;
        DeclarationDescriptor parentDeclaration = deserializedDescriptor.getContainingDeclaration();
        if (parentDeclaration instanceof PackageFragmentDescriptor) {
            containingClassesInfo = this.getPackageMemberContainingClassesInfo(deserializedDescriptor);
        } else {
            ClassId classId = JetTypeMapper.getContainerClassIdForClassDescriptor((ClassDescriptor)parentDeclaration);
            containingClassesInfo = ContainingClassesInfo.forClassMemberOrNull(classId);
        }
        if (containingClassesInfo == null) {
            throw new IllegalStateException("Couldn't find container for " + deserializedDescriptor.getName());
        }
        return containingClassesInfo;
    }

    private static ClassId getContainerClassIdForClassDescriptor(ClassDescriptor classDescriptor) {
        ClassId classId = DescriptorUtilsKt.getClassId(classDescriptor);
        if (DescriptorUtils.isInterface(classDescriptor)) {
            FqName relativeClassName = classId.getRelativeClassName();
            classId = new ClassId(classId.getPackageFqName(), Name.identifier(relativeClassName.shortName().asString() + "$DefaultImpls"));
        }
        return classId;
    }

    @Nullable
    private String getPackageMemberOwnerInternalName(@NotNull DeserializedCallableMemberDescriptor descriptor2, boolean publicFacade) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "getPackageMemberOwnerInternalName"));
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        assert (containingDeclaration instanceof PackageFragmentDescriptor) : "Not a top-level member: " + descriptor2;
        ContainingClassesInfo containingClasses = this.getPackageMemberContainingClassesInfo(descriptor2);
        if (containingClasses == null) {
            return null;
        }
        ClassId ownerClassId = publicFacade ? containingClasses.getFacadeClassId() : containingClasses.getImplClassId();
        return JvmClassName.byClassId(ownerClassId).getInternalName();
    }

    @Nullable
    private ContainingClassesInfo getPackageMemberContainingClassesInfo(@NotNull DeserializedCallableMemberDescriptor descriptor2) {
        String facadeSimpleName;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "getPackageMemberContainingClassesInfo"));
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        assert (containingDeclaration instanceof PackageFragmentDescriptor) : "Package member expected, got " + descriptor2 + " in " + containingDeclaration;
        PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)containingDeclaration;
        if (packageFragmentDescriptor instanceof BuiltinsPackageFragment) {
            return new ContainingClassesInfo(FAKE_CLASS_ID_FOR_BUILTINS, FAKE_CLASS_ID_FOR_BUILTINS);
        }
        Name implClassName = JvmFileClassUtil.getImplClassName(descriptor2);
        assert (implClassName != null) : "No implClassName for " + descriptor2;
        String implSimpleName = implClassName.asString();
        KtScope scope2 = packageFragmentDescriptor.getMemberScope();
        if (scope2 instanceof AbstractScopeAdapter) {
            scope2 = ((AbstractScopeAdapter)scope2).getActualScope();
        }
        if (scope2 instanceof LazyJavaPackageScope) {
            facadeSimpleName = ((LazyJavaPackageScope)scope2).getFacadeSimpleNameForPartSimpleName(implClassName.asString());
        } else if (packageFragmentDescriptor instanceof IncrementalPackageFragmentProvider.IncrementalPackageFragment) {
            assert (this.incrementalCache != null) : "IncrementalPackageFragment found outside of incremental compilation context for " + descriptor2 + " in package " + packageFragmentDescriptor;
            String implClassInternalName = AsmUtil.internalNameByFqNameWithoutInnerClasses(packageFragmentDescriptor.getFqName().child(implClassName));
            String facadeClassInternalName = this.incrementalCache.getMultifileFacade(implClassInternalName);
            facadeSimpleName = facadeClassInternalName == null ? implClassName.asString() : AsmUtil.getSimpleInternalName(facadeClassInternalName);
        } else {
            throw new AssertionError((Object)("Unexpected package member scope for " + descriptor2 + ": " + scope2 + " :" + scope2.getClass().getSimpleName()));
        }
        return ContainingClassesInfo.forPackageMemberOrNull(packageFragmentDescriptor.getFqName(), facadeSimpleName, implSimpleName);
    }

    @NotNull
    public Type mapReturnType(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapReturnType"));
        }
        Type type2 = this.mapReturnType(descriptor2, null);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapReturnType"));
        }
        return type2;
    }

    @NotNull
    private Type mapReturnType(@NotNull CallableDescriptor descriptor2, @Nullable BothSignatureWriter sw) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapReturnType"));
        }
        KotlinType returnType2 = descriptor2.getReturnType();
        assert (returnType2 != null) : "Function has no return type: " + descriptor2;
        if (descriptor2 instanceof ConstructorDescriptor) {
            Type type2 = Type.VOID_TYPE;
            if (type2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapReturnType"));
            }
            return type2;
        }
        if (KotlinBuiltIns.isUnit(returnType2) && !TypeUtils.isNullableType(returnType2) && !(descriptor2 instanceof PropertyGetterDescriptor)) {
            if (sw != null) {
                sw.writeAsmType(Type.VOID_TYPE);
            }
            Type type3 = Type.VOID_TYPE;
            if (type3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapReturnType"));
            }
            return type3;
        }
        if (descriptor2 instanceof FunctionDescriptor && JetTypeMapper.forceBoxedReturnType((FunctionDescriptor)descriptor2)) {
            Type type4 = this.mapType(descriptor2.getReturnType(), sw, JetTypeMapperMode.TYPE_PARAMETER);
            if (type4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapReturnType"));
            }
            return type4;
        }
        if (DescriptorUtils.isAnnotationClass(descriptor2.getContainingDeclaration())) {
            Type type5 = this.mapType(descriptor2.getReturnType(), sw, JetTypeMapperMode.VALUE_FOR_ANNOTATION);
            if (type5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapReturnType"));
            }
            return type5;
        }
        Type type6 = this.mapType(returnType2, sw, JetTypeMapperMode.VALUE, Variance.OUT_VARIANCE);
        if (type6 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapReturnType"));
        }
        return type6;
    }

    @NotNull
    private Type mapType(@NotNull KotlinType jetType, @NotNull JetTypeMapperMode mode) {
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
        }
        Type type2 = this.mapType(jetType, null, mode);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
        }
        return type2;
    }

    @NotNull
    public Type mapSupertype(@NotNull KotlinType jetType, @Nullable BothSignatureWriter signatureVisitor) {
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapSupertype"));
        }
        Type type2 = this.mapType(jetType, signatureVisitor, JetTypeMapperMode.SUPER_TYPE);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapSupertype"));
        }
        return type2;
    }

    @NotNull
    public Type mapTypeParameter(@NotNull KotlinType jetType, @Nullable BothSignatureWriter signatureVisitor) {
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapTypeParameter"));
        }
        Type type2 = this.mapType(jetType, signatureVisitor, JetTypeMapperMode.TYPE_PARAMETER);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapTypeParameter"));
        }
        return type2;
    }

    @NotNull
    public Type mapClass(@NotNull ClassifierDescriptor classifier2) {
        if (classifier2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classifier", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapClass"));
        }
        Type type2 = this.mapType(classifier2.getDefaultType(), null, JetTypeMapperMode.IMPL);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapClass"));
        }
        return type2;
    }

    @NotNull
    public Type mapType(@NotNull KotlinType jetType) {
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
        }
        Type type2 = this.mapType(jetType, null, JetTypeMapperMode.VALUE);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
        }
        return type2;
    }

    @NotNull
    public Type mapType(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
        }
        Type type2 = this.mapType(descriptor2.getReturnType());
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
        }
        return type2;
    }

    @NotNull
    public JvmMethodSignature mapAnnotationParameterSignature(@NotNull PropertyDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapAnnotationParameterSignature"));
        }
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD);
        sw.writeReturnType();
        this.mapType(descriptor2.getType(), sw, JetTypeMapperMode.VALUE_FOR_ANNOTATION);
        sw.writeReturnTypeEnd();
        JvmMethodSignature jvmMethodSignature = sw.makeJvmMethodSignature(descriptor2.getName().asString());
        if (jvmMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapAnnotationParameterSignature"));
        }
        return jvmMethodSignature;
    }

    @NotNull
    public Type mapType(@NotNull ClassifierDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
        }
        Type type2 = this.mapType(descriptor2.getDefaultType());
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
        }
        return type2;
    }

    @NotNull
    private Type mapType(@NotNull KotlinType jetType, @Nullable BothSignatureWriter signatureVisitor, @NotNull JetTypeMapperMode mode) {
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
        }
        Type type2 = this.mapType(jetType, signatureVisitor, mode, Variance.INVARIANT);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
        }
        return type2;
    }

    @NotNull
    private Type mapType(@NotNull KotlinType jetType, @Nullable BothSignatureWriter signatureVisitor, @NotNull JetTypeMapperMode kind, @NotNull Variance howThisTypeIsUsed) {
        boolean projectionsAllowed;
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
        }
        if (howThisTypeIsUsed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "howThisTypeIsUsed", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
        }
        Type known = JetTypeMapper.mapBuiltinType(jetType);
        boolean bl = projectionsAllowed = kind != JetTypeMapperMode.SUPER_TYPE;
        if (known != null) {
            if (kind == JetTypeMapperMode.VALUE || kind == JetTypeMapperMode.VALUE_FOR_ANNOTATION) {
                Type type2 = this.mapKnownAsmType(jetType, known, signatureVisitor, howThisTypeIsUsed);
                if (type2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
                }
                return type2;
            }
            if (kind == JetTypeMapperMode.TYPE_PARAMETER || kind == JetTypeMapperMode.SUPER_TYPE || kind == JetTypeMapperMode.TYPE_PARAMETER_FOR_ANNOTATION) {
                Type type3 = this.mapKnownAsmType(jetType, AsmUtil.boxType(known), signatureVisitor, howThisTypeIsUsed, projectionsAllowed);
                if (type3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
                }
                return type3;
            }
            if (kind == JetTypeMapperMode.IMPL) {
                Type type4 = this.mapKnownAsmType(jetType, known, signatureVisitor, howThisTypeIsUsed);
                if (type4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
                }
                return type4;
            }
            throw new IllegalStateException("unknown kind: " + (Object)((Object)kind));
        }
        TypeConstructor constructor = jetType.getConstructor();
        ClassifierDescriptor descriptor2 = constructor.getDeclarationDescriptor();
        if (constructor instanceof IntersectionTypeConstructor) {
            jetType = CommonSupertypes.commonSupertype(new ArrayList<KotlinType>(constructor.getSupertypes()));
        }
        if (descriptor2 == null) {
            throw new UnsupportedOperationException("no descriptor for type constructor of " + jetType);
        }
        if (ErrorUtils.isError(descriptor2)) {
            if (this.classBuilderMode != ClassBuilderMode.LIGHT_CLASSES) {
                throw new IllegalStateException(JetTypeMapper.generateErrorMessageForErrorType(jetType, descriptor2));
            }
            Type asmType = Type.getObjectType("error/NonExistentClass");
            if (signatureVisitor != null) {
                signatureVisitor.writeAsmType(asmType);
            }
            Type type5 = asmType;
            if (type5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
            }
            return type5;
        }
        if (descriptor2 instanceof ClassDescriptor && KotlinBuiltIns.isArray(jetType)) {
            Type arrayElementType;
            if (jetType.getArguments().size() != 1) {
                throw new UnsupportedOperationException("arrays must have one type argument");
            }
            TypeProjection memberProjection = jetType.getArguments().get(0);
            KotlinType memberType = memberProjection.getType();
            if (memberProjection.getProjectionKind() == Variance.IN_VARIANCE) {
                arrayElementType = AsmTypes.OBJECT_TYPE;
                if (signatureVisitor != null) {
                    signatureVisitor.writeArrayType();
                    signatureVisitor.writeAsmType(arrayElementType);
                    signatureVisitor.writeArrayEnd();
                }
            } else {
                arrayElementType = AsmUtil.boxType(this.mapType(memberType, kind));
                if (signatureVisitor != null) {
                    signatureVisitor.writeArrayType();
                    JetTypeMapperMode newMode = kind.isForAnnotation() ? JetTypeMapperMode.TYPE_PARAMETER_FOR_ANNOTATION : JetTypeMapperMode.TYPE_PARAMETER;
                    this.mapType(memberType, signatureVisitor, newMode, memberProjection.getProjectionKind());
                    signatureVisitor.writeArrayEnd();
                }
            }
            Type type6 = Type.getType("[" + arrayElementType.getDescriptor());
            if (type6 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
            }
            return type6;
        }
        if (descriptor2 instanceof ClassDescriptor) {
            Type asmType = kind.isForAnnotation() && KotlinBuiltIns.isKClass((ClassDescriptor)descriptor2) ? AsmTypes.JAVA_CLASS_TYPE : this.computeAsmType((ClassDescriptor)descriptor2.getOriginal());
            this.writeGenericType(signatureVisitor, asmType, jetType, howThisTypeIsUsed, projectionsAllowed);
            Type type7 = asmType;
            if (type7 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
            }
            return type7;
        }
        if (descriptor2 instanceof TypeParameterDescriptor) {
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)descriptor2;
            Type type8 = this.mapType(typeParameterDescriptor.getUpperBounds().iterator().next(), kind);
            if (signatureVisitor != null) {
                signatureVisitor.writeTypeVariable(typeParameterDescriptor.getName(), type8);
            }
            Type type9 = type8;
            if (type9 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
            }
            return type9;
        }
        throw new UnsupportedOperationException("Unknown type " + jetType);
    }

    @Nullable
    private static Type mapBuiltinType(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapBuiltinType"));
        }
        ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return null;
        }
        FqNameUnsafe fqName2 = DescriptorUtils.getFqName(descriptor2);
        PrimitiveType primitiveType = KotlinBuiltIns.getPrimitiveTypeByFqName(fqName2);
        if (primitiveType != null) {
            Type asmType = Type.getType(JvmPrimitiveType.get(primitiveType).getDesc());
            return TypeUtils.isNullableType(type2) ? AsmUtil.boxType(asmType) : asmType;
        }
        PrimitiveType arrayElementType = KotlinBuiltIns.getPrimitiveTypeByArrayClassFqName(fqName2);
        if (arrayElementType != null) {
            return Type.getType("[" + JvmPrimitiveType.get(arrayElementType).getDesc());
        }
        ClassId classId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(fqName2);
        if (classId != null) {
            return Type.getObjectType(JvmClassName.byClassId(classId).getInternalName());
        }
        return null;
    }

    @NotNull
    private Type computeAsmType(@NotNull ClassDescriptor klass) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "computeAsmType"));
        }
        Type alreadyComputedType = this.bindingContext.get(CodegenBinding.ASM_TYPE, klass);
        if (alreadyComputedType != null) {
            Type type2 = alreadyComputedType;
            if (type2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "computeAsmType"));
            }
            return type2;
        }
        Type asmType = Type.getObjectType(this.computeAsmTypeImpl(klass));
        assert (PsiCodegenPredictor.checkPredictedNameFromPsi(klass, asmType, this.fileClassesProvider));
        Type type3 = asmType;
        if (type3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "computeAsmType"));
        }
        return type3;
    }

    @NotNull
    private String computeAsmTypeImpl(@NotNull ClassDescriptor klass) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "computeAsmTypeImpl"));
        }
        DeclarationDescriptor container = klass.getContainingDeclaration();
        String name = SpecialNames.safeIdentifier(klass.getName()).getIdentifier();
        if (container instanceof PackageFragmentDescriptor) {
            FqName fqName2 = ((PackageFragmentDescriptor)container).getFqName();
            String string = fqName2.isRoot() ? name : fqName2.asString().replace('.', '/') + '/' + name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "computeAsmTypeImpl"));
            }
            return string;
        }
        if (container instanceof ScriptDescriptor) {
            String string = CodegenBinding.asmTypeForScriptDescriptor(this.bindingContext, (ScriptDescriptor)container).getInternalName() + "$" + name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "computeAsmTypeImpl"));
            }
            return string;
        }
        assert (container instanceof ClassDescriptor) : "Unexpected container: " + container + " for " + klass;
        String containerInternalName = this.computeAsmTypeImpl((ClassDescriptor)container);
        String string = klass.getKind() == ClassKind.ENUM_ENTRY ? containerInternalName : containerInternalName + "$" + name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "computeAsmTypeImpl"));
        }
        return string;
    }

    @NotNull
    public Type mapDefaultImpls(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapDefaultImpls"));
        }
        Type type2 = Type.getObjectType(this.mapType(descriptor2).getInternalName() + "$DefaultImpls");
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapDefaultImpls"));
        }
        return type2;
    }

    @NotNull
    private static String generateErrorMessageForErrorType(@NotNull KotlinType type2, @NotNull DeclarationDescriptor descriptor2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "generateErrorMessageForErrorType"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "generateErrorMessageForErrorType"));
        }
        PsiElement declarationElement = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        if (declarationElement == null) {
            String message = "Error type encountered: %s (%s).";
            if (FlexibleTypesKt.upperIfFlexible(type2) instanceof DeserializedType) {
                message = message + " One of the possible reasons may be that this type is not directly accessible from this module. To workaround this error, try adding an explicit dependency on the module or library which contains this type to the classpath";
            }
            String string = String.format(message, type2, type2.getClass().getSimpleName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "generateErrorMessageForErrorType"));
            }
            return string;
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        PsiElement parentDeclarationElement = containingDeclaration != null ? DescriptorToSourceUtils.descriptorToDeclaration(containingDeclaration) : null;
        String string = String.format("Error type encountered: %s (%s). Descriptor: %s. For declaration %s:%s in %s:%s", type2, type2.getClass().getSimpleName(), descriptor2, declarationElement, declarationElement.getText(), parentDeclarationElement, parentDeclarationElement != null ? parentDeclarationElement.getText() : "null");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "generateErrorMessageForErrorType"));
        }
        return string;
    }

    private void writeGenericType(BothSignatureWriter signatureVisitor, Type asmType, KotlinType jetType, Variance howThisTypeIsUsed, boolean projectionsAllowed) {
        if (signatureVisitor != null) {
            if (JetTypeMapper.hasNothingInArguments(jetType)) {
                signatureVisitor.writeAsmType(asmType);
                return;
            }
            signatureVisitor.writeClassBegin(asmType);
            List<TypeProjection> arguments2 = jetType.getArguments();
            for (TypeParameterDescriptor parameter : jetType.getConstructor().getParameters()) {
                TypeProjection argument = arguments2.get(parameter.getIndex());
                if (projectionsAllowed && argument.isStarProjection()) {
                    signatureVisitor.writeUnboundedWildcard();
                    continue;
                }
                Variance projectionKind = projectionsAllowed ? JetTypeMapper.getEffectiveVariance(parameter.getVariance(), argument.getProjectionKind(), howThisTypeIsUsed) : Variance.INVARIANT;
                signatureVisitor.writeTypeArgument(projectionKind);
                this.mapType(argument.getType(), signatureVisitor, JetTypeMapperMode.TYPE_PARAMETER);
                signatureVisitor.writeTypeArgumentEnd();
            }
            signatureVisitor.writeClassEnd();
        }
    }

    private static boolean hasNothingInArguments(KotlinType jetType) {
        boolean hasNothingInArguments = CollectionsKt.any(jetType.getArguments(), new Function1<TypeProjection, Boolean>(){

            @Override
            public Boolean invoke(TypeProjection projection) {
                return KotlinBuiltIns.isNothingOrNullableNothing(projection.getType());
            }
        });
        if (hasNothingInArguments) {
            return true;
        }
        return CollectionsKt.any(jetType.getArguments(), new Function1<TypeProjection, Boolean>(){

            @Override
            public Boolean invoke(TypeProjection projection) {
                return !projection.isStarProjection() && JetTypeMapper.hasNothingInArguments(projection.getType());
            }
        });
    }

    private static Variance getEffectiveVariance(Variance parameterVariance, Variance projectionKind, Variance howThisTypeIsUsed) {
        if (howThisTypeIsUsed == Variance.OUT_VARIANCE) {
            return projectionKind;
        }
        if (parameterVariance == Variance.INVARIANT) {
            return projectionKind;
        }
        if (projectionKind == Variance.INVARIANT) {
            return parameterVariance;
        }
        if (parameterVariance == projectionKind) {
            return parameterVariance;
        }
        return Variance.OUT_VARIANCE;
    }

    private Type mapKnownAsmType(KotlinType jetType, Type asmType, @Nullable BothSignatureWriter signatureVisitor, @NotNull Variance howThisTypeIsUsed) {
        if (howThisTypeIsUsed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "howThisTypeIsUsed", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapKnownAsmType"));
        }
        return this.mapKnownAsmType(jetType, asmType, signatureVisitor, howThisTypeIsUsed, true);
    }

    private Type mapKnownAsmType(KotlinType jetType, Type asmType, @Nullable BothSignatureWriter signatureVisitor, @NotNull Variance howThisTypeIsUsed, boolean allowProjections) {
        if (howThisTypeIsUsed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "howThisTypeIsUsed", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapKnownAsmType"));
        }
        if (signatureVisitor != null) {
            if (jetType.getArguments().isEmpty()) {
                signatureVisitor.writeAsmType(asmType);
            } else {
                this.writeGenericType(signatureVisitor, asmType, jetType, howThisTypeIsUsed, allowProjections);
            }
        }
        return asmType;
    }

    @NotNull
    public CallableMethod mapToCallableMethod(@NotNull FunctionDescriptor descriptor2, boolean superCall) {
        Type owner;
        JvmMethodSignature signature;
        int invokeOpcode;
        Type thisClass;
        Type ownerForDefaultImpl;
        Type ownerForDefaultParam;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapToCallableMethod"));
        }
        if (descriptor2 instanceof ConstructorDescriptor) {
            JvmMethodSignature method = this.mapSignature(descriptor2);
            Type owner2 = this.mapClass(((ConstructorDescriptor)descriptor2).getContainingDeclaration());
            CallableMethod callableMethod = new CallableMethod(owner2, owner2, owner2, method, 183, null, null, null);
            if (callableMethod == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapToCallableMethod"));
            }
            return callableMethod;
        }
        DeclarationDescriptor functionParent = descriptor2.getOriginal().getContainingDeclaration();
        FunctionDescriptor functionDescriptor = DescriptorUtils.unwrapFakeOverride(descriptor2.getOriginal());
        if (functionParent instanceof ClassDescriptor) {
            FunctionDescriptor declarationFunctionDescriptor = JetTypeMapper.findAnyDeclaration(functionDescriptor);
            ClassDescriptor currentOwner = (ClassDescriptor)functionParent;
            ClassDescriptor declarationOwner = (ClassDescriptor)declarationFunctionDescriptor.getContainingDeclaration();
            boolean originalIsInterface = JvmCodegenUtil.isJvmInterface(declarationOwner);
            boolean currentIsInterface = JvmCodegenUtil.isJvmInterface(currentOwner);
            boolean isInterface = currentIsInterface && originalIsInterface;
            ClassDescriptor ownerForDefault = (ClassDescriptor)JetTypeMapper.findBaseDeclaration(functionDescriptor).getContainingDeclaration();
            ownerForDefaultParam = this.mapClass(ownerForDefault);
            Type type2 = ownerForDefaultImpl = JvmCodegenUtil.isJvmInterface(ownerForDefault) ? this.mapDefaultImpls(ownerForDefault) : ownerForDefaultParam;
            if (isInterface && (superCall || descriptor2.getVisibility() == Visibilities.PRIVATE)) {
                thisClass = this.mapClass(currentOwner);
                if (declarationOwner instanceof JavaClassDescriptor) {
                    invokeOpcode = 183;
                    signature = this.mapSignature(functionDescriptor);
                    owner = thisClass;
                } else {
                    invokeOpcode = 184;
                    signature = this.mapSignature(descriptor2.getOriginal(), OwnerKind.DEFAULT_IMPLS);
                    owner = this.mapDefaultImpls(currentOwner);
                }
            } else {
                boolean isStaticInvocation;
                boolean bl = isStaticInvocation = DescriptorUtils.isStaticDeclaration(functionDescriptor) && !(functionDescriptor instanceof ImportedFromObjectCallableDescriptor) || JetTypeMapper.isStaticAccessor(functionDescriptor) || AnnotationUtilKt.isPlatformStaticInObjectOrClass(functionDescriptor);
                if (isStaticInvocation) {
                    invokeOpcode = 184;
                } else if (isInterface) {
                    invokeOpcode = 185;
                } else {
                    boolean isPrivateFunInvocation = Visibilities.isPrivate(functionDescriptor.getVisibility());
                    invokeOpcode = superCall || isPrivateFunInvocation ? 183 : 182;
                }
                FunctionDescriptor overriddenSpecialBuiltinFunction = SpecialBuiltinMembers.getOverriddenBuiltinWithDifferentJvmDescriptor(functionDescriptor.getOriginal());
                FunctionDescriptor functionToCall = overriddenSpecialBuiltinFunction != null ? overriddenSpecialBuiltinFunction.getOriginal() : functionDescriptor.getOriginal();
                signature = this.mapSignature(functionToCall);
                ClassDescriptor receiver = currentIsInterface && !originalIsInterface || currentOwner instanceof FunctionClassDescriptor ? declarationOwner : currentOwner;
                thisClass = owner = this.mapClass(receiver);
            }
        } else {
            signature = this.mapSignature(functionDescriptor.getOriginal());
            ownerForDefaultParam = owner = this.mapOwner(functionDescriptor);
            ownerForDefaultImpl = owner;
            if (functionParent instanceof PackageFragmentDescriptor) {
                invokeOpcode = 184;
                thisClass = null;
            } else if (functionDescriptor instanceof ConstructorDescriptor) {
                invokeOpcode = 183;
                thisClass = null;
            } else {
                invokeOpcode = 182;
                thisClass = owner;
            }
        }
        Type calleeType = DescriptorUtils.isLocalFunction(functionDescriptor) ? owner : null;
        ReceiverParameterDescriptor receiverParameter = functionDescriptor.getOriginal().getExtensionReceiverParameter();
        Type receiverParameterType = receiverParameter != null ? this.mapType(receiverParameter.getType()) : null;
        CallableMethod callableMethod = new CallableMethod(owner, ownerForDefaultImpl, ownerForDefaultParam, signature, invokeOpcode, thisClass, receiverParameterType, calleeType);
        if (callableMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapToCallableMethod"));
        }
        return callableMethod;
    }

    public static boolean isAccessor(@NotNull CallableMemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "isAccessor"));
        }
        return descriptor2 instanceof AccessorForCallableDescriptor;
    }

    public static boolean isStaticAccessor(@NotNull CallableMemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "isStaticAccessor"));
        }
        if (descriptor2 instanceof AccessorForConstructorDescriptor) {
            return false;
        }
        return JetTypeMapper.isAccessor(descriptor2);
    }

    @NotNull
    private static FunctionDescriptor findAnyDeclaration(@NotNull FunctionDescriptor function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "findAnyDeclaration"));
        }
        if (function.getKind() == CallableMemberDescriptor.Kind.DECLARATION) {
            FunctionDescriptor functionDescriptor = function;
            if (functionDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "findAnyDeclaration"));
            }
            return functionDescriptor;
        }
        FunctionDescriptor functionDescriptor = JetTypeMapper.findBaseDeclaration(function);
        if (functionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "findAnyDeclaration"));
        }
        return functionDescriptor;
    }

    @NotNull
    private static FunctionDescriptor findBaseDeclaration(@NotNull FunctionDescriptor function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "findBaseDeclaration"));
        }
        if (function.getOverriddenDescriptors().isEmpty()) {
            FunctionDescriptor functionDescriptor = function;
            if (functionDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "findBaseDeclaration"));
            }
            return functionDescriptor;
        }
        FunctionDescriptor functionDescriptor = JetTypeMapper.findBaseDeclaration(function.getOverriddenDescriptors().iterator().next());
        if (functionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "findBaseDeclaration"));
        }
        return functionDescriptor;
    }

    @NotNull
    private String mapFunctionName(@NotNull FunctionDescriptor descriptor2) {
        String platformName2;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapFunctionName"));
        }
        if (!(descriptor2 instanceof JavaCallableMemberDescriptor) && (platformName2 = DescriptorUtils.getJvmName(descriptor2)) != null) {
            String string = platformName2;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapFunctionName"));
            }
            return string;
        }
        String nameForSpecialFunction = SpecialBuiltinMembers.getJvmMethodNameIfSpecial(descriptor2);
        if (nameForSpecialFunction != null) {
            String string = nameForSpecialFunction;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapFunctionName"));
            }
            return string;
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor property = ((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty();
            if (DescriptorUtils.isAnnotationClass(property.getContainingDeclaration())) {
                String string = property.getName().asString();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapFunctionName"));
                }
                return string;
            }
            boolean isAccessor = property instanceof AccessorForPropertyDescriptor;
            String propertyName = isAccessor ? ((AccessorForPropertyDescriptor)property).getAccessorSuffix() : property.getName().asString();
            String accessorName = descriptor2 instanceof PropertyGetterDescriptor ? JvmAbi.getterName(propertyName) : JvmAbi.setterName(propertyName);
            String string = this.updateMemberNameIfInternal(isAccessor ? "access$" + accessorName : accessorName, descriptor2);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapFunctionName"));
            }
            return string;
        }
        if (DescriptorUtils.isFunctionLiteral(descriptor2)) {
            SamType samType;
            PsiElement expression;
            PsiElement element = DescriptorToSourceUtils.getSourceFromDescriptor(descriptor2);
            if (element instanceof KtFunctionLiteral && (expression = element.getParent()) instanceof KtFunctionLiteralExpression && (samType = this.bindingContext.get(CodegenBinding.SAM_VALUE, (KtExpression)expression)) != null) {
                String string = samType.getAbstractMethod().getName().asString();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapFunctionName"));
                }
                return string;
            }
            String string = OperatorNameConventions.INVOKE.asString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapFunctionName"));
            }
            return string;
        }
        if (DescriptorUtils.isLocalFunction(descriptor2) || DescriptorUtils.isFunctionExpression(descriptor2)) {
            String string = OperatorNameConventions.INVOKE.asString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapFunctionName"));
            }
            return string;
        }
        String string = this.updateMemberNameIfInternal(descriptor2.getName().asString(), descriptor2);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapFunctionName"));
        }
        return string;
    }

    @NotNull
    public static String mapDefaultFieldName(@NotNull PropertyDescriptor propertyDescriptor, boolean isDelegated) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapDefaultFieldName"));
        }
        String name = propertyDescriptor instanceof AccessorForPropertyDescriptor ? ((AccessorForPropertyDescriptor)propertyDescriptor).getCalleeDescriptor().getName().asString() : propertyDescriptor.getName().asString();
        String string = isDelegated ? name + "$delegate" : name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapDefaultFieldName"));
        }
        return string;
    }

    @NotNull
    private String updateMemberNameIfInternal(@NotNull String name, @NotNull CallableMemberDescriptor descriptor2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "updateMemberNameIfInternal"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "updateMemberNameIfInternal"));
        }
        if (descriptor2.getContainingDeclaration() instanceof ScriptDescriptor) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "updateMemberNameIfInternal"));
            }
            return string;
        }
        if (DescriptorUtils.isTopLevelDeclaration(descriptor2)) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "updateMemberNameIfInternal"));
            }
            return string;
        }
        if (!(descriptor2 instanceof ConstructorDescriptor) && descriptor2.getVisibility() == Visibilities.INTERNAL) {
            String string = name + "$" + JvmAbi.sanitizeAsJavaIdentifier(this.moduleName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "updateMemberNameIfInternal"));
            }
            return string;
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "updateMemberNameIfInternal"));
        }
        return string;
    }

    @NotNull
    public JvmMethodSignature mapSignature(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapSignature"));
        }
        JvmMethodSignature jvmMethodSignature = this.mapSignature(descriptor2, OwnerKind.IMPLEMENTATION);
        if (jvmMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapSignature"));
        }
        return jvmMethodSignature;
    }

    @NotNull
    public JvmMethodSignature mapSignature(@NotNull FunctionDescriptor f, @NotNull OwnerKind kind) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapSignature"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapSignature"));
        }
        if (f instanceof ConstructorDescriptor) {
            JvmMethodSignature jvmMethodSignature = this.mapSignature(f, kind, f.getOriginal().getValueParameters());
            if (jvmMethodSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapSignature"));
            }
            return jvmMethodSignature;
        }
        JvmMethodSignature jvmMethodSignature = this.mapSignature(f, kind, f.getValueParameters());
        if (jvmMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapSignature"));
        }
        return jvmMethodSignature;
    }

    @NotNull
    public JvmMethodSignature mapSignature(@NotNull FunctionDescriptor f, @NotNull OwnerKind kind, List<ValueParameterDescriptor> valueParameters) {
        BuiltinMethodsWithSpecialGenericSignature.SpecialSignatureInfo specialSignatureInfo;
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapSignature"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapSignature"));
        }
        if (f instanceof FunctionImportedFromObject) {
            JvmMethodSignature jvmMethodSignature = this.mapSignature(((FunctionImportedFromObject)f).getFunctionFromObject());
            if (jvmMethodSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapSignature"));
            }
            return jvmMethodSignature;
        }
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD);
        if (f instanceof ConstructorDescriptor) {
            sw.writeParametersStart();
            this.writeAdditionalConstructorParameters((ConstructorDescriptor)f, sw);
            for (ValueParameterDescriptor parameter : valueParameters) {
                this.writeParameter(sw, parameter.getType());
            }
            if (f instanceof AccessorForConstructorDescriptor) {
                JetTypeMapper.writeParameter(sw, JvmMethodParameterKind.CONSTRUCTOR_MARKER, AsmTypes.DEFAULT_CONSTRUCTOR_MARKER);
            }
            JetTypeMapper.writeVoidReturn(sw);
        } else {
            this.writeFormalTypeParameters(JvmCodegenUtil.getDirectMember(f).getTypeParameters(), sw);
            sw.writeParametersStart();
            this.writeThisIfNeeded(f, kind, sw);
            ReceiverParameterDescriptor receiverParameter = f.getExtensionReceiverParameter();
            if (receiverParameter != null) {
                this.writeParameter(sw, JvmMethodParameterKind.RECEIVER, receiverParameter.getType());
            }
            for (ValueParameterDescriptor parameter : valueParameters) {
                if (this.writeCustomParameter(f, parameter, sw)) continue;
                this.writeParameter(sw, parameter.getType());
            }
            sw.writeReturnType();
            this.mapReturnType(f, sw);
            sw.writeReturnTypeEnd();
        }
        JvmMethodSignature signature = sw.makeJvmMethodSignature(this.mapFunctionName(f));
        if (kind != OwnerKind.DEFAULT_IMPLS && (specialSignatureInfo = BuiltinMethodsWithSpecialGenericSignature.getSpecialSignatureInfo(f)) != null) {
            JvmMethodSignature jvmMethodSignature = new JvmMethodSignature(signature.getAsmMethod(), specialSignatureInfo.getSignature(), signature.getValueParameters());
            if (jvmMethodSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapSignature"));
            }
            return jvmMethodSignature;
        }
        JvmMethodSignature jvmMethodSignature = signature;
        if (jvmMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapSignature"));
        }
        return jvmMethodSignature;
    }

    private boolean writeCustomParameter(@NotNull FunctionDescriptor f, @NotNull ValueParameterDescriptor parameter, @NotNull BothSignatureWriter sw) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeCustomParameter"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeCustomParameter"));
        }
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeCustomParameter"));
        }
        FunctionDescriptor overridden = BuiltinMethodsWithSpecialGenericSignature.getOverriddenBuiltinFunctionWithErasedValueParametersInJava(f);
        if (overridden == null) {
            return false;
        }
        if (SpecialBuiltinMembers.isFromJavaOrBuiltins(f)) {
            return false;
        }
        if (overridden.getName().asString().equals("remove") && this.mapType(parameter.getType()).getSort() == 5) {
            this.writeParameter(sw, TypeUtils.makeNullable(parameter.getType()));
            return true;
        }
        return false;
    }

    @NotNull
    public static String getDefaultDescriptor(@NotNull Method method, @Nullable String dispatchReceiverDescriptor, boolean isExtension) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "getDefaultDescriptor"));
        }
        String descriptor2 = method.getDescriptor();
        int argumentsCount = Type.getArgumentTypes(descriptor2).length;
        if (isExtension) {
            --argumentsCount;
        }
        int maskArgumentsCount = (argumentsCount + 32 - 1) / 32;
        String additionalArgs = StringUtil.repeat(Type.INT_TYPE.getDescriptor(), maskArgumentsCount);
        if (JetTypeMapper.isConstructor(method)) {
            additionalArgs = additionalArgs + AsmTypes.DEFAULT_CONSTRUCTOR_MARKER.getDescriptor();
        }
        String result2 = descriptor2.replace(")", additionalArgs + ")");
        if (dispatchReceiverDescriptor != null && !JetTypeMapper.isConstructor(method)) {
            String string = result2.replace("(", "(" + dispatchReceiverDescriptor);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "getDefaultDescriptor"));
            }
            return string;
        }
        String string = result2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "getDefaultDescriptor"));
        }
        return string;
    }

    public ClassBuilderMode getClassBuilderMode() {
        return this.classBuilderMode;
    }

    private static boolean isConstructor(@NotNull Method method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "isConstructor"));
        }
        return "<init>".equals(method.getName());
    }

    @NotNull
    public Method mapDefaultMethod(@NotNull FunctionDescriptor functionDescriptor, @NotNull OwnerKind kind) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapDefaultMethod"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapDefaultMethod"));
        }
        Method jvmSignature = this.mapSignature(functionDescriptor, kind).getAsmMethod();
        Type ownerType = this.mapOwner(functionDescriptor);
        boolean isConstructor = JetTypeMapper.isConstructor(jvmSignature);
        String descriptor2 = JetTypeMapper.getDefaultDescriptor(jvmSignature, AsmUtil.isStaticMethod(kind, functionDescriptor) || isConstructor ? null : ownerType.getDescriptor(), functionDescriptor.getExtensionReceiverParameter() != null);
        Method method = new Method(isConstructor ? "<init>" : jvmSignature.getName() + "$default", descriptor2);
        if (method == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapDefaultMethod"));
        }
        return method;
    }

    private static boolean forceBoxedReturnType(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "forceBoxedReturnType"));
        }
        if (!KotlinBuiltIns.isPrimitiveType(descriptor2.getReturnType())) {
            return false;
        }
        for (FunctionDescriptor overridden : DescriptorUtils.getAllOverriddenDescriptors(descriptor2)) {
            if (KotlinBuiltIns.isPrimitiveType(overridden.getOriginal().getReturnType())) continue;
            return true;
        }
        return false;
    }

    private static void writeVoidReturn(@NotNull BothSignatureWriter sw) {
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeVoidReturn"));
        }
        sw.writeReturnType();
        sw.writeAsmType(Type.VOID_TYPE);
        sw.writeReturnTypeEnd();
    }

    @Nullable
    public String mapFieldSignature(@NotNull KotlinType backingFieldType) {
        if (backingFieldType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backingFieldType", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapFieldSignature"));
        }
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.TYPE);
        this.mapType(backingFieldType, sw, JetTypeMapperMode.VALUE);
        return sw.makeJavaGenericSignature();
    }

    private void writeThisIfNeeded(@NotNull CallableMemberDescriptor descriptor2, @NotNull OwnerKind kind, @NotNull BothSignatureWriter sw) {
        ClassDescriptor thisType;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeThisIfNeeded"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeThisIfNeeded"));
        }
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeThisIfNeeded"));
        }
        if (kind == OwnerKind.DEFAULT_IMPLS) {
            thisType = JetTypeMapper.getTraitImplThisParameterClass((ClassDescriptor)descriptor2.getContainingDeclaration());
        } else if (JetTypeMapper.isAccessor(descriptor2) && descriptor2.getDispatchReceiverParameter() != null) {
            thisType = (ClassDescriptor)descriptor2.getContainingDeclaration();
        } else {
            return;
        }
        this.writeParameter(sw, JvmMethodParameterKind.THIS, thisType.getDefaultType());
    }

    @NotNull
    private static ClassDescriptor getTraitImplThisParameterClass(@NotNull ClassDescriptor traitDescriptor) {
        if (traitDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traitDescriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "getTraitImplThisParameterClass"));
        }
        for (ClassDescriptor descriptor2 : DescriptorUtils.getSuperclassDescriptors(traitDescriptor)) {
            if (descriptor2.getKind() == ClassKind.INTERFACE) continue;
            ClassDescriptor classDescriptor = descriptor2;
            if (classDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "getTraitImplThisParameterClass"));
            }
            return classDescriptor;
        }
        ClassDescriptor classDescriptor = traitDescriptor;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "getTraitImplThisParameterClass"));
        }
        return classDescriptor;
    }

    public void writeFormalTypeParameters(@NotNull List<TypeParameterDescriptor> typeParameters, @NotNull BothSignatureWriter sw) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeFormalTypeParameters"));
        }
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeFormalTypeParameters"));
        }
        for (TypeParameterDescriptor typeParameter : typeParameters) {
            this.writeFormalTypeParameter(typeParameter, sw);
        }
    }

    private void writeFormalTypeParameter(@NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull BothSignatureWriter sw) {
        if (typeParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterDescriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeFormalTypeParameter"));
        }
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeFormalTypeParameter"));
        }
        if (this.classBuilderMode == ClassBuilderMode.LIGHT_CLASSES && typeParameterDescriptor.getName().isSpecial()) {
            return;
        }
        sw.writeFormalTypeParameter(typeParameterDescriptor.getName().asString());
        sw.writeClassBound();
        for (KotlinType jetType : typeParameterDescriptor.getUpperBounds()) {
            if (!(jetType.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor) || JvmCodegenUtil.isJvmInterface(jetType)) continue;
            this.mapType(jetType, sw, JetTypeMapperMode.TYPE_PARAMETER);
            break;
        }
        sw.writeClassBoundEnd();
        for (KotlinType jetType : typeParameterDescriptor.getUpperBounds()) {
            ClassifierDescriptor classifier2 = jetType.getConstructor().getDeclarationDescriptor();
            if (classifier2 instanceof ClassDescriptor) {
                if (!JvmCodegenUtil.isJvmInterface(jetType)) continue;
                sw.writeInterfaceBound();
                this.mapType(jetType, sw, JetTypeMapperMode.TYPE_PARAMETER);
                sw.writeInterfaceBoundEnd();
                continue;
            }
            if (classifier2 instanceof TypeParameterDescriptor) {
                sw.writeInterfaceBound();
                this.mapType(jetType, sw, JetTypeMapperMode.TYPE_PARAMETER);
                sw.writeInterfaceBoundEnd();
                continue;
            }
            throw new UnsupportedOperationException("Unknown classifier: " + classifier2);
        }
    }

    private void writeParameter(@NotNull BothSignatureWriter sw, @NotNull KotlinType type2) {
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeParameter"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeParameter"));
        }
        this.writeParameter(sw, JvmMethodParameterKind.VALUE, type2);
    }

    private void writeParameter(@NotNull BothSignatureWriter sw, @NotNull JvmMethodParameterKind kind, @NotNull KotlinType type2) {
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeParameter"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeParameter"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeParameter"));
        }
        sw.writeParameterType(kind);
        this.mapType(type2, sw, JetTypeMapperMode.VALUE);
        sw.writeParameterTypeEnd();
    }

    private static void writeParameter(@NotNull BothSignatureWriter sw, @NotNull JvmMethodParameterKind kind, @NotNull Type type2) {
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeParameter"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeParameter"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeParameter"));
        }
        sw.writeParameterType(kind);
        sw.writeAsmType(type2);
        sw.writeParameterTypeEnd();
    }

    private void writeAdditionalConstructorParameters(@NotNull ConstructorDescriptor descriptor2, @NotNull BothSignatureWriter sw) {
        ClassDescriptor containingDeclaration;
        KotlinType captureReceiverType;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeAdditionalConstructorParameters"));
        }
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeAdditionalConstructorParameters"));
        }
        MutableClosure closure = this.bindingContext.get(CodegenBinding.CLOSURE, descriptor2.getContainingDeclaration());
        ClassDescriptor captureThis = JvmCodegenUtil.getDispatchReceiverParameterForConstructorCall(descriptor2, closure);
        if (captureThis != null) {
            this.writeParameter(sw, JvmMethodParameterKind.OUTER, captureThis.getDefaultType());
        }
        KotlinType kotlinType = captureReceiverType = closure != null ? closure.getCaptureReceiverType() : null;
        if (captureReceiverType != null) {
            this.writeParameter(sw, JvmMethodParameterKind.RECEIVER, captureReceiverType);
        }
        if ((containingDeclaration = descriptor2.getContainingDeclaration()).getKind() == ClassKind.ENUM_CLASS || containingDeclaration.getKind() == ClassKind.ENUM_ENTRY) {
            this.writeParameter(sw, JvmMethodParameterKind.ENUM_NAME_OR_ORDINAL, DescriptorUtilsKt.getBuiltIns(descriptor2).getStringType());
            this.writeParameter(sw, JvmMethodParameterKind.ENUM_NAME_OR_ORDINAL, DescriptorUtilsKt.getBuiltIns(descriptor2).getIntType());
        }
        if (closure == null) {
            return;
        }
        for (DeclarationDescriptor variableDescriptor : closure.getCaptureVariables().keySet()) {
            Type type2;
            if (variableDescriptor instanceof VariableDescriptor && !(variableDescriptor instanceof PropertyDescriptor)) {
                Type sharedVarType = this.getSharedVarType(variableDescriptor);
                if (sharedVarType == null) {
                    sharedVarType = this.mapType(((VariableDescriptor)variableDescriptor).getType());
                }
                type2 = sharedVarType;
            } else {
                type2 = DescriptorUtils.isLocalFunction(variableDescriptor) ? CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, (FunctionDescriptor)variableDescriptor) : null;
            }
            if (type2 == null) continue;
            closure.setCapturedParameterOffsetInConstructor(variableDescriptor, sw.getCurrentSignatureSize() + 1);
            JetTypeMapper.writeParameter(sw, JvmMethodParameterKind.CAPTURED_LOCAL_VARIABLE, type2);
        }
        if (this.classBuilderMode == ClassBuilderMode.FULL) {
            ResolvedCall<ConstructorDescriptor> superCall = this.findFirstDelegatingSuperCall(descriptor2);
            if (superCall == null) {
                return;
            }
            this.writeSuperConstructorCallParameters(sw, descriptor2, superCall, captureThis != null);
        }
    }

    private void writeSuperConstructorCallParameters(@NotNull BothSignatureWriter sw, @NotNull ConstructorDescriptor descriptor2, @NotNull ResolvedCall<ConstructorDescriptor> superCall, boolean hasOuter) {
        int i;
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeSuperConstructorCallParameters"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeSuperConstructorCallParameters"));
        }
        if (superCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superCall", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeSuperConstructorCallParameters"));
        }
        ConstructorDescriptor superDescriptor = (ConstructorDescriptor)SamCodegenUtil.resolveSamAdapter((FunctionDescriptor)superCall.getResultingDescriptor());
        List<ResolvedValueArgument> valueArguments2 = superCall.getValueArgumentsByIndex();
        assert (valueArguments2 != null) : "Failed to arrange value arguments by index: " + superDescriptor;
        List<JvmMethodParameterSignature> parameters2 = this.mapSignature(superDescriptor).getValueParameters();
        int params = parameters2.size();
        int args = valueArguments2.size();
        assert (params >= args) : String.format("Incorrect number of mapped parameters vs arguments: %d < %d for %s", params, args, descriptor2);
        for (i = 0; i < params - args; ++i) {
            JvmMethodParameterSignature parameter = parameters2.get(i);
            JvmMethodParameterKind kind = parameter.getKind();
            if (kind == JvmMethodParameterKind.ENUM_NAME_OR_ORDINAL || hasOuter && kind == JvmMethodParameterKind.OUTER) continue;
            JetTypeMapper.writeParameter(sw, JvmMethodParameterKind.SUPER_CALL_PARAM, parameter.getAsmType());
        }
        if (DescriptorUtils.isAnonymousObject(descriptor2.getContainingDeclaration())) {
            for (i = 0; i < args; ++i) {
                ResolvedValueArgument valueArgument = valueArguments2.get(i);
                JvmMethodParameterSignature parameter = parameters2.get(params - args + i);
                if (valueArgument instanceof DefaultValueArgument) continue;
                JetTypeMapper.writeParameter(sw, JvmMethodParameterKind.SUPER_CALL_PARAM, parameter.getAsmType());
            }
        }
    }

    @Nullable
    private ResolvedCall<ConstructorDescriptor> findFirstDelegatingSuperCall(@NotNull ConstructorDescriptor descriptor2) {
        ResolvedCall<ConstructorDescriptor> next;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "findFirstDelegatingSuperCall"));
        }
        ClassDescriptor classDescriptor = descriptor2.getContainingDeclaration();
        do {
            if ((next = BindingContextUtils.getDelegationConstructorCall(this.bindingContext, descriptor2)) != null) continue;
            return null;
        } while ((descriptor2 = next.getResultingDescriptor()).getContainingDeclaration() == classDescriptor);
        return next;
    }

    @NotNull
    public JvmMethodSignature mapScriptSignature(@NotNull ScriptDescriptor script, @NotNull List<ScriptDescriptor> importedScripts) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapScriptSignature"));
        }
        if (importedScripts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importedScripts", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapScriptSignature"));
        }
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD);
        sw.writeParametersStart();
        for (ScriptDescriptor importedScript : importedScripts) {
            ClassDescriptor descriptor2 = this.bindingContext.get(CodegenBinding.CLASS_FOR_SCRIPT, importedScript);
            assert (descriptor2 != null) : "Script not found: " + importedScript;
            this.writeParameter(sw, descriptor2.getDefaultType());
        }
        for (ValueParameterDescriptor valueParameter : script.getScriptCodeDescriptor().getValueParameters()) {
            this.writeParameter(sw, valueParameter.getType());
        }
        JetTypeMapper.writeVoidReturn(sw);
        JvmMethodSignature jvmMethodSignature = sw.makeJvmMethodSignature("<init>");
        if (jvmMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapScriptSignature"));
        }
        return jvmMethodSignature;
    }

    public Type getSharedVarType(DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof SimpleFunctionDescriptor && descriptor2.getContainingDeclaration() instanceof FunctionDescriptor) {
            return CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, (FunctionDescriptor)descriptor2);
        }
        if (descriptor2 instanceof PropertyDescriptor || descriptor2 instanceof FunctionDescriptor) {
            ReceiverParameterDescriptor receiverParameter = ((CallableDescriptor)descriptor2).getExtensionReceiverParameter();
            assert (receiverParameter != null) : "Callable should have a receiver parameter: " + descriptor2;
            return StackValue.sharedTypeForType(this.mapType(receiverParameter.getType()));
        }
        if (descriptor2 instanceof VariableDescriptor && BindingContextUtils.isVarCapturedInClosure(this.bindingContext, descriptor2)) {
            return StackValue.sharedTypeForType(this.mapType(((VariableDescriptor)descriptor2).getType()));
        }
        return null;
    }

    public static class ContainingClassesInfo {
        private final ClassId facadeClassId;
        private final ClassId implClassId;

        public ContainingClassesInfo(ClassId facadeClassId, ClassId implClassId) {
            this.facadeClassId = facadeClassId;
            this.implClassId = implClassId;
        }

        public ClassId getFacadeClassId() {
            return this.facadeClassId;
        }

        public ClassId getImplClassId() {
            return this.implClassId;
        }

        @Nullable
        private static ContainingClassesInfo forPackageMemberOrNull(@NotNull FqName packageFqName, @Nullable String facadeClassName, @Nullable String implClassName) {
            if (packageFqName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/codegen/state/JetTypeMapper$ContainingClassesInfo", "forPackageMemberOrNull"));
            }
            if (facadeClassName == null || implClassName == null) {
                return null;
            }
            return new ContainingClassesInfo(ClassId.topLevel(packageFqName.child(Name.identifier(facadeClassName))), ClassId.topLevel(packageFqName.child(Name.identifier(implClassName))));
        }

        @Nullable
        private static ContainingClassesInfo forClassMemberOrNull(@Nullable ClassId classId) {
            if (classId == null) {
                return null;
            }
            return new ContainingClassesInfo(classId, classId);
        }
    }

    private static enum JetTypeMapperMode {
        IMPL,
        VALUE,
        TYPE_PARAMETER,
        SUPER_TYPE,
        VALUE_FOR_ANNOTATION,
        TYPE_PARAMETER_FOR_ANNOTATION;


        boolean isForAnnotation() {
            return this == VALUE_FOR_ANNOTATION || this == TYPE_PARAMETER_FOR_ANNOTATION;
        }
    }
}

