/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration.propertyTranslator;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNew;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.google.dart.compiler.backend.js.ast.JsReturn;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.PreconditionsKt;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.propertyTranslator.PropertyTranslatorKt;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.jsAstUtils.AstUtilsKt;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"w\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u0019Q!\u0001\u0005\b\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tAAA\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!-Q!\u0001\u0003\u0002\u000b\u0005A\u0011!\u0002\u0001\u0006\u0003!\u0005R!\u0001\u0003\u0002\t\u0005a\u0001!G\u0001\u0019\u0002\u0005~\u0011b\u0001\u0005\u0002\u001b\u0005A\u001a!\u0003\u0003\t\u00055\u0011A\u0012\u0001M\u0003\u0013\rA1!D\u0001\u0019\bE\u001b\u0011\u0001\u0003\u0003&\u0011\u0011\t\u0001rB\u0007\u00021\u001dI2\u0001\u0003\u0005\u000e\u0003aEQe\u0005\u0003\u0002\u0011%i\u0011\u0001g\u0002\u001a\u0007!\u0019Q\"\u0001M\u00043\u0019A\u0019\"\u0004\u0003\n\u0005%\t\u0001T\u0003\r\u000b3\rA1\"D\u0001\u0019\u0012\u0015bA!\u0001E\f\u001b\u0005AB\"G\u0002\t\u00115\t\u0001\u0014C\r\u0004\u00113i\u0011\u0001G\u0007&\t\u0011\t\u00012D\u0007\u000211)\u0003\u0002B\u0001\t\u001d5\t\u0001$D\r\u0004\u0011;i\u0011\u0001G\b&\t\u0011\t\u0001rD\u0007\u000211)\u0003\u0002B\u0001\t!5\t\u0001$D\r\u0004\u0011Ci\u0011\u0001G\t&\u001f\u0011\t\u00012E\u0007\u000215I2\u0001#\b\u000e\u0003ay\u0011D\u0002E\n\u001b\u0011I!!C\u0001\u0019\u0016aQQ\u0005\u0002\u0003\u0002\u0011Ii\u0011\u0001\u0007\u0007&\t\u0011\t\u0001RE\u0007\u000211)C\u0001B\u0001\t'5\t\u0001tE\u0013\u0005\t\u0005AA#D\u0001\u0019(\u0015\"A!\u0001E\u0015\u001b\u0005AR#\n\u0003\u0005\u0003!-R\"\u0001\r\u0016K)Aa#D\u0001\u0019.e1\u0001bF\u0007\u0005\u0013\tI\u0011\u0001\u0007\u0007\u00190\u0015BA!\u0001\u0005\u0019\u001b\u0005AB\"G\u0002\t25\t\u0001tE\u0015\f\t\rC\u0001BA\u0007\u0003\u0019\u0003A*!U\u0002\u0005\u000b\u0001i!\u0001\"\u0003\t\u000b%RAa\u0011\u0005\t\u00035\t\u00014A)\u0004\t\u0015\u0001QB\u0001C\u0006\u0011\u0019Is\u0001B!\t\u0011\u001bi\u0011\u0001G\u0004R\u0007\u0005)\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/js/translate/declaration/propertyTranslator/PropertyTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "declaration", "Lorg/jetbrains/kotlin/psi/KtProperty;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;Lorg/jetbrains/kotlin/psi/KtProperty;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "getDeclaration", "()Lorg/jetbrains/kotlin/psi/KtProperty;", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "propertyName", "", "accessorDescription", "accessorDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyAccessorDescriptor;", "contextWithPropertyMetadataCreationIntrinsified", "delegatedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "accessor", "generateDefaultAccessor", "Lcom/google/dart/compiler/backend/js/ast/JsPropertyInitializer;", "function", "Lcom/google/dart/compiler/backend/js/ast/JsFunction;", "generateDefaultGetter", "generateDefaultGetterFunction", "getterDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyGetterDescriptor;", "generateDefaultSetter", "generateDefaultSetterFunction", "setterDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertySetterDescriptor;", "generateDelegatedGetterFunction", "generateGetter", "generateSetter", "getCustomGetterDeclaration", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "getCustomSetterDeclaration", "hasCustomGetter", "", "hasCustomSetter", "translate", "", "result", "", "translateCustomAccessor", "expression"}, moduleName="kotlin-compiler")
public final class PropertyTranslator
extends AbstractTranslator {
    private final String propertyName;
    @NotNull
    private final PropertyDescriptor descriptor;
    @Nullable
    private final KtProperty declaration;

    public final void translate(@NotNull List<JsPropertyInitializer> result2) {
        Intrinsics.checkParameterIsNotNull(result2, "result");
        TranslationContext translationContext = this.context();
        Intrinsics.checkExpressionValueIsNotNull(translationContext, "context()");
        PropertyTranslatorKt.addGetterAndSetter(result2, this.descriptor, translationContext, (Function0<? extends JsPropertyInitializer>)new Function0<JsPropertyInitializer>(this){
            final /* synthetic */ PropertyTranslator this$0;

            @NotNull
            public final JsPropertyInitializer invoke() {
                return PropertyTranslator.access$generateGetter(this.this$0);
            }
            {
                this.this$0 = propertyTranslator;
                super(0);
            }
        }, (Function0<? extends JsPropertyInitializer>)new Function0<JsPropertyInitializer>(this){
            final /* synthetic */ PropertyTranslator this$0;

            @NotNull
            public final JsPropertyInitializer invoke() {
                return PropertyTranslator.access$generateSetter(this.this$0);
            }
            {
                this.this$0 = propertyTranslator;
                super(0);
            }
        });
    }

    private final JsPropertyInitializer generateGetter() {
        return this.hasCustomGetter() ? this.translateCustomAccessor(this.getCustomGetterDeclaration()) : this.generateDefaultGetter();
    }

    private final JsPropertyInitializer generateSetter() {
        return this.hasCustomSetter() ? this.translateCustomAccessor(this.getCustomSetterDeclaration()) : this.generateDefaultSetter();
    }

    private final boolean hasCustomGetter() {
        KtProperty ktProperty = this.declaration;
        return (ktProperty != null ? ktProperty.getGetter() : null) != null && this.getCustomGetterDeclaration().hasBody();
    }

    private final boolean hasCustomSetter() {
        KtProperty ktProperty = this.declaration;
        return (ktProperty != null ? ktProperty.getSetter() : null) != null && this.getCustomSetterDeclaration().hasBody();
    }

    private final KtPropertyAccessor getCustomGetterDeclaration() {
        KtDeclarationStub ktDeclarationStub = this.declaration;
        if (ktDeclarationStub == null || (ktDeclarationStub = ktDeclarationStub.getGetter()) == null) {
            throw (Throwable)new IllegalStateException("declaration and getter should not be null descriptor=" + this.descriptor + " declaration=" + this.declaration);
        }
        Intrinsics.checkExpressionValueIsNotNull(ktDeclarationStub, "declaration?.getGetter()\u2026laration=${declaration}\")");
        return ktDeclarationStub;
    }

    private final KtPropertyAccessor getCustomSetterDeclaration() {
        KtDeclarationStub ktDeclarationStub = this.declaration;
        if (ktDeclarationStub == null || (ktDeclarationStub = ktDeclarationStub.getSetter()) == null) {
            throw (Throwable)new IllegalStateException("declaration and setter should not be null descriptor=" + this.descriptor + " declaration=" + this.declaration);
        }
        Intrinsics.checkExpressionValueIsNotNull(ktDeclarationStub, "declaration?.getSetter()\u2026laration=${declaration}\")");
        return ktDeclarationStub;
    }

    private final JsPropertyInitializer generateDefaultGetter() {
        PropertyGetterDescriptor propertyGetterDescriptor = this.descriptor.getGetter();
        if (propertyGetterDescriptor == null) {
            throw (Throwable)new IllegalStateException("Getter descriptor should not be null");
        }
        PropertyGetterDescriptor getterDescriptor = propertyGetterDescriptor;
        PropertyAccessorDescriptor propertyAccessorDescriptor = getterDescriptor;
        Intrinsics.checkExpressionValueIsNotNull(propertyAccessorDescriptor, "getterDescriptor");
        PropertyGetterDescriptor propertyGetterDescriptor2 = getterDescriptor;
        Intrinsics.checkExpressionValueIsNotNull(propertyGetterDescriptor2, "getterDescriptor");
        return this.generateDefaultAccessor(propertyAccessorDescriptor, this.generateDefaultGetterFunction(propertyGetterDescriptor2));
    }

    private final JsFunction generateDefaultGetterFunction(PropertyGetterDescriptor getterDescriptor) {
        ResolvedCall delegatedCall = (ResolvedCall)this.bindingContext().get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, getterDescriptor);
        if (delegatedCall != null) {
            return this.generateDelegatedGetterFunction(getterDescriptor, delegatedCall);
        }
        boolean value2 = !DescriptorUtilsKt.isExtension(this.descriptor);
        if (PreconditionsKt.getASSERTIONS_ENABLED() && !value2) {
            String message = "Unexpected extension property " + this.getDescriptor() + "}";
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        JsScope scope2 = this.context().getScopeForDescriptor(getterDescriptor.getContainingDeclaration());
        JsNameRef result2 = TranslationUtils.backingFieldReference(this.context(), this.descriptor);
        JsBlock body = new JsBlock(new JsReturn(result2));
        return new JsFunction(scope2, body, this.accessorDescription(getterDescriptor));
    }

    private final JsFunction generateDelegatedGetterFunction(PropertyGetterDescriptor getterDescriptor, ResolvedCall<FunctionDescriptor> delegatedCall) {
        JsScope scope2 = this.context().getScopeForDescriptor(getterDescriptor.getContainingDeclaration());
        JsFunction function = new JsFunction(scope2, new JsBlock(), this.accessorDescription(getterDescriptor));
        JsNameRef delegateRef = Namer.getDelegateNameRef(this.propertyName);
        TranslationContext translationContext = this.context();
        Intrinsics.checkExpressionValueIsNotNull(translationContext, "context()");
        JsExpression delegatedJsCall = CallTranslator.translate(this.contextWithPropertyMetadataCreationIntrinsified(translationContext, delegatedCall, getterDescriptor), delegatedCall, delegateRef);
        if (DescriptorUtilsKt.isExtension(getterDescriptor)) {
            String string = Namer.getReceiverParameterName();
            Intrinsics.checkExpressionValueIsNotNull(string, "getReceiverParameterName()");
            JsName receiver = AstUtilsKt.addParameter$default(function, string, null, 2).getName();
            JsExpression jsExpression = delegatedJsCall;
            if (jsExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.google.dart.compiler.backend.js.ast.JsInvocation");
            }
            List<JsExpression> arguments2 = ((JsInvocation)jsExpression).getArguments();
            arguments2.set(0, receiver.makeRef());
        }
        JsReturn returnResult = new JsReturn(delegatedJsCall);
        AstUtilsKt.addStatement(function, returnResult);
        return function;
    }

    private final TranslationContext contextWithPropertyMetadataCreationIntrinsified(TranslationContext context, ResolvedCall<FunctionDescriptor> delegatedCall, PropertyAccessorDescriptor accessor) {
        JsStringLiteral propertyNameLiteral = context.program().getStringLiteral(accessor.getCorrespondingProperty().getName().asString());
        List<ResolvedValueArgument> list = delegatedCall.getValueArgumentsByIndex();
        if (list == null) {
            Intrinsics.throwNpe();
        }
        ResolvedValueArgument resolvedValueArgument = list.get(1);
        if (resolvedValueArgument == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument");
        }
        ValueArgument valueArgument = ((ExpressionValueArgument)resolvedValueArgument).getValueArgument();
        if (valueArgument == null) {
            Intrinsics.throwNpe();
        }
        KtExpression fakeArgumentExpression = valueArgument.getArgumentExpression();
        TranslationContext translationContext = context.innerContextWithAliasesForExpressions(MapsKt.mapOf(TuplesKt.to(fakeArgumentExpression, new JsNew(new JsNameRef("PropertyMetadata", "Kotlin"), CollectionsKt.listOf(propertyNameLiteral)))));
        Intrinsics.checkExpressionValueIsNotNull(translationContext, "context.innerContextWith\u2026yNameLiteral))\n        ))");
        return translationContext;
    }

    private final JsPropertyInitializer generateDefaultSetter() {
        PropertySetterDescriptor propertySetterDescriptor = this.descriptor.getSetter();
        if (propertySetterDescriptor == null) {
            throw (Throwable)new IllegalStateException("Setter descriptor should not be null");
        }
        PropertySetterDescriptor setterDescriptor = propertySetterDescriptor;
        PropertyAccessorDescriptor propertyAccessorDescriptor = setterDescriptor;
        Intrinsics.checkExpressionValueIsNotNull(propertyAccessorDescriptor, "setterDescriptor");
        PropertySetterDescriptor propertySetterDescriptor2 = setterDescriptor;
        Intrinsics.checkExpressionValueIsNotNull(propertySetterDescriptor2, "setterDescriptor");
        return this.generateDefaultAccessor(propertyAccessorDescriptor, this.generateDefaultSetterFunction(propertySetterDescriptor2));
    }

    /*
     * WARNING - void declaration
     */
    private final JsFunction generateDefaultSetterFunction(PropertySetterDescriptor setterDescriptor) {
        String correspondingPropertyName;
        void value2;
        void $receiver22;
        JsScope containingScope = this.context().getScopeForDescriptor(setterDescriptor.getContainingDeclaration());
        JsFunction function = new JsFunction(containingScope, new JsBlock(), this.accessorDescription(setterDescriptor));
        Collection collection = setterDescriptor.getValueParameters();
        boolean $receiver22 = $receiver22.size() == 1;
        if (PreconditionsKt.getASSERTIONS_ENABLED() && value2 == false) {
            String message = "Setter must have 1 parameter";
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        String string = correspondingPropertyName = setterDescriptor.getCorrespondingProperty().getName().asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "correspondingPropertyName");
        JsName valueParameter = AstUtilsKt.addParameter$default(function, string, null, 2).getName();
        TranslationContext withAliased = this.context().innerContextWithAliased(setterDescriptor.getValueParameters().get(0), valueParameter.makeRef());
        ResolvedCall delegatedCall = (ResolvedCall)this.context().bindingContext().get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, setterDescriptor);
        if (delegatedCall != null) {
            TranslationContext translationContext = withAliased;
            Intrinsics.checkExpressionValueIsNotNull(translationContext, "withAliased");
            JsExpression delegatedJsCall = CallTranslator.translate(this.contextWithPropertyMetadataCreationIntrinsified(translationContext, delegatedCall, setterDescriptor), delegatedCall, Namer.getDelegateNameRef(correspondingPropertyName));
            JsStatement jsStatement = delegatedJsCall.makeStmt();
            Intrinsics.checkExpressionValueIsNotNull(jsStatement, "delegatedJsCall.makeStmt()");
            AstUtilsKt.addStatement(function, jsStatement);
            if (DescriptorUtilsKt.isExtension(setterDescriptor)) {
                String string2 = Namer.getReceiverParameterName();
                Intrinsics.checkExpressionValueIsNotNull(string2, "getReceiverParameterName()");
                JsName receiver = AstUtilsKt.addParameter(function, string2, 0).getName();
                JsExpression jsExpression = delegatedJsCall;
                if (jsExpression == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.google.dart.compiler.backend.js.ast.JsInvocation");
                }
                ((JsInvocation)jsExpression).getArguments().set(0, receiver.makeRef());
            }
        } else {
            void value3;
            boolean delegatedJsCall = !DescriptorUtilsKt.isExtension(this.descriptor);
            if (PreconditionsKt.getASSERTIONS_ENABLED() && value3 == false) {
                String message = "Unexpected extension property " + this.getDescriptor() + "}";
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            JsExpression assignment = TranslationUtils.assignmentToBackingField(withAliased, this.descriptor, valueParameter.makeRef());
            JsStatement jsStatement = assignment.makeStmt();
            Intrinsics.checkExpressionValueIsNotNull(jsStatement, "assignment.makeStmt()");
            AstUtilsKt.addStatement(function, jsStatement);
        }
        return function;
    }

    private final JsPropertyInitializer generateDefaultAccessor(PropertyAccessorDescriptor accessorDescriptor, JsFunction function) {
        JsPropertyInitializer jsPropertyInitializer = TranslationUtils.translateFunctionAsEcma5PropertyDescriptor(function, accessorDescriptor, this.context());
        Intrinsics.checkExpressionValueIsNotNull(jsPropertyInitializer, "translateFunctionAsEcma5\u2026sorDescriptor, context())");
        return jsPropertyInitializer;
    }

    private final JsPropertyInitializer translateCustomAccessor(KtPropertyAccessor expression) {
        JsPropertyInitializer jsPropertyInitializer = Translation.functionTranslator(expression, this.context()).translateAsEcma5PropertyDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(jsPropertyInitializer, "Translation.functionTran\u2026Ecma5PropertyDescriptor()");
        return jsPropertyInitializer;
    }

    private final String accessorDescription(PropertyAccessorDescriptor accessorDescriptor) {
        String string;
        PropertyAccessorDescriptor propertyAccessorDescriptor = accessorDescriptor;
        if (propertyAccessorDescriptor instanceof PropertyGetterDescriptor) {
            string = "getter";
        } else if (propertyAccessorDescriptor instanceof PropertySetterDescriptor) {
            string = "setter";
        } else {
            throw (Throwable)new IllegalArgumentException("Unknown accessor type " + accessorDescriptor.getClass());
        }
        String accessorType = string;
        String name = accessorDescriptor.getName().asString();
        return accessorType + " for " + name;
    }

    @NotNull
    public final PropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Nullable
    public final KtProperty getDeclaration() {
        return this.declaration;
    }

    public PropertyTranslator(@NotNull PropertyDescriptor descriptor2, @Nullable KtProperty declaration, @NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(context, "context");
        super(context);
        this.descriptor = descriptor2;
        this.declaration = declaration;
        String string = this.descriptor.getName().asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "descriptor.getName().asString()");
        this.propertyName = string;
    }

    @NotNull
    public static final /* synthetic */ JsPropertyInitializer access$generateGetter(PropertyTranslator $this) {
        return $this.generateGetter();
    }

    @NotNull
    public static final /* synthetic */ JsPropertyInitializer access$generateSetter(PropertyTranslator $this) {
        return $this.generateSetter();
    }
}

