/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsExpressionImpl;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import kotlin.PreconditionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.KotlinType;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"C\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!-Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!9\u0001B2\u0002\u0019\u0001I\u0012\u0001'\u0001\"\b\u0011\t\u0011kA\u0001\t\u0003\u0015BA!\u0001E\u0002\u001b\u0005A\"!G\u0002\t\u00065\t\u0001dA\u0013\t\t\u0005A9!D\u0001\u0019\u0005e\u0019\u0001RA\u0007\u00021\r)\u0003\u0002B\u0001\t\t5\t\u0001DA\r\u0004\u0011\u000bi\u0011\u0001G\u0002&\u0011\u0011\t\u0001\u0012B\u0007\u00021\u0015I2\u0001#\u0002\u000e\u0003a-Q\u0005\u0004\u0003\u0002\u0011\u0019i\u0011\u0001G\u0003\u001a\u0007!5Q\"\u0001\r\b3\rAy!D\u0001\u0019\u0011\u0015Z\u0001\u0012C\u0007\u00021\u0015I2\u0001c\u0004\u000e\u0003aA\u0011d\u0001E\u0007\u001b\u0005Ar!\n\t\u0005\u0003!IQ\"\u0001\r\u00063\rA)!D\u0001\u0019\u0007e\u0019\u00012C\u0007\u00021)I2\u0001#\u0004\u000e\u0003a9Q\u0005\u0004\u0003\u0002\u0011+i\u0011\u0001G\u0003\u001a\u0007!\u0015Q\"\u0001\r\f3\rAi!D\u0001\u0019\u000f\u0015bA!\u0001E\f\u001b\u0005AR!G\u0002\t\u00065\t\u0001dC\r\u0004\u0011\u001bi\u0011\u0001G\u0004&\u0019\u0011\t\u0001\u0002D\u0007\u00021\u0015I2\u0001#\u0002\u000e\u0003a-\u0011d\u0001E\u0007\u001b\u0005Ar!\n\t\u0005\u0003!eQ\"\u0001\r\u00063\rA)!D\u0001\u0019\u0017e\u0019\u0001RB\u0007\u00021\u001dI2\u0001c\u0004\u000e\u0003aAQ\u0005\u0004\u0003\u0002\u00115i\u0011\u0001G\u0003\u001a\u0007!\u0015Q\"\u0001\r\f3\rAi!D\u0001\u0019\u000f\u0015bA!\u0001E\u000e\u001b\u0005AR!G\u0002\t\u00065\t\u00014B\r\u0004\u0011\u001bi\u0011\u0001G\u0004&!\u0011\t\u0001BD\u0007\u00021\u0015I2\u0001#\u0002\u000e\u0003a-\u0011d\u0001E\u0007\u001b\u0005Ar!G\u0002\t\u00105\t\u0001\u0004C\u0013\r\t\u0005Ai\"D\u0001\u0019\u000be\u0019\u0001RA\u0007\u00021\u0017I2\u0001#\u0004\u000e\u0003a9\u0001"}, strings={"Lorg/jetbrains/kotlin/js/translate/reference/CallableReferenceTranslator;", "", "()V", "isConstructor", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "isExtension", "isMember", "isVar", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "reportNotSupported", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "expression", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "translate", "translateAsMemberFunctionReference", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "translateForConstructor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "translateForExtensionFunction", "translateForExtensionProperty", "translateForFunction", "translateForMemberFunction", "translateForMemberProperty", "translateForProperty", "translateForTopLevelProperty"}, moduleName="kotlin-compiler")
public final class CallableReferenceTranslator {
    public static final CallableReferenceTranslator INSTANCE;
    public static final CallableReferenceTranslator INSTANCE$;

    @NotNull
    public final JsExpression translate(@NotNull KtCallableReferenceExpression expression, @NotNull TranslationContext context) {
        JsExpression jsExpression;
        DeclarationDescriptor descriptor2;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        DeclarationDescriptor declarationDescriptor = descriptor2 = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), expression.getCallableReference());
        if (declarationDescriptor instanceof PropertyDescriptor) {
            jsExpression = this.translateForProperty((PropertyDescriptor)descriptor2, context, expression);
        } else if (declarationDescriptor instanceof FunctionDescriptor) {
            jsExpression = this.translateForFunction((FunctionDescriptor)descriptor2, context, expression);
        } else {
            throw (Throwable)new IllegalArgumentException("Expected property or function: " + descriptor2 + ", expression=" + expression.getText());
        }
        return jsExpression;
    }

    private final JsExpression reportNotSupported(TranslationContext context, KtCallableReferenceExpression expression) {
        context.bindingTrace().report(ErrorsJs.REFERENCE_TO_BUILTIN_MEMBERS_NOT_SUPPORTED.on((KtElement)((PsiElement)expression), expression));
        JsExpression jsExpression = context.getEmptyExpression();
        Intrinsics.checkExpressionValueIsNotNull(jsExpression, "context.getEmptyExpression()");
        return jsExpression;
    }

    private final JsExpression translateForFunction(FunctionDescriptor descriptor2, TranslationContext context, KtCallableReferenceExpression expression) {
        JsExpression jsExpression;
        if (JsDescriptorUtils.isBuiltin(descriptor2)) {
            jsExpression = this.reportNotSupported(context, expression);
        } else if (this.isConstructor(descriptor2)) {
            jsExpression = this.translateForConstructor(descriptor2, context);
        } else if (this.isExtension(descriptor2)) {
            jsExpression = this.translateForExtensionFunction(descriptor2, context);
        } else if (this.isMember(descriptor2)) {
            jsExpression = this.translateForMemberFunction(descriptor2, context);
        } else {
            JsExpression jsExpression2 = ReferenceTranslator.translateAsFQReference(descriptor2, context);
            jsExpression = jsExpression2;
            Intrinsics.checkExpressionValueIsNotNull(jsExpression2, "ReferenceTranslator.tran\u2026ence(descriptor, context)");
        }
        return jsExpression;
    }

    private final JsExpression translateForProperty(PropertyDescriptor descriptor2, TranslationContext context, KtCallableReferenceExpression expression) {
        return JsDescriptorUtils.isBuiltin(descriptor2) ? this.reportNotSupported(context, expression) : (this.isExtension(descriptor2) ? this.translateForExtensionProperty(descriptor2, context) : (this.isMember(descriptor2) ? this.translateForMemberProperty(descriptor2, context) : this.translateForTopLevelProperty(descriptor2, context)));
    }

    private final boolean isConstructor(CallableDescriptor descriptor2) {
        return descriptor2 instanceof ConstructorDescriptor;
    }

    private final boolean isExtension(CallableDescriptor descriptor2) {
        return DescriptorUtils.isExtension(descriptor2);
    }

    private final boolean isMember(CallableDescriptor descriptor2) {
        return JsDescriptorUtils.getContainingDeclaration(descriptor2) instanceof ClassDescriptor;
    }

    private final JsExpression isVar(PropertyDescriptor descriptor2) {
        return descriptor2.isVar() ? JsLiteral.TRUE : JsLiteral.FALSE;
    }

    /*
     * WARNING - void declaration
     */
    private final JsExpression translateForTopLevelProperty(PropertyDescriptor descriptor2, TranslationContext context) {
        void value2;
        DeclarationDescriptor packageDescriptor = JsDescriptorUtils.getContainingDeclaration(descriptor2);
        boolean bl = packageDescriptor instanceof PackageFragmentDescriptor;
        if (PreconditionsKt.getASSERTIONS_ENABLED() && value2 == false) {
            String message = "Expected PackageFragmentDescriptor: " + packageDescriptor;
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        JsNameRef jsPackageNameRef = context.getQualifiedReference(packageDescriptor);
        JsName jsPropertyName = context.getNameForDescriptor(descriptor2);
        JsStringLiteral jsPropertyNameAsString = context.program().getStringLiteral(jsPropertyName.toString());
        return new JsInvocation(context.namer().callableRefForTopLevelPropertyReference(), jsPackageNameRef, jsPropertyNameAsString, this.isVar(descriptor2));
    }

    private final JsExpression translateForMemberProperty(PropertyDescriptor descriptor2, TranslationContext context) {
        JsName jsPropertyName = context.getNameForDescriptor(descriptor2);
        JsStringLiteral jsPropertyNameAsString = context.program().getStringLiteral(jsPropertyName.toString());
        return new JsInvocation(context.namer().callableRefForMemberPropertyReference(), jsPropertyNameAsString, this.isVar(descriptor2));
    }

    private final JsExpression translateForExtensionProperty(PropertyDescriptor descriptor2, TranslationContext context) {
        PropertyGetterDescriptor propertyGetterDescriptor = descriptor2.getGetter();
        if (propertyGetterDescriptor == null) {
            Intrinsics.throwNpe();
        }
        JsNameRef jsGetterNameRef = context.getQualifiedReference(propertyGetterDescriptor);
        Name propertyName = descriptor2.getName();
        JsStringLiteral jsPropertyNameAsString = context.program().getStringLiteral(propertyName.asString());
        ArrayList<JsExpressionImpl> argumentList2 = new ArrayList<JsExpressionImpl>(3);
        argumentList2.add(jsPropertyNameAsString);
        argumentList2.add(jsGetterNameRef);
        if (descriptor2.isVar()) {
            PropertySetterDescriptor propertySetterDescriptor = descriptor2.getSetter();
            if (propertySetterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            JsNameRef jsSetterNameRef = context.getQualifiedReference(propertySetterDescriptor);
            argumentList2.add(jsSetterNameRef);
        }
        if (AnnotationsUtils.isNativeObject(descriptor2)) {
            return this.translateForMemberProperty(descriptor2, context);
        }
        return new JsInvocation(context.namer().callableRefForExtensionPropertyReference(), (List<JsExpression>)argumentList2);
    }

    private final JsExpression translateForConstructor(FunctionDescriptor descriptor2, TranslationContext context) {
        JsExpression jsFunctionRef = ReferenceTranslator.translateAsFQReference(descriptor2, context);
        return new JsInvocation(context.namer().callableRefForConstructorReference(), jsFunctionRef);
    }

    /*
     * WARNING - void declaration
     */
    private final JsExpression translateForExtensionFunction(FunctionDescriptor descriptor2, TranslationContext context) {
        void value2;
        ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
        boolean bl = receiverParameterDescriptor != null;
        if (PreconditionsKt.getASSERTIONS_ENABLED() && value2 == false) {
            String message = "receiverParameter for extension should not be null";
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        JsExpression jsFunctionRef = ReferenceTranslator.translateAsFQReference(descriptor2, context);
        if (Intrinsics.areEqual(descriptor2.getVisibility(), Visibilities.LOCAL)) {
            return new JsInvocation(context.namer().callableRefForLocalExtensionFunctionReference(), jsFunctionRef);
        }
        if (AnnotationsUtils.isNativeObject(descriptor2)) {
            ReceiverParameterDescriptor receiverParameterDescriptor2 = receiverParameterDescriptor;
            if (receiverParameterDescriptor2 == null) {
                Intrinsics.throwNpe();
            }
            KotlinType jetType = receiverParameterDescriptor2.getType();
            ClassDescriptor receiverClassDescriptor = DescriptorUtils.getClassDescriptorForType(jetType);
            CallableDescriptor callableDescriptor = descriptor2;
            ClassDescriptor classDescriptor = receiverClassDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "receiverClassDescriptor");
            return this.translateAsMemberFunctionReference(callableDescriptor, classDescriptor, context);
        }
        return new JsInvocation(context.namer().callableRefForExtensionFunctionReference(), jsFunctionRef);
    }

    private final JsExpression translateForMemberFunction(FunctionDescriptor descriptor2, TranslationContext context) {
        DeclarationDescriptor declarationDescriptor = JsDescriptorUtils.getContainingDeclaration(descriptor2);
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor == null) {
            throw (Throwable)new IllegalArgumentException("Expected ClassDescriptor: " + descriptor2);
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        return this.translateAsMemberFunctionReference(descriptor2, classDescriptor2, context);
    }

    private final JsExpression translateAsMemberFunctionReference(CallableDescriptor descriptor2, ClassDescriptor classDescriptor, TranslationContext context) {
        JsNameRef jsClassNameRef = context.getQualifiedReference(classDescriptor);
        JsName funName = context.getNameForDescriptor(descriptor2);
        JsStringLiteral funNameAsString = context.program().getStringLiteral(funName.toString());
        return new JsInvocation(context.namer().callableRefForMemberFunctionReference(), jsClassNameRef, funNameAsString);
    }

    static {
        new CallableReferenceTranslator();
    }

    private CallableReferenceTranslator() {
        INSTANCE = this;
        INSTANCE$ = this;
    }
}

