/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java;

import kotlin.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.deserialization.BinaryVersion;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

public final class JvmAbi {
    public static final BinaryVersion VERSION = BinaryVersion.create(1, 0, 0);
    public static final String DEFAULT_IMPLS_CLASS_NAME = "DefaultImpls";
    public static final String DEFAULT_IMPLS_SUFFIX = "$DefaultImpls";
    public static final String DEFAULT_PARAMS_IMPL_SUFFIX = "$default";
    public static final String DELEGATED_PROPERTY_NAME_SUFFIX = "$delegate";
    public static final String DELEGATED_PROPERTIES_ARRAY_NAME = "$delegatedProperties";
    public static final String ANNOTATED_PROPERTY_METHOD_NAME_SUFFIX = "$annotations";
    public static final String INSTANCE_FIELD = "INSTANCE";
    public static final String DEPRECATED_INSTANCE_FIELD = "INSTANCE$";
    public static final String MODULE_NAME_FIELD = "$moduleName";
    public static final String DEFAULT_MODULE_NAME = "main";
    public static final ClassId REFLECTION_FACTORY_IMPL = ClassId.topLevel(new FqName("kotlin.reflect.jvm.internal.ReflectionFactoryImpl"));
    public static final String LOCAL_VARIABLE_NAME_PREFIX_INLINE_ARGUMENT = "$i$a$";
    public static final String LOCAL_VARIABLE_NAME_PREFIX_INLINE_FUNCTION = "$i$f$";

    @NotNull
    public static String getSyntheticMethodNameForAnnotatedProperty(@NotNull Name propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/kotlin/load/java/JvmAbi", "getSyntheticMethodNameForAnnotatedProperty"));
        }
        String string = propertyName.asString() + ANNOTATED_PROPERTY_METHOD_NAME_SUFFIX;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/JvmAbi", "getSyntheticMethodNameForAnnotatedProperty"));
        }
        return string;
    }

    public static boolean isGetterName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/java/JvmAbi", "isGetterName"));
        }
        return name.startsWith("get") || name.startsWith("is");
    }

    public static boolean isSetterName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/java/JvmAbi", "isSetterName"));
        }
        return name.startsWith("set");
    }

    @NotNull
    public static String getterName(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/kotlin/load/java/JvmAbi", "getterName"));
        }
        String string = JvmAbi.startsWithIsPrefix(propertyName) ? propertyName : "get" + CapitalizeDecapitalizeKt.capitalizeAsciiOnly(propertyName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/JvmAbi", "getterName"));
        }
        return string;
    }

    @NotNull
    public static String setterName(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/kotlin/load/java/JvmAbi", "setterName"));
        }
        String string = JvmAbi.startsWithIsPrefix(propertyName) ? "set" + propertyName.substring("is".length()) : "set" + CapitalizeDecapitalizeKt.capitalizeAsciiOnly(propertyName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/JvmAbi", "setterName"));
        }
        return string;
    }

    public static boolean startsWithIsPrefix(String name) {
        if (!name.startsWith("is")) {
            return false;
        }
        if (name.length() == "is".length()) {
            return false;
        }
        char c = name.charAt("is".length());
        return 'a' > c || c > 'z';
    }

    @NotNull
    public static String sanitizeAsJavaIdentifier(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "org/jetbrains/kotlin/load/java/JvmAbi", "sanitizeAsJavaIdentifier"));
        }
        String string = StringsKt.replace(str, StringsKt.toRegex("[^\\p{L}\\p{Digit}]"), "_");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/JvmAbi", "sanitizeAsJavaIdentifier"));
        }
        return string;
    }
}

