/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.sam;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.load.java.components.SamConversionResolver;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaConstructorDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.SamAdapterDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.SamConstructorDescriptor;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaClassDescriptor;
import org.jetbrains.kotlin.load.java.sam.SingleAbstractMethodUtils;
import org.jetbrains.kotlin.load.java.sources.JavaSourceElement;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaElement;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.KtScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"E\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011E)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005!)!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0005G\u0006a\u0001!G\u0001\u0019\u0002\u0005\u001eA!A)\u0004\u0003!\tQe\u0003\u0003\u0002\u0011\u0007i\u0011\u0001\u0007\u0002\u001a\r!\u0015Q\u0002B\u0005\u0003\u0013\u0005A:\u0001G\u0002&'\u0011Y\u0001\u0002B\u0007\u0003\u0019\u0003A:!G\u0002\t\n5\t\u0001$B\r\n\u0011\u0017iq!\u0003\u0002\n\u0003a5\u0011BA\u0005\u00021\u001dAb!*\t\u0005\u0018!=QB\u0001G\u0001I!\tB\u0001\u0002\u0001\t\u0011U\t\u0001dB\r\u0004\u0011#i\u0011\u0001\n\u0005R\u0007\u0005A\u0011\"J\u0007\u0005\u0017!MQB\u0001G\u00011)I2\u0001#\u0006\u000e\u0003aY\u0011d\u0001E\f\u001b\u0005AB\u0002"}, strings={"Lorg/jetbrains/kotlin/load/java/sam/SamConversionResolverImpl;", "Lorg/jetbrains/kotlin/load/java/components/SamConversionResolver;", "()V", "findFunctionWithMostSpecificReturnType", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "supertypes", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "resolveFunctionTypeIfSamInterface", "classDescriptor", "Lorg/jetbrains/kotlin/load/java/descriptors/JavaClassDescriptor;", "resolveMethod", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/load/java/structure/JavaMethod;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "resolveSamAdapter", "D", "original", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "resolveSamConstructor", "Lorg/jetbrains/kotlin/load/java/descriptors/SamConstructorDescriptor;", "name", "Lorg/jetbrains/kotlin/name/Name;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/KtScope;"}, moduleName="kotlin-compiler")
public final class SamConversionResolverImpl
implements SamConversionResolver {
    public static final SamConversionResolverImpl INSTANCE;
    public static final SamConversionResolverImpl INSTANCE$;

    @Override
    @Nullable
    public SamConstructorDescriptor resolveSamConstructor(@NotNull Name name, @NotNull KtScope scope2) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        ClassifierDescriptor classifierDescriptor = scope2.getClassifier(name);
        if (!(classifierDescriptor instanceof LazyJavaClassDescriptor)) {
            classifierDescriptor = null;
        }
        LazyJavaClassDescriptor lazyJavaClassDescriptor = (LazyJavaClassDescriptor)classifierDescriptor;
        if (lazyJavaClassDescriptor == null) {
            return null;
        }
        LazyJavaClassDescriptor classifier2 = lazyJavaClassDescriptor;
        if (classifier2.getFunctionTypeForSamInterface() == null) {
            return null;
        }
        return SingleAbstractMethodUtils.createSamConstructorFunction(scope2.getContainingDeclaration(), classifier2);
    }

    @Override
    @Nullable
    public <D extends FunctionDescriptor> D resolveSamAdapter(@NotNull D original) {
        FunctionDescriptor functionDescriptor;
        Intrinsics.checkParameterIsNotNull(original, "original");
        if (!SingleAbstractMethodUtils.isSamAdapterNecessary(original)) {
            functionDescriptor = null;
        } else if (original instanceof JavaConstructorDescriptor) {
            SamAdapterDescriptor<JavaConstructorDescriptor> samAdapterDescriptor = SingleAbstractMethodUtils.createSamAdapterConstructor((JavaConstructorDescriptor)original);
            if (samAdapterDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type D");
            }
            functionDescriptor = samAdapterDescriptor;
        } else if (original instanceof JavaMethodDescriptor) {
            SamAdapterDescriptor<JavaMethodDescriptor> samAdapterDescriptor = SingleAbstractMethodUtils.createSamAdapterFunction((JavaMethodDescriptor)original);
            if (samAdapterDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type D");
            }
            functionDescriptor = samAdapterDescriptor;
        } else {
            functionDescriptor = null;
        }
        return (D)functionDescriptor;
    }

    @Override
    @Nullable
    public KotlinType resolveFunctionTypeIfSamInterface(@NotNull JavaClassDescriptor classDescriptor, @NotNull Function1<? super JavaMethod, ? extends FunctionDescriptor> resolveMethod) {
        FunctionDescriptor functionDescriptor;
        Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
        Intrinsics.checkParameterIsNotNull(resolveMethod, "resolveMethod");
        SourceElement sourceElement = classDescriptor.getSource();
        if (!(sourceElement instanceof JavaSourceElement)) {
            sourceElement = null;
        }
        JavaSourceElement javaSourceElement = (JavaSourceElement)sourceElement;
        JavaElement javaElement = javaSourceElement != null ? javaSourceElement.getJavaElement() : null;
        if (!(javaElement instanceof JavaClass)) {
            javaElement = null;
        }
        JavaClass javaClass = (JavaClass)javaElement;
        if (javaClass == null) {
            return null;
        }
        JavaClass jClass = javaClass;
        JavaMethod javaMethod = SingleAbstractMethodUtils.getSamInterfaceMethod(jClass);
        if (javaMethod == null) {
            return null;
        }
        JavaMethod samInterfaceMethod = javaMethod;
        if (Intrinsics.areEqual(jClass.getFqName(), samInterfaceMethod.getContainingClass().getFqName())) {
            JavaMethod javaMethod2 = samInterfaceMethod;
            Intrinsics.checkExpressionValueIsNotNull(javaMethod2, "samInterfaceMethod");
            functionDescriptor = resolveMethod.invoke(javaMethod2);
        } else {
            Set<KotlinType> set = TypeUtils.getAllSupertypes(classDescriptor.getDefaultType());
            Intrinsics.checkExpressionValueIsNotNull(set, "TypeUtils.getAllSupertyp\u2026criptor.getDefaultType())");
            functionDescriptor = this.findFunctionWithMostSpecificReturnType(set);
        }
        FunctionDescriptor abstractMethod = functionDescriptor;
        return SingleAbstractMethodUtils.getFunctionTypeForAbstractMethod(abstractMethod);
    }

    /*
     * WARNING - void declaration
     */
    private final SimpleFunctionDescriptor findFunctionWithMostSpecificReturnType(Set<? extends KotlinType> supertypes2) {
        void var3_6;
        ArrayList<SimpleFunctionDescriptor> arrayList;
        Collection collection = supertypes2;
        ArrayList<SimpleFunctionDescriptor> arrayList2 = arrayList;
        ArrayList<SimpleFunctionDescriptor> arrayList3 = arrayList;
        int n = collection.size();
        arrayList2(n);
        ArrayList<SimpleFunctionDescriptor> candidates = arrayList3;
        for (KotlinType kotlinType : supertypes2) {
            List<CallableMemberDescriptor> abstractMembers = SingleAbstractMethodUtils.getAbstractMembers(kotlinType);
            if (abstractMembers.isEmpty()) continue;
            CallableMemberDescriptor callableMemberDescriptor = abstractMembers.get(0);
            if (callableMemberDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor");
            }
            candidates.add((SimpleFunctionDescriptor)callableMemberDescriptor);
        }
        if (candidates.isEmpty()) {
            throw (Throwable)new IllegalStateException("Couldn't find abstract method in supertypes " + supertypes2);
        }
        SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)candidates.get(0);
        for (SimpleFunctionDescriptor candidate : candidates) {
            void value2;
            KotlinType candidateReturnType = candidate.getReturnType();
            KotlinType currentMostSpecificReturnType = var3_6.getReturnType();
            boolean bl = candidateReturnType != null && currentMostSpecificReturnType != null;
            if (PreconditionsKt.getASSERTIONS_ENABLED() && value2 == false) {
                String message = candidate + ", " + currentMostSpecificReturnType;
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            KotlinType kotlinType = candidateReturnType;
            if (kotlinType == null) {
                Intrinsics.throwNpe();
            }
            KotlinType kotlinType2 = currentMostSpecificReturnType;
            if (kotlinType2 == null) {
                Intrinsics.throwNpe();
            }
            if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(kotlinType, kotlinType2)) continue;
            SimpleFunctionDescriptor simpleFunctionDescriptor2 = candidate;
        }
        void v4 = var3_6;
        Intrinsics.checkExpressionValueIsNotNull(v4, "currentMostSpecificType");
        return v4;
    }

    static {
        new SamConversionResolverImpl();
    }

    private SamConversionResolverImpl() {
        INSTANCE = this;
        INSTANCE$ = this;
    }
}

