/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtDelegationSpecifier;
import org.jetbrains.kotlin.psi.KtDelegationSpecifierList;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SubstitutionUtils;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

public class DeclarationsChecker {
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final ModifiersChecker.ModifiersCheckingProcedure modifiersChecker;
    @NotNull
    private final DescriptorResolver descriptorResolver;
    @NotNull
    private final AnnotationChecker annotationChecker;
    @NotNull
    private final IdentifierChecker identifierChecker;
    private static final Set<String> METHOD_OF_ANY_NAMES = ImmutableSet.of("toString", "hashCode", "equals");

    public DeclarationsChecker(@NotNull DescriptorResolver descriptorResolver, @NotNull ModifiersChecker modifiersChecker, @NotNull AnnotationChecker annotationChecker, @NotNull IdentifierChecker identifierChecker, @NotNull BindingTrace trace) {
        if (descriptorResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorResolver", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "<init>"));
        }
        if (modifiersChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiersChecker", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "<init>"));
        }
        if (annotationChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationChecker", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "<init>"));
        }
        if (identifierChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifierChecker", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "<init>"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "<init>"));
        }
        this.descriptorResolver = descriptorResolver;
        this.modifiersChecker = modifiersChecker.withTrace(trace);
        this.annotationChecker = annotationChecker;
        this.identifierChecker = identifierChecker;
        this.trace = trace;
    }

    public void process(@NotNull BodiesResolveContext bodiesResolveContext) {
        if (bodiesResolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bodiesResolveContext", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "process"));
        }
        for (KtFile file : bodiesResolveContext.getFiles()) {
            this.checkModifiersAndAnnotationsInPackageDirective(file);
            this.annotationChecker.check(file, this.trace, null);
        }
        Map<KtClassOrObject, ClassDescriptorWithResolutionScopes> classes2 = bodiesResolveContext.getDeclaredClasses();
        for (Map.Entry<KtClassOrObject, ClassDescriptorWithResolutionScopes> entry : classes2.entrySet()) {
            KtClassOrObject classOrObject = entry.getKey();
            ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes = entry.getValue();
            this.checkSupertypesForConsistency(classDescriptorWithResolutionScopes);
            this.checkTypesInClassHeader(classOrObject);
            if (classOrObject instanceof KtClass) {
                KtClass ktClass = (KtClass)classOrObject;
                this.checkClass(bodiesResolveContext, ktClass, classDescriptorWithResolutionScopes);
                this.descriptorResolver.checkNamesInConstraints(ktClass, classDescriptorWithResolutionScopes, classDescriptorWithResolutionScopes.getScopeForClassHeaderResolution(), this.trace);
            } else if (classOrObject instanceof KtObjectDeclaration) {
                this.checkObject((KtObjectDeclaration)classOrObject, classDescriptorWithResolutionScopes);
            }
            this.checkPrimaryConstructor(classOrObject, classDescriptorWithResolutionScopes);
            this.modifiersChecker.checkModifiersForDeclaration(classOrObject, classDescriptorWithResolutionScopes);
            this.identifierChecker.checkDeclaration(classOrObject, this.trace);
            this.checkClassExposedType(classOrObject, classDescriptorWithResolutionScopes);
        }
        Map<KtNamedFunction, SimpleFunctionDescriptor> functions2 = bodiesResolveContext.getFunctions();
        for (Map.Entry<KtNamedFunction, SimpleFunctionDescriptor> entry : functions2.entrySet()) {
            KtNamedFunction ktNamedFunction = entry.getKey();
            SimpleFunctionDescriptor functionDescriptor = entry.getValue();
            this.checkFunction(ktNamedFunction, functionDescriptor);
            this.modifiersChecker.checkModifiersForDeclaration(ktNamedFunction, functionDescriptor);
            this.identifierChecker.checkDeclaration(ktNamedFunction, this.trace);
        }
        Map<KtProperty, PropertyDescriptor> properties2 = bodiesResolveContext.getProperties();
        for (Map.Entry<KtProperty, PropertyDescriptor> entry : properties2.entrySet()) {
            KtProperty property = entry.getKey();
            PropertyDescriptor propertyDescriptor = entry.getValue();
            this.checkProperty(property, propertyDescriptor);
            this.modifiersChecker.checkModifiersForDeclaration(property, propertyDescriptor);
            this.identifierChecker.checkDeclaration(property, this.trace);
        }
        for (Map.Entry<KtDeclarationStub, CallableMemberDescriptor> entry : bodiesResolveContext.getSecondaryConstructors().entrySet()) {
            ConstructorDescriptor constructorDescriptor = (ConstructorDescriptor)entry.getValue();
            KtSecondaryConstructor declaration = (KtSecondaryConstructor)entry.getKey();
            this.checkConstructorDeclaration(constructorDescriptor, declaration);
            this.checkFunctionExposedType(declaration, constructorDescriptor);
        }
    }

    private void checkConstructorDeclaration(ConstructorDescriptor constructorDescriptor, KtDeclaration declaration) {
        this.modifiersChecker.checkModifiersForDeclaration(declaration, constructorDescriptor);
        this.identifierChecker.checkDeclaration(declaration, this.trace);
    }

    private void checkModifiersAndAnnotationsInPackageDirective(KtFile file) {
        KtPackageDirective packageDirective = file.getPackageDirective();
        if (packageDirective == null) {
            return;
        }
        KtModifierList modifierList = packageDirective.getModifierList();
        if (modifierList == null) {
            return;
        }
        for (KtAnnotationEntry annotationEntry : modifierList.getAnnotationEntries()) {
            KtSimpleNameExpression reference;
            KtConstructorCalleeExpression calleeExpression = annotationEntry.getCalleeExpression();
            if (calleeExpression == null || (reference = calleeExpression.getConstructorReferenceExpression()) == null) continue;
            this.trace.report(Errors.UNRESOLVED_REFERENCE.on(reference, reference));
        }
        this.annotationChecker.check(packageDirective, this.trace, null);
        ModifierCheckerCore.INSTANCE$.check(packageDirective, this.trace, null);
    }

    private void checkTypesInClassHeader(@NotNull KtClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkTypesInClassHeader"));
        }
        for (KtDelegationSpecifier delegationSpecifier : classOrObject.getDelegationSpecifiers()) {
            this.checkBoundsForTypeInClassHeader(delegationSpecifier.getTypeReference());
        }
        if (!(classOrObject instanceof KtClass)) {
            return;
        }
        KtClass ktClass = (KtClass)classOrObject;
        for (KtTypeParameter jetTypeParameter : ktClass.getTypeParameters()) {
            this.checkBoundsForTypeInClassHeader(jetTypeParameter.getExtendsBound());
            this.checkFinalUpperBounds(jetTypeParameter.getExtendsBound());
        }
        for (KtTypeConstraint constraint : ktClass.getTypeConstraints()) {
            this.checkBoundsForTypeInClassHeader(constraint.getBoundTypeReference());
            this.checkFinalUpperBounds(constraint.getBoundTypeReference());
        }
    }

    private void checkBoundsForTypeInClassHeader(@Nullable KtTypeReference typeReference) {
        KotlinType type2;
        if (typeReference != null && (type2 = this.trace.getBindingContext().get(BindingContext.TYPE, typeReference)) != null) {
            DescriptorResolver.checkBounds(typeReference, type2, this.trace);
        }
    }

    private void checkFinalUpperBounds(@Nullable KtTypeReference typeReference) {
        KotlinType type2;
        if (typeReference != null && (type2 = this.trace.getBindingContext().get(BindingContext.TYPE, typeReference)) != null) {
            DescriptorResolver.checkUpperBoundType(typeReference, type2, this.trace);
        }
    }

    private void checkSupertypesForConsistency(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkSupertypesForConsistency"));
        }
        Multimap<TypeConstructor, TypeProjection> multimap = SubstitutionUtils.buildDeepSubstitutionMultimap(classDescriptor.getDefaultType());
        for (Map.Entry<TypeConstructor, Collection<TypeProjection>> entry : multimap.asMap().entrySet()) {
            Collection<TypeProjection> projections = entry.getValue();
            if (projections.size() <= 1) continue;
            TypeConstructor typeConstructor2 = entry.getKey();
            ClassifierDescriptor declarationDescriptor = typeConstructor2.getDeclarationDescriptor();
            assert (declarationDescriptor instanceof TypeParameterDescriptor) : declarationDescriptor;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)declarationDescriptor;
            LinkedHashSet<KotlinType> conflictingTypes = Sets.newLinkedHashSet();
            for (TypeProjection projection : projections) {
                conflictingTypes.add(projection.getType());
            }
            DeclarationsChecker.removeDuplicateTypes(conflictingTypes);
            if (conflictingTypes.size() <= 1) continue;
            DeclarationDescriptor containingDeclaration = typeParameterDescriptor.getContainingDeclaration();
            assert (containingDeclaration instanceof ClassDescriptor) : containingDeclaration;
            KtClassOrObject psiElement2 = (KtClassOrObject)DescriptorToSourceUtils.getSourceFromDescriptor(classDescriptor);
            assert (psiElement2 != null);
            KtDelegationSpecifierList delegationSpecifierList = psiElement2.getDelegationSpecifierList();
            assert (delegationSpecifierList != null);
            this.trace.report(Errors.INCONSISTENT_TYPE_PARAMETER_VALUES.on(delegationSpecifierList, typeParameterDescriptor, (ClassDescriptor)containingDeclaration, conflictingTypes));
        }
    }

    private void checkClassExposedType(@NotNull KtClassOrObject klass, @NotNull ClassDescriptor classDescriptor) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkClassExposedType"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkClassExposedType"));
        }
        this.checkExposedSupertypes(klass, classDescriptor);
        this.checkExposedParameterBounds(klass, classDescriptor);
        if (classDescriptor.getUnsubstitutedPrimaryConstructor() != null && klass.getPrimaryConstructor() != null) {
            this.checkFunctionExposedType(klass.getPrimaryConstructor(), classDescriptor.getUnsubstitutedPrimaryConstructor());
        }
    }

    private void checkExposedParameterBounds(@NotNull KtClassOrObject klass, @NotNull ClassDescriptor classDescriptor) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkExposedParameterBounds"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkExposedParameterBounds"));
        }
        EffectiveVisibility classVisibility = EffectiveVisibility.Companion.forClass(classDescriptor);
        List<KtTypeParameter> typeParameterList = klass.getTypeParameters();
        int i = 0;
        for (TypeParameterDescriptor typeParameterDescriptor : classDescriptor.getTypeConstructor().getParameters()) {
            if (i >= typeParameterList.size()) {
                return;
            }
            for (KotlinType upperBound : typeParameterDescriptor.getUpperBounds()) {
                EffectiveVisibility upperBoundVisibility = EffectiveVisibility.Companion.forType(upperBound);
                if (upperBoundVisibility.sameOrMorePermissive(classVisibility)) continue;
                KtTypeParameter typeParameter = typeParameterList.get(i);
                this.trace.report(Errors.EXPOSED_TYPE_PARAMETER_BOUND.on(typeParameter, classVisibility, upperBoundVisibility));
                break;
            }
            ++i;
        }
    }

    private void checkExposedSupertypes(@NotNull KtClassOrObject klass, @NotNull ClassDescriptor classDescriptor) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkExposedSupertypes"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkExposedSupertypes"));
        }
        EffectiveVisibility classVisibility = EffectiveVisibility.Companion.forClass(classDescriptor);
        boolean isInterface = classDescriptor.getKind() == ClassKind.INTERFACE;
        List<KtDelegationSpecifier> delegationList = klass.getDelegationSpecifiers();
        int i = -1;
        for (KotlinType superType : classDescriptor.getTypeConstructor().getSupertypes()) {
            EffectiveVisibility superTypeVisibility;
            boolean superIsInterface;
            if (++i >= delegationList.size()) {
                return;
            }
            ClassDescriptor superDescriptor = TypeUtils.getClassDescriptor(superType);
            if (superDescriptor == null || (superIsInterface = superDescriptor.getKind() == ClassKind.INTERFACE) != isInterface || (superTypeVisibility = EffectiveVisibility.Companion.forType(superType)).sameOrMorePermissive(classVisibility)) continue;
            if (isInterface) {
                this.trace.report(Errors.EXPOSED_SUPER_INTERFACE.on((KtDelegationSpecifier)((PsiElement)delegationList.get(i)), classVisibility, superTypeVisibility));
                continue;
            }
            this.trace.report(Errors.EXPOSED_SUPER_CLASS.on((KtDelegationSpecifier)((PsiElement)delegationList.get(i)), classVisibility, superTypeVisibility));
        }
    }

    private static void removeDuplicateTypes(Set<KotlinType> conflictingTypes) {
        Iterator<KotlinType> iterator2 = conflictingTypes.iterator();
        block0: while (iterator2.hasNext()) {
            KotlinType type2 = iterator2.next();
            for (KotlinType otherType : conflictingTypes) {
                boolean subtypeOf = KotlinTypeChecker.DEFAULT.equalTypes(type2, otherType);
                if (type2 == otherType || !subtypeOf) continue;
                iterator2.remove();
                continue block0;
            }
        }
    }

    private void checkObject(KtObjectDeclaration declaration, ClassDescriptor classDescriptor) {
        if (declaration.isLocal() && !declaration.isCompanion() && !declaration.isObjectLiteral()) {
            this.trace.report(Errors.LOCAL_OBJECT_NOT_ALLOWED.on(declaration, classDescriptor));
        }
    }

    private void checkClass(BodiesResolveContext c, KtClass aClass, ClassDescriptorWithResolutionScopes classDescriptor) {
        this.checkOpenMembers(classDescriptor);
        this.checkTypeParameters(aClass);
        this.checkTypeParameterConstraints(aClass);
        if (aClass.isInterface()) {
            this.checkConstructorInInterface(aClass);
            this.checkMethodsOfAnyInInterface(classDescriptor);
            if (aClass.isLocal() && !(classDescriptor.getContainingDeclaration() instanceof ClassDescriptor)) {
                this.trace.report(Errors.LOCAL_INTERFACE_NOT_ALLOWED.on(aClass, classDescriptor));
            }
        } else if (classDescriptor.getKind() == ClassKind.ANNOTATION_CLASS) {
            this.checkAnnotationClassWithBody(aClass);
            this.checkValOnAnnotationParameter(aClass);
        } else if (aClass instanceof KtEnumEntry) {
            this.checkEnumEntry((KtEnumEntry)aClass, classDescriptor);
        }
        for (CallableMemberDescriptor memberDescriptor : classDescriptor.getDeclaredCallableMembers()) {
            KtNamedDeclaration member;
            if (memberDescriptor.getKind() != CallableMemberDescriptor.Kind.DECLARATION || !((member = (KtNamedDeclaration)DescriptorToSourceUtils.descriptorToDeclaration(memberDescriptor)) instanceof KtFunction) || !(memberDescriptor instanceof FunctionDescriptor)) continue;
            this.checkFunctionExposedType((KtFunction)member, (FunctionDescriptor)memberDescriptor);
        }
    }

    private void checkPrimaryConstructor(KtClassOrObject classOrObject, ClassDescriptor classDescriptor) {
        ConstructorDescriptor primaryConstructor2 = classDescriptor.getUnsubstitutedPrimaryConstructor();
        KtPrimaryConstructor declaration = classOrObject.getPrimaryConstructor();
        if (primaryConstructor2 == null || declaration == null) {
            return;
        }
        for (KtParameter parameter : declaration.getValueParameters()) {
            PropertyDescriptor propertyDescriptor = this.trace.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter);
            if (propertyDescriptor == null) continue;
            this.modifiersChecker.checkModifiersForDeclaration(parameter, propertyDescriptor);
            this.checkPropertyLateInit(parameter, propertyDescriptor);
        }
        if (declaration.getModifierList() != null && !declaration.hasConstructorKeyword()) {
            this.trace.report(Errors.MISSING_CONSTRUCTOR_KEYWORD.on(declaration.getModifierList()));
        }
        if (!(classOrObject instanceof KtClass)) {
            this.trace.report(Errors.CONSTRUCTOR_IN_OBJECT.on(declaration));
        }
        this.checkConstructorDeclaration(primaryConstructor2, declaration);
    }

    private void checkTypeParameters(KtTypeParameterListOwner typeParameterListOwner) {
        for (KtTypeParameter jetTypeParameter : typeParameterListOwner.getTypeParameters()) {
            AnnotationResolver.reportUnsupportedAnnotationForTypeParameter(jetTypeParameter, this.trace);
            TypeParameterDescriptor typeParameter = this.trace.get(BindingContext.TYPE_PARAMETER, jetTypeParameter);
            if (typeParameter == null) continue;
            DescriptorResolver.checkConflictingUpperBounds(this.trace, typeParameter, jetTypeParameter);
        }
    }

    private void checkTypeParameterConstraints(KtTypeParameterListOwner typeParameterListOwner) {
        List<KtTypeConstraint> constraints = typeParameterListOwner.getTypeConstraints();
        if (!constraints.isEmpty()) {
            for (KtTypeParameter typeParameter : typeParameterListOwner.getTypeParameters()) {
                if (typeParameter.getExtendsBound() == null || !DeclarationsChecker.hasConstraints(typeParameter, constraints)) continue;
                this.trace.report(Errors.MISPLACED_TYPE_PARAMETER_CONSTRAINTS.on(typeParameter));
            }
        }
    }

    private static boolean hasConstraints(KtTypeParameter typeParameter, List<KtTypeConstraint> constraints) {
        for (KtTypeConstraint constraint : constraints) {
            KtSimpleNameExpression parameterName = constraint.getSubjectTypeParameterName();
            if (parameterName == null || !parameterName.getText().equals(typeParameter.getName())) continue;
            return true;
        }
        return false;
    }

    private void checkConstructorInInterface(KtClass klass) {
        KtPrimaryConstructor primaryConstructor2 = klass.getPrimaryConstructor();
        if (primaryConstructor2 != null) {
            this.trace.report(Errors.CONSTRUCTOR_IN_INTERFACE.on(primaryConstructor2));
        }
    }

    private void checkMethodsOfAnyInInterface(ClassDescriptorWithResolutionScopes classDescriptor) {
        for (CallableMemberDescriptor declaredCallableMember : classDescriptor.getDeclaredCallableMembers()) {
            FunctionDescriptor functionDescriptor;
            PsiElement declaration;
            if (!(declaredCallableMember instanceof FunctionDescriptor) || !((declaration = DescriptorToSourceUtils.descriptorToDeclaration(functionDescriptor = (FunctionDescriptor)declaredCallableMember)) instanceof KtNamedFunction)) continue;
            KtNamedFunction functionDeclaration = (KtNamedFunction)declaration;
            if (DeclarationsChecker.isHidingParentMemberIfPresent(declaredCallableMember) || !DeclarationsChecker.isImplementingMethodOfAny(declaredCallableMember)) continue;
            this.trace.report(Errors.METHOD_OF_ANY_IMPLEMENTED_IN_INTERFACE.on(functionDeclaration));
        }
    }

    private static boolean isImplementingMethodOfAny(CallableMemberDescriptor member) {
        if (!METHOD_OF_ANY_NAMES.contains(member.getName().asString())) {
            return false;
        }
        if (member.getModality() == Modality.ABSTRACT) {
            return false;
        }
        return DeclarationsChecker.isImplementingMethodOfAnyInternal(member, new HashSet<ClassDescriptor>());
    }

    private static boolean isImplementingMethodOfAnyInternal(CallableMemberDescriptor member, Set<ClassDescriptor> visitedClasses) {
        for (CallableMemberDescriptor callableMemberDescriptor : member.getOverriddenDescriptors()) {
            ClassDescriptor containingClass;
            DeclarationDescriptor containingDeclaration = callableMemberDescriptor.getContainingDeclaration();
            if (!(containingDeclaration instanceof ClassDescriptor) || visitedClasses.contains(containingClass = (ClassDescriptor)containingDeclaration)) continue;
            if (DescriptorUtils.getFqName(containingClass).equals(KotlinBuiltIns.FQ_NAMES.any)) {
                return true;
            }
            if (DeclarationsChecker.isHidingParentMemberIfPresent(callableMemberDescriptor)) continue;
            visitedClasses.add(containingClass);
            if (!DeclarationsChecker.isImplementingMethodOfAnyInternal(callableMemberDescriptor, visitedClasses)) continue;
            return true;
        }
        return false;
    }

    private static boolean isHidingParentMemberIfPresent(CallableMemberDescriptor member) {
        KtNamedDeclaration declaration = (KtNamedDeclaration)DescriptorToSourceUtils.descriptorToDeclaration(member);
        if (declaration != null) {
            KtModifierList modifierList = declaration.getModifierList();
            return modifierList == null || !modifierList.hasModifier(KtTokens.OVERRIDE_KEYWORD);
        }
        return false;
    }

    private void checkAnnotationClassWithBody(KtClassOrObject classOrObject) {
        if (classOrObject.getBody() != null) {
            this.trace.report(Errors.ANNOTATION_CLASS_WITH_BODY.on(classOrObject.getBody()));
        }
    }

    private void checkValOnAnnotationParameter(KtClass aClass) {
        for (KtParameter parameter : aClass.getPrimaryConstructorParameters()) {
            if (parameter.hasValOrVar()) continue;
            this.trace.report(Errors.MISSING_VAL_ON_ANNOTATION_PARAMETER.on(parameter));
        }
    }

    private void checkOpenMembers(ClassDescriptorWithResolutionScopes classDescriptor) {
        if (DescriptorUtils.classCanHaveOpenMembers(classDescriptor)) {
            return;
        }
        for (CallableMemberDescriptor memberDescriptor : classDescriptor.getDeclaredCallableMembers()) {
            KtNamedDeclaration member;
            if (memberDescriptor.getKind() != CallableMemberDescriptor.Kind.DECLARATION || (member = (KtNamedDeclaration)DescriptorToSourceUtils.descriptorToDeclaration(memberDescriptor)) == null || !member.hasModifier(KtTokens.OPEN_KEYWORD)) continue;
            this.trace.report(Errors.NON_FINAL_MEMBER_IN_FINAL_CLASS.on(member));
        }
    }

    private void checkProperty(KtProperty property, PropertyDescriptor propertyDescriptor) {
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        if (containingDeclaration instanceof ClassDescriptor) {
            this.checkPropertyAbstractness(property, propertyDescriptor, (ClassDescriptor)containingDeclaration);
        }
        this.checkPropertyLateInit(property, propertyDescriptor);
        this.checkPropertyInitializer(property, propertyDescriptor);
        this.checkAccessors(property, propertyDescriptor);
        this.checkTypeParameterConstraints(property);
        this.checkPropertyExposedType(property, propertyDescriptor);
        this.checkPropertyTypeParametersAreUsedInReceiverType(propertyDescriptor);
    }

    private void checkPropertyTypeParametersAreUsedInReceiverType(@NotNull PropertyDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkPropertyTypeParametersAreUsedInReceiverType"));
        }
        for (TypeParameterDescriptor typeParameter : descriptor2.getTypeParameters()) {
            PsiElement typeParameterPsi;
            if (DeclarationsChecker.isTypeParameterUsedInReceiverType(typeParameter, descriptor2) || !((typeParameterPsi = DescriptorToSourceUtils.getSourceFromDescriptor(typeParameter)) instanceof KtTypeParameter)) continue;
            this.trace.report(Errors.TYPE_PARAMETER_OF_PROPERTY_NOT_USED_IN_RECEIVER.on((KtTypeParameter)typeParameterPsi));
        }
    }

    private static boolean isTypeParameterUsedInReceiverType(final @NotNull TypeParameterDescriptor parameter, @NotNull PropertyDescriptor descriptor2) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "isTypeParameterUsedInReceiverType"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "isTypeParameterUsedInReceiverType"));
        }
        ReceiverParameterDescriptor receiverParameter = descriptor2.getExtensionReceiverParameter();
        if (receiverParameter == null) {
            return false;
        }
        return TypeUtils.containsSpecialType(receiverParameter.getType(), new Function1<KotlinType, Boolean>(){

            @Override
            public Boolean invoke(KotlinType type2) {
                return parameter.equals(type2.getConstructor().getDeclarationDescriptor());
            }
        });
    }

    private void checkPropertyLateInit(@NotNull KtCallableDeclaration property, @NotNull PropertyDescriptor propertyDescriptor) {
        boolean isAbstract;
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkPropertyLateInit"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkPropertyLateInit"));
        }
        KtModifierList modifierList = property.getModifierList();
        if (modifierList == null) {
            return;
        }
        PsiElement modifier = modifierList.getModifier(KtTokens.LATEINIT_KEYWORD);
        if (modifier == null) {
            return;
        }
        if (!propertyDescriptor.isVar()) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is allowed only on mutable properties"));
        }
        boolean returnTypeIsNullable = true;
        boolean returnTypeIsPrimitive = true;
        KotlinType returnType2 = propertyDescriptor.getReturnType();
        if (returnType2 != null) {
            returnTypeIsNullable = TypeUtils.isNullableType(returnType2);
            returnTypeIsPrimitive = KotlinBuiltIns.isPrimitiveType(returnType2);
        }
        if (returnTypeIsNullable) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on nullable properties"));
        }
        if (returnTypeIsPrimitive) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on primitive type properties"));
        }
        boolean bl = isAbstract = propertyDescriptor.getModality() == Modality.ABSTRACT;
        if (isAbstract) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on abstract properties"));
        }
        if (property instanceof KtParameter) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on primary constructor parameters"));
        }
        boolean hasDelegateExpressionOrInitializer = false;
        if (property instanceof KtProperty && (hasDelegateExpressionOrInitializer = ((KtProperty)property).hasDelegateExpressionOrInitializer())) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on properties with initializer or on delegated properties"));
        }
        PropertyGetterDescriptor getter2 = propertyDescriptor.getGetter();
        PropertySetterDescriptor setter2 = propertyDescriptor.getSetter();
        boolean customGetterOrSetter = false;
        if (getter2 != null) {
            customGetterOrSetter = getter2.hasBody();
        }
        if (setter2 != null) {
            customGetterOrSetter |= setter2.hasBody();
        }
        if (!hasDelegateExpressionOrInitializer && customGetterOrSetter) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on properties with a custom getter or setter"));
        }
        boolean hasBackingField = Boolean.TRUE.equals(this.trace.getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor));
        if (!(isAbstract || customGetterOrSetter || hasDelegateExpressionOrInitializer || hasBackingField)) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on properties without backing field"));
        }
        if (propertyDescriptor.getExtensionReceiverParameter() != null) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on extension properties"));
        }
    }

    private void checkPropertyAbstractness(@NotNull KtProperty property, @NotNull PropertyDescriptor propertyDescriptor, @NotNull ClassDescriptor classDescriptor) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkPropertyAbstractness"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkPropertyAbstractness"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkPropertyAbstractness"));
        }
        KtPropertyAccessor getter2 = property.getGetter();
        KtPropertyAccessor setter2 = property.getSetter();
        KtModifierList modifierList = property.getModifierList();
        if (modifierList != null && modifierList.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
            if (!DescriptorUtils.classCanHaveAbstractMembers(classDescriptor)) {
                String name = property.getName();
                this.trace.report(Errors.ABSTRACT_PROPERTY_IN_NON_ABSTRACT_CLASS.on(property, name != null ? name : "", classDescriptor));
                return;
            }
            if (classDescriptor.getKind() == ClassKind.INTERFACE) {
                this.trace.report(Errors.ABSTRACT_MODIFIER_IN_INTERFACE.on(property));
            }
        }
        if (propertyDescriptor.getModality() == Modality.ABSTRACT) {
            KtPropertyDelegate delegate2;
            KtExpression initializer2 = property.getInitializer();
            if (initializer2 != null) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_INITIALIZER.on(initializer2));
            }
            if ((delegate2 = property.getDelegate()) != null) {
                this.trace.report(Errors.ABSTRACT_DELEGATED_PROPERTY.on(delegate2));
            }
            if (getter2 != null && getter2.hasBody()) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_GETTER.on(getter2));
            }
            if (setter2 != null && setter2.hasBody()) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_SETTER.on(setter2));
            }
        }
    }

    private void checkPropertyInitializer(@NotNull KtProperty property, @NotNull PropertyDescriptor propertyDescriptor) {
        boolean inTrait;
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkPropertyInitializer"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkPropertyInitializer"));
        }
        KtPropertyAccessor getter2 = property.getGetter();
        KtPropertyAccessor setter2 = property.getSetter();
        boolean hasAccessorImplementation = getter2 != null && getter2.hasBody() || setter2 != null && setter2.hasBody();
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        boolean bl = inTrait = containingDeclaration instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).getKind() == ClassKind.INTERFACE;
        if (propertyDescriptor.getModality() == Modality.ABSTRACT) {
            if (!property.hasDelegateExpressionOrInitializer() && property.getTypeReference() == null) {
                this.trace.report(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER.on(property));
            }
            if (inTrait && property.hasModifier(KtTokens.PRIVATE_KEYWORD) && !property.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
                this.trace.report(Errors.PRIVATE_PROPERTY_IN_INTERFACE.on(property));
            }
            return;
        }
        KtExpression initializer2 = property.getInitializer();
        KtPropertyDelegate delegate2 = property.getDelegate();
        boolean backingFieldRequired = Boolean.TRUE.equals(this.trace.getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor));
        if (inTrait && backingFieldRequired && hasAccessorImplementation) {
            this.trace.report(Errors.BACKING_FIELD_IN_INTERFACE.on(property));
        }
        if (initializer2 == null && delegate2 == null) {
            boolean error = false;
            if (backingFieldRequired && !inTrait && !propertyDescriptor.isLateInit() && Boolean.TRUE.equals(this.trace.getBindingContext().get(BindingContext.IS_UNINITIALIZED, propertyDescriptor))) {
                if (!(containingDeclaration instanceof ClassDescriptor) || hasAccessorImplementation) {
                    error = true;
                    this.trace.report(Errors.MUST_BE_INITIALIZED.on(property));
                } else {
                    error = true;
                    this.trace.report(Errors.MUST_BE_INITIALIZED_OR_BE_ABSTRACT.on(property));
                }
            }
            if (!error && property.getTypeReference() == null) {
                this.trace.report(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER.on(property));
            }
            if (inTrait && property.hasModifier(KtTokens.FINAL_KEYWORD) && backingFieldRequired) {
                this.trace.report(Errors.FINAL_PROPERTY_IN_INTERFACE.on(property));
            }
            return;
        }
        if (inTrait) {
            if (delegate2 != null) {
                this.trace.report(Errors.DELEGATED_PROPERTY_IN_INTERFACE.on(delegate2));
            } else {
                this.trace.report(Errors.PROPERTY_INITIALIZER_IN_INTERFACE.on(initializer2));
            }
        } else if (delegate2 == null) {
            if (!backingFieldRequired) {
                this.trace.report(Errors.PROPERTY_INITIALIZER_NO_BACKING_FIELD.on(initializer2));
            } else if (property.getReceiverTypeReference() != null) {
                this.trace.report(Errors.EXTENSION_PROPERTY_WITH_BACKING_FIELD.on(initializer2));
            }
        }
    }

    private void checkMemberReceiverExposedType(@Nullable KtTypeReference typeReference, @NotNull CallableMemberDescriptor memberDescriptor) {
        if (memberDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberDescriptor", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkMemberReceiverExposedType"));
        }
        if (typeReference == null) {
            return;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = memberDescriptor.getExtensionReceiverParameter();
        if (receiverParameterDescriptor == null) {
            return;
        }
        EffectiveVisibility memberVisibility = EffectiveVisibility.Companion.forMember(memberDescriptor);
        EffectiveVisibility receiverTypeVisibility = EffectiveVisibility.Companion.forType(receiverParameterDescriptor.getType());
        if (!receiverTypeVisibility.sameOrMorePermissive(memberVisibility)) {
            this.trace.report(Errors.EXPOSED_RECEIVER_TYPE.on(typeReference, memberVisibility, receiverTypeVisibility));
        }
    }

    private void checkPropertyExposedType(@NotNull KtProperty property, @NotNull PropertyDescriptor propertyDescriptor) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkPropertyExposedType"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkPropertyExposedType"));
        }
        EffectiveVisibility propertyVisibility = EffectiveVisibility.Companion.forMember(propertyDescriptor);
        EffectiveVisibility typeVisibility = EffectiveVisibility.Companion.forType(propertyDescriptor.getType());
        if (!typeVisibility.sameOrMorePermissive(propertyVisibility)) {
            this.trace.report(Errors.EXPOSED_PROPERTY_TYPE.on(property, propertyVisibility, typeVisibility));
        }
        this.checkMemberReceiverExposedType(property.getReceiverTypeReference(), propertyDescriptor);
    }

    protected void checkFunction(KtNamedFunction function, SimpleFunctionDescriptor functionDescriptor) {
        KtTypeParameterList typeParameterList = function.getTypeParameterList();
        PsiElement nameIdentifier = function.getNameIdentifier();
        if (typeParameterList != null && nameIdentifier != null && typeParameterList.getTextRange().getStartOffset() > nameIdentifier.getTextRange().getStartOffset()) {
            this.trace.report(Errors.DEPRECATED_TYPE_PARAMETER_SYNTAX.on(typeParameterList));
        }
        this.checkTypeParameterConstraints(function);
        DeclarationDescriptor containingDescriptor = functionDescriptor.getContainingDeclaration();
        boolean hasAbstractModifier = function.hasModifier(KtTokens.ABSTRACT_KEYWORD);
        boolean hasExternalModifier = function.hasModifier(KtTokens.EXTERNAL_KEYWORD);
        if (containingDescriptor instanceof ClassDescriptor) {
            boolean hasBody;
            boolean inTrait;
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDescriptor;
            boolean bl = inTrait = classDescriptor.getKind() == ClassKind.INTERFACE;
            if (hasAbstractModifier && !DescriptorUtils.classCanHaveAbstractMembers(classDescriptor)) {
                this.trace.report(Errors.ABSTRACT_FUNCTION_IN_NON_ABSTRACT_CLASS.on(function, functionDescriptor.getName().asString(), classDescriptor));
            }
            if (hasAbstractModifier && inTrait) {
                this.trace.report(Errors.ABSTRACT_MODIFIER_IN_INTERFACE.on(function));
            }
            if ((hasBody = function.hasBody()) && hasAbstractModifier) {
                this.trace.report(Errors.ABSTRACT_FUNCTION_WITH_BODY.on(function, functionDescriptor));
            }
            if (!hasBody && inTrait) {
                if (function.hasModifier(KtTokens.FINAL_KEYWORD) && !hasExternalModifier) {
                    this.trace.report(Errors.FINAL_FUNCTION_WITH_NO_BODY.on(function, functionDescriptor));
                }
                if (function.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
                    this.trace.report(Errors.PRIVATE_FUNCTION_WITH_NO_BODY.on(function, functionDescriptor));
                }
            }
            if (!(hasBody || hasAbstractModifier || hasExternalModifier || inTrait)) {
                this.trace.report(Errors.NON_ABSTRACT_FUNCTION_WITH_NO_BODY.on(function, functionDescriptor));
            }
            return;
        }
        if (!(function.hasBody() || hasAbstractModifier || hasExternalModifier)) {
            this.trace.report(Errors.NON_MEMBER_FUNCTION_NO_BODY.on(function, functionDescriptor));
        }
        if (TypeUtilsKt.isNothing(functionDescriptor.getReturnType()) && !function.hasDeclaredReturnType()) {
            this.trace.report(Errors.IMPLICIT_NOTHING_RETURN_TYPE.on(function.getNameIdentifier() != null ? function.getNameIdentifier() : function));
        }
        this.checkFunctionExposedType(function, functionDescriptor);
    }

    private void checkFunctionExposedType(@NotNull KtFunction function, @NotNull FunctionDescriptor functionDescriptor) {
        EffectiveVisibility returnTypeVisibility;
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkFunctionExposedType"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkFunctionExposedType"));
        }
        EffectiveVisibility functionVisibility = EffectiveVisibility.Companion.forMember(functionDescriptor);
        if (!(function instanceof KtConstructor) && !(returnTypeVisibility = EffectiveVisibility.Companion.forType(functionDescriptor.getReturnType())).sameOrMorePermissive(functionVisibility)) {
            PsiElement reportOn = function.getNameIdentifier();
            if (reportOn == null) {
                reportOn = function;
            }
            this.trace.report(Errors.EXPOSED_FUNCTION_RETURN_TYPE.on(reportOn, functionVisibility, returnTypeVisibility));
        }
        int i = 0;
        for (ValueParameterDescriptor parameterDescriptor : functionDescriptor.getValueParameters()) {
            EffectiveVisibility typeVisibility = EffectiveVisibility.Companion.forType(parameterDescriptor.getType());
            if (!typeVisibility.sameOrMorePermissive(functionVisibility) && i < function.getValueParameters().size()) {
                this.trace.report(Errors.EXPOSED_PARAMETER_TYPE.on((KtParameter)((PsiElement)function.getValueParameters().get(i)), functionVisibility, typeVisibility));
            }
            ++i;
        }
        this.checkMemberReceiverExposedType(function.getReceiverTypeReference(), functionDescriptor);
    }

    private void checkAccessors(@NotNull KtProperty property, @NotNull PropertyDescriptor propertyDescriptor) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkAccessors"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkAccessors"));
        }
        for (KtPropertyAccessor accessor : property.getAccessors()) {
            PropertyAccessorDescriptor propertyAccessorDescriptor;
            PropertyAccessorDescriptor propertyAccessorDescriptor2 = propertyAccessorDescriptor = accessor.isGetter() ? propertyDescriptor.getGetter() : propertyDescriptor.getSetter();
            assert (propertyAccessorDescriptor != null) : "No property accessor descriptor for " + property.getText();
            this.modifiersChecker.checkModifiersForDeclaration(accessor, propertyAccessorDescriptor);
            this.identifierChecker.checkDeclaration(accessor, this.trace);
        }
        this.checkAccessor(propertyDescriptor, property.getGetter(), propertyDescriptor.getGetter());
        this.checkAccessor(propertyDescriptor, property.getSetter(), propertyDescriptor.getSetter());
    }

    private void reportVisibilityModifierDiagnostics(Collection<PsiElement> tokens, DiagnosticFactory0<PsiElement> diagnostic) {
        for (PsiElement token : tokens) {
            this.trace.report(diagnostic.on(token));
        }
    }

    private void checkAccessor(@NotNull PropertyDescriptor propertyDescriptor, @Nullable KtPropertyAccessor accessor, @Nullable PropertyAccessorDescriptor accessorDescriptor) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkAccessor"));
        }
        if (accessor == null) {
            return;
        }
        KtModifierList accessorModifierList = accessor.getModifierList();
        if (accessorModifierList != null && accessorDescriptor != null) {
            Map<KtModifierKeywordToken, PsiElement> tokens = this.modifiersChecker.getTokensCorrespondingToModifiers(accessorModifierList, Sets.newHashSet(KtTokens.PUBLIC_KEYWORD, KtTokens.PROTECTED_KEYWORD, KtTokens.PRIVATE_KEYWORD, KtTokens.INTERNAL_KEYWORD));
            if (propertyDescriptor.getModality() == Modality.ABSTRACT && accessorDescriptor.getVisibility() != propertyDescriptor.getVisibility()) {
                this.reportVisibilityModifierDiagnostics(tokens.values(), Errors.ACCESSOR_VISIBILITY_FOR_ABSTRACT_PROPERTY);
            } else if (accessor.isGetter()) {
                if (accessorDescriptor.getVisibility() != propertyDescriptor.getVisibility()) {
                    this.reportVisibilityModifierDiagnostics(tokens.values(), Errors.GETTER_VISIBILITY_DIFFERS_FROM_PROPERTY_VISIBILITY);
                } else {
                    this.reportVisibilityModifierDiagnostics(tokens.values(), Errors.REDUNDANT_MODIFIER_IN_GETTER);
                }
            } else if (accessorDescriptor.getVisibility() == Visibilities.PRIVATE && propertyDescriptor.getVisibility() != Visibilities.PRIVATE && propertyDescriptor.isLateInit()) {
                this.reportVisibilityModifierDiagnostics(tokens.values(), Errors.PRIVATE_SETTER_ON_NON_PRIVATE_LATE_INIT_VAR);
            }
        }
    }

    private void checkEnumEntry(@NotNull KtEnumEntry enumEntry, @NotNull ClassDescriptor classDescriptor) {
        if (enumEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntry", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkEnumEntry"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkEnumEntry"));
        }
        DeclarationDescriptor declaration = classDescriptor.getContainingDeclaration();
        if (DescriptorUtils.isEnumClass(declaration)) {
            ClassDescriptor enumClass = (ClassDescriptor)declaration;
            if (!enumEntry.hasInitializer() && !DescriptorUtils.hasDefaultConstructor(enumClass)) {
                this.trace.report(Errors.ENUM_ENTRY_SHOULD_BE_INITIALIZED.on(enumEntry));
            }
        } else assert (DescriptorUtils.isInterface(declaration)) : "Enum entry should be declared in enum class: " + classDescriptor + " " + (Object)((Object)classDescriptor.getKind());
    }
}

