/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.callResolverUtil;

import com.google.common.collect.Lists;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtMultiDeclarationEntry;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImpl;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.scopes.KtScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeImpl;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"e\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005A\u0001#B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u00012B\u0003\u0002\t\u000b)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\u0001Q\u0012\u0004\u0005\u0001\u001b\u0005A\n!G\u0002\t\u00035\t\u00014A\r\u0004\u0011\ti\u0011\u0001'\u0002U\u0007\riI\u0002c\u0002\u000e\u0003a\u0005\u0011d\u0001\u0005\u0005\u001b\u0005AJ!G\u0002\t\u000b5\t\u00014\u0002+\u0004\u00075\u0005B!\u0001\u0005\u0007\u001b!Ia!C\u0003\u0011\u0010U\u0011A\u0012\u0001\r\b1\u001dAj!G\u0002\t\u00115\t\u0001\u0014\u0001+\u0004\u00075aA!\u0001E\t\u001b\u000fA\n!U\u0002\u0002\t%I2\u0001\u0003\u0005\u000e\u0003a\u0005AkA\u0002\u000e\u0014!MQB\u0001G\u00011)I2\u0001#\u0006\u000e\u0003aYAkA\u0002\u000e\u0014!]QB\u0001G\u000111I2\u0001#\u0006\u000e\u0003aYAkA\u0002\u000e\u0012!eQ\"\u0001\r\u000e3\rA\u0001\"D\u0001\u0019\u0002Q\u001b1!$\u0005\t\u001c5\t\u0001$D\r\u0004\u0011!i\u0011\u0001'\u0001U\u0007\ri\t\u0002\u0003\b\u000e\u0003ai\u0011d\u0001E\u000b\u001b\u0005A2\u0002V\u0002\u0004\u001b#Ai\"D\u0001\u0019\u001be\u0019\u0001RC\u0007\u00021-!6aAG\t\u0011=i\u0011\u0001G\u0007\u001a\u0007!UQ\"\u0001\r\f)\u000e\u0019Q\u0012\u0003E\u0010\u001b\u0005AR\"G\u0002\t\u000b5\t\u0001\u0004\u0005+\u0004\u00075E\u0001\u0012E\u0007\u00021\u0003I2\u0001\u0003\u0005\u000e\u0003a\u0005AkA\u0002\u000e\"\u0011\t\u0001\"E\u0007\u00021GI2\u0001\u0003\u0005\u000e\u0003a\u0005\u0011D\u0002\u0005\u0013\u001b\u0011I!!C\u0001\u0019\u000fa5AkA\u0002\u000e\u0019!\u0015R\"\u0001\r\u000e+\u0005AZ!'\u0003\t'5\t\u0001t\u0005)\u0004\u0002Q\u001b1!D\u0007\u0005\u0003!!R\"\u0001\r\u000e+\u0005AZ!'\u0003\t'5\t\u0001t\u0005)\u0004\u0002Q\u001b1\u0001"}, strings={"getEffectiveExpectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "parameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "argument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "CallResolverUtilKt", "getErasedReceiverType", "receiverParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getParameterArgumentsOfCallableType", "", "Lorg/jetbrains/kotlin/types/TypeProjection;", "kotlin.jvm.PlatformType", "type", "getReturnTypeForCallable", "Lorg/jetbrains/annotations/NotNull;", "getSuperCallExpression", "Lorg/jetbrains/kotlin/psi/KtSuperExpression;", "call", "Lorg/jetbrains/kotlin/psi/Call;", "getUnaryPlusOrMinusOperatorFunctionName", "Lorg/jetbrains/kotlin/name/Name;", "hasUnknownFunctionParameter", "", "hasUnknownReturnType", "isConventionCall", "isInvokeCallOnExpressionWithBothReceivers", "isInvokeCallOnVariable", "isOrOverridesSynthesized", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "replaceReturnTypeByUnknown", "replaceTypeArguments", "Lorg/jetbrains/kotlin/types/KotlinTypeImpl;", "newArguments", "hasInferredReturnType", "constraintSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem;", "hasReturnTypeDependentOnUninferredParams"}, moduleName="kotlin-compiler")
public final class CallResolverUtilKt {
    public static final boolean hasUnknownFunctionParameter(@NotNull KotlinType type2) {
        boolean bl;
        block2: {
            Intrinsics.checkParameterIsNotNull(type2, "type");
            boolean value2 = ReflectionTypes.Companion.INSTANCE.isCallableType(type2);
            if (PreconditionsKt.getASSERTIONS_ENABLED() && !value2) {
                String message = "type " + type2 + " is not a function or property";
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            Iterable $receiver = CallResolverUtilKt.getParameterArgumentsOfCallableType(type2);
            for (Object element : $receiver) {
                TypeProjection it2 = (TypeProjection)element;
                if (!(TypeUtils.containsSpecialType(it2.getType(), TypeUtils.DONT_CARE) || ErrorUtils.containsUninferredParameter(it2.getType()))) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean hasUnknownReturnType(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        boolean value2 = ReflectionTypes.Companion.INSTANCE.isCallableType(type2);
        if (PreconditionsKt.getASSERTIONS_ENABLED() && !value2) {
            String message = "type " + type2 + " is not a function or property";
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        return ErrorUtils.containsErrorType(CallResolverUtilKt.getReturnTypeForCallable(type2));
    }

    @NotNull
    public static final KotlinType replaceReturnTypeByUnknown(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        boolean value2 = ReflectionTypes.Companion.INSTANCE.isCallableType(type2);
        if (PreconditionsKt.getASSERTIONS_ENABLED() && !value2) {
            String message = "type " + type2 + " is not a function or property";
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        ArrayList<TypeProjectionImpl> newArguments = Lists.newArrayList();
        newArguments.addAll((Collection)CallResolverUtilKt.getParameterArgumentsOfCallableType(type2));
        newArguments.add(new TypeProjectionImpl(Variance.INVARIANT, TypeUtils.DONT_CARE));
        List list = newArguments;
        Intrinsics.checkExpressionValueIsNotNull(list, "newArguments");
        return CallResolverUtilKt.replaceTypeArguments(type2, list);
    }

    private static final KotlinTypeImpl replaceTypeArguments(KotlinType type2, List<? extends TypeProjection> newArguments) {
        Annotations annotations2 = type2.getAnnotations();
        Intrinsics.checkExpressionValueIsNotNull(annotations2, "type.getAnnotations()");
        TypeConstructor typeConstructor2 = type2.getConstructor();
        Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "type.getConstructor()");
        boolean bl = type2.isMarkedNullable();
        KtScope ktScope = type2.getMemberScope();
        Intrinsics.checkExpressionValueIsNotNull(ktScope, "type.getMemberScope()");
        return KotlinTypeImpl.Companion.INSTANCE.create(annotations2, typeConstructor2, bl, newArguments, ktScope);
    }

    private static final List<TypeProjection> getParameterArgumentsOfCallableType(KotlinType type2) {
        return CollectionsKt.dropLast(type2.getArguments(), 1);
    }

    private static final KotlinType getReturnTypeForCallable(KotlinType type2) {
        return CollectionsKt.last(type2.getArguments()).getType();
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean hasReturnTypeDependentOnUninferredParams(CallableDescriptor $receiver, ConstraintSystem constraintSystem) {
        boolean bl;
        block3: {
            void $receiver2;
            Iterable receiver;
            KotlinType kotlinType = $receiver.getReturnType();
            if (kotlinType == null) {
                return false;
            }
            KotlinType returnType2 = kotlinType;
            ConstraintSystem constraintSystem2 = constraintSystem;
            if (constraintSystem2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImpl");
            }
            ConstraintSystemImpl constraintSystemImpl = (ConstraintSystemImpl)constraintSystem2;
            ConstraintSystemImpl $receiver3 = (ConstraintSystemImpl)((Object)receiver);
            List nestedTypeVariables = ConstraintSystemImpl.getNestedTypeVariables$default($receiver3, returnType2, false, 1);
            receiver = nestedTypeVariables;
            for (Object element : $receiver2) {
                TypeParameterDescriptor it2 = (TypeParameterDescriptor)element;
                if (!(((ConstraintSystemImpl)constraintSystem).getTypeBounds(it2).getValue() == null)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean hasInferredReturnType(CallableDescriptor $receiver, @NotNull ConstraintSystem constraintSystem) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(constraintSystem, "constraintSystem");
        if (CallResolverUtilKt.hasReturnTypeDependentOnUninferredParams($receiver, constraintSystem)) {
            return false;
        }
        return !constraintSystem.getStatus().hasOnlyErrorsDerivedFrom(ConstraintPositionKind.EXPECTED_TYPE_POSITION);
    }

    @NotNull
    public static final KotlinType getErasedReceiverType(@NotNull ReceiverParameterDescriptor receiverParameterDescriptor, @NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(receiverParameterDescriptor, "receiverParameterDescriptor");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        KotlinType receiverType = receiverParameterDescriptor.getType();
        for (TypeParameterDescriptor typeParameter : descriptor2.getTypeParameters()) {
            if (!Intrinsics.areEqual(typeParameter.getTypeConstructor(), receiverType.getConstructor())) continue;
            receiverType = typeParameter.getUpperBoundsAsType();
        }
        List fakeTypeArguments = ContainerUtil.newSmartList();
        for (TypeProjection typeProjection : receiverType.getArguments()) {
            fakeTypeArguments.add(new TypeProjectionImpl(typeProjection.getProjectionKind(), TypeUtils.DONT_CARE));
        }
        Annotations annotations2 = receiverType.getAnnotations();
        Intrinsics.checkExpressionValueIsNotNull(annotations2, "receiverType.getAnnotations()");
        TypeConstructor typeConstructor2 = receiverType.getConstructor();
        Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "receiverType.getConstructor()");
        boolean bl = receiverType.isMarkedNullable();
        List list = fakeTypeArguments;
        Intrinsics.checkExpressionValueIsNotNull(list, "fakeTypeArguments");
        KtScope ktScope = ErrorUtils.createErrorScope("Error scope for erased receiver type", true);
        Intrinsics.checkExpressionValueIsNotNull(ktScope, "ErrorUtils.createErrorSc\u2026/*throwExceptions=*/true)");
        return KotlinTypeImpl.Companion.INSTANCE.create(annotations2, typeConstructor2, bl, list, ktScope);
    }

    public static final boolean isOrOverridesSynthesized(@NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (Intrinsics.areEqual((Object)descriptor2.getKind(), (Object)CallableMemberDescriptor.Kind.SYNTHESIZED)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)descriptor2.getKind(), (Object)CallableMemberDescriptor.Kind.FAKE_OVERRIDE)) {
            boolean bl;
            block3: {
                Iterable $receiver = descriptor2.getOverriddenDescriptors();
                for (Object element : $receiver) {
                    CallableMemberDescriptor it2;
                    CallableMemberDescriptor callableMemberDescriptor = it2 = (CallableMemberDescriptor)element;
                    Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor, "it");
                    if (CallResolverUtilKt.isOrOverridesSynthesized(callableMemberDescriptor)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public static final boolean isConventionCall(@NotNull Call call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        if (call instanceof CallTransformer.CallForImplicitInvoke) {
            return true;
        }
        KtElement callElement = call.getCallElement();
        if (callElement instanceof KtArrayAccessExpression || callElement instanceof KtMultiDeclarationEntry) {
            return true;
        }
        KtExpression ktExpression = call.getCalleeExpression();
        if (!(ktExpression instanceof KtOperationReferenceExpression)) {
            ktExpression = null;
        }
        KtOperationReferenceExpression ktOperationReferenceExpression = (KtOperationReferenceExpression)ktExpression;
        if (ktOperationReferenceExpression == null) {
            return false;
        }
        KtOperationReferenceExpression calleeExpression = ktOperationReferenceExpression;
        return KtOperationReferenceExpression.getNameForConventionalOperation$default(calleeExpression, false, false, 3) != null;
    }

    @Nullable
    public static final Name getUnaryPlusOrMinusOperatorFunctionName(@NotNull Call call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        if (!(call.getCallElement() instanceof KtPrefixExpression)) {
            return null;
        }
        KtExpression ktExpression = call.getCalleeExpression();
        if (!(ktExpression instanceof KtOperationReferenceExpression)) {
            ktExpression = null;
        }
        KtOperationReferenceExpression ktOperationReferenceExpression = (KtOperationReferenceExpression)ktExpression;
        if (ktOperationReferenceExpression == null) {
            return null;
        }
        KtOperationReferenceExpression calleeExpression = ktOperationReferenceExpression;
        Name name = calleeExpression.getNameForConventionalOperation(true, false);
        return Intrinsics.areEqual(name, OperatorNameConventions.INSTANCE.getUNARY_PLUS()) || Intrinsics.areEqual(name, OperatorNameConventions.INSTANCE.getUNARY_MINUS()) ? name : (Name)null;
    }

    public static final boolean isInvokeCallOnVariable(@NotNull Call call) {
        ReceiverValue dispatchReceiver;
        Intrinsics.checkParameterIsNotNull(call, "call");
        if (call.getCallType() != Call.CallType.INVOKE) {
            return false;
        }
        ReceiverValue receiverValue = dispatchReceiver = call.getDispatchReceiver();
        if (receiverValue == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver");
        }
        KtExpression expression = ((ExpressionReceiver)receiverValue).getExpression();
        return expression instanceof KtSimpleNameExpression;
    }

    public static final boolean isInvokeCallOnExpressionWithBothReceivers(@NotNull Call call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        if (call.getCallType() != Call.CallType.INVOKE || CallResolverUtilKt.isInvokeCallOnVariable(call)) {
            return false;
        }
        return call.getExplicitReceiver().exists() && call.getDispatchReceiver().exists();
    }

    @Nullable
    public static final KtSuperExpression getSuperCallExpression(@NotNull Call call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        ReceiverValue receiverValue = call.getExplicitReceiver();
        if (!(receiverValue instanceof ExpressionReceiver)) {
            receiverValue = null;
        }
        ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverValue;
        KtExpression ktExpression = expressionReceiver != null ? expressionReceiver.getExpression() : null;
        if (!(ktExpression instanceof KtSuperExpression)) {
            ktExpression = null;
        }
        return (KtSuperExpression)ktExpression;
    }

    @NotNull
    public static final KotlinType getEffectiveExpectedType(@NotNull ValueParameterDescriptor parameterDescriptor, @NotNull ValueArgument argument) {
        Intrinsics.checkParameterIsNotNull(parameterDescriptor, "parameterDescriptor");
        Intrinsics.checkParameterIsNotNull(argument, "argument");
        if (argument.getSpreadElement() != null) {
            if (parameterDescriptor.getVarargElementType() == null) {
                KotlinType kotlinType = TypeUtils.DONT_CARE;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "DONT_CARE");
                return kotlinType;
            }
            KotlinType kotlinType = parameterDescriptor.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "parameterDescriptor.getType()");
            return kotlinType;
        }
        KotlinType varargElementType = parameterDescriptor.getVarargElementType();
        if (varargElementType != null) {
            return varargElementType;
        }
        KotlinType kotlinType = parameterDescriptor.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "parameterDescriptor.getType()");
        return kotlinType;
    }
}

