/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.scopes.KtScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeCapabilities;
import org.jetbrains.kotlin.types.TypeCapability;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

public abstract class DelegatingType
implements KotlinType {
    protected abstract KotlinType getDelegate();

    @Override
    @NotNull
    public TypeConstructor getConstructor() {
        TypeConstructor typeConstructor2 = this.getDelegate().getConstructor();
        if (typeConstructor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/DelegatingType", "getConstructor"));
        }
        return typeConstructor2;
    }

    @Override
    @NotNull
    public List<TypeProjection> getArguments() {
        List<TypeProjection> list = this.getDelegate().getArguments();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/DelegatingType", "getArguments"));
        }
        return list;
    }

    @Override
    @NotNull
    public TypeSubstitution getSubstitution() {
        TypeSubstitution typeSubstitution = this.getDelegate().getSubstitution();
        if (typeSubstitution == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/DelegatingType", "getSubstitution"));
        }
        return typeSubstitution;
    }

    @Override
    public boolean isMarkedNullable() {
        return this.getDelegate().isMarkedNullable();
    }

    @Override
    @NotNull
    public KtScope getMemberScope() {
        KtScope ktScope = this.getDelegate().getMemberScope();
        if (ktScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/DelegatingType", "getMemberScope"));
        }
        return ktScope;
    }

    @Override
    public boolean isError() {
        return this.getDelegate().isError();
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        Annotations annotations2 = this.getDelegate().getAnnotations();
        if (annotations2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/DelegatingType", "getAnnotations"));
        }
        return annotations2;
    }

    @Override
    @Nullable
    public <T extends TypeCapability> T getCapability(@NotNull Class<T> capabilityClass) {
        if (capabilityClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "capabilityClass", "org/jetbrains/kotlin/types/DelegatingType", "getCapability"));
        }
        return this.getDelegate().getCapability(capabilityClass);
    }

    @Override
    @NotNull
    public TypeCapabilities getCapabilities() {
        TypeCapabilities typeCapabilities = this.getDelegate().getCapabilities();
        if (typeCapabilities == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/DelegatingType", "getCapabilities"));
        }
        return typeCapabilities;
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KotlinType)) {
            return false;
        }
        KotlinType type2 = (KotlinType)obj;
        return KotlinTypeChecker.FLEXIBLE_UNEQUAL_TO_INFLEXIBLE.equalTypes(this, type2);
    }

    public String toString() {
        return this.getDelegate().toString();
    }
}

