/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava;

import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.light.AbstractLightClass;
import com.intellij.psi.impl.source.ClassInnerStuffCache;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import kotlin.ArraysKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.ClsWrapperStubPsiFactory;
import org.jetbrains.kotlin.asJava.KotlinLightClass;
import org.jetbrains.kotlin.asJava.KotlinLightClassForEnumEntry;
import org.jetbrains.kotlin.asJava.KotlinLightEnumConstant;
import org.jetbrains.kotlin.asJava.KotlinLightFieldForDeclaration;
import org.jetbrains.kotlin.asJava.KotlinLightMethodForDeclaration;
import org.jetbrains.kotlin.asJava.KotlinLightMethodForTraitFakeOverride;
import org.jetbrains.kotlin.asJava.KotlinNoOriginLightField;
import org.jetbrains.kotlin.asJava.KotlinNoOriginLightMethod;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

public abstract class KotlinWrappingLightClass
extends AbstractLightClass
implements PsiExtensibleClass,
KotlinLightClass {
    private final ClassInnerStuffCache myInnersCache = new ClassInnerStuffCache(this);

    protected KotlinWrappingLightClass(PsiManager manager) {
        super(manager, KotlinLanguage.INSTANCE);
    }

    @Override
    @Nullable
    public abstract KtClassOrObject getOrigin();

    @Override
    @NotNull
    public abstract PsiClass getDelegate();

    @Override
    @NotNull
    public PsiField[] getFields() {
        PsiField[] psiFieldArray = this.myInnersCache.getFields();
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinWrappingLightClass", "getFields"));
        }
        return psiFieldArray;
    }

    @Override
    @NotNull
    public PsiMethod[] getMethods() {
        PsiMethod[] psiMethodArray = this.myInnersCache.getMethods();
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinWrappingLightClass", "getMethods"));
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiMethod[] getConstructors() {
        PsiMethod[] psiMethodArray = this.myInnersCache.getConstructors();
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinWrappingLightClass", "getConstructors"));
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiClass[] getInnerClasses() {
        PsiClass[] psiClassArray = this.myInnersCache.getInnerClasses();
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinWrappingLightClass", "getInnerClasses"));
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public PsiField[] getAllFields() {
        PsiField[] psiFieldArray = PsiClassImplUtil.getAllFields(this);
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinWrappingLightClass", "getAllFields"));
        }
        return psiFieldArray;
    }

    @Override
    @NotNull
    public PsiMethod[] getAllMethods() {
        PsiMethod[] psiMethodArray = PsiClassImplUtil.getAllMethods(this);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinWrappingLightClass", "getAllMethods"));
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiClass[] getAllInnerClasses() {
        PsiClass[] psiClassArray = PsiClassImplUtil.getAllInnerClasses(this);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinWrappingLightClass", "getAllInnerClasses"));
        }
        return psiClassArray;
    }

    @Override
    public PsiField findFieldByName(String name, boolean checkBases) {
        return this.myInnersCache.findFieldByName(name, checkBases);
    }

    @Override
    @NotNull
    public PsiMethod[] findMethodsByName(String name, boolean checkBases) {
        PsiMethod[] psiMethodArray = this.myInnersCache.findMethodsByName(name, checkBases);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinWrappingLightClass", "findMethodsByName"));
        }
        return psiMethodArray;
    }

    @Override
    public PsiClass findInnerClassByName(String name, boolean checkBases) {
        return this.myInnersCache.findInnerClassByName(name, checkBases);
    }

    @Override
    @NotNull
    public List<PsiField> getOwnFields() {
        List<PsiField> list = ContainerUtil.map(this.getDelegate().getFields(), new Function<PsiField, PsiField>(){

            @Override
            public PsiField fun(PsiField field) {
                KtDeclaration declaration = ClsWrapperStubPsiFactory.getOriginalDeclaration(field);
                if (declaration instanceof KtEnumEntry) {
                    assert (field instanceof PsiEnumConstant) : "Field delegate should be an enum constant (" + field.getName() + "):\n" + PsiUtilsKt.getElementTextWithContext(declaration);
                    KtEnumEntry enumEntry = (KtEnumEntry)declaration;
                    PsiEnumConstant enumConstant = (PsiEnumConstant)field;
                    FqName enumConstantFqName = new FqName(KotlinWrappingLightClass.this.getFqName().asString() + "." + enumEntry.getName());
                    KotlinLightClassForEnumEntry initializingClass = enumEntry.getDeclarations().isEmpty() ? null : new KotlinLightClassForEnumEntry(KotlinWrappingLightClass.this.myManager, enumConstantFqName, enumEntry, enumConstant);
                    return new KotlinLightEnumConstant(KotlinWrappingLightClass.this.myManager, enumEntry, enumConstant, KotlinWrappingLightClass.this, initializingClass);
                }
                if (declaration != null) {
                    return new KotlinLightFieldForDeclaration(KotlinWrappingLightClass.this.myManager, declaration, field, (PsiClass)KotlinWrappingLightClass.this);
                }
                return new KotlinNoOriginLightField(KotlinWrappingLightClass.this.myManager, field, KotlinWrappingLightClass.this);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinWrappingLightClass", "getOwnFields"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<PsiMethod> getOwnMethods() {
        List<PsiMethod> list = ArraysKt.map(this.getDelegate().getMethods(), new Function1<PsiMethod, PsiMethod>(){

            @Override
            public PsiMethod invoke(PsiMethod method) {
                KtDeclaration declaration = ClsWrapperStubPsiFactory.getOriginalDeclaration(method);
                if (declaration instanceof KtPropertyAccessor) {
                    declaration = PsiTreeUtil.getParentOfType((PsiElement)declaration, KtProperty.class);
                }
                if (declaration != null) {
                    return !KotlinWrappingLightClass.this.isTraitFakeOverride(declaration) ? new KotlinLightMethodForDeclaration(KotlinWrappingLightClass.this.myManager, method, declaration, KotlinWrappingLightClass.this) : new KotlinLightMethodForTraitFakeOverride(KotlinWrappingLightClass.this.myManager, method, declaration, KotlinWrappingLightClass.this);
                }
                return new KotlinNoOriginLightMethod(KotlinWrappingLightClass.this.myManager, method, KotlinWrappingLightClass.this);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinWrappingLightClass", "getOwnMethods"));
        }
        return list;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/asJava/KotlinWrappingLightClass", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/asJava/KotlinWrappingLightClass", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/asJava/KotlinWrappingLightClass", "processDeclarations"));
        }
        if (this.isEnum() && !PsiClassImplUtil.processDeclarationsInEnum(processor, state, this.myInnersCache)) {
            return false;
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    @Override
    public String getText() {
        KtClassOrObject origin = this.getOrigin();
        return origin == null ? null : origin.getText();
    }

    @Override
    @NotNull
    public Language getLanguage() {
        KotlinLanguage kotlinLanguage = KotlinLanguage.INSTANCE;
        if (kotlinLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinWrappingLightClass", "getLanguage"));
        }
        return kotlinLanguage;
    }

    private boolean isTraitFakeOverride(@NotNull KtDeclaration originMethodDeclaration) {
        if (originMethodDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originMethodDeclaration", "org/jetbrains/kotlin/asJava/KotlinWrappingLightClass", "isTraitFakeOverride"));
        }
        if (!(originMethodDeclaration instanceof KtNamedFunction || originMethodDeclaration instanceof KtPropertyAccessor || originMethodDeclaration instanceof KtProperty)) {
            return false;
        }
        KtClassOrObject parentOfMethodOrigin = PsiTreeUtil.getParentOfType((PsiElement)originMethodDeclaration, KtClassOrObject.class);
        KtClassOrObject thisClassDeclaration = this.getOrigin();
        return parentOfMethodOrigin != null && thisClassDeclaration != parentOfMethodOrigin && KtPsiUtil.isTrait(parentOfMethodOrigin);
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @Override
    public PsiElement getContext() {
        return this.getParent();
    }
}

