/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.Label;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValue;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionVisitor;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionVisitorWithResult;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.LexicalScope;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.AbstractJumpInstruction;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.utils.CollectionsKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"[\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001E\u0006\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\t\t)\u0011\u0001\u0003\t\u0006\u0003\u0011\rQ!\u0001\u0005\u0010\u000b\u0005!q!B\u0001\t\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u0011Q!\u0001\u0005\b\u0019\u0001I\u0012\u0001'\u0001\"0%\u0019\u0001\"A\u0007\u00021\u0007I1\u0001\u0003\u0002\u000e\u0003a\u0015\u0011b\u0001\u0005\u0004\u001b\u0005A:!C\u0002\t\t5\t\u0001\u0014B\u0005\u0005\u0011\u0015i!\u0001$\u0001\u0019\fE\u001b\u0011\u0001\u0003\u0004&\u0011\u0011Y\u0001RE\u0007\u00021MI2\u0001c\n\u000e\u0003a!R\u0015\u0005\u0003\f\u0011Ki\u0011\u0001*\u000b\u0012\u0005\u0011\u0001\u0001\u0012F\r\u0007\u0011OiA!\u0003\u0002\n\u0003\u0011&\u0002$F)\u0004\u0003!-R\u0005\u0004\u0003\u000b\u0011Yi\u0011\u0001'\u0001\u001a\u0007!5R\"\u0001M\u00053\rA1!D\u0001\u0019\b\u0015\"Aa\u0003\u0005\u0018\u001b\u0005Az#\u000b\u0005\u0005\u0003rAi!\u0004\u0002\r\u0002a9\u0011kA\u0001\u0006\u0001%BA!\u0011\u000f\t\u00105\u0011A\u0012\u0001\r\b#\u000e\tQ\u0001A\u0015\f\t\rC\u0001\"B\u0007\u0003\u0019\u0003AZ!U\u0002\u0005\u000b\u0001i!\u0001\u0002\u0005\t\u0012%jAa\u0013\u0005\t\u00135!\u0011BA\u0005\u00021\u0017A\u001a\u0002H\u0016R\u0007\ri!\u0001\u0002\u0006\t\u0016%jAa\u0013\u0005\t\u00175!\u0011BA\u0005\u00021\u001dA:\u0002H\u0016R\u0007\ri!\u0001\u0002\u0007\t\u001a%\u0012Ba\u0011\u000f\t\u001c5\t\u0001dB\r\u0004\u00115i\u0011\u0001G\u0004\u001dG\u0001\u001a\u0013k\u0001\u0004\u000e\u0005\u0011q\u0001RD\t\u0003\t=Ay\"\u000b\n\u0005\u0007rA\u0001#D\u0001\u0019\u000fe\u0019\u0001\"D\u0007\u00021\u001da2\u0005I\u0012R\u0007\u0019i!\u0001\"\t\t\u001eE\u0011A!\u0005E\u0010S)!1\t\u0003\u0005\u0003\u001b\u0005A*!U\u0002\u0005\u000b\u0001i!\u0001b\t\t%\u0001"}, strings={"Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/jumps/ConditionalJumpInstruction;", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/jumps/AbstractJumpInstruction;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "onTrue", "", "lexicalScope", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/LexicalScope;", "targetLabel", "Lorg/jetbrains/kotlin/cfg/Label;", "conditionValue", "Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;", "(Lorg/jetbrains/kotlin/psi/KtElement;ZLorg/jetbrains/kotlin/cfg/pseudocode/instructions/LexicalScope;Lorg/jetbrains/kotlin/cfg/Label;Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;)V", "_nextOnFalse", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "_nextOnTrue", "getConditionValue", "()Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;", "inputValues", "", "getInputValues", "()Ljava/util/List;", "nextInstructions", "", "getNextInstructions", "()Ljava/util/Collection;", "value", "nextOnFalse", "getNextOnFalse", "()Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "setNextOnFalse", "(Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;)V", "nextOnTrue", "getNextOnTrue", "setNextOnTrue", "getOnTrue", "()Z", "accept", "", "visitor", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionVisitor;", "R", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionVisitorWithResult;", "(Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionVisitorWithResult;)Ljava/lang/Object;", "createCopy", "newLabel", "toString", ""}, moduleName="kotlin-compiler")
public final class ConditionalJumpInstruction
extends AbstractJumpInstruction {
    private Instruction _nextOnTrue;
    private Instruction _nextOnFalse;
    private final boolean onTrue;
    @Nullable
    private final PseudoValue conditionValue;

    @NotNull
    public final Instruction getNextOnTrue() {
        Instruction instruction = this._nextOnTrue;
        if (instruction == null) {
            Intrinsics.throwNpe();
        }
        return instruction;
    }

    public final void setNextOnTrue(@NotNull Instruction value2) {
        Intrinsics.checkParameterIsNotNull(value2, "value");
        this._nextOnTrue = this.outgoingEdgeTo(value2);
    }

    @NotNull
    public final Instruction getNextOnFalse() {
        Instruction instruction = this._nextOnFalse;
        if (instruction == null) {
            Intrinsics.throwNpe();
        }
        return instruction;
    }

    public final void setNextOnFalse(@NotNull Instruction value2) {
        Intrinsics.checkParameterIsNotNull(value2, "value");
        this._nextOnFalse = this.outgoingEdgeTo(value2);
    }

    @Override
    @NotNull
    public Collection<Instruction> getNextInstructions() {
        Collection collection = Arrays.asList(this.getNextOnFalse(), this.getNextOnTrue());
        Intrinsics.checkExpressionValueIsNotNull(collection, "Arrays.asList(nextOnFalse, nextOnTrue)");
        return collection;
    }

    @Override
    @NotNull
    public List<PseudoValue> getInputValues() {
        return CollectionsKt.emptyOrSingletonList(this.conditionValue);
    }

    @Override
    public void accept(@NotNull InstructionVisitor visitor2) {
        Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
        visitor2.visitConditionalJump(this);
    }

    @Override
    public <R> R accept(@NotNull InstructionVisitorWithResult<R> visitor2) {
        Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
        return visitor2.visitConditionalJump(this);
    }

    @NotNull
    public String toString() {
        Object object;
        String instr;
        block3: {
            block2: {
                instr = this.onTrue ? "jt" : "jf";
                object = this.conditionValue;
                if (object == null) break block2;
                PseudoValue $receiver = object;
                PseudoValue it2 = $receiver;
                object = "|" + it2;
                if (object != null) break block3;
            }
            object = "";
        }
        Object inValue = object;
        return instr + "(" + this.getTargetLabel().getName() + (String)inValue + ")";
    }

    @Override
    @NotNull
    protected AbstractJumpInstruction createCopy(@NotNull Label newLabel, @NotNull LexicalScope lexicalScope) {
        Intrinsics.checkParameterIsNotNull(newLabel, "newLabel");
        Intrinsics.checkParameterIsNotNull(lexicalScope, "lexicalScope");
        return new ConditionalJumpInstruction(this.getElement(), this.onTrue, lexicalScope, newLabel, this.conditionValue);
    }

    public final boolean getOnTrue() {
        return this.onTrue;
    }

    @Nullable
    public final PseudoValue getConditionValue() {
        return this.conditionValue;
    }

    public ConditionalJumpInstruction(@NotNull KtElement element, boolean onTrue, @NotNull LexicalScope lexicalScope, @NotNull Label targetLabel, @Nullable PseudoValue conditionValue) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        Intrinsics.checkParameterIsNotNull(lexicalScope, "lexicalScope");
        Intrinsics.checkParameterIsNotNull(targetLabel, "targetLabel");
        super(element, targetLabel, lexicalScope);
        this.onTrue = onTrue;
        this.conditionValue = conditionValue;
    }
}

