/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.ReadOnly;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.FunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertySetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.VariableDescriptorWithInitializerImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.DescriptorSubstitutor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.SmartSet;

public class PropertyDescriptorImpl
extends VariableDescriptorWithInitializerImpl
implements PropertyDescriptor {
    private final Modality modality;
    private Visibility visibility;
    private final Set<PropertyDescriptor> overriddenProperties;
    private final PropertyDescriptor original;
    private final CallableMemberDescriptor.Kind kind;
    private final boolean lateInit;
    private final boolean isConst;
    private ReceiverParameterDescriptor dispatchReceiverParameter;
    private ReceiverParameterDescriptor extensionReceiverParameter;
    private List<TypeParameterDescriptor> typeParameters;
    private PropertyGetterDescriptorImpl getter;
    private PropertySetterDescriptor setter;
    private boolean setterProjectedOut;

    protected PropertyDescriptorImpl(@NotNull DeclarationDescriptor containingDeclaration, @Nullable PropertyDescriptor original, @NotNull Annotations annotations2, @NotNull Modality modality, @NotNull Visibility visibility, boolean isVar, @NotNull Name name, @NotNull CallableMemberDescriptor.Kind kind, @NotNull SourceElement source, boolean lateInit, boolean isConst) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "<init>"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "<init>"));
        }
        if (modality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modality", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "<init>"));
        }
        if (visibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "<init>"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "<init>"));
        }
        super(containingDeclaration, annotations2, name, null, isVar, source);
        this.overriddenProperties = SmartSet.create();
        this.modality = modality;
        this.visibility = visibility;
        this.original = original == null ? this : original;
        this.kind = kind;
        this.lateInit = lateInit;
        this.isConst = isConst;
    }

    @NotNull
    public static PropertyDescriptorImpl create(@NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations2, @NotNull Modality modality, @NotNull Visibility visibility, boolean isVar, @NotNull Name name, @NotNull CallableMemberDescriptor.Kind kind, @NotNull SourceElement source, boolean lateInit, boolean isConst) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "create"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "create"));
        }
        if (modality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modality", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "create"));
        }
        if (visibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "create"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "create"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "create"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "create"));
        }
        PropertyDescriptorImpl propertyDescriptorImpl = new PropertyDescriptorImpl(containingDeclaration, null, annotations2, modality, visibility, isVar, name, kind, source, lateInit, isConst);
        if (propertyDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "create"));
        }
        return propertyDescriptorImpl;
    }

    public void setType(@NotNull KotlinType outType, @ReadOnly @NotNull List<? extends TypeParameterDescriptor> typeParameters, @Nullable ReceiverParameterDescriptor dispatchReceiverParameter, @Nullable KotlinType receiverType) {
        if (outType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outType", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "setType"));
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "setType"));
        }
        ReceiverParameterDescriptor extensionReceiverParameter = DescriptorFactory.createExtensionReceiverParameterForCallable(this, receiverType);
        this.setType(outType, typeParameters, dispatchReceiverParameter, extensionReceiverParameter);
    }

    public void setType(@NotNull KotlinType outType, @ReadOnly @NotNull List<? extends TypeParameterDescriptor> typeParameters, @Nullable ReceiverParameterDescriptor dispatchReceiverParameter, @Nullable ReceiverParameterDescriptor extensionReceiverParameter) {
        if (outType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outType", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "setType"));
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "setType"));
        }
        this.setOutType(outType);
        this.typeParameters = new ArrayList<TypeParameterDescriptor>(typeParameters);
        this.extensionReceiverParameter = extensionReceiverParameter;
        this.dispatchReceiverParameter = dispatchReceiverParameter;
    }

    public void initialize(@Nullable PropertyGetterDescriptorImpl getter2, @Nullable PropertySetterDescriptor setter2) {
        this.getter = getter2;
        this.setter = setter2;
    }

    public void setSetterProjectedOut(boolean setterProjectedOut) {
        this.setterProjectedOut = setterProjectedOut;
    }

    public void setVisibility(@NotNull Visibility visibility) {
        if (visibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "setVisibility"));
        }
        this.visibility = visibility;
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getTypeParameters() {
        List<TypeParameterDescriptor> list = this.typeParameters;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "getTypeParameters"));
        }
        return list;
    }

    @Override
    @Nullable
    public ReceiverParameterDescriptor getExtensionReceiverParameter() {
        return this.extensionReceiverParameter;
    }

    @Override
    @Nullable
    public ReceiverParameterDescriptor getDispatchReceiverParameter() {
        return this.dispatchReceiverParameter;
    }

    @Override
    @NotNull
    public KotlinType getReturnType() {
        KotlinType kotlinType = this.getType();
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "getReturnType"));
        }
        return kotlinType;
    }

    @Override
    @NotNull
    public Modality getModality() {
        Modality modality = this.modality;
        if (modality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "getModality"));
        }
        return modality;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = this.visibility;
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "getVisibility"));
        }
        return visibility;
    }

    @Override
    @Nullable
    public PropertyGetterDescriptorImpl getGetter() {
        return this.getter;
    }

    @Override
    @Nullable
    public PropertySetterDescriptor getSetter() {
        return this.setter;
    }

    @Override
    public boolean isSetterProjectedOut() {
        return this.setterProjectedOut;
    }

    @Override
    public boolean isLateInit() {
        return this.lateInit;
    }

    @Override
    public boolean isConst() {
        return this.isConst;
    }

    @Override
    @NotNull
    public List<PropertyAccessorDescriptor> getAccessors() {
        ArrayList<PropertyAccessorDescriptor> result2 = new ArrayList<PropertyAccessorDescriptor>(2);
        if (this.getter != null) {
            result2.add(this.getter);
        }
        if (this.setter != null) {
            result2.add(this.setter);
        }
        ArrayList<PropertyAccessorDescriptor> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "getAccessors"));
        }
        return arrayList;
    }

    @Override
    public PropertyDescriptor substitute(@NotNull TypeSubstitutor originalSubstitutor) {
        if (originalSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalSubstitutor", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "substitute"));
        }
        if (originalSubstitutor.isEmpty()) {
            return this;
        }
        return this.doSubstitute(originalSubstitutor, this.getContainingDeclaration(), this.modality, this.visibility, this.getOriginal(), true, this.getKind());
    }

    @Nullable
    private PropertyDescriptor doSubstitute(@NotNull TypeSubstitutor originalSubstitutor, @NotNull DeclarationDescriptor newOwner, @NotNull Modality newModality, @NotNull Visibility newVisibility, @Nullable PropertyDescriptor original, boolean copyOverrides, @NotNull CallableMemberDescriptor.Kind kind) {
        PropertySetterDescriptorImpl newSetter;
        PropertyGetterDescriptorImpl newGetter;
        KotlinType substitutedReceiverType;
        ReceiverParameterDescriptor substitutedDispatchReceiver;
        KotlinType originalOutType;
        if (originalSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalSubstitutor", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "doSubstitute"));
        }
        if (newOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newOwner", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "doSubstitute"));
        }
        if (newModality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newModality", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "doSubstitute"));
        }
        if (newVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newVisibility", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "doSubstitute"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "doSubstitute"));
        }
        PropertyDescriptorImpl substitutedDescriptor = this.createSubstitutedCopy(newOwner, newModality, newVisibility, original, kind);
        List<TypeParameterDescriptor> originalTypeParameters = this.getTypeParameters();
        ArrayList<TypeParameterDescriptor> substitutedTypeParameters = new ArrayList<TypeParameterDescriptor>(originalTypeParameters.size());
        TypeSubstitutor substitutor2 = DescriptorSubstitutor.substituteTypeParameters(originalTypeParameters, originalSubstitutor.getSubstitution(), substitutedDescriptor, substitutedTypeParameters);
        KotlinType outType = substitutor2.substitute(originalOutType = this.getType(), Variance.OUT_VARIANCE);
        if (outType == null) {
            return null;
        }
        ReceiverParameterDescriptor dispatchReceiver = this.getDispatchReceiverParameter();
        if (dispatchReceiver != null) {
            substitutedDispatchReceiver = dispatchReceiver.substitute(substitutor2);
            if (substitutedDispatchReceiver == null) {
                return null;
            }
        } else {
            substitutedDispatchReceiver = null;
        }
        if (this.extensionReceiverParameter != null) {
            substitutedReceiverType = substitutor2.substitute(this.extensionReceiverParameter.getType(), Variance.IN_VARIANCE);
            if (substitutedReceiverType == null) {
                return null;
            }
        } else {
            substitutedReceiverType = null;
        }
        substitutedDescriptor.setType(outType, substitutedTypeParameters, substitutedDispatchReceiver, substitutedReceiverType);
        PropertyGetterDescriptorImpl propertyGetterDescriptorImpl = this.getter == null ? null : (newGetter = new PropertyGetterDescriptorImpl(substitutedDescriptor, this.getter.getAnnotations(), newModality, PropertyDescriptorImpl.convertVisibility(this.getter.getVisibility(), newVisibility), this.getter.hasBody(), this.getter.isDefault(), this.getter.isExternal(), kind, original == null ? null : original.getGetter(), SourceElement.NO_SOURCE));
        if (newGetter != null) {
            KotlinType returnType2 = this.getter.getReturnType();
            newGetter.initialize(returnType2 != null ? substitutor2.substitute(returnType2, Variance.OUT_VARIANCE) : null);
        }
        PropertySetterDescriptorImpl propertySetterDescriptorImpl = this.setter == null ? null : (newSetter = new PropertySetterDescriptorImpl(substitutedDescriptor, this.setter.getAnnotations(), newModality, PropertyDescriptorImpl.convertVisibility(this.setter.getVisibility(), newVisibility), this.setter.hasBody(), this.setter.isDefault(), this.setter.isExternal(), kind, original == null ? null : original.getSetter(), SourceElement.NO_SOURCE));
        if (newSetter != null) {
            List<ValueParameterDescriptor> substitutedValueParameters = FunctionDescriptorImpl.getSubstitutedValueParameters(newSetter, this.setter.getValueParameters(), substitutor2);
            if (substitutedValueParameters == null) {
                substitutedDescriptor.setSetterProjectedOut(true);
                substitutedValueParameters = Collections.singletonList(PropertySetterDescriptorImpl.createSetterParameter(newSetter, DescriptorUtilsKt.getBuiltIns(newOwner).getNothingType()));
            }
            if (substitutedValueParameters.size() != 1) {
                throw new IllegalStateException();
            }
            newSetter.initialize(substitutedValueParameters.get(0));
        }
        substitutedDescriptor.initialize(newGetter, newSetter);
        if (copyOverrides) {
            for (PropertyDescriptor propertyDescriptor : this.overriddenProperties) {
                substitutedDescriptor.addOverriddenDescriptor(propertyDescriptor.substitute(substitutor2));
            }
        }
        return substitutedDescriptor;
    }

    @NotNull
    protected PropertyDescriptorImpl createSubstitutedCopy(@NotNull DeclarationDescriptor newOwner, @NotNull Modality newModality, @NotNull Visibility newVisibility, @Nullable PropertyDescriptor original, @NotNull CallableMemberDescriptor.Kind kind) {
        if (newOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newOwner", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "createSubstitutedCopy"));
        }
        if (newModality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newModality", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "createSubstitutedCopy"));
        }
        if (newVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newVisibility", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "createSubstitutedCopy"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "createSubstitutedCopy"));
        }
        PropertyDescriptorImpl propertyDescriptorImpl = new PropertyDescriptorImpl(newOwner, original, this.getAnnotations(), newModality, newVisibility, this.isVar(), this.getName(), kind, SourceElement.NO_SOURCE, this.isLateInit(), this.isConst());
        if (propertyDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "createSubstitutedCopy"));
        }
        return propertyDescriptorImpl;
    }

    @NotNull
    private static Visibility convertVisibility(Visibility orig, Visibility candidate) {
        if (candidate == Visibilities.INHERITED) {
            Visibility visibility = candidate;
            if (visibility == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "convertVisibility"));
            }
            return visibility;
        }
        Integer result2 = Visibilities.compare(orig, candidate);
        Visibility visibility = result2 != null && result2 < 0 ? candidate : orig;
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "convertVisibility"));
        }
        return visibility;
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor2, D data) {
        return visitor2.visitPropertyDescriptor(this, data);
    }

    @Override
    @NotNull
    public PropertyDescriptor getOriginal() {
        PropertyDescriptor propertyDescriptor = this.original == this ? this : this.original.getOriginal();
        if (propertyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "getOriginal"));
        }
        return propertyDescriptor;
    }

    @Override
    @NotNull
    public CallableMemberDescriptor.Kind getKind() {
        CallableMemberDescriptor.Kind kind = this.kind;
        if (kind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "getKind"));
        }
        return kind;
    }

    @Override
    public void addOverriddenDescriptor(@NotNull CallableMemberDescriptor overridden) {
        if (overridden == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "addOverriddenDescriptor"));
        }
        this.overriddenProperties.add((PropertyDescriptorImpl)overridden);
    }

    @Override
    @NotNull
    public Collection<? extends PropertyDescriptor> getOverriddenDescriptors() {
        Set<PropertyDescriptor> set = this.overriddenProperties;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "getOverriddenDescriptors"));
        }
        return set;
    }

    @Override
    @NotNull
    public PropertyDescriptor copy(DeclarationDescriptor newOwner, Modality modality, Visibility visibility, CallableMemberDescriptor.Kind kind, boolean copyOverrides) {
        PropertyDescriptor propertyDescriptor = this.doSubstitute(TypeSubstitutor.EMPTY, newOwner, modality, visibility, null, copyOverrides, kind);
        if (propertyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl", "copy"));
        }
        return propertyDescriptor;
    }
}

