/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import kotlin.PreconditionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.kotlin.DeserializedDescriptorResolver;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.ClassDataWithSource;
import org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBufUtil;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u0019\u0001I\u0012\u0001'\u0001\"\u0016%\u0019\u0001\"A\u0007\u00021\u0007I1\u0001\u0003\u0002\u000e\u0003a\u0015\u0011kA\u0001\t\u0007\u0015JAa\u0003E\u0004\u001b\ta\t\u0001\u0007\u0003\u001a\u0007!%Q\"\u0001\r\u0006S\u001d!\u0011\t\u0003\u0005\u0003\u001b\u0005A*!U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0005)\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/load/kotlin/JavaClassDataFinder;", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassDataFinder;", "kotlinClassFinder", "Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder;", "deserializedDescriptorResolver", "Lorg/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver;", "(Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder;Lorg/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver;)V", "findClassData", "Lorg/jetbrains/kotlin/serialization/ClassDataWithSource;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;"}, moduleName="kotlin-compiler")
public final class JavaClassDataFinder
implements ClassDataFinder {
    private final KotlinClassFinder kotlinClassFinder;
    private final DeserializedDescriptorResolver deserializedDescriptorResolver;

    @Override
    @Nullable
    public ClassDataWithSource findClassData(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        KotlinJvmBinaryClass kotlinJvmBinaryClass = this.kotlinClassFinder.findKotlinClass(classId);
        if (kotlinJvmBinaryClass == null) {
            return null;
        }
        KotlinJvmBinaryClass kotlinJvmBinaryClass2 = kotlinJvmBinaryClass;
        boolean value2 = Intrinsics.areEqual(kotlinJvmBinaryClass2.getClassId(), classId);
        if (PreconditionsKt.getASSERTIONS_ENABLED() && !value2) {
            String message = "Class with incorrect id found: expected " + classId + ", actual " + kotlinJvmBinaryClass2.getClassId();
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        String[] stringArray = this.deserializedDescriptorResolver.readData(kotlinJvmBinaryClass2, DeserializedDescriptorResolver.KOTLIN_CLASS);
        if (stringArray == null) {
            return null;
        }
        String[] data = stringArray;
        String[] stringArray2 = kotlinJvmBinaryClass2.getClassHeader().getStrings();
        if (stringArray2 == null) {
            stringArray2 = (String[])PreconditionsKt.error("String table not found in " + kotlinJvmBinaryClass2);
        }
        String[] strings = stringArray2;
        Intrinsics.checkExpressionValueIsNotNull(data, "data");
        ClassData classData = JvmProtoBufUtil.readClassDataFrom(data, strings);
        return new ClassDataWithSource(classData, new KotlinJvmBinarySourceElement(kotlinJvmBinaryClass2));
    }

    public JavaClassDataFinder(@NotNull KotlinClassFinder kotlinClassFinder, @NotNull DeserializedDescriptorResolver deserializedDescriptorResolver) {
        Intrinsics.checkParameterIsNotNull(kotlinClassFinder, "kotlinClassFinder");
        Intrinsics.checkParameterIsNotNull(deserializedDescriptorResolver, "deserializedDescriptorResolver");
        this.kotlinClassFinder = kotlinClassFinder;
        this.deserializedDescriptorResolver = deserializedDescriptorResolver;
    }
}

