/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.psiUtil;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractElementManipulator;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.JetPsiUtilKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001d\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!!!B\u0001\t\u000f1\u0001\u0011\u0004B\u0005\u0003\u0013\u0005A\u0012\u0001'\u0001\"\u0006E\u001b\u0011\u0001c\u0001&\u0011\u0011Y\u0001BA\u0007\u00021\u000bI2\u0001C\u0002\u000e\u0003a\tQ%\u0005\u0003\f\u0011\u000fi!\u0001$\u0001\u0019\u0003e\u0019\u0001bA\u0007\u00021\u0005I2\u0001\u0003\u0003\u000e\u0003a\u0015\u0011d\u0001E\u0005\u001b\u0005AR\u0001"}, strings={"Lorg/jetbrains/kotlin/psi/psiUtil/StringTemplateExpressionManipulator;", "Lcom/intellij/psi/AbstractElementManipulator;", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "()V", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "element", "handleContentChange", "range", "newContent", ""}, moduleName="kotlin-compiler")
public final class StringTemplateExpressionManipulator
extends AbstractElementManipulator<KtStringTemplateExpression> {
    @Override
    @Nullable
    public KtStringTemplateExpression handleContentChange(@NotNull KtStringTemplateExpression element, @NotNull TextRange range, @NotNull String newContent) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        Intrinsics.checkParameterIsNotNull(range, "range");
        Intrinsics.checkParameterIsNotNull(newContent, "newContent");
        ASTNode node = element.getNode();
        String content = node.getFirstChildNode().getTextLength() == 1 ? StringUtil.escapeStringCharacters(newContent) : newContent;
        String oldText = node.getText();
        String newText = StringsKt.substring(oldText, 0, range.getStartOffset()) + content + StringsKt.substring(oldText, range.getEndOffset());
        Project project = element.getProject();
        Intrinsics.checkExpressionValueIsNotNull(project, "element.getProject()");
        KtExpression expression = new KtPsiFactory(project).createExpression(newText);
        node.replaceAllChildrenToChildrenOf(expression.getNode());
        return node.getPsi(KtStringTemplateExpression.class);
    }

    @Override
    @NotNull
    public TextRange getRangeInElement(@NotNull KtStringTemplateExpression element) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        return JetPsiUtilKt.getContentRange(element);
    }
}

