/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tasks;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.AbstractTracingStrategy;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001d\u0004)\u0011\u0001D\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\u0015Q!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001c\b\u0006\u00031\tQ!\u0001\u0003\u0005\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0003\u0011\u0011Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\t\u000f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\t\u001f\u0015\tA!A\u0003\u0002\u0011\u0017)\u0011\u0001B\u0001\u0006\u0003!!Q!\u0001C\u0002\u000b\u0005a\u0011\u0001\u0004\u0001\u001a\u0003a\u0005\u0011UC\u0005\u0004\u0011\u0005i\u0011\u0001g\u0001\n\u0007!\u0011Q\"\u0001M\u0003#\u000e\t\u0001bA\u0013\t\t-Aq!D\u0001\u0019\u0010e\u0019\u0001\u0002C\u0007\u00021#)\u0013\u0004B\u0006\t\u00135\t\u0001tB\t\u0006\t\u0001A\u0019\"\u0006\u0002\r\u0002aQ\u0011d\u0001\u0005\t\u001b\u0005A\n\"\u0007\u0006\t\u00165A\u0011B\u0002C\u0001\u0013\u0011I!!C\u0001%\u0014a]\u0001dC\u0013\r\t-AA\"D\u0001\u0019\u0010e\u0019\u0001\u0002C\u0007\u00021#I2\u0001\u0003\u0002\u000e\u0003a\u0015Q\u0005\u0006\u0003\f\u00113i\u0011\u0001g\u0004\u0012\t\u0011\u0001\u00012C\u000b\u00021)I2\u0001\u0003\u0005\u000e\u0003aE\u0011D\u0002\u0005\u000e\u001b\u0011I!!C\u0001%\u0014a]Q\u0005\u0006\u0003\f\u00117i\u0011\u0001g\u0004\u0012\t\u0011\u0001\u00012C\u000b\u00021)I2\u0001\u0003\u0005\u000e\u0003aE\u0011D\u0002\u0005\u000e\u001b\u0011I!!C\u0001%\u0014a]Q%\u0007\u0003\f\u00119i\u0011\u0001g\u0004\u0012\u000b\u0011\u0001\u00012C\u000b\u0003\u0019\u0003A\"\"G\u0002\t\u00115\t\u0001\u0014C\r\u000b\u0011+i\u0001\"\u0003\u0004\u0005\u0002%!\u0011BA\u0005\u0002I'A:\u0002G\u0006&\u0011\u0011Y\u0001RD\u0007\u00021\u001fI2\u0001\u0003\u0005\u000e\u0003aEQ\u0005\u0004\u0003\f\u0011=i\u0011\u0001g\u0004\u001a\u0007!AQ\"\u0001M\t3\rAy\"D\u0001\u0019!\u0015bAa\u0003E\u0011\u001b\u0005Az!G\u0002\t\u00115\t\u0001\u0014C\r\u0004\u0011Ei\u0011\u0001g\t&!\u0011Y\u0001BE\u0007\u00021\u001fI2\u0001\u0003\u0005\u000e\u0003aE\u0011d\u0001E\u0013\u001b\u0005A2#G\u0002\t(5\t\u0001\u0004F\u0013\t\t-AI#D\u0001\u0019\u0010e\u0019\u0001\u0002C\u0007\u00021#)C\u0002B\u0006\t+5\t\u0001tB\r\u0004\u0011!i\u0011\u0001'\u0005\u001a\u0007!-R\"\u0001\r\u0017Ke!1\u0002#\f\u000e\u0003a=\u0011#\u0002\u0003\u0001\u0011')\"\u0001$\u0001\u0019\u0015e\u0019\u0001\u0002C\u0007\u00021#I\"\u0002#\u0006\u000e\u0011%1A\u0011A\u0005\u0005\u0013\tI\u0011\u0001j\u0005\u0019\u0018aYQ\u0005\u0003\u0003\u0002\u0011]i\u0011\u0001g\u0004\u001a\u0007!AQ\"\u0001M\tK1!1\u0002c\f\u000e\u0003a=\u0011d\u0001\u0005\t\u001b\u0005A\n\"G\u0002\t15\t\u0001\u0014G\u0013\t\t\u0005A\u0011$D\u0001\u0019\u0010e\u0019\u00012G\u0007\u00021i)C\u0002B\u0006\t65\t\u0001tB\r\u0004\u0011!i\u0011\u0001'\u0005\u001a\u0007!MR\"\u0001\r\u001cK!!1\u0002c\u000e\u000e\u0003a=\u0011d\u0001\u0005\t\u001b\u0005A\n\"J\f\u0005\u0017!aR\"\u0001M\b#\u0011!\u0001\u0001c\u0005\u0016\u0003aQ\u0011d\u0001\u0005\t\u001b\u0005A\n\"G\u0005\t:59\u0011\"B\u0005\u0005\u0013\tI\u0011\u0001j\u0005\u0019\u0018aiR\u0005\u0005\u0003\f\u0011wi\u0011\u0001g\u0004\u001a\u0007!AQ\"\u0001M\t3\rA\u0019$D\u0001\u00197e\u0019\u0001BH\u0007\u00021{)C\u0002B\u0006\t?5\t\u0001tB\r\u0004\u0011!i\u0011\u0001'\u0005\u001a\u0007!}R\"\u0001\r!KA!1\u0002#\u0011\u000e\u0003a=\u0011d\u0001\u0005\t\u001b\u0005A\n\"G\u0002\tC5\t\u00014E\r\u0004\u0011\u0007j\u0011\u0001\u0007\u0012*\u001c\u0011\u0019\u0005\u0002c\u0002\u000e\n1\u0005\u0001\u0004B)\u0004\u0003\u0011%\u0011k\u0001\u0003\u0006\u00015\u0011A!\u0002E\u0006S)!1\t\u0003\u0005\u0002\u001b\u0005A\u001a!U\u0002\u0005\u000b\u0001i!\u0001\u0002\u0004\t\u000e\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyForImplicitConstructorDelegationCall;", "Lorg/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy;", "delegationCall", "Lorg/jetbrains/kotlin/psi/KtConstructorDelegationCall;", "call", "Lorg/jetbrains/kotlin/psi/Call;", "(Lorg/jetbrains/kotlin/psi/KtConstructorDelegationCall;Lorg/jetbrains/kotlin/psi/Call;)V", "calleeExpression", "Lorg/jetbrains/kotlin/psi/KtConstructorDelegationReferenceExpression;", "Lorg/jetbrains/annotations/Nullable;", "getCalleeExpression", "()Lorg/jetbrains/kotlin/psi/KtConstructorDelegationReferenceExpression;", "getDelegationCall", "()Lorg/jetbrains/kotlin/psi/KtConstructorDelegationCall;", "abstractSuperCall", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "ambiguity", "D", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "descriptors", "", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "bindCall", "bindReference", "resolvedCall", "bindResolvedCall", "cannotCompleteResolve", "instantiationOfAbstractClass", "invisibleMember", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "missingReceiver", "expectedReceiver", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "nestedClassAccessViaInstanceReference", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "explicitReceiverKind", "Lorg/jetbrains/kotlin/resolve/calls/tasks/ExplicitReceiverKind;", "noReceiverAllowed", "noValueForParameter", "valueParameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "noneApplicable", "reportError", "typeInferenceFailed", "data", "Lorg/jetbrains/kotlin/resolve/calls/inference/InferenceErrorData;", "unexpectedError", "type", "", "unnecessarySafeCall", "Lorg/jetbrains/kotlin/types/KotlinType;", "unresolvedReference", "unresolvedReferenceWrongReceiver", "candidates", "", "unsafeCall", "isCallForImplicitInvoke", "", "wrongNumberOfTypeArguments", "expectedTypeArgumentCount", "", "wrongReceiverType", "receiverParameter", "receiverArgument", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;"}, moduleName="kotlin-compiler")
public final class TracingStrategyForImplicitConstructorDelegationCall
extends AbstractTracingStrategy {
    @Nullable
    private final KtConstructorDelegationReferenceExpression calleeExpression;
    @NotNull
    private final KtConstructorDelegationCall delegationCall;

    @Nullable
    public final KtConstructorDelegationReferenceExpression getCalleeExpression() {
        return this.calleeExpression;
    }

    @Override
    public void bindCall(@NotNull BindingTrace trace, @NotNull Call call) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(call, "call");
        trace.record(BindingContext.CALL, call.getCalleeExpression(), call);
    }

    @Override
    public <D extends CallableDescriptor> void bindReference(@NotNull BindingTrace trace, @NotNull ResolvedCall<D> resolvedCall) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        D descriptor2 = resolvedCall.getCandidateDescriptor();
        DeclarationDescriptor storedReference = (DeclarationDescriptor)trace.get(BindingContext.REFERENCE_TARGET, this.calleeExpression);
        if (storedReference == null || !ErrorUtils.isError((DeclarationDescriptor)descriptor2)) {
            trace.record(BindingContext.REFERENCE_TARGET, this.calleeExpression, descriptor2);
        }
    }

    @Override
    public <D extends CallableDescriptor> void bindResolvedCall(@NotNull BindingTrace trace, @NotNull ResolvedCall<D> resolvedCall) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        trace.record(BindingContext.RESOLVED_CALL, this.call, resolvedCall);
    }

    @Override
    public void unresolvedReference(@NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        trace.report(Errors.UNRESOLVED_REFERENCE.on((KtReferenceExpression)((PsiElement)this.calleeExpression), this.calleeExpression));
    }

    @Override
    public <D extends CallableDescriptor> void unresolvedReferenceWrongReceiver(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> candidates) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(candidates, "candidates");
        trace.report(Errors.UNRESOLVED_REFERENCE_WRONG_RECEIVER.on(this.reference, candidates));
    }

    @Override
    public void noValueForParameter(@NotNull BindingTrace trace, @NotNull ValueParameterDescriptor valueParameter) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(valueParameter, "valueParameter");
        this.reportError(trace);
    }

    @Override
    public <D extends CallableDescriptor> void ambiguity(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> descriptors) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(descriptors, "descriptors");
        this.reportError(trace);
    }

    @Override
    public <D extends CallableDescriptor> void noneApplicable(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> descriptors) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(descriptors, "descriptors");
        this.reportError(trace);
    }

    @Override
    public void invisibleMember(@NotNull BindingTrace trace, @NotNull DeclarationDescriptorWithVisibility descriptor2) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        this.reportError(trace);
    }

    private final void reportError(BindingTrace trace) {
        boolean bl;
        block2: {
            Iterable $receiver = trace.getBindingContext().getDiagnostics().forElement(this.delegationCall);
            for (Object element : $receiver) {
                Diagnostic it2 = (Diagnostic)element;
                if (!Intrinsics.areEqual(it2.getFactory(), Errors.EXPLICIT_DELEGATION_CALL_REQUIRED)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        if (!bl) {
            trace.report(Errors.EXPLICIT_DELEGATION_CALL_REQUIRED.on((KtConstructorDelegationCall)((PsiElement)this.delegationCall)));
        }
    }

    @Override
    public <D extends CallableDescriptor> void cannotCompleteResolve(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> descriptors) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(descriptors, "descriptors");
        this.unexpectedError("cannotCompleteResolve");
    }

    @Override
    public void instantiationOfAbstractClass(@NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        this.unexpectedError("instantiationOfAbstractClass");
    }

    @Override
    public void abstractSuperCall(@NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        this.unexpectedError("abstractSuperCall");
    }

    @Override
    public void nestedClassAccessViaInstanceReference(@NotNull BindingTrace trace, @NotNull ClassDescriptor classDescriptor, @NotNull ExplicitReceiverKind explicitReceiverKind) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)explicitReceiverKind, "explicitReceiverKind");
        this.unexpectedError("nestedClassAccessViaInstanceReference");
    }

    @Override
    public void unsafeCall(@NotNull BindingTrace trace, @NotNull KotlinType type2, boolean isCallForImplicitInvoke) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(type2, "type");
        this.unexpectedError("unsafeCall");
    }

    @Override
    public void unnecessarySafeCall(@NotNull BindingTrace trace, @NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(type2, "type");
        this.unexpectedError("unnecessarySafeCall");
    }

    @Override
    public void missingReceiver(@NotNull BindingTrace trace, @NotNull ReceiverParameterDescriptor expectedReceiver) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(expectedReceiver, "expectedReceiver");
        this.unexpectedError("missingReceiver");
    }

    @Override
    public void wrongReceiverType(@NotNull BindingTrace trace, @NotNull ReceiverParameterDescriptor receiverParameter, @NotNull ReceiverValue receiverArgument) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(receiverParameter, "receiverParameter");
        Intrinsics.checkParameterIsNotNull(receiverArgument, "receiverArgument");
        this.unexpectedError("wrongReceiverType");
    }

    @Override
    public void noReceiverAllowed(@NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        this.unexpectedError("noReceiverAllowed");
    }

    @Override
    public void wrongNumberOfTypeArguments(@NotNull BindingTrace trace, int expectedTypeArgumentCount) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        this.unexpectedError("wrongNumberOfTypeArguments");
    }

    @Override
    public void typeInferenceFailed(@NotNull BindingTrace trace, @NotNull InferenceErrorData data) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(data, "data");
        this.unexpectedError("typeInferenceFailed");
    }

    private final void unexpectedError(String type2) {
        throw (Throwable)((Object)new AssertionError((Object)("Unexpected error type: " + type2)));
    }

    @NotNull
    public final KtConstructorDelegationCall getDelegationCall() {
        return this.delegationCall;
    }

    public TracingStrategyForImplicitConstructorDelegationCall(@NotNull KtConstructorDelegationCall delegationCall, @NotNull Call call) {
        Intrinsics.checkParameterIsNotNull(delegationCall, "delegationCall");
        Intrinsics.checkParameterIsNotNull(call, "call");
        KtConstructorDelegationReferenceExpression ktConstructorDelegationReferenceExpression = delegationCall.getCalleeExpression();
        if (ktConstructorDelegationReferenceExpression == null) {
            Intrinsics.throwNpe();
        }
        super(ktConstructorDelegationReferenceExpression, call);
        this.delegationCall = delegationCall;
        this.calleeExpression = this.delegationCall.getCalleeExpression();
    }
}

