/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.descriptors;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.impl.AbstractLazyTypeParameterDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStubbedPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.LazyClassContext;
import org.jetbrains.kotlin.resolve.lazy.LazyEntity;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyClassDescriptor;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;

public class LazyTypeParameterDescriptor
extends AbstractLazyTypeParameterDescriptor
implements LazyEntity {
    private final LazyClassContext c;
    private final KtTypeParameter jetTypeParameter;

    public LazyTypeParameterDescriptor(@NotNull LazyClassContext c, @NotNull LazyClassDescriptor containingDeclaration, @NotNull KtTypeParameter jetTypeParameter, int index2) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyTypeParameterDescriptor", "<init>"));
        }
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyTypeParameterDescriptor", "<init>"));
        }
        if (jetTypeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetTypeParameter", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyTypeParameterDescriptor", "<init>"));
        }
        super(c.getStorageManager(), containingDeclaration, jetTypeParameter.getNameAsSafeName(), jetTypeParameter.getVariance(), jetTypeParameter.hasModifier(KtTokens.REIFIED_KEYWORD), index2, KotlinSourceElementKt.toSourceElement(jetTypeParameter));
        this.c = c;
        this.jetTypeParameter = jetTypeParameter;
        this.c.getTrace().record(BindingContext.TYPE_PARAMETER, jetTypeParameter, this);
    }

    @Override
    @NotNull
    protected Set<KotlinType> resolveUpperBounds() {
        LinkedHashSet<KotlinType> upperBounds = Sets.newLinkedHashSet();
        KtTypeParameter jetTypeParameter = this.jetTypeParameter;
        KtTypeReference extendsBound = jetTypeParameter.getExtendsBound();
        if (extendsBound != null) {
            KotlinType boundType = this.c.getDescriptorResolver().resolveTypeParameterExtendsBound(this, extendsBound, this.getContainingDeclaration().getScopeForClassHeaderResolution(), this.c.getTrace());
            upperBounds.add(boundType);
        }
        this.resolveUpperBoundsFromWhereClause(upperBounds);
        if (upperBounds.isEmpty()) {
            upperBounds.add(this.c.getModuleDescriptor().getBuiltIns().getDefaultBound());
        }
        LinkedHashSet<KotlinType> linkedHashSet = upperBounds;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyTypeParameterDescriptor", "resolveUpperBounds"));
        }
        return linkedHashSet;
    }

    private void resolveUpperBoundsFromWhereClause(Set<KotlinType> upperBounds) {
        KtClassOrObject classOrObject = KtStubbedPsiUtil.getPsiOrStubParent(this.jetTypeParameter, KtClassOrObject.class, true);
        if (classOrObject instanceof KtClass) {
            KtClass ktClass = (KtClass)classOrObject;
            for (KtTypeConstraint jetTypeConstraint : ktClass.getTypeConstraints()) {
                KtSimpleNameExpression constrainedParameterName = jetTypeConstraint.getSubjectTypeParameterName();
                if (constrainedParameterName == null || !this.getName().equals(constrainedParameterName.getReferencedNameAsName())) continue;
                this.c.getTrace().record(BindingContext.REFERENCE_TARGET, constrainedParameterName, this);
                KtTypeReference boundTypeReference = jetTypeConstraint.getBoundTypeReference();
                if (boundTypeReference == null) continue;
                KotlinType boundType = this.resolveBoundType(boundTypeReference);
                upperBounds.add(boundType);
            }
        }
    }

    private KotlinType resolveBoundType(@NotNull KtTypeReference boundTypeReference) {
        if (boundTypeReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "boundTypeReference", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyTypeParameterDescriptor", "resolveBoundType"));
        }
        return this.c.getTypeResolver().resolveType(this.getContainingDeclaration().getScopeForClassHeaderResolution(), boundTypeReference, this.c.getTrace(), false);
    }

    @Override
    @NotNull
    public LazyClassDescriptor getContainingDeclaration() {
        LazyClassDescriptor lazyClassDescriptor = (LazyClassDescriptor)super.getContainingDeclaration();
        if (lazyClassDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyTypeParameterDescriptor", "getContainingDeclaration"));
        }
        return lazyClassDescriptor;
    }

    @Override
    public void forceResolveAllContents() {
        ForceResolveUtil.forceResolveAllContents(this.getAnnotations());
        this.getContainingDeclaration();
        this.getDefaultType();
        this.getIndex();
        ForceResolveUtil.forceResolveAllContents(this.getLowerBounds());
        this.getOriginal();
        ForceResolveUtil.forceResolveAllContents(this.getTypeConstructor());
        ForceResolveUtil.forceResolveAllContents(this.getUpperBounds());
        this.getUpperBoundsAsType();
        this.getVariance();
    }
}

