/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.HashSet;
import kotlin.PreconditionsKt;
import kotlin.SetsKt;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.types.DelegatingType;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.FlexibleTypeCapabilities;
import org.jetbrains.kotlin.types.FlexibleTypeDelegation;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.NullAwareness;
import org.jetbrains.kotlin.types.SubtypingRepresentatives;
import org.jetbrains.kotlin.types.TypeCapability;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"C\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!I!B\u0001\t\f\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tAaA\u0003\u0002\u0011\u001d)\u0001\u0001B\u0006\r\u0001A\u0001\u0012$\u0001M\u00013\u0005A\u0012!G\u0001\u0019\u0004e\t\u0001DAO\u0001!\u0005~AAA\u0005\u0004\u0011\u000bi\u0011\u0001G\u0002\n\u0007!\u001dQ\"\u0001\r\u0004\u0013\rAA!D\u0001\u0019\nE\u001b\u0011\u0001C\u0003&\t\u0011Y\u0001\"C\u0007\u00021');\u0003B\u0006\t\u00155\u0011A\u0012\u0001S\u000b#\u0011!\u0001\u0001#\u0006\u0016\u0003aY\u0011D\u0002E\f\u001b\u0011I!!C\u0001%\u0016aa\u0011kA\u0001\t\u001a\u0015\"AA\u0003\u0005\u000e\u001b\u0005A2!\n\u0003\u0005\u0017!mQ\"\u0001M\nK!!1\u0002\u0003\b\u000e\u0003a\u0019\u0011d\u0001E\u000f\u001b\u0005A\u001a\"\n\u0003\u0005\u0017!yQ\"\u0001M\u0010S)!1\n\u0003E\u0006\u001b\u0005A2!U\u0002\u0005\u000b\u0001i!\u0001\u0002\u0004\t\u000e%RAa\u0013\u0005\t\t5\t\u0001\u0014B)\u0004\t\u0015\u0001QB\u0001\u0003\b\u0011\u001fI#\u0002B&\t\u0011\u000bi\u0011\u0001G\u0002R\u0007\u0011)\u0001!\u0004\u0002\u0005\u0011!5\u0011F\u0003\u0003L\u0011!\u001dQ\"\u0001\r\u0004#\u000e!Q\u0001A\u0007\u0003\t#Ai\u0001"}, strings={"Lorg/jetbrains/kotlin/types/DelegatingFlexibleType;", "Lorg/jetbrains/kotlin/types/DelegatingType;", "Lorg/jetbrains/kotlin/types/NullAwareness;", "Lorg/jetbrains/kotlin/types/Flexibility;", "Lorg/jetbrains/kotlin/types/FlexibleTypeDelegation;", "lowerBound", "Lorg/jetbrains/kotlin/types/KotlinType;", "upperBound", "extraCapabilities", "Lorg/jetbrains/kotlin/types/FlexibleTypeCapabilities;", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/FlexibleTypeCapabilities;)V", "delegateType", "getDelegateType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "getExtraCapabilities", "()Lorg/jetbrains/kotlin/types/FlexibleTypeCapabilities;", "getLowerBound", "getUpperBound", "computeIsNullable", "", "getCapability", "T", "Lorg/jetbrains/kotlin/types/TypeCapability;", "capabilityClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Lorg/jetbrains/kotlin/types/TypeCapability;", "getDelegate", "isMarkedNullable", "makeNullableAsSpecified", "nullable", "toString", "", "Companion"}, moduleName="kotlin-compiler")
public class DelegatingFlexibleType
extends DelegatingType
implements Flexibility,
FlexibleTypeDelegation,
NullAwareness {
    @NotNull
    public static final HashSet<Class<? extends TypeCapability>> capabilityClasses;
    @NotNull
    private final KotlinType delegateType;
    @NotNull
    private final KotlinType lowerBound;
    @NotNull
    private final KotlinType upperBound;
    @NotNull
    private final FlexibleTypeCapabilities extraCapabilities;
    public static final Companion Companion;

    static {
        Companion = org.jetbrains.kotlin.types.DelegatingFlexibleType$Companion.INSTANCE;
        capabilityClasses = SetsKt.hashSetOf(NullAwareness.class, Flexibility.class, SubtypingRepresentatives.class, FlexibleTypeDelegation.class);
    }

    @Override
    @Nullable
    public <T extends TypeCapability> T getCapability(@NotNull Class<T> capabilityClass) {
        Intrinsics.checkParameterIsNotNull(capabilityClass, "capabilityClass");
        T extra = this.getExtraCapabilities().getCapability(capabilityClass, this, this);
        if (extra != null) {
            return extra;
        }
        if (Companion.getCapabilityClasses$kotlin_compiler().contains(capabilityClass)) {
            DelegatingFlexibleType delegatingFlexibleType = this;
            if (delegatingFlexibleType == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            return (T)delegatingFlexibleType;
        }
        return super.getCapability(capabilityClass);
    }

    @Override
    @NotNull
    public KotlinType makeNullableAsSpecified(boolean nullable2) {
        KotlinType kotlinType = TypeUtils.makeNullableAsSpecified(this.getLowerBound(), nullable2);
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "TypeUtils.makeNullableAs\u2026ied(lowerBound, nullable)");
        KotlinType kotlinType2 = TypeUtils.makeNullableAsSpecified(this.getUpperBound(), nullable2);
        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "TypeUtils.makeNullableAs\u2026ied(upperBound, nullable)");
        return Companion.create(kotlinType, kotlinType2, this.getExtraCapabilities());
    }

    @Override
    public boolean computeIsNullable() {
        return this.getDelegateType().isMarkedNullable();
    }

    @Override
    public boolean isMarkedNullable() {
        NullAwareness nullAwareness = this.getCapability(NullAwareness.class);
        if (nullAwareness == null) {
            Intrinsics.throwNpe();
        }
        return nullAwareness.computeIsNullable();
    }

    @Override
    @NotNull
    public KotlinType getDelegateType() {
        return this.delegateType;
    }

    @Override
    @NotNull
    protected KotlinType getDelegate() {
        FlexibleTypeDelegation flexibleTypeDelegation = this.getCapability(FlexibleTypeDelegation.class);
        if (flexibleTypeDelegation == null) {
            Intrinsics.throwNpe();
        }
        return flexibleTypeDelegation.getDelegateType();
    }

    @Override
    @NotNull
    public String toString() {
        return "('" + this.getLowerBound() + "'..'" + this.getUpperBound() + "')";
    }

    @Override
    @NotNull
    public KotlinType getLowerBound() {
        return this.lowerBound;
    }

    @Override
    @NotNull
    public KotlinType getUpperBound() {
        return this.upperBound;
    }

    @Override
    @NotNull
    public FlexibleTypeCapabilities getExtraCapabilities() {
        return this.extraCapabilities;
    }

    protected DelegatingFlexibleType(@NotNull KotlinType lowerBound, @NotNull KotlinType upperBound, @NotNull FlexibleTypeCapabilities extraCapabilities) {
        Intrinsics.checkParameterIsNotNull(lowerBound, "lowerBound");
        Intrinsics.checkParameterIsNotNull(upperBound, "upperBound");
        Intrinsics.checkParameterIsNotNull(extraCapabilities, "extraCapabilities");
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.extraCapabilities = extraCapabilities;
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            boolean value2;
            boolean bl = !FlexibleTypesKt.isFlexible(this.getLowerBound());
            if (PreconditionsKt.getASSERTIONS_ENABLED() && !value2) {
                String message = "Lower bound of a flexible type can not be flexible: " + this.getLowerBound();
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            value2 = !FlexibleTypesKt.isFlexible(this.getUpperBound());
            if (PreconditionsKt.getASSERTIONS_ENABLED() && !value2) {
                String message = "Upper bound of a flexible type can not be flexible: " + this.getUpperBound();
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            value2 = Intrinsics.areEqual(this.getLowerBound(), this.getUpperBound()) ^ true;
            if (PreconditionsKt.getASSERTIONS_ENABLED() && !value2) {
                String message = "Lower and upper bounds are equal: " + this.getLowerBound() + " == " + this.getUpperBound();
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            value2 = KotlinTypeChecker.DEFAULT.isSubtypeOf(this.getLowerBound(), this.getUpperBound());
            if (PreconditionsKt.getASSERTIONS_ENABLED() && !value2) {
                String message = "Lower bound " + this.getLowerBound() + " of a flexible type must be a subtype of the upper bound " + this.getUpperBound();
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
        }
        this.delegateType = this.getLowerBound();
    }

    @Override
    @NotNull
    public KotlinType getSubTypeRepresentative() {
        return Flexibility.DefaultImpls.getSubTypeRepresentative(this);
    }

    @Override
    @NotNull
    public KotlinType getSuperTypeRepresentative() {
        return Flexibility.DefaultImpls.getSuperTypeRepresentative(this);
    }

    @Override
    public boolean sameTypeConstructor(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        return Flexibility.DefaultImpls.sameTypeConstructor(this, type2);
    }

    @JvmStatic
    @NotNull
    public static final KotlinType create(@NotNull KotlinType lowerBound, @NotNull KotlinType upperBound, @NotNull FlexibleTypeCapabilities extraCapabilities) {
        Intrinsics.checkParameterIsNotNull(lowerBound, "lowerBound");
        Intrinsics.checkParameterIsNotNull(upperBound, "upperBound");
        Intrinsics.checkParameterIsNotNull(extraCapabilities, "extraCapabilities");
        return Companion.create(lowerBound, upperBound, extraCapabilities);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={")\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0005\u0007\ba\u0001!G\u0001\u0019\u0002\u0005\u001eA!A)\u0004\u0003!\tQ\u0005\u0005C\u0004\u0011\u0013i\u0011\u0001G\u0003\u001a\u0007!-Q\"\u0001\r\u00063\rAa!D\u0001\u0019\u000be\u0019\u0001RB\u0007\u00021\u001dI#\u0003\u0002!\t\u0011\u0007i\u0001\"\u0003\u0004\n\u000b%\u0019A\u0011A\u0005\u00021\rA*\u0001\u0007\u0002R\u0007\u0015)\u0011\u0001$\u0001\u000e\u0005\u0011\u001d\u0001\u0002\u0002"}, strings={"Lorg/jetbrains/kotlin/types/DelegatingFlexibleType$Companion;", "", "()V", "capabilityClasses", "Ljava/util/HashSet;", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/types/TypeCapability;", "getCapabilityClasses$kotlin_compiler", "()Ljava/util/HashSet;", "create", "Lorg/jetbrains/kotlin/types/KotlinType;", "lowerBound", "upperBound", "extraCapabilities", "Lorg/jetbrains/kotlin/types/FlexibleTypeCapabilities;"}, moduleName="kotlin-compiler")
    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final HashSet<Class<? extends TypeCapability>> getCapabilityClasses$kotlin_compiler() {
            return capabilityClasses;
        }

        @JvmStatic
        @NotNull
        public final KotlinType create(@NotNull KotlinType lowerBound, @NotNull KotlinType upperBound, @NotNull FlexibleTypeCapabilities extraCapabilities) {
            Intrinsics.checkParameterIsNotNull(lowerBound, "lowerBound");
            Intrinsics.checkParameterIsNotNull(upperBound, "upperBound");
            Intrinsics.checkParameterIsNotNull(extraCapabilities, "extraCapabilities");
            if (Intrinsics.areEqual(lowerBound, upperBound)) {
                return lowerBound;
            }
            return new DelegatingFlexibleType(lowerBound, upperBound, extraCapabilities);
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

