/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.operation;

import gnu.trove.THashMap;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.BinaryOperationIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.BinaryOperationIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.CompareToBOIF;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.EqualsBOIF;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.LongCompareToBOIF;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.NO_INTRINSIC;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.psi.KtBinaryExpression;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={";\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!\u0001R!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tAaA\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001A\u0002A\r\u00021\u0003\t+!U\u0002\u0002\u0011\u0005)C\u0002B\u0001\t\r5\t\u00014B\r\u0004\u0011\u001bi\u0011\u0001'\u0003\u001a\u0007!9Q\"\u0001\r\u0006K1!\u0011\u0001c\u0004\u000e\u0003a-\u0011d\u0001E\u0007\u001b\u0005AJ!G\u0002\t\u000f5\t\u0001$B\u0013\f\u0011!i\u0011\u0001g\u0003\u001a\u0007!EQ\"\u0001\r\n3\rA\u0019\"D\u0001\u0019\u0015\u0015jA!\u0001E\u000b\u001b\ta\t\u0001g\u0003\u001a\u0007!5Q\"\u0001M\u00053\rAq!D\u0001\u0019\u000b%RA!\u0011\u0005\t\u00045!\u0011BA\u0005\u00021\u000bA\"!U\u0002\u0002\u000b\u0001I3\u0003B!\t\u0011\riQ\"\u0003\u0005\n\u000f%\u0011\u0011\"\u0001M\u0005\u0013\tI\u0011\u0001G\u0003\u0019\t%\u0011\u0011\"\u0001M\u00061\u000f\t6!A\u0003\u0001"}, strings={"Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/BinaryOperationIntrinsics;", "", "()V", "factories", "", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/BinaryOperationIntrinsicFactory;", "intrinsicCache", "Lgnu/trove/THashMap;", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/lexer/KtToken;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/BinaryOperationIntrinsic;", "computeAndCacheIntrinsic", "token", "descriptor", "computeIntrinsic", "getIntrinsic", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "lookUpCache"}, moduleName="kotlin-compiler")
public final class BinaryOperationIntrinsics {
    private final THashMap<Pair<? extends KtToken, ? extends FunctionDescriptor>, BinaryOperationIntrinsic> intrinsicCache = new THashMap();
    private final List<? extends BinaryOperationIntrinsicFactory> factories = CollectionsKt.listOf(LongCompareToBOIF.INSTANCE, EqualsBOIF.INSTANCE, CompareToBOIF.INSTANCE);

    @NotNull
    public final BinaryOperationIntrinsic getIntrinsic(@NotNull KtBinaryExpression expression, @NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        KtToken token = PsiUtils.getOperationToken(expression);
        CallableDescriptor descriptor2 = BindingUtils.getCallableDescriptorForOperationExpression(context.bindingContext(), expression);
        if (descriptor2 == null || !(descriptor2 instanceof FunctionDescriptor)) {
            return NO_INTRINSIC.INSTANCE;
        }
        KtToken ktToken = token;
        Intrinsics.checkExpressionValueIsNotNull(ktToken, "token");
        BinaryOperationIntrinsic binaryOperationIntrinsic = this.lookUpCache(ktToken, (FunctionDescriptor)descriptor2);
        if (binaryOperationIntrinsic == null) {
            KtToken ktToken2 = token;
            Intrinsics.checkExpressionValueIsNotNull(ktToken2, "token");
            binaryOperationIntrinsic = this.computeAndCacheIntrinsic(ktToken2, (FunctionDescriptor)descriptor2);
        }
        return binaryOperationIntrinsic;
    }

    private final BinaryOperationIntrinsic lookUpCache(KtToken token, FunctionDescriptor descriptor2) {
        return this.intrinsicCache.get(new Pair<KtToken, FunctionDescriptor>(token, descriptor2));
    }

    private final BinaryOperationIntrinsic computeAndCacheIntrinsic(KtToken token, FunctionDescriptor descriptor2) {
        BinaryOperationIntrinsic result2 = this.computeIntrinsic(token, descriptor2);
        this.intrinsicCache.put(new Pair<KtToken, FunctionDescriptor>(token, descriptor2), result2);
        return result2;
    }

    private final BinaryOperationIntrinsic computeIntrinsic(KtToken token, FunctionDescriptor descriptor2) {
        for (BinaryOperationIntrinsicFactory binaryOperationIntrinsicFactory : this.factories) {
            BinaryOperationIntrinsic intrinsic;
            if (!CollectionsKt.contains((Iterable)binaryOperationIntrinsicFactory.getSupportTokens(), token) || (intrinsic = binaryOperationIntrinsicFactory.getIntrinsic(descriptor2)) == null) continue;
            return intrinsic;
        }
        return NO_INTRINSIC.INSTANCE;
    }
}

