/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.EditCommaSeparatedListHelper;
import org.jetbrains.kotlin.psi.KtElementImpl;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitor;

public class KtValueArgumentList
extends KtElementImpl {
    public KtValueArgumentList(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/KtValueArgumentList", "<init>"));
        }
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtValueArgumentList", "accept"));
        }
        return visitor2.visitValueArgumentList(this, data);
    }

    @NotNull
    public List<KtValueArgument> getArguments() {
        List<KtValueArgument> list = this.findChildrenByType(KtNodeTypes.VALUE_ARGUMENT);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtValueArgumentList", "getArguments"));
        }
        return list;
    }

    @Nullable
    public PsiElement getRightParenthesis() {
        return this.findChildByType(KtTokens.RPAR);
    }

    @Nullable
    public PsiElement getLeftParenthesis() {
        return this.findChildByType(KtTokens.LPAR);
    }

    @NotNull
    public KtValueArgument addArgument(@NotNull KtValueArgument argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/psi/KtValueArgumentList", "addArgument"));
        }
        KtValueArgument ktValueArgument = EditCommaSeparatedListHelper.INSTANCE$.addItem(this, this.getArguments(), argument);
        if (ktValueArgument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtValueArgumentList", "addArgument"));
        }
        return ktValueArgument;
    }

    @NotNull
    public KtValueArgument addArgumentAfter(@NotNull KtValueArgument argument, @Nullable KtValueArgument anchor2) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/psi/KtValueArgumentList", "addArgumentAfter"));
        }
        KtValueArgument ktValueArgument = EditCommaSeparatedListHelper.INSTANCE$.addItemAfter(this, this.getArguments(), argument, anchor2);
        if (ktValueArgument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtValueArgumentList", "addArgumentAfter"));
        }
        return ktValueArgument;
    }

    @NotNull
    public KtValueArgument addArgumentBefore(@NotNull KtValueArgument argument, @Nullable KtValueArgument anchor2) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/psi/KtValueArgumentList", "addArgumentBefore"));
        }
        KtValueArgument ktValueArgument = EditCommaSeparatedListHelper.INSTANCE$.addItemBefore(this, this.getArguments(), argument, anchor2);
        if (ktValueArgument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtValueArgumentList", "addArgumentBefore"));
        }
        return ktValueArgument;
    }

    public void removeArgument(@NotNull KtValueArgument argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/psi/KtValueArgumentList", "removeArgument"));
        }
        assert (argument.getParent() == this);
        EditCommaSeparatedListHelper.INSTANCE$.removeItem(argument);
    }
}

