/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"K\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\t\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001\u0003\t\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"\u0001\u0007\u00013\u0005A\n!)\u0006\n\u0007!\tQ\"\u0001M\u0002\u0013\rA!!D\u0001\u0019\u0006E\u001b\u0011\u0001C\u0002&!\u0011\t\u0001rA\u0007\u00021\u0011I2\u0001#\u0003\u000e\u0003a)\u0011d\u0001E\u0006\u001b\u0005Ab!G\u0002\t\u000e5\t\u0001dB\u0013\u001e\u0011\u001fi\u0011\u0001\u0007\u0003\u001a\r!AQ\u0002B\u0005\u0003\u0013\u0005Ab\u0001'\u0005\u001a\r!IQ\u0002B\u0005\u0003\u0013\u0005AR\u0001'\u0005\u001a\u0007!MQ\"\u0001\r\u000b3\rA)\"D\u0001\u0019\u0017e\u0019\u0001rC\u0007\u000211)S\u0003c\u0004\u000e\u0003a!\u0011D\u0002\u0005\t\u001b\u0011I!!C\u0001\u0019\raE\u0011D\u0002\u0005\n\u001b\u0011I!!C\u0001\u0019\u000baE\u0011d\u0001E\u0007\u001b\u0005Ar!K\u0004\u0005\u0003\"A!!D\u0001\u0019\u0006E\u001b\u0011!\u0002\u0001*\u000f\u0011\t\u0005\u0002C\u0001\u000e\u0003a\r\u0011kA\u0001\u0006\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/types/expressions/ValueParameterResolver;", "", "expressionTypingServices", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "constantExpressionEvaluator", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "(Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;)V", "resolveDefaultValue", "", "valueParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "jetParameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "resolveValueParameters", "valueParameters", "", "valueParameterDescriptors", "declaringScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;"}, moduleName="kotlin-compiler")
public final class ValueParameterResolver {
    private final ExpressionTypingServices expressionTypingServices;
    private final ConstantExpressionEvaluator constantExpressionEvaluator;

    public final void resolveValueParameters(@NotNull List<? extends KtParameter> valueParameters, @NotNull List<? extends ValueParameterDescriptor> valueParameterDescriptors, @NotNull LexicalScope declaringScope, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(valueParameters, "valueParameters");
        Intrinsics.checkParameterIsNotNull(valueParameterDescriptors, "valueParameterDescriptors");
        Intrinsics.checkParameterIsNotNull(declaringScope, "declaringScope");
        Intrinsics.checkParameterIsNotNull(dataFlowInfo, "dataFlowInfo");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        ExpressionTypingContext expressionTypingContext = ExpressionTypingContext.newContext(trace, declaringScope, dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE);
        Intrinsics.checkExpressionValueIsNotNull(expressionTypingContext, "ExpressionTypingContext.\u2026peUtils.NO_EXPECTED_TYPE)");
        this.resolveValueParameters(valueParameters, valueParameterDescriptors, expressionTypingContext);
    }

    public final void resolveValueParameters(@NotNull List<? extends KtParameter> valueParameters, @NotNull List<? extends ValueParameterDescriptor> valueParameterDescriptors, @NotNull ExpressionTypingContext context) {
        Intrinsics.checkParameterIsNotNull(valueParameters, "valueParameters");
        Intrinsics.checkParameterIsNotNull(valueParameterDescriptors, "valueParameterDescriptors");
        Intrinsics.checkParameterIsNotNull(context, "context");
        for (Pair pair : CollectionsKt.zip((Iterable)valueParameterDescriptors, (Iterable)valueParameters)) {
            ValueParameterDescriptor descriptor2 = (ValueParameterDescriptor)pair.component1();
            KtParameter parameter = (KtParameter)pair.component2();
            ForceResolveUtil.forceResolveAllContents(descriptor2.getAnnotations());
            this.resolveDefaultValue(descriptor2, parameter, context);
        }
    }

    private final void resolveDefaultValue(ValueParameterDescriptor valueParameterDescriptor, KtParameter jetParameter, ExpressionTypingContext context) {
        if (!valueParameterDescriptor.declaresDefaultValue()) {
            return;
        }
        KtExpression ktExpression = jetParameter.getDefaultValue();
        if (ktExpression == null) {
            return;
        }
        KtExpression defaultValue = ktExpression;
        this.expressionTypingServices.getTypeInfo(defaultValue, (ResolutionContext)context.replaceExpectedType(valueParameterDescriptor.getType()));
        if (DescriptorUtils.isAnnotationClass(DescriptorResolver.getContainingClass(context.scope))) {
            KtExpression ktExpression2 = defaultValue;
            Intrinsics.checkExpressionValueIsNotNull(ktExpression2, "defaultValue");
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
            CompileTimeConstant<?> compileTimeConstant = this.constantExpressionEvaluator.evaluateExpression(ktExpression2, bindingTrace, valueParameterDescriptor.getType());
            if (compileTimeConstant == null) {
                context.trace.report(Errors.ANNOTATION_PARAMETER_DEFAULT_VALUE_MUST_BE_CONSTANT.on((KtExpression)((PsiElement)defaultValue)));
                compileTimeConstant = Unit.INSTANCE;
            }
        }
    }

    public ValueParameterResolver(@NotNull ExpressionTypingServices expressionTypingServices, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator) {
        Intrinsics.checkParameterIsNotNull(expressionTypingServices, "expressionTypingServices");
        Intrinsics.checkParameterIsNotNull(constantExpressionEvaluator, "constantExpressionEvaluator");
        this.expressionTypingServices = expressionTypingServices;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
    }
}

