/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.CollectionsKt;
import kotlin.PreconditionsKt;
import kotlin.Sequence;
import kotlin.SequencesKt;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorWithVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyAccessorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.KotlinRetention;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.EnumValue;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.utils.DFS;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DescriptorUtilsKt {
    @NotNull
    public static final ClassDescriptor getClassObjectReferenceTarget(ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassDescriptor classDescriptor = $receiver.getCompanionObjectDescriptor();
        if (classDescriptor == null) {
            classDescriptor = $receiver;
        }
        return classDescriptor;
    }

    @NotNull
    public static final DeclarationDescriptor getImportableDescriptor(DeclarationDescriptor $receiver) {
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if ($receiver instanceof ConstructorDescriptor) {
            DeclarationDescriptor declarationDescriptor2 = ((ConstructorDescriptor)$receiver).getContainingDeclaration();
            declarationDescriptor = declarationDescriptor2;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor2, "getContainingDeclaration()");
        } else if ($receiver instanceof PropertyAccessorDescriptor) {
            DeclarationDescriptor declarationDescriptor3 = ((PropertyAccessorDescriptor)$receiver).getCorrespondingProperty();
            declarationDescriptor = declarationDescriptor3;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor3, "getCorrespondingProperty()");
        } else {
            declarationDescriptor = $receiver;
        }
        return declarationDescriptor;
    }

    @NotNull
    public static final FqNameUnsafe getFqNameUnsafe(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName($receiver);
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe, "DescriptorUtils.getFqName(this)");
        return fqNameUnsafe;
    }

    @NotNull
    public static final FqName getFqNameSafe(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        FqName fqName2 = DescriptorUtils.getFqNameSafe($receiver);
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "DescriptorUtils.getFqNameSafe(this)");
        return fqName2;
    }

    public static final boolean isExtension(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver instanceof CallableDescriptor && ((CallableDescriptor)$receiver).getExtensionReceiverParameter() != null;
    }

    @NotNull
    public static final ModuleDescriptor getModule(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModule($receiver);
        Intrinsics.checkExpressionValueIsNotNull(moduleDescriptor, "DescriptorUtils.getContainingModule(this)");
        return moduleDescriptor;
    }

    @Nullable
    public static final ClassDescriptor resolveTopLevelClass(ModuleDescriptor $receiver, @NotNull FqName topLevelClassFqName, @NotNull LookupLocation location2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(topLevelClassFqName, "topLevelClassFqName");
        Intrinsics.checkParameterIsNotNull(location2, "location");
        PreconditionsKt.assert(!topLevelClassFqName.isRoot());
        FqName fqName2 = topLevelClassFqName.parent();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "topLevelClassFqName.parent()");
        MemberScope memberScope2 = $receiver.getPackage(fqName2).getMemberScope();
        Name name = topLevelClassFqName.shortName();
        Intrinsics.checkExpressionValueIsNotNull(name, "topLevelClassFqName.shortName()");
        ClassifierDescriptor classifierDescriptor = memberScope2.getContributedClassifier(name, location2);
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        return (ClassDescriptor)classifierDescriptor;
    }

    @NotNull
    public static final ClassId getClassId(ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        DeclarationDescriptor owner = $receiver.getContainingDeclaration();
        if (owner instanceof PackageFragmentDescriptor) {
            return new ClassId(((PackageFragmentDescriptor)owner).getFqName(), $receiver.getName());
        }
        if (owner instanceof ClassDescriptor) {
            ClassId classId = DescriptorUtilsKt.getClassId((ClassDescriptor)owner).createNestedClassId($receiver.getName());
            Intrinsics.checkExpressionValueIsNotNull(classId, "owner.classId.createNestedClassId(getName())");
            return classId;
        }
        throw (Throwable)new IllegalStateException("Illegal container: " + owner);
    }

    public static final boolean getHasClassObjectType(ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return DescriptorUtilsKt.getClassObjectType($receiver) != null;
    }

    @Nullable
    public static final KotlinType getClassObjectType(ClassDescriptor $receiver) {
        ClassDescriptor correspondingDescriptor;
        ClassDescriptor classDescriptor;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassKind classKind = $receiver.getKind();
        if (Intrinsics.areEqual((Object)classKind, (Object)ClassKind.OBJECT)) {
            classDescriptor = $receiver;
        } else if (Intrinsics.areEqual((Object)classKind, (Object)ClassKind.ENUM_ENTRY)) {
            DeclarationDescriptor container = $receiver.getContainingDeclaration();
            PreconditionsKt.assert(container instanceof ClassDescriptor && Intrinsics.areEqual((Object)((ClassDescriptor)container).getKind(), (Object)ClassKind.ENUM_CLASS));
            DeclarationDescriptor declarationDescriptor = container;
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            classDescriptor = (ClassDescriptor)declarationDescriptor;
        } else {
            classDescriptor = $receiver.getCompanionObjectDescriptor();
        }
        ClassDescriptor classDescriptor2 = correspondingDescriptor = classDescriptor;
        return classDescriptor2 != null ? classDescriptor2.getDefaultType() : null;
    }

    public static final boolean isEffectivelyPublicApi(DeclarationDescriptorWithVisibility $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        DeclarationDescriptorWithVisibility parent2 = $receiver;
        while (parent2 != null) {
            if (!parent2.getVisibility().isPublicAPI()) {
                return false;
            }
            parent2 = DescriptorUtils.getParentOfType(parent2, DeclarationDescriptorWithVisibility.class);
        }
        return true;
    }

    @Nullable
    public static final ClassDescriptor getSuperClassNotAny(ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        for (KotlinType supertype : $receiver.getDefaultType().getConstructor().getSupertypes()) {
            ClassifierDescriptor superClassifier = supertype.getConstructor().getDeclarationDescriptor();
            if (KotlinBuiltIns.isAnyOrNullableAny(supertype) || !DescriptorUtils.isClass(superClassifier) && !DescriptorUtils.isEnumClass(superClassifier)) continue;
            ClassifierDescriptor classifierDescriptor = superClassifier;
            if (classifierDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            return (ClassDescriptor)classifierDescriptor;
        }
        return null;
    }

    @NotNull
    public static final ClassDescriptor getSuperClassOrAny(ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getSuperClassNotAny($receiver);
        if (classDescriptor == null) {
            ClassDescriptor classDescriptor2 = DescriptorUtilsKt.getBuiltIns($receiver).getAny();
            classDescriptor = classDescriptor2;
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor2, "builtIns.getAny()");
        }
        return classDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ConstructorDescriptor> getSecondaryConstructors(ClassDescriptor $receiver) {
        void var3_3;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Iterable $receiver3 = $receiver.getConstructors();
        Iterable iterable = $receiver3;
        Collection destination = new ArrayList();
        for (Object element : $receiver2) {
            ConstructorDescriptor it2 = (ConstructorDescriptor)element;
            if (it2.isPrimary()) continue;
            destination.add(element);
        }
        return (List)var3_3;
    }

    @NotNull
    public static final KotlinBuiltIns getBuiltIns(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return DescriptorUtilsKt.getModule($receiver).getBuiltIns();
    }

    @Nullable
    public static final DeclarationDescriptor getOwnerForEffectiveDispatchReceiverParameter(CallableDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if ($receiver instanceof CallableMemberDescriptor && Intrinsics.areEqual((Object)((CallableMemberDescriptor)$receiver).getKind(), (Object)CallableMemberDescriptor.Kind.FAKE_OVERRIDE)) {
            return ((CallableMemberDescriptor)$receiver).getContainingDeclaration();
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = $receiver.getDispatchReceiverParameter();
        return receiverParameterDescriptor != null ? receiverParameterDescriptor.getContainingDeclaration() : null;
    }

    public static final boolean hasDefaultValue(ValueParameterDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        DFS.AbstractNodeHandler<ValueParameterDescriptor, Boolean> handler2 = new DFS.AbstractNodeHandler<ValueParameterDescriptor, Boolean>(){
            private boolean result;

            public final boolean getResult() {
                return this.result;
            }

            public final void setResult(boolean bl) {
                this.result = bl;
            }

            public boolean beforeChildren(@NotNull ValueParameterDescriptor current) {
                Intrinsics.checkParameterIsNotNull(current, "current");
                this.result = this.result || current.declaresDefaultValue();
                return !this.result;
            }

            @NotNull
            public Boolean result() {
                return this.result;
            }
        };
        DFS.dfs((Collection)CollectionsKt.listOf($receiver), hasDefaultValue.1.INSTANCE, handler2);
        return handler2.result();
    }

    public static final boolean isRepeatableAnnotation(Annotated $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Annotations annotations2 = $receiver.getAnnotations();
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.repeatable;
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "KotlinBuiltIns.FQ_NAMES.repeatable");
        return annotations2.findAnnotation(fqName2) != null;
    }

    public static final boolean isDocumentedAnnotation(Annotated $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Annotations annotations2 = $receiver.getAnnotations();
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.mustBeDocumented;
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "KotlinBuiltIns.FQ_NAMES.mustBeDocumented");
        return annotations2.findAnnotation(fqName2) != null;
    }

    @Nullable
    public static final KotlinRetention getAnnotationRetention(Annotated $receiver) {
        Object v3;
        block4: {
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            Annotations annotations2 = $receiver.getAnnotations();
            FqName fqName2 = KotlinBuiltIns.FQ_NAMES.retention;
            Intrinsics.checkExpressionValueIsNotNull(fqName2, "KotlinBuiltIns.FQ_NAMES.retention");
            AnnotationDescriptor annotationDescriptor = annotations2.findAnnotation(fqName2);
            if (annotationDescriptor == null) {
                return null;
            }
            AnnotationDescriptor annotationEntryDescriptor = annotationDescriptor;
            Object $receiver2 = annotationEntryDescriptor.getAllValueArguments();
            $receiver2 = $receiver2.entrySet();
            Iterator iterator2 = $receiver2.iterator();
            while (iterator2.hasNext()) {
                Object element = iterator2.next();
                Map.Entry it2 = (Map.Entry)element;
                if (!Intrinsics.areEqual(((ValueParameterDescriptor)it2.getKey()).getName().asString(), "value")) continue;
                v3 = element;
                break block4;
            }
            v3 = null;
        }
        Map.Entry entry = v3;
        ConstantValue constantValue = entry != null ? (ConstantValue)CollectionsKt.getValue(entry) : null;
        if (!(constantValue instanceof EnumValue)) {
            constantValue = null;
        }
        EnumValue enumValue = (EnumValue)constantValue;
        if (enumValue == null) {
            return null;
        }
        EnumValue retentionArgumentValue = enumValue;
        String string = ((ClassDescriptor)retentionArgumentValue.getValue()).getName().asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "retentionArgumentValue.value.name.asString()");
        return KotlinRetention.valueOf(string);
    }

    @NotNull
    public static final Sequence<DeclarationDescriptor> getParentsWithSelf(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return SequencesKt.sequence($receiver, (Function1)parentsWithSelf.1.INSTANCE);
    }

    @NotNull
    public static final Sequence<DeclarationDescriptor> getParents(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return SequencesKt.drop(DescriptorUtilsKt.getParentsWithSelf($receiver), 1);
    }
}

