/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.ArraysKt;
import kotlin.CollectionsKt;
import kotlin.ExtensionsKt;
import kotlin.Sequence;
import kotlin.SequencesKt;
import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.container.CacheKt;
import org.jetbrains.kotlin.container.ClassInfo;
import org.jetbrains.kotlin.container.ClassTraversalCache;
import org.jetbrains.kotlin.container.ConstructorInfo;
import org.jetbrains.kotlin.container.SetterInfo;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"7\u0015\u0001Q!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u00012E\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005A\u0001#B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u000e\"\u0011\t\u0001\u0002A\u0007\u00021\u0003I2\u0001C\u0001\u000e\u0003a\r\u0011D\u0002\u0005\u0003\u001b\u0011I!!C\u0001\u0019\u0004a\u0015AkA\u0002\u000e\u001a\u0011\t\u0001rA\u0007\u0003\u0019\u0003AB!G\u0003\t\n5\u0019\u0011\"\u0001C\u00021\u0015!6aAG\u000f\t\u0005AY!\u0004\u0003\n\u0005%\t\u00014\u0001\r\u00073\u0015Ai!D\u0002\n\u0003\u0011\r\u0001$\u0002+\u0004\u00075uA!\u0001\u0005\b\u001b\u0011I!!C\u0001\u0019\u0010a1\u0011$\u0002E\u0005\u001b\rI\u0011\u0001b\u0001\u0019\u000bQ\u001b1!d\u0006\u0005\u0003!AQ\"\u0001M\t3\u0015AI!D\u0002\n\u0003\u0011\r\u0001$\u0002+\u0004\u00075E\u0001\"C\u0007\u00021#)2!C\u0001\u0005\u0004a)AkA\u0002"}, strings={"collectInterfacesRecursive", "", "type", "Ljava/lang/reflect/Type;", "result", "", "CacheKt", "getConstructorInfo", "Lorg/jetbrains/kotlin/container/ConstructorInfo;", "c", "Ljava/lang/Class;", "getRegistrations", "", "klass", "getSetterInfos", "Lorg/jetbrains/kotlin/container/SetterInfo;", "traverseClass", "Lorg/jetbrains/kotlin/container/ClassInfo;", "getInfo"}, moduleName="kotlin-compiler")
public final class CacheKt {
    @NotNull
    public static final ClassInfo getInfo(Class<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return ClassTraversalCache.INSTANCE.getClassInfo($receiver);
    }

    private static final ClassInfo traverseClass(Class<?> c) {
        return new ClassInfo(CacheKt.getConstructorInfo(c), CacheKt.getSetterInfos(c), CacheKt.getRegistrations(c));
    }

    private static final List<SetterInfo> getSetterInfos(Class<?> c) {
        ArrayList<SetterInfo> setterInfos = new ArrayList<SetterInfo>();
        Method[] methodArray = c.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            Annotation[] annotationArray = method.getDeclaredAnnotations();
            for (int j = 0; j < annotationArray.length; ++j) {
                Annotation annotation2 = annotationArray[j];
                if (!StringsKt.endsWith$default(ExtensionsKt.annotationType(annotation2).getName(), ".Inject", false, 2)) continue;
                Method method2 = method;
                Intrinsics.checkExpressionValueIsNotNull(method2, "method");
                setterInfos.add(new SetterInfo(method2, ArraysKt.toList((Object[])method.getGenericParameterTypes())));
            }
        }
        return setterInfos;
    }

    private static final ConstructorInfo getConstructorInfo(Class<?> c) {
        Constructor constructor;
        boolean hasSinglePublicConstructor;
        boolean bl;
        if (Modifier.isAbstract(c.getModifiers()) || c.isPrimitive()) {
            return null;
        }
        Constructor<?>[] constructors2 = c.getConstructors();
        Constructor constructor2 = (Constructor)ArraysKt.singleOrNull((Object[])constructors2);
        if (constructor2 != null) {
            Constructor $receiver = constructor2;
            Constructor it2 = $receiver;
            bl = Modifier.isPublic(it2.getModifiers());
        } else {
            bl = hasSinglePublicConstructor = false;
        }
        if (!hasSinglePublicConstructor) {
            return null;
        }
        Constructor constructor3 = constructor = (Constructor)ArraysKt.single((Object[])constructors2);
        Intrinsics.checkExpressionValueIsNotNull(constructor3, "constructor");
        return new ConstructorInfo(constructor3, ArraysKt.toList((Object[])constructor.getGenericParameterTypes()));
    }

    private static final void collectInterfacesRecursive(Type type2, Set<Type> result2) {
        Unit unit;
        Type[] klass;
        Object object;
        Type type3 = type2;
        if (type3 instanceof Class) {
            object = (Type[])type2;
        } else if (type3 instanceof ParameterizedType) {
            Type type4 = ((ParameterizedType)type2).getRawType();
            if (!(type4 instanceof Class)) {
                type4 = null;
            }
            object = (Class)type4;
        } else {
            object = null;
        }
        Type[] typeArray = klass = object;
        if (klass != null && (typeArray = typeArray.getGenericInterfaces()) != null) {
            Object[] $receiver = typeArray;
            for (int i = 0; i < $receiver.length; ++i) {
                Type it2;
                Object element = $receiver[i];
                Type type5 = it2 = (Type)element;
                Intrinsics.checkExpressionValueIsNotNull(type5, "it");
                if (!result2.add(type5)) continue;
                Type type6 = it2;
                Intrinsics.checkExpressionValueIsNotNull(type6, "it");
                CacheKt.collectInterfacesRecursive(type6, result2);
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Type> getRegistrations(Class<?> klass) {
        void $receiver;
        ArrayList registrations = new ArrayList();
        Sequence<Class<?>> superClasses2 = SequencesKt.sequence(klass, (Function1)getRegistrations.superClasses.1.INSTANCE);
        CollectionsKt.addAll((Collection)registrations, superClasses2);
        LinkedHashSet interfaces = new LinkedHashSet();
        Sequence<Class<?>> sequence2 = superClasses2;
        for (Object element : $receiver) {
            Type it2 = (Type)element;
            CacheKt.collectInterfacesRecursive(it2, interfaces);
        }
        registrations.addAll(interfaces);
        registrations.remove(Object.class);
        return registrations;
    }

    @NotNull
    public static final /* synthetic */ ClassInfo access$traverseClass(@NotNull Class<?> c) {
        return CacheKt.traverseClass(c);
    }
}

