/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.annotations;

import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptorImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.Variance;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"\u001f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!9Q!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\t\u001f\u0015\u0001Q2\u0005\u0005\u0001\u001b\u0005A\n!F\u0001\u0019\u0003e%\u00012A\u0007\u00021\t\u00016\u0011AM\u0005\u0011\u000bi\u0011\u0001\u0007\u0002Q\u0007\u0005!6aAG\u0011\t\u0005#\u0001rA\u0007\u00021\u0011)B!\u0003\u0002\n\u0003a!\u0001\u0014BM\u0005\u0011\u0015i\u0011\u0001\u0007\u0002Q\u0007\u0003!6a\u0001"}, strings={"createDeprecatedAnnotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "message", "", "replaceWith", "AnnotationUtilKt", "get", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "", "parameterName"}, moduleName="kotlin-compiler")
public final class AnnotationUtilKt {
    @NotNull
    public static final AnnotationDescriptor createDeprecatedAnnotation(KotlinBuiltIns $receiver, @NotNull String message, @NotNull String replaceWith) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(message, "message");
        Intrinsics.checkParameterIsNotNull(replaceWith, "replaceWith");
        ClassDescriptor deprecatedAnnotation = $receiver.getDeprecatedAnnotation();
        ConstructorDescriptor constructorDescriptor = deprecatedAnnotation.getUnsubstitutedPrimaryConstructor();
        if (constructorDescriptor == null) {
            Intrinsics.throwNpe();
        }
        List<ValueParameterDescriptor> parameters2 = constructorDescriptor.getValueParameters();
        ClassDescriptor replaceWithClass = $receiver.getBuiltInClassByName(Name.identifier("ReplaceWith"));
        ConstructorDescriptor constructorDescriptor2 = replaceWithClass.getUnsubstitutedPrimaryConstructor();
        if (constructorDescriptor2 == null) {
            Intrinsics.throwNpe();
        }
        List<ValueParameterDescriptor> replaceWithParameters = constructorDescriptor2.getValueParameters();
        KotlinType kotlinType = deprecatedAnnotation.getDefaultType();
        Pair[] pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to(AnnotationUtilKt.get((Collection<? extends ValueParameterDescriptor>)parameters2, "message"), new StringValue(message, $receiver));
        ValueParameterDescriptor valueParameterDescriptor = AnnotationUtilKt.get((Collection<? extends ValueParameterDescriptor>)parameters2, "replaceWith");
        KotlinType kotlinType2 = replaceWithClass.getDefaultType();
        Pair[] pairArray2 = new Pair[2];
        pairArray2[0] = TuplesKt.to(AnnotationUtilKt.get((Collection<? extends ValueParameterDescriptor>)replaceWithParameters, "expression"), new StringValue(replaceWith, $receiver));
        ValueParameterDescriptor valueParameterDescriptor2 = AnnotationUtilKt.get((Collection<? extends ValueParameterDescriptor>)replaceWithParameters, "imports");
        List list = CollectionsKt.emptyList();
        KotlinType kotlinType3 = $receiver.getArrayType(Variance.INVARIANT, $receiver.getStringType());
        Intrinsics.checkExpressionValueIsNotNull(kotlinType3, "getArrayType(Variance.INVARIANT, stringType)");
        pairArray2[1] = TuplesKt.to(valueParameterDescriptor2, new ArrayValue(list, kotlinType3, $receiver));
        pairArray[1] = TuplesKt.to(valueParameterDescriptor, new AnnotationValue(new AnnotationDescriptorImpl(kotlinType2, MapsKt.mapOf(pairArray2), SourceElement.NO_SOURCE)));
        return new AnnotationDescriptorImpl(kotlinType, MapsKt.mapOf(pairArray), SourceElement.NO_SOURCE);
    }

    private static final ValueParameterDescriptor get(Collection<? extends ValueParameterDescriptor> $receiver, String parameterName) {
        Iterable $receiver2 = $receiver;
        Object single = null;
        boolean found = false;
        for (Object element : $receiver2) {
            ValueParameterDescriptor it2 = (ValueParameterDescriptor)element;
            if (!Intrinsics.areEqual(it2.getName().asString(), parameterName)) continue;
            if (found) {
                throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single = element;
            found = true;
        }
        if (!found) {
            throw (Throwable)new NoSuchElementException("Collection doesn't contain any element matching predicate.");
        }
        return (ValueParameterDescriptor)((Object)single);
    }
}

