/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.vfs.CharsetToolkit;
import org.jetbrains.annotations.NotNull;

public class Attachment {
    public static final Attachment[] EMPTY_ARRAY = new Attachment[0];
    private final String myPath;
    private final byte[] myBytes;
    private boolean myIncluded;
    private final String myDisplayText;

    public Attachment(@NotNull String path, @NotNull String content) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/diagnostic/Attachment", "<init>"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/diagnostic/Attachment", "<init>"));
        }
        this.myIncluded = true;
        this.myPath = path;
        this.myDisplayText = content;
        this.myBytes = Attachment.getBytes(content);
    }

    @NotNull
    public static byte[] getBytes(@NotNull String content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/diagnostic/Attachment", "getBytes"));
        }
        byte[] byArray = content.getBytes(CharsetToolkit.UTF8_CHARSET);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diagnostic/Attachment", "getBytes"));
        }
        return byArray;
    }
}

