/*
 * Decompiled with CFR 0.152.
 */
package com.sampullara.cli;

import com.sampullara.cli.Argument;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Args {
    public static List<String> parse(Object target, String[] args) {
        Class<?> clazz;
        ArrayList<String> arguments2 = new ArrayList<String>();
        arguments2.addAll(Arrays.asList(args));
        if (target instanceof Class) {
            clazz = (Class<?>)target;
        } else {
            clazz = target.getClass();
            try {
                BeanInfo info = Introspector.getBeanInfo(clazz);
                for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                    Args.processProperty(target, pd, arguments2);
                }
            }
            catch (IntrospectionException info) {
                // empty catch block
            }
        }
        for (Class<?> currentClazz = clazz; currentClazz != null; currentClazz = currentClazz.getSuperclass()) {
            for (Field field : currentClazz.getDeclaredFields()) {
                Args.processField(target, field, arguments2);
            }
        }
        for (String argument : arguments2) {
            if (!argument.startsWith("-")) continue;
            throw new IllegalArgumentException("Invalid argument: " + argument);
        }
        return arguments2;
    }

    private static void processField(Object target, Field field, List<String> arguments2) {
        Argument argument = field.getAnnotation(Argument.class);
        if (argument != null) {
            boolean set = false;
            Iterator<String> i = arguments2.iterator();
            while (i.hasNext()) {
                String arg = i.next();
                String prefix = argument.prefix();
                String delimiter = argument.delimiter();
                if (!arg.startsWith(prefix)) continue;
                String name = Args.getName(argument, field);
                String alias = Args.getAlias(argument);
                arg = arg.substring(prefix.length());
                Class<?> type2 = field.getType();
                if (arg.equals(name) || alias != null && arg.equals(alias)) {
                    i.remove();
                    Object value2 = Args.consumeArgumentValue(type2, argument, i);
                    if (!set) {
                        Args.setField(type2, field, target, value2, delimiter);
                    } else {
                        Args.addArgument(type2, field, target, value2, delimiter);
                    }
                    set = true;
                }
                if (!set || type2.isArray()) continue;
                break;
            }
            if (!set && argument.required()) {
                String name = Args.getName(argument, field);
                throw new IllegalArgumentException("You must set argument " + name);
            }
        }
    }

    private static void addArgument(Class type2, Field field, Object target, Object value2, String delimiter) {
        try {
            Object[] os = (Object[])field.get(target);
            Object[] vs = (Object[])Args.getValue(type2, value2, delimiter);
            Object[] s = (Object[])Array.newInstance(type2.getComponentType(), os.length + vs.length);
            System.arraycopy(os, 0, s, 0, os.length);
            System.arraycopy(vs, 0, s, os.length, vs.length);
            field.set(target, s);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Could not set field " + field, iae);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Could not find constructor in class " + type2.getName() + " that takes a string", e);
        }
    }

    private static void addPropertyArgument(Class type2, PropertyDescriptor property, Object target, Object value2, String delimiter) {
        try {
            Object[] os = (Object[])property.getReadMethod().invoke(target, new Object[0]);
            Object[] vs = (Object[])Args.getValue(type2, value2, delimiter);
            Object[] s = (Object[])Array.newInstance(type2.getComponentType(), os.length + vs.length);
            System.arraycopy(os, 0, s, 0, os.length);
            System.arraycopy(vs, 0, s, os.length, vs.length);
            property.getWriteMethod().invoke(target, new Object[]{s});
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Could not set property " + property, iae);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Could not find constructor in class " + type2.getName() + " that takes a string", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Failed to validate argument " + value2 + " for " + property);
        }
    }

    private static void processProperty(Object target, PropertyDescriptor property, List<String> arguments2) {
        Argument argument;
        Method writeMethod = property.getWriteMethod();
        if (writeMethod != null && (argument = writeMethod.getAnnotation(Argument.class)) != null) {
            boolean set = false;
            Iterator<String> i = arguments2.iterator();
            while (i.hasNext()) {
                String arg = i.next();
                String prefix = argument.prefix();
                String delimiter = argument.delimiter();
                if (!arg.startsWith(prefix)) continue;
                String name = Args.getName(argument, property);
                String alias = Args.getAlias(argument);
                arg = arg.substring(prefix.length());
                Class<?> type2 = property.getPropertyType();
                if (arg.equals(name) || alias != null && arg.equals(alias)) {
                    i.remove();
                    Object value2 = Args.consumeArgumentValue(type2, argument, i);
                    if (!set) {
                        Args.setProperty(type2, property, target, value2, delimiter);
                    } else {
                        Args.addPropertyArgument(type2, property, target, value2, delimiter);
                    }
                    set = true;
                }
                if (!set || type2.isArray()) continue;
                break;
            }
            if (!set && argument.required()) {
                String name = Args.getName(argument, property);
                throw new IllegalArgumentException("You must set argument " + name);
            }
        }
    }

    static String getName(Argument argument, PropertyDescriptor property) {
        String name = argument.value();
        if (name.equals("")) {
            name = property.getName();
        }
        return name;
    }

    private static Object consumeArgumentValue(Class<?> type2, Argument argument, Iterator<String> i) {
        Object value2;
        if (type2 == Boolean.TYPE || type2 == Boolean.class) {
            value2 = true;
        } else if (i.hasNext()) {
            value2 = i.next();
            i.remove();
        } else {
            throw new IllegalArgumentException("Must have a value for non-boolean argument " + argument.value());
        }
        return value2;
    }

    static void setProperty(Class<?> type2, PropertyDescriptor property, Object target, Object value2, String delimiter) {
        try {
            value2 = Args.getValue(type2, value2, delimiter);
            property.getWriteMethod().invoke(target, value2);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Could not set property " + property, iae);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Could not find constructor in class " + type2.getName() + " that takes a string", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Failed to validate argument " + value2 + " for " + property);
        }
    }

    static String getAlias(Argument argument) {
        String alias = argument.alias();
        if (alias.equals("")) {
            alias = null;
        }
        return alias;
    }

    static String getName(Argument argument, Field field) {
        String name = argument.value();
        if (name.equals("")) {
            name = field.getName();
        }
        return name;
    }

    static void setField(Class<?> type2, Field field, Object target, Object value2, String delimiter) {
        Args.makeAccessible(field);
        try {
            value2 = Args.getValue(type2, value2, delimiter);
            field.set(target, value2);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Could not set field " + field, iae);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Could not find constructor in class " + type2.getName() + " that takes a string", e);
        }
    }

    private static Object getValue(Class<?> type2, Object value2, String delimiter) throws NoSuchMethodException {
        if (type2 != String.class && type2 != Boolean.class && type2 != Boolean.TYPE) {
            if (type2.isArray()) {
                String string = (String)value2;
                String[] strings = string.split(delimiter);
                if ((type2 = type2.getComponentType()) == String.class) {
                    value2 = strings;
                } else {
                    Object[] array = (Object[])Array.newInstance(type2, strings.length);
                    for (int i = 0; i < array.length; ++i) {
                        array[i] = Args.createValue(type2, strings[i]);
                    }
                    value2 = array;
                }
            } else {
                value2 = Args.createValue(type2, value2);
            }
        }
        return value2;
    }

    private static Object createValue(Class<?> type2, Object value2) throws NoSuchMethodException {
        Constructor<?> init = type2.getDeclaredConstructor(String.class);
        try {
            value2 = init.newInstance(value2);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to convert " + value2 + " to type " + type2.getName(), e);
        }
        return value2;
    }

    private static void makeAccessible(AccessibleObject ao) {
        Member member;
        if (ao instanceof Member && !Modifier.isPublic((member = (Member)((Object)ao)).getModifiers())) {
            ao.setAccessible(true);
        }
    }
}

