/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"%\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\u000f\u0015\u0001Q!\u0001\u0005\u0011\u000b\u0005a\u0011!B\u0001\u0005\n\u0015\t\u0001\u0002B\u0003\u0002\t\u0007!1\t\u0002\u0007\u00013\u0005A\n!i\u0007\n\u0007!\tQ\"\u0001M\u0002\u0013\u0019A!!\u0004\u0003\n\u0005%\t\u0001d\u0001M\u0003#\u000e\t\u0001rAS\u0005\t\r;\u0001BB\u0007\u00021\u0007){\u0001B\"\b\u0011\u001biA!\u0003\u0002\n\u0003a\u0019\u0001TAS\u0012\t\r\u001b\u0001bB\u0007\u00021\u0001IB\u0001B\u0001\t\u00035\t\u00014A\r\b\t\u0005A!!\u0004\u0003\n\u0005%\t\u0001d\u0001M\u0003K\rAy!D\u0001\u0019\u0011\u0015Z\u0001\u0012C\u0007\u00021\rI2\u0001C\u0005\u000e\u0003aA\u0011d\u0001E\n\u001b\u0005A\u0002\"K\u0007\u0005\u0007\"A!!\u0004\u0003\n\u0005%\t\u0001d\u0001M\u0003#\u000e!Q\u0001A\u0007\u0003\t\u0011AI!\u000b\u0006\u0005\u0007\"A\u0011!D\u0001\u0019\u0004E\u001bA!\u0002\u0001\u000e\u0005\u0011)\u00012\u0002"}, strings={"Lkotlin/io/FilePathComponents;", "", "rootName", "", "fileList", "", "Ljava/io/File;", "(Ljava/lang/String;Ljava/util/List;)V", "getFileList", "()Ljava/util/List;", "getRootName", "()Ljava/lang/String;", "component1", "component2", "copy", "size", "", "subPath", "beginIndex", "endIndex"}, moduleName="kotlin-stdlib")
public final class FilePathComponents {
    @NotNull
    private final String rootName;
    @NotNull
    private final List<? extends File> fileList;

    public final int size() {
        Collection $receiver = this.fileList;
        return $receiver.size();
    }

    @NotNull
    public final File subPath(int beginIndex, int endIndex) {
        if (beginIndex < 0 || beginIndex > endIndex || endIndex > this.size()) {
            throw (Throwable)new IllegalArgumentException();
        }
        Iterable iterable = this.fileList.subList(beginIndex, endIndex);
        CharSequence charSequence = File.separator;
        Intrinsics.checkExpressionValueIsNotNull(charSequence, "File.separator");
        return new File(CollectionsKt.joinToString$default(iterable, charSequence, null, null, 0, null, null, 62));
    }

    @NotNull
    public final String getRootName() {
        return this.rootName;
    }

    @NotNull
    public final List<File> getFileList() {
        return this.fileList;
    }

    public FilePathComponents(@NotNull String rootName, @NotNull List<? extends File> fileList) {
        Intrinsics.checkParameterIsNotNull(rootName, "rootName");
        Intrinsics.checkParameterIsNotNull(fileList, "fileList");
        this.rootName = rootName;
        this.fileList = fileList;
    }

    @NotNull
    public final String component1() {
        return this.rootName;
    }

    @NotNull
    public final List<File> component2() {
        return this.fileList;
    }

    @NotNull
    public final FilePathComponents copy(@NotNull String rootName, @NotNull List<? extends File> fileList) {
        Intrinsics.checkParameterIsNotNull(rootName, "rootName");
        Intrinsics.checkParameterIsNotNull(fileList, "fileList");
        return new FilePathComponents(rootName, fileList);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ FilePathComponents copy$default(FilePathComponents filePathComponents, String string, List list, int n) {
        if ((n & 1) != 0) {
            string = filePathComponents.rootName;
        }
        if ((n & 2) != 0) {
            list = filePathComponents.fileList;
        }
        return filePathComponents.copy(string, list);
    }

    public String toString() {
        return "FilePathComponents(rootName=" + this.rootName + ", fileList=" + this.fileList + ")";
    }

    public int hashCode() {
        String string = this.rootName;
        List<? extends File> list = this.fileList;
        return (string != null ? string.hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof FilePathComponents)) break block3;
                FilePathComponents filePathComponents = (FilePathComponents)object;
                if (!Intrinsics.areEqual(this.rootName, filePathComponents.rootName) || !Intrinsics.areEqual(this.fileList, filePathComponents.fileList)) break block3;
            }
            return true;
        }
        return false;
    }
}

