/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava;

import com.intellij.lang.Language;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KtLightElement;
import org.jetbrains.kotlin.asJava.KtLightMethod;
import org.jetbrains.kotlin.asJava.KtLightModifierList;
import org.jetbrains.kotlin.asJava.LightParameter;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

public class KtLightParameter
extends LightParameter
implements KtLightElement<KtParameter, PsiParameter> {
    private final PsiModifierList modifierList;
    private final PsiParameter delegate;
    private final int index;
    private final KtLightMethod method;

    private static String getName(PsiParameter delegate2, int index2) {
        String name = delegate2.getName();
        return name != null ? name : "p" + index2;
    }

    public KtLightParameter(final PsiParameter delegate2, int index2, KtLightMethod method) {
        super(KtLightParameter.getName(delegate2, index2), delegate2.getType(), method, (Language)KotlinLanguage.INSTANCE);
        this.delegate = delegate2;
        this.index = index2;
        this.method = method;
        this.modifierList = new KtLightModifierList(method.getManager(), ArrayUtil.EMPTY_STRING_ARRAY){

            @Override
            public PsiAnnotationOwner getDelegate() {
                return delegate2.getModifierList();
            }
        };
    }

    @Override
    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList psiModifierList = this.modifierList;
        if (psiModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KtLightParameter", "getModifierList"));
        }
        return psiModifierList;
    }

    @Override
    @NotNull
    public PsiParameter getDelegate() {
        PsiParameter psiParameter = this.delegate;
        if (psiParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KtLightParameter", "getDelegate"));
        }
        return psiParameter;
    }

    @Override
    @Nullable
    public KtParameter getOrigin() {
        int jetIndex;
        Object declaration = this.method.getOrigin();
        if (declaration == null) {
            return null;
        }
        int n = jetIndex = KtPsiUtilKt.isExtensionDeclaration(declaration) ? this.index - 1 : this.index;
        if (jetIndex < 0) {
            return null;
        }
        if (declaration instanceof KtFunction) {
            List<KtParameter> paramList = ((KtFunction)declaration).getValueParameters();
            return jetIndex < paramList.size() ? paramList.get(jetIndex) : null;
        }
        if (jetIndex != 0) {
            return null;
        }
        KtPropertyAccessor setter2 = null;
        if (declaration instanceof KtPropertyAccessor) {
            KtPropertyAccessor accessor = (KtPropertyAccessor)declaration;
            setter2 = accessor.isSetter() ? accessor : null;
        } else if (declaration instanceof KtProperty) {
            setter2 = ((KtProperty)declaration).getSetter();
        }
        return setter2 != null ? setter2.getParameter() : null;
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        KtParameter origin = this.getOrigin();
        PsiElement psiElement2 = origin != null ? origin : super.getNavigationElement();
        if (psiElement2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KtLightParameter", "getNavigationElement"));
        }
        return psiElement2;
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/asJava/KtLightParameter", "setName"));
        }
        KtParameter origin = this.getOrigin();
        if (origin != null) {
            origin.setName(name);
        }
        return this;
    }

    @Override
    public PsiFile getContainingFile() {
        Object declaration = this.method.getOrigin();
        return declaration != null ? declaration.getContainingFile() : super.getContainingFile();
    }

    @Override
    @NotNull
    public Language getLanguage() {
        KotlinLanguage kotlinLanguage = KotlinLanguage.INSTANCE;
        if (kotlinLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KtLightParameter", "getLanguage"));
        }
        return kotlinLanguage;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        KtParameter origin = this.getOrigin();
        SearchScope searchScope = origin != null ? origin.getUseScope() : GlobalSearchScope.EMPTY_SCOPE;
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KtLightParameter", "getUseScope"));
        }
        return searchScope;
    }

    public KtLightMethod getMethod() {
        return this.method;
    }

    @Override
    public String getText() {
        return "";
    }
}

